/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.Destroyable;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="Implementation of Container and LifeCycle")
public class ContainerLifeCycle
extends AbstractLifeCycle
implements Container,
Destroyable,
Dumpable.DumpableContainer {
    private static final Logger LOG = Log.getLogger(ContainerLifeCycle.class);
    private final List<Bean> _beans = new CopyOnWriteArrayList<Bean>();
    private final List<Container.Listener> _listeners = new CopyOnWriteArrayList<Container.Listener>();
    private boolean _doStarted;
    private boolean _destroyed;

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doStart() throws Exception {
        if (this._destroyed) {
            throw new IllegalStateException("Destroyed container cannot be restarted");
        }
        this._doStarted = true;
        try {
            for (Bean b : this._beans) {
                if (b._bean instanceof LifeCycle) {
                    LifeCycle l = (LifeCycle)b._bean;
                    switch (b._managed) {
                        case MANAGED: {
                            if (!l.isStopped() && !l.isFailed()) break;
                            this.start(l);
                            break;
                        }
                        case AUTO: {
                            if (l.isStopped()) {
                                void var3_5;
                                this.manage(b);
                                this.start((LifeCycle)var3_5);
                                break;
                            }
                            this.unmanage(b);
                        }
                    }
                }
            }
            super.doStart();
            return;
        }
        catch (Throwable t) {
            void var1_2;
            ArrayList<Bean> reverse = new ArrayList<Bean>(this._beans);
            Collections.reverse(reverse);
            for (Bean b : reverse) {
                LifeCycle l;
                if (!(b._bean instanceof LifeCycle) || b._managed != Managed.MANAGED || !(l = (LifeCycle)b._bean).isRunning()) continue;
                try {
                    this.stop(l);
                }
                catch (Throwable throwable) {
                    void var2_4;
                    Throwable cause2 = throwable;
                    if (throwable == t) continue;
                    t.addSuppressed((Throwable)var2_4);
                }
            }
            throw var1_2;
        }
    }

    protected void start(LifeCycle l) throws Exception {
        l.start();
    }

    protected void stop(LifeCycle l) throws Exception {
        l.stop();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doStop() throws Exception {
        void var2_2;
        Iterator iterator;
        this._doStarted = false;
        super.doStop();
        ArrayList<Bean> reverse = new ArrayList<Bean>(this._beans);
        Collections.reverse(reverse);
        MultiException mex = new MultiException();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Bean b = (Bean)iterator.next();
            if (b._managed != Managed.MANAGED || !(b._bean instanceof LifeCycle)) continue;
            LifeCycle l = (LifeCycle)b._bean;
            try {
                this.stop(l);
            }
            catch (Throwable cause) {
                void var3_4;
                mex.add((Throwable)var3_4);
            }
        }
        var2_2.ifExceptionThrow();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void destroy() {
        Iterator iterator;
        this._destroyed = true;
        ArrayList<Bean> reverse = new ArrayList<Bean>(this._beans);
        Collections.reverse(reverse);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Bean b = (Bean)iterator.next();
            if (!(b._bean instanceof Destroyable) || b._managed != Managed.MANAGED && b._managed != Managed.POJO) continue;
            Destroyable d = (Destroyable)b._bean;
            try {
                d.destroy();
            }
            catch (Throwable cause) {
                void var2_3;
                LOG.warn((Throwable)var2_3);
            }
        }
        this._beans.clear();
    }

    public boolean contains(Object bean) {
        for (Bean bean2 : this._beans) {
            if (bean2._bean != bean) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isManaged(Object bean) {
        for (Bean b : this._beans) {
            void var3_3;
            if (b._bean != bean) continue;
            return var3_3.isManaged();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isAuto(Object bean) {
        for (Bean b : this._beans) {
            void var3_3;
            if (b._bean != bean) continue;
            return ((Bean)var3_3)._managed == Managed.AUTO;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isUnmanaged(Object bean) {
        for (Bean b : this._beans) {
            void var3_3;
            if (b._bean != bean) continue;
            return ((Bean)var3_3)._managed == Managed.UNMANAGED;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addBean(Object o) {
        void var1_1;
        if (o instanceof LifeCycle) {
            void var2_2;
            LifeCycle l = (LifeCycle)o;
            return this.addBean(o, var2_2.isRunning() ? Managed.UNMANAGED : Managed.AUTO);
        }
        return this.addBean((Object)var1_1, Managed.POJO);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addBean(Object o, boolean managed) {
        void var2_2;
        void var1_1;
        if (o instanceof LifeCycle) {
            return this.addBean(o, managed ? Managed.MANAGED : Managed.UNMANAGED);
        }
        return this.addBean((Object)var1_1, var2_2 != false ? Managed.POJO : Managed.UNMANAGED);
    }

    /*
     * WARNING - void declaration
     */
    private boolean addBean(Object o, Managed managed) {
        Object l;
        if (o == null || this.contains(o)) {
            return false;
        }
        Bean newBean = new Bean(o);
        if (o instanceof Container.Listener) {
            this.addEventListener((Container.Listener)o);
        }
        this._beans.add(newBean);
        for (Container.Listener listener : this._listeners) {
            listener.beanAdded(this, o);
        }
        try {
            void var2_2;
            switch (1.$SwitchMap$org$eclipse$jetty$util$component$ContainerLifeCycle$Managed[var2_2.ordinal()]) {
                case 3: {
                    this.unmanage(newBean);
                    break;
                }
                case 1: {
                    this.manage(newBean);
                    if (this.isStarting() && this._doStarted) {
                        l = (LifeCycle)o;
                        if (!l.isRunning()) {
                            this.start((LifeCycle)l);
                        }
                    }
                    break;
                }
                case 2: {
                    if (o instanceof LifeCycle) {
                        void var1_1;
                        l = (LifeCycle)var1_1;
                        if (this.isStarting()) {
                            if (l.isRunning()) {
                                this.unmanage(newBean);
                                break;
                            }
                            if (this._doStarted) {
                                this.manage(newBean);
                                this.start((LifeCycle)l);
                                break;
                            }
                            Bean.access$102(newBean, Managed.AUTO);
                            break;
                        }
                        if (this.isStarted()) {
                            this.unmanage(newBean);
                            break;
                        }
                        Bean.access$102(newBean, Managed.AUTO);
                        break;
                    }
                    Bean.access$102(newBean, Managed.POJO);
                    break;
                }
                case 4: {
                    Bean.access$102(newBean, Managed.POJO);
                }
            }
        }
        catch (Error | RuntimeException throwable) {
            l = throwable;
            throw throwable;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (LOG.isDebugEnabled()) {
            void var3_3;
            LOG.debug("{} added {}", this, var3_3);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void addManaged(LifeCycle lifecycle) {
        this.addBean(lifecycle, true);
        try {
            if (this.isRunning() && !lifecycle.isRunning()) {
                this.start((LifeCycle)lifecycle);
            }
            return;
        }
        catch (Error | RuntimeException throwable) {
            lifecycle = throwable;
            throw throwable;
        }
        catch (Exception e) {
            void var1_2;
            throw new RuntimeException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addEventListener(Container.Listener listener) {
        if (this._listeners.contains(listener)) {
            return;
        }
        this._listeners.add(listener);
        for (Bean b : this._beans) {
            void var3_3;
            listener.beanAdded(this, b._bean);
            if (!(listener instanceof Container.InheritedListener) || !b.isManaged() || !(b._bean instanceof Container)) continue;
            if (b._bean instanceof ContainerLifeCycle) {
                ((ContainerLifeCycle)b._bean).addBean((Object)listener, false);
                continue;
            }
            ((Container)((Bean)var3_3)._bean).addBean(listener);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void manage(Object bean) {
        void var1_1;
        for (Bean b : this._beans) {
            void var3_3;
            if (b._bean != bean) continue;
            this.manage((Bean)var3_3);
            return;
        }
        throw new IllegalArgumentException("Unknown bean " + var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void manage(Bean bean) {
        if (bean._managed != Managed.MANAGED) {
            Bean.access$102(bean, Managed.MANAGED);
            if (bean._bean instanceof Container) {
                for (Container.Listener l : this._listeners) {
                    void var3_3;
                    if (!(l instanceof Container.InheritedListener)) continue;
                    if (bean._bean instanceof ContainerLifeCycle) {
                        ((ContainerLifeCycle)bean._bean).addBean((Object)l, false);
                        continue;
                    }
                    ((Container)bean._bean).addBean(var3_3);
                }
            }
            if (bean._bean instanceof AbstractLifeCycle) {
                void var1_1;
                ((AbstractLifeCycle)((Bean)var1_1)._bean).setStopTimeout(this.getStopTimeout());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void unmanage(Object bean) {
        void var1_1;
        for (Bean b : this._beans) {
            void var3_3;
            if (b._bean != bean) continue;
            this.unmanage((Bean)var3_3);
            return;
        }
        throw new IllegalArgumentException("Unknown bean " + var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void unmanage(Bean bean) {
        if (bean._managed != Managed.UNMANAGED) {
            void var1_1;
            if (bean._managed == Managed.MANAGED && bean._bean instanceof Container) {
                for (Container.Listener l : this._listeners) {
                    void var3_3;
                    if (!(l instanceof Container.InheritedListener)) continue;
                    ((Container)bean._bean).removeBean(var3_3);
                }
            }
            Bean.access$102((Bean)var1_1, Managed.UNMANAGED);
        }
    }

    @Override
    public Collection<Object> getBeans() {
        return this.getBeans(Object.class);
    }

    /*
     * WARNING - void declaration
     */
    public void setBeans(Collection<Object> beans) {
        for (Object bean : beans) {
            void var2_2;
            this.addBean(var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> Collection<T> getBeans(Class<T> clazz) {
        void var2_2;
        ArrayList<T> beans = null;
        for (Bean b : this._beans) {
            if (!clazz.isInstance(b._bean)) continue;
            if (beans == null) {
                beans = new ArrayList<T>();
            }
            beans.add(clazz.cast(b._bean));
        }
        if (beans == null) {
            return Collections.emptyList();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T getBean(Class<T> clazz) {
        for (Bean b : this._beans) {
            void var3_3;
            if (!clazz.isInstance(b._bean)) continue;
            return clazz.cast(((Bean)var3_3)._bean);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void removeBeans() {
        Object object = new ArrayList<Bean>(this._beans);
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            void var2_2;
            Bean b = (Bean)object.next();
            this.remove((Bean)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Bean getBean(Object o) {
        for (Bean b : this._beans) {
            void var3_3;
            if (b._bean != o) continue;
            return var3_3;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean removeBean(Object o) {
        void var1_1;
        Bean b = this.getBean(o);
        return b != null && this.remove((Bean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private boolean remove(Bean bean) {
        if (this._beans.remove(bean)) {
            void var2_2;
            boolean wasManaged = bean.isManaged();
            this.unmanage(bean);
            for (Container.Listener listener : this._listeners) {
                listener.beanRemoved(this, bean._bean);
            }
            if (bean._bean instanceof Container.Listener) {
                this.removeEventListener((Container.Listener)bean._bean);
            }
            if (var2_2 != false && bean._bean instanceof LifeCycle) {
                try {
                    void var1_1;
                    this.stop((LifeCycle)((Bean)var1_1)._bean);
                }
                catch (Error | RuntimeException throwable) {
                    Throwable throwable2 = throwable;
                    throw throwable;
                }
                catch (Exception e) {
                    void var3_4;
                    throw new RuntimeException((Throwable)var3_4);
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeEventListener(Container.Listener listener) {
        if (this._listeners.remove(listener)) {
            for (Bean b : this._beans) {
                void var3_3;
                listener.beanRemoved(this, b._bean);
                if (!(listener instanceof Container.InheritedListener) || !b.isManaged() || !(b._bean instanceof Container)) continue;
                ((Container)((Bean)var3_3)._bean).removeBean(listener);
            }
        }
    }

    @Override
    public void setStopTimeout(long stopTimeout) {
        super.setStopTimeout(stopTimeout);
        for (Bean bean : this._beans) {
            if (!bean.isManaged() || !(bean._bean instanceof AbstractLifeCycle)) continue;
            ((AbstractLifeCycle)bean._bean).setStopTimeout(stopTimeout);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManagedOperation(value="Dump the object to stderr")
    public void dumpStdErr() {
        try {
            this.dump(System.err, "");
            System.err.println("key: +- bean, += managed, +~ unmanaged, +? auto, +: iterable, +] array, +@ map, +> undefined");
            return;
        }
        catch (IOException e) {
            void var1_1;
            LOG.warn((Throwable)var1_1);
            return;
        }
    }

    @Override
    @ManagedOperation(value="Dump the object to a string")
    public String dump() {
        return Dumpable.dump(this);
    }

    @Deprecated
    public static String dump(Dumpable dumpable) {
        return Dumpable.dump(dumpable);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void dump(Appendable out, String indent) throws IOException {
        void var2_2;
        void var1_1;
        this.dumpObjects((Appendable)var1_1, (String)var2_2, new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    public void dump(Appendable out) throws IOException {
        void var1_1;
        this.dump((Appendable)var1_1, "");
    }

    @Deprecated
    protected void dumpThis(Appendable out) throws IOException {
        out.append(String.valueOf(this)).append(" - ").append(this.getState()).append("\n");
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static void dumpObject(Appendable out, Object obj) throws IOException {
        void var1_1;
        Dumpable.dumpObject(out, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void dumpObjects(Appendable out, String indent, Object ... items) throws IOException {
        void var3_3;
        void var2_2;
        Dumpable.dumpObjects(out, (String)var2_2, this, (Object[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected void dumpBeans(Appendable out, String indent, Collection<?> ... items) throws IOException {
        void var3_3;
        void var2_2;
        ContainerLifeCycle.dump(out, (String)var2_2, var3_3);
    }

    @Deprecated
    public static void dump(Appendable out, String indent, Collection<?> ... collections) throws IOException {
        if (collections.length == 0) {
            return;
        }
        int size = 0;
        Collection<?>[] collectionArray = collections;
        int n = collections.length;
        for (int i = 0; i < n; ++i) {
            Collection<?> c = collectionArray[i];
            size += c.size();
        }
        if (size == 0) {
            return;
        }
        int i = 0;
        for (Iterator iterator : iterator) {
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                out.append(indent).append(" +- ");
                Dumpable.dumpObjects(out, indent + (++i < size ? " |  " : "    "), o, new Object[0]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void updateBean(Object oldBean, Object newBean) {
        if (newBean != oldBean) {
            if (oldBean != null) {
                void var1_1;
                this.removeBean(var1_1);
            }
            if (newBean != null) {
                void var2_2;
                this.addBean(var2_2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void updateBean(Object oldBean, Object newBean, boolean managed) {
        if (newBean != oldBean) {
            if (oldBean != null) {
                void var1_1;
                this.removeBean(var1_1);
            }
            if (newBean != null) {
                void var3_3;
                void var2_2;
                this.addBean((Object)var2_2, (boolean)var3_3);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void updateBeans(Object[] oldBeans, Object[] newBeans) {
        int n;
        int n2;
        Object[] objectArray;
        if (oldBeans != null) {
            Object[] objectArray2 = oldBeans;
            int n3 = oldBeans.length;
            block0: for (int i = 0; i < n3; ++i) {
                Object o = objectArray2[i];
                if (newBeans != null) {
                    objectArray = newBeans;
                    n2 = newBeans.length;
                    for (n = 0; n < n2; ++n) {
                        Object n4 = objectArray[n];
                        if (o == n4) continue block0;
                    }
                }
                this.removeBean(o);
            }
        }
        if (newBeans != null) {
            void var2_2;
            block2: for (Object n5 : var2_2) {
                if (oldBeans != null) {
                    objectArray = oldBeans;
                    n2 = oldBeans.length;
                    for (n = 0; n < n2; ++n) {
                        Object object = objectArray[n];
                        if (object == n5) continue block2;
                    }
                }
                this.addBean(n5);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> Collection<T> getContainedBeans(Class<T> clazz) {
        void var2_2;
        void var1_1;
        HashSet beans = new HashSet();
        this.getContainedBeans((Class<T>)var1_1, beans);
        return var2_2;
    }

    protected <T> void getContainedBeans(Class<T> clazz, Collection<T> beans) {
        beans.addAll(this.getBeans(clazz));
        for (Container c : this.getBeans(Container.class)) {
            Bean bean = this.getBean(c);
            if (bean == null || !bean.isManageable()) continue;
            if (c instanceof ContainerLifeCycle) {
                ((ContainerLifeCycle)c).getContainedBeans(clazz, beans);
                continue;
            }
            beans.addAll(c.getContainedBeans(clazz));
        }
    }

    private static class Bean {
        private final Object _bean;
        private volatile Managed _managed = Managed.POJO;

        /*
         * WARNING - void declaration
         */
        private Bean(Object b) {
            void var1_1;
            if (b == null) {
                throw new NullPointerException();
            }
            this._bean = var1_1;
        }

        public boolean isManaged() {
            return this._managed == Managed.MANAGED;
        }

        public boolean isManageable() {
            switch (this._managed) {
                case MANAGED: {
                    return true;
                }
                case AUTO: {
                    return this._bean instanceof LifeCycle && ((LifeCycle)this._bean).isStopped();
                }
            }
            return false;
        }

        public String toString() {
            return String.format("{%s,%s}", new Object[]{this._bean, this._managed});
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ Managed access$102(Bean x0, Managed x1) {
            void var1_1;
            x0._managed = var1_1;
            return x0._managed;
        }
    }

    static enum Managed {
        POJO,
        MANAGED,
        UNMANAGED,
        AUTO;

    }
}

