/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class Utf8Appendable {
    protected static final Logger LOG = Log.getLogger(Utf8Appendable.class);
    public static final char REPLACEMENT = '\ufffd';
    public static final byte[] REPLACEMENT_UTF8 = new byte[]{-17, -65, -67};
    private static final int UTF8_ACCEPT = 0;
    private static final int UTF8_REJECT = 12;
    protected final Appendable _appendable;
    protected int _state = 0;
    private static final byte[] BYTE_TABLE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 10, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 11, 6, 6, 6, 5, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
    private static final byte[] TRANS_TABLE = new byte[]{0, 12, 24, 36, 60, 96, 84, 12, 12, 12, 48, 72, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 0, 12, 12, 12, 12, 12, 0, 12, 0, 12, 12, 12, 24, 12, 12, 12, 12, 12, 24, 12, 24, 12, 12, 12, 12, 12, 12, 12, 12, 12, 24, 12, 12, 12, 12, 12, 24, 12, 12, 12, 12, 12, 12, 12, 24, 12, 12, 12, 12, 12, 12, 12, 12, 12, 36, 12, 36, 12, 12, 12, 36, 12, 12, 12, 12, 12, 36, 12, 36, 12, 12, 12, 36, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
    private int _codep;

    /*
     * WARNING - void declaration
     */
    public Utf8Appendable(Appendable appendable) {
        void var1_1;
        this._appendable = var1_1;
    }

    public abstract int length();

    protected void reset() {
        this._state = 0;
    }

    /*
     * WARNING - void declaration
     */
    private void checkCharAppend() throws IOException {
        if (this._state != 0) {
            void var1_1;
            this._appendable.append('\ufffd');
            int state = this._state;
            this._state = 0;
            throw new NotUtf8Exception("char appended in state " + (int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void append(char c) {
        try {
            this.checkCharAppend();
            this._appendable.append(c);
            return;
        }
        catch (IOException e) {
            void var1_2;
            throw new RuntimeException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void append(String s) {
        try {
            this.checkCharAppend();
            this._appendable.append(s);
            return;
        }
        catch (IOException e) {
            void var1_2;
            throw new RuntimeException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void append(String s, int offset, int length) {
        try {
            void var3_4;
            void var2_3;
            this.checkCharAppend();
            void v0 = var2_3;
            this._appendable.append(s, (int)v0, (int)(v0 + var3_4));
            return;
        }
        catch (IOException e) {
            void var1_2;
            throw new RuntimeException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void append(byte b) {
        try {
            this.appendByte(b);
            return;
        }
        catch (IOException e) {
            void var1_2;
            throw new RuntimeException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void append(ByteBuffer buf) {
        try {
            while (buf.remaining() > 0) {
                this.appendByte(buf.get());
            }
            return;
        }
        catch (IOException e) {
            void var1_2;
            throw new RuntimeException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void append(byte[] b) {
        void var1_1;
        this.append(b, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    public void append(byte[] b, int offset, int length) {
        try {
            void i;
            int end = offset + length;
            while (i < end) {
                this.appendByte(b[i]);
                ++i;
            }
            return;
        }
        catch (IOException e) {
            void var3_4;
            throw new RuntimeException((Throwable)var3_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean append(byte[] b, int offset, int length, int maxChars) {
        try {
            void i;
            int end = offset + length;
            while (i < end) {
                if (this.length() > maxChars) {
                    return false;
                }
                this.appendByte(b[i]);
                ++i;
            }
            return true;
        }
        catch (IOException e) {
            void var3_4;
            throw new RuntimeException((Throwable)var3_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void appendByte(byte b) throws IOException {
        void var2_4;
        int n;
        if (b > 0 && this._state == 0) {
            this._appendable.append((char)(b & 0xFF));
            return;
        }
        int i = b & 0xFF;
        byte type = BYTE_TABLE[i];
        this._codep = this._state == 0 ? 255 >> type & i : i & 0x3F | this._codep << 6;
        int next = TRANS_TABLE[this._state + n];
        switch (next) {
            case 0: {
                this._state = next;
                if (this._codep < 55296) {
                    this._appendable.append((char)this._codep);
                    return;
                }
                for (char c : Character.toChars(this._codep)) {
                    this._appendable.append(c);
                }
                return;
            }
            case 12: {
                void var1_3;
                String reason = "byte " + TypeUtil.toHexString(b) + " in state " + this._state / 12;
                this._codep = 0;
                this._state = 0;
                this._appendable.append('\ufffd');
                throw new NotUtf8Exception((String)var1_3);
            }
        }
        this._state = var2_4;
    }

    public boolean isUtf8SequenceComplete() {
        return this._state == 0;
    }

    /*
     * WARNING - void declaration
     */
    protected void checkState() {
        if (!this.isUtf8SequenceComplete()) {
            this._codep = 0;
            this._state = 0;
            try {
                this._appendable.append('\ufffd');
            }
            catch (IOException e) {
                void var1_1;
                throw new RuntimeException((Throwable)var1_1);
            }
            throw new NotUtf8Exception("incomplete UTF8 sequence");
        }
    }

    public abstract String getPartialString();

    /*
     * WARNING - void declaration
     */
    public String takePartialString() {
        void var1_1;
        void var2_2;
        String partial = this.getPartialString();
        int save = this._state;
        this.reset();
        this._state = var2_2;
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String toReplacedString() {
        if (!this.isUtf8SequenceComplete()) {
            void var1_2;
            this._codep = 0;
            this._state = 0;
            try {
                this._appendable.append('\ufffd');
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            NotUtf8Exception th = new NotUtf8Exception("incomplete UTF8 sequence");
            LOG.warn(th.toString(), new Object[0]);
            LOG.debug((Throwable)var1_2);
        }
        return this._appendable.toString();
    }

    public static class NotUtf8Exception
    extends IllegalArgumentException {
        /*
         * WARNING - void declaration
         */
        public NotUtf8Exception(String reason) {
            super("Not valid UTF8! " + (String)var1_1);
            void var1_1;
        }
    }
}

