/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.util.ByteArrayOutputStream2;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.Utf8Appendable;
import org.eclipse.jetty.util.Utf8StringBuffer;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class UrlEncoded
extends MultiMap<String>
implements Cloneable {
    static final Logger LOG;
    public static final Charset ENCODING;

    /*
     * WARNING - void declaration
     */
    public UrlEncoded(UrlEncoded url) {
        super(var1_1);
        void var1_1;
    }

    public UrlEncoded() {
    }

    /*
     * WARNING - void declaration
     */
    public UrlEncoded(String query) {
        void var1_1;
        UrlEncoded.decodeTo((String)var1_1, (MultiMap<String>)this, ENCODING);
    }

    public void decode(String query) {
        UrlEncoded.decodeTo(query, (MultiMap<String>)this, ENCODING);
    }

    /*
     * WARNING - void declaration
     */
    public void decode(String query, Charset charset) {
        void var2_2;
        UrlEncoded.decodeTo(query, (MultiMap<String>)this, (Charset)var2_2);
    }

    public String encode() {
        return this.encode(ENCODING, false);
    }

    /*
     * WARNING - void declaration
     */
    public String encode(Charset charset) {
        void var1_1;
        return this.encode((Charset)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized String encode(Charset charset, boolean equalsForNullValue) {
        void var2_2;
        void var1_1;
        return UrlEncoded.encode(this, (Charset)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String encode(MultiMap<String> map, Charset charset, boolean equalsForNullValue) {
        void var3_3;
        Object object;
        if (charset == null) {
            charset = ENCODING;
        }
        StringBuilder result = new StringBuilder(128);
        boolean delim = false;
        for (Map.Entry entry : ((LinkedHashMap)object).entrySet()) {
            String key = (String)entry.getKey();
            List list = (List)entry.getValue();
            int s = list.size();
            if (delim) {
                result.append('&');
            }
            if (s == 0) {
                result.append(UrlEncoded.encodeString(key, charset));
                if (equalsForNullValue) {
                    result.append('=');
                }
            } else {
                for (int i = 0; i < s; ++i) {
                    if (i > 0) {
                        result.append('&');
                    }
                    String val = (String)list.get(i);
                    result.append(UrlEncoded.encodeString(key, charset));
                    if (val != null) {
                        String str = val;
                        if (str.length() > 0) {
                            result.append('=');
                            result.append(UrlEncoded.encodeString(str, charset));
                            continue;
                        }
                        if (!equalsForNullValue) continue;
                        result.append('=');
                        continue;
                    }
                    if (!equalsForNullValue) continue;
                    result.append('=');
                }
            }
            boolean bl = true;
        }
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static void decodeTo(String content, MultiMap<String> map, String charset) {
        void var2_2;
        void var1_1;
        UrlEncoded.decodeTo(content, (MultiMap<String>)var1_1, charset == null ? null : Charset.forName((String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static void decodeTo(String content, MultiMap<String> map, Charset charset) {
        if (charset == null) {
            charset = ENCODING;
        }
        if (StandardCharsets.UTF_8.equals(charset)) {
            UrlEncoded.decodeUtf8To(content, 0, content.length(), map);
            return;
        }
        MultiMap<String> multiMap = map;
        synchronized (multiMap) {
            String string;
            void var2_3;
            String key = null;
            int mark = -1;
            boolean encoded = false;
            block9: for (int i = 0; i < content.length(); ++i) {
                char c = content.charAt(i);
                switch (c) {
                    case '&': {
                        int l = i - mark - 1;
                        String value = l == 0 ? "" : (encoded ? UrlEncoded.decodeString(content, mark + 1, l, charset) : content.substring(mark + 1, i));
                        mark = i;
                        encoded = false;
                        if (key != null) {
                            map.add(key, value);
                        } else if (value != null && value.length() > 0) {
                            map.add(value, "");
                        }
                        key = null;
                        continue block9;
                    }
                    case '=': {
                        if (key != null) continue block9;
                        key = encoded ? UrlEncoded.decodeString(content, mark + 1, i - mark - 1, charset) : content.substring(mark + 1, i);
                        mark = i;
                        encoded = false;
                        continue block9;
                    }
                    case '+': {
                        encoded = true;
                        continue block9;
                    }
                    case '%': {
                        encoded = true;
                    }
                }
            }
            if (key != null) {
                int l = content.length() - mark - 1;
                String value = l == 0 ? "" : (encoded ? UrlEncoded.decodeString(content, mark + 1, l, charset) : content.substring(mark + 1));
                map.add(key, value);
            } else if (mark < content.length() && (key = encoded ? UrlEncoded.decodeString(content, mark + 1, content.length() - mark - 1, (Charset)var2_3) : string.substring(mark + 1)) != null && key.length() > 0) {
                void var1_2;
                var1_2.add(key, "");
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void decodeUtf8To(String query, MultiMap<String> map) {
        void var1_1;
        String string;
        UrlEncoded.decodeUtf8To(query, 0, string.length(), (MultiMap<String>)var1_1);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void decodeUtf8To(String query, int offset, int length, MultiMap<String> map) {
        Utf8StringBuilder buffer = new Utf8StringBuilder();
        void var5_7 = map;
        synchronized (var5_7) {
            String key = null;
            void end = offset + length;
            block8: for (void i = offset; i < end; ++i) {
                void var1_1;
                char c = query.charAt((int)i);
                switch (c) {
                    case '&': {
                        String value = buffer.toReplacedString();
                        buffer.reset();
                        if (key != null) {
                            map.add(key, value);
                        } else if (value != null && value.length() > 0) {
                            map.add(value, "");
                        }
                        key = null;
                        continue block8;
                    }
                    case '=': {
                        if (key != null) break;
                        key = buffer.toReplacedString();
                        buffer.reset();
                        continue block8;
                    }
                    case '+': {
                        buffer.append((byte)32);
                        continue block8;
                    }
                    case '%': {
                        if (i + 2 >= end) {
                            throw new Utf8Appendable.NotUtf8Exception("Incomplete % encoding");
                        }
                        char hi = query.charAt((int)(++i));
                        char lo = query.charAt((int)(++i));
                        buffer.append(UrlEncoded.decodeHexByte((char)var1_1, lo));
                        continue block8;
                    }
                }
                buffer.append((char)var1_1);
            }
            if (key != null) {
                String string = buffer.toReplacedString();
                buffer.reset();
                map.add(key, string);
            } else if (((Utf8Appendable)buffer).length() > 0) {
                void var3_5;
                var3_5.add(buffer.toReplacedString(), "");
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void decode88591To(InputStream in, MultiMap<String> map, int maxLength, int maxKeys) throws IOException {
        MultiMap<String> multiMap = map;
        synchronized (multiMap) {
            void var3_4;
            void var1_2;
            int b;
            StringBuilder buffer = new StringBuilder();
            String key = null;
            int totalLength = 0;
            while ((b = in.read()) >= 0) {
                switch ((char)b) {
                    case '&': {
                        String value = buffer.length() == 0 ? "" : buffer.toString();
                        buffer.setLength(0);
                        if (key != null) {
                            map.add(key, value);
                        } else if (value.length() > 0) {
                            map.add(value, "");
                        }
                        key = null;
                        UrlEncoded.checkMaxKeys(map, maxKeys);
                        break;
                    }
                    case '=': {
                        if (key != null) {
                            void value;
                            buffer.append((char)value);
                            break;
                        }
                        key = buffer.toString();
                        buffer.setLength(0);
                        break;
                    }
                    case '+': {
                        buffer.append(' ');
                        break;
                    }
                    case '%': {
                        int code0 = in.read();
                        int code1 = in.read();
                        buffer.append(UrlEncoded.decodeHexChar(code0, code1));
                        break;
                    }
                    default: {
                        void var7_9;
                        buffer.append((char)var7_9);
                    }
                }
                UrlEncoded.checkMaxLength(++totalLength, maxLength);
            }
            if (key != null) {
                String string = buffer.length() == 0 ? "" : buffer.toString();
                buffer.setLength(0);
                map.add(key, string);
            } else if (buffer.length() > 0) {
                map.add(buffer.toString(), "");
            }
            UrlEncoded.checkMaxKeys((MultiMap<String>)var1_2, (int)var3_4);
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void decodeUtf8To(InputStream in, MultiMap<String> map, int maxLength, int maxKeys) throws IOException {
        void var4_4 = map;
        synchronized (var4_4) {
            void var3_3;
            void var1_1;
            int b;
            Utf8StringBuilder buffer = new Utf8StringBuilder();
            String key = null;
            int totalLength = 0;
            while ((b = in.read()) >= 0) {
                block15: {
                    void var7_8;
                    switch ((char)b) {
                        case '&': {
                            String value = buffer.toReplacedString();
                            buffer.reset();
                            if (key != null) {
                                map.add(key, value);
                            } else if (value != null && value.length() > 0) {
                                map.add(value, "");
                            }
                            key = null;
                            UrlEncoded.checkMaxKeys((MultiMap<String>)map, (int)maxKeys);
                            break block15;
                        }
                        case '=': {
                            if (key != null) break;
                            key = buffer.toReplacedString();
                            buffer.reset();
                            break block15;
                        }
                        case '+': {
                            buffer.append((byte)32);
                            break block15;
                        }
                        case '%': {
                            char code0 = (char)in.read();
                            char code1 = (char)in.read();
                            buffer.append(UrlEncoded.decodeHexByte(code0, code1));
                            break block15;
                        }
                    }
                    buffer.append((byte)var7_8);
                }
                UrlEncoded.checkMaxLength(++totalLength, (int)maxLength);
            }
            if (key != null) {
                String string = buffer.toReplacedString();
                buffer.reset();
                map.add(key, string);
            } else if (((Utf8Appendable)buffer).length() > 0) {
                map.add(buffer.toReplacedString(), "");
            }
            UrlEncoded.checkMaxKeys((MultiMap<String>)var1_1, (int)var3_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void decodeUtf16To(InputStream in, MultiMap<String> map, int maxLength, int maxKeys) throws IOException {
        void var1_1;
        void var3_4;
        void var2_2;
        Closeable closeable;
        Closeable input = new InputStreamReader(in, StandardCharsets.UTF_16);
        StringWriter buf = new StringWriter(8192);
        IO.copy((Reader)closeable, buf, (long)var2_2);
        UrlEncoded.decodeTo(var3_4.getBuffer().toString(), (MultiMap<String>)var1_1, StandardCharsets.UTF_16);
    }

    /*
     * WARNING - void declaration
     */
    public static void decodeTo(InputStream in, MultiMap<String> map, String charset, int maxLength, int maxKeys) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        InputStream inputStream;
        if (charset == null) {
            if (ENCODING.equals(StandardCharsets.UTF_8)) {
                UrlEncoded.decodeUtf8To(in, map, maxLength, maxKeys);
                return;
            }
            UrlEncoded.decodeTo(in, map, ENCODING, maxLength, maxKeys);
            return;
        }
        if ("utf-8".equalsIgnoreCase(charset)) {
            UrlEncoded.decodeUtf8To(in, map, maxLength, maxKeys);
            return;
        }
        if ("iso-8859-1".equalsIgnoreCase(charset)) {
            UrlEncoded.decode88591To(in, map, maxLength, maxKeys);
            return;
        }
        if ("utf-16".equalsIgnoreCase(charset)) {
            UrlEncoded.decodeUtf16To(in, map, maxLength, maxKeys);
            return;
        }
        UrlEncoded.decodeTo(inputStream, (MultiMap<String>)var1_1, Charset.forName((String)var2_2), (int)var3_3, maxKeys);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void decodeTo(InputStream in, MultiMap<String> map, Charset charset, int maxLength, int maxKeys) throws IOException {
        if (charset == null) {
            charset = ENCODING;
        }
        if (StandardCharsets.UTF_8.equals(charset)) {
            UrlEncoded.decodeUtf8To(in, (MultiMap<String>)map, (int)maxLength, (int)maxKeys);
            return;
        }
        if (StandardCharsets.ISO_8859_1.equals(charset)) {
            UrlEncoded.decode88591To(in, (MultiMap<String>)map, (int)maxLength, (int)maxKeys);
            return;
        }
        if (StandardCharsets.UTF_16.equals(charset)) {
            UrlEncoded.decodeUtf16To(in, (MultiMap<String>)map, (int)maxLength, (int)maxKeys);
            return;
        }
        void var5_5 = map;
        synchronized (var5_5) {
            String key = null;
            int totalLength = 0;
            try (ByteArrayOutputStream2 output = new ByteArrayOutputStream2();){
                void var1_1;
                int c;
                while ((c = in.read()) > 0) {
                    block25: {
                        int code1;
                        switch ((char)c) {
                            case '&': {
                                c = output.size();
                                String value = c == 0 ? "" : output.toString(charset);
                                output.setCount(0);
                                if (key != null) {
                                    map.add(key, value);
                                } else if (value != null && value.length() > 0) {
                                    map.add(value, "");
                                }
                                key = null;
                                UrlEncoded.checkMaxKeys((MultiMap<String>)map, (int)maxKeys);
                                break block25;
                            }
                            case '=': {
                                if (key != null) break;
                                int value = output.size();
                                key = value == 0 ? "" : output.toString(charset);
                                output.setCount(0);
                                break block25;
                            }
                            case '+': {
                                output.write(32);
                                break block25;
                            }
                            case '%': {
                                int code0 = in.read();
                                code1 = in.read();
                                output.write(UrlEncoded.decodeHexChar(code0, code1));
                                break block25;
                            }
                        }
                        output.write(code1);
                    }
                    UrlEncoded.checkMaxLength(++totalLength, (int)maxLength);
                }
                int size2 = output.size();
                if (key != null) {
                    String size2 = size2 == 0 ? "" : output.toString(charset);
                    output.setCount(0);
                    map.add(key, size2);
                } else if (size2 > 0) {
                    void var2_2;
                    map.add(output.toString((Charset)var2_2), "");
                }
                UrlEncoded.checkMaxKeys((MultiMap<String>)var1_1, (int)maxKeys);
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void checkMaxKeys(MultiMap<String> map, int maxKeys) {
        int size = map.size();
        if (maxKeys >= 0 && size > maxKeys) {
            void var1_2;
            void var0_1;
            throw new IllegalStateException(String.format("Form with too many keys [%d > %d]", (int)var0_1, (int)var1_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void checkMaxLength(int length, int maxLength) {
        int n;
        if (maxLength >= 0 && n > maxLength) {
            void var1_1;
            throw new IllegalStateException("Form is larger than max length " + (int)var1_1);
        }
    }

    public static String decodeString(String encoded) {
        String string;
        return UrlEncoded.decodeString(encoded, 0, string.length(), ENCODING);
    }

    /*
     * WARNING - void declaration
     */
    public static String decodeString(String encoded, int offset, int length, Charset charset) {
        if (charset == null || StandardCharsets.UTF_8.equals(charset)) {
            Utf8Appendable buffer = null;
            for (int i = 0; i < length; ++i) {
                char c = encoded.charAt(offset + i);
                if (c < '\u0000' || c > '\u00ff') {
                    if (buffer == null) {
                        buffer = new Utf8StringBuffer(length);
                        int n = offset;
                        ((Utf8StringBuffer)buffer).getStringBuffer().append(encoded, n, n + i + 1);
                        continue;
                    }
                    ((Utf8StringBuffer)buffer).getStringBuffer().append(c);
                    continue;
                }
                if (c == '+') {
                    if (buffer == null) {
                        buffer = new Utf8StringBuffer(length);
                        int n = offset;
                        ((Utf8StringBuffer)buffer).getStringBuffer().append(encoded, n, n + i);
                    }
                    ((Utf8StringBuffer)buffer).getStringBuffer().append(' ');
                    continue;
                }
                if (c == '%') {
                    if (buffer == null) {
                        buffer = new Utf8StringBuffer(length);
                        int n = offset;
                        ((Utf8StringBuffer)buffer).getStringBuffer().append(encoded, n, n + i);
                    }
                    if (i + 2 < length) {
                        int o = offset + i + 1;
                        i += 2;
                        byte b = (byte)TypeUtil.parseInt(encoded, o, 2, 16);
                        buffer.append(b);
                        continue;
                    }
                    ((Utf8StringBuffer)buffer).getStringBuffer().append('\ufffd');
                    i = length;
                    continue;
                }
                if (buffer == null) continue;
                ((Utf8StringBuffer)buffer).getStringBuffer().append(c);
            }
            if (buffer == null) {
                if (offset == 0 && encoded.length() == length) {
                    return encoded;
                }
                int n = offset;
                return encoded.substring(n, n + length);
            }
            return buffer.toReplacedString();
        }
        StringBuffer buffer = null;
        for (int i = 0; i < length; ++i) {
            char c;
            char c2 = encoded.charAt(offset + i);
            if (c2 < '\u0000' || c2 > '\u00ff') {
                if (buffer == null) {
                    buffer = new StringBuffer(length);
                    int n = offset;
                    buffer.append(encoded, n, n + i + 1);
                    continue;
                }
                buffer.append(c2);
                continue;
            }
            if (c2 == '+') {
                if (buffer == null) {
                    buffer = new StringBuffer(length);
                    int n = offset;
                    buffer.append(encoded, n, n + i);
                }
                buffer.append(' ');
                continue;
            }
            if (c2 == '%') {
                if (buffer == null) {
                    buffer = new StringBuffer(length);
                    int n = offset;
                    buffer.append(encoded, n, n + i);
                }
                byte[] ba = new byte[length];
                int n = 0;
                while (c2 >= '\u0000' && c2 <= '\u00ff') {
                    if (c2 == '%') {
                        if (i + 2 < length) {
                            int o = offset + i + 1;
                            i += 3;
                            ba[n] = (byte)TypeUtil.parseInt(encoded, o, 2, 16);
                            ++n;
                        } else {
                            ba[n++] = 63;
                            i = length;
                        }
                    } else if (c == '+') {
                        ba[n++] = 32;
                        ++i;
                    } else {
                        ba[n++] = (byte)c;
                        ++i;
                    }
                    if (i >= length) break;
                    c = encoded.charAt(offset + i);
                }
                --i;
                buffer.append(new String(ba, 0, n, charset));
                continue;
            }
            if (buffer == null) continue;
            buffer.append(c);
        }
        if (buffer == null) {
            void var2_2;
            String string;
            void var1_1;
            if (offset == 0 && encoded.length() == length) {
                return encoded;
            }
            void v7 = var1_1;
            return string.substring((int)v7, (int)(v7 + var2_2));
        }
        return buffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static char decodeHexChar(int hi, int lo) {
        try {
            return (char)((TypeUtil.convertHexDigit(hi) << 4) + TypeUtil.convertHexDigit(lo));
        }
        catch (NumberFormatException numberFormatException) {
            void var1_1;
            int n;
            throw new IllegalArgumentException("Not valid encoding '%" + (char)n + (char)var1_1 + "'");
        }
    }

    /*
     * WARNING - void declaration
     */
    private static byte decodeHexByte(char hi, char lo) {
        try {
            return (byte)((TypeUtil.convertHexDigit(hi) << 4) + TypeUtil.convertHexDigit(lo));
        }
        catch (NumberFormatException numberFormatException) {
            void var1_1;
            char c;
            throw new IllegalArgumentException("Not valid encoding '%" + c + (char)var1_1 + "'");
        }
    }

    public static String encodeString(String string) {
        return UrlEncoded.encodeString(string, ENCODING);
    }

    /*
     * WARNING - void declaration
     */
    public static String encodeString(String string, Charset charset) {
        void var1_1;
        if (charset == null) {
            charset = ENCODING;
        }
        byte[] bytes = string.getBytes(charset);
        int len = bytes.length;
        byte[] encoded = new byte[bytes.length * 3];
        int n = 0;
        boolean noEncode = true;
        for (int i = 0; i < len; ++i) {
            byte b = bytes[i];
            if (b == 32) {
                noEncode = false;
                encoded[n++] = 43;
                continue;
            }
            if (b >= 97 && b <= 122 || b >= 65 && b <= 90 || b >= 48 && b <= 57 || b == 45 || b == 46 || b == 95 || b == 126) {
                encoded[n++] = b;
                continue;
            }
            noEncode = false;
            encoded[n++] = 37;
            byte nibble = (byte)((b & 0xF0) >> 4);
            encoded[n++] = nibble >= 10 ? (byte)(nibble + 65 - 10) : (byte)(nibble + 48);
            nibble = (byte)(b & 0xF);
            encoded[n++] = nibble >= 10 ? (byte)(nibble + 65 - 10) : (byte)(nibble + 48);
        }
        if (noEncode) {
            String string2;
            return string2;
        }
        return new String(encoded, 0, n, (Charset)var1_1);
    }

    @Override
    public Object clone() {
        return new UrlEncoded(this);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        Charset encoding;
        LOG = Log.getLogger(UrlEncoded.class);
        try {
            String charset = System.getProperty("org.eclipse.jetty.util.UrlEncoding.charset");
            encoding = charset == null ? StandardCharsets.UTF_8 : Charset.forName(charset);
        }
        catch (Exception e) {
            LOG.warn(e);
            encoding = StandardCharsets.UTF_8;
        }
        ENCODING = var0;
    }
}

