/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Uptime {
    public static final int NOIMPL = -1;
    private static final Uptime INSTANCE = new Uptime();
    private Impl impl;

    public static Uptime getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private Uptime() {
        try {
            this.impl = new DefaultImpl();
            return;
        }
        catch (UnsupportedOperationException e) {
            void var1_1;
            System.err.printf("Defaulting Uptime to NOIMPL due to (%s) %s%n", e.getClass().getName(), var1_1.getMessage());
            this.impl = null;
            return;
        }
    }

    public Impl getImpl() {
        return this.impl;
    }

    /*
     * WARNING - void declaration
     */
    public void setImpl(Impl impl) {
        void var1_1;
        this.impl = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static long getUptime() {
        void var0;
        Uptime u = Uptime.getInstance();
        if (u == null || u.impl == null) {
            return -1L;
        }
        return var0.impl.getUptime();
    }

    public static class DefaultImpl
    implements Impl {
        public Object mxBean;
        public Method uptimeMethod;

        /*
         * WARNING - void declaration
         */
        public DefaultImpl() {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                void var3_4;
                void var1_1;
                Class<?> mgmtFactory = Class.forName("java.lang.management.ManagementFactory", true, cl);
                Class<?> runtimeClass = Class.forName("java.lang.management.RuntimeMXBean", true, cl);
                Class[] noparams = new Class[]{};
                Method mxBeanMethod = mgmtFactory.getMethod("getRuntimeMXBean", noparams);
                if (mxBeanMethod == null) {
                    throw new UnsupportedOperationException("method getRuntimeMXBean() not found");
                }
                this.mxBean = mxBeanMethod.invoke(mgmtFactory, new Object[0]);
                if (this.mxBean == null) {
                    throw new UnsupportedOperationException("getRuntimeMXBean() method returned null");
                }
                this.uptimeMethod = var1_1.getMethod("getUptime", (Class<?>)var3_4);
                if (this.mxBean == null) {
                    throw new UnsupportedOperationException("method getUptime() not found");
                }
                return;
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoClassDefFoundError | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                void var2_3;
                throw new UnsupportedOperationException("Implementation not available in this environment", (Throwable)var2_3);
            }
        }

        @Override
        public long getUptime() {
            try {
                return (Long)this.uptimeMethod.invoke(this.mxBean, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                return -1L;
            }
        }
    }

    public static interface Impl {
        public long getUptime();
    }
}

