/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.util.HostPort;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.Utf8Appendable;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class URIUtil
implements Cloneable {
    private static final Logger LOG = Log.getLogger(URIUtil.class);
    public static final String SLASH = "/";
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    public static final Charset __CHARSET = StandardCharsets.UTF_8;

    private URIUtil() {
    }

    /*
     * WARNING - void declaration
     */
    public static String encodePath(String path) {
        void var1_1;
        if (path == null || path.length() == 0) {
            return path;
        }
        StringBuilder buf = URIUtil.encodePath(null, path, 0);
        if (buf == null) {
            String string;
            return string;
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static StringBuilder encodePath(StringBuilder buf, String path) {
        void var1_1;
        return URIUtil.encodePath(buf, (String)var1_1, 0);
    }

    private static StringBuilder encodePath(StringBuilder buf, String path, int offset) {
        StringBuilder stringBuilder;
        int i;
        byte[] bytes = null;
        if (buf == null) {
            block41: for (i = offset; i < path.length(); ++i) {
                char c = path.charAt(i);
                switch (c) {
                    case ' ': 
                    case '\"': 
                    case '#': 
                    case '%': 
                    case '\'': 
                    case ';': 
                    case '<': 
                    case '>': 
                    case '?': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '^': 
                    case '`': 
                    case '{': 
                    case '|': 
                    case '}': {
                        buf = new StringBuilder(path.length() << 1);
                        break block41;
                    }
                    default: {
                        if (c >= ' ' && c < '\u007f') continue block41;
                        bytes = path.getBytes(__CHARSET);
                        buf = new StringBuilder(path.length() << 1);
                        break block41;
                    }
                }
            }
            if (buf == null) {
                return null;
            }
        }
        block42: for (i = var2_2; i < path.length(); ++i) {
            char c = path.charAt(i);
            switch (c) {
                case '%': {
                    buf.append("%25");
                    continue block42;
                }
                case '?': {
                    buf.append("%3F");
                    continue block42;
                }
                case ';': {
                    buf.append("%3B");
                    continue block42;
                }
                case '#': {
                    buf.append("%23");
                    continue block42;
                }
                case '\"': {
                    buf.append("%22");
                    continue block42;
                }
                case '\'': {
                    buf.append("%27");
                    continue block42;
                }
                case '<': {
                    buf.append("%3C");
                    continue block42;
                }
                case '>': {
                    buf.append("%3E");
                    continue block42;
                }
                case ' ': {
                    buf.append("%20");
                    continue block42;
                }
                case '[': {
                    buf.append("%5B");
                    continue block42;
                }
                case '\\': {
                    buf.append("%5C");
                    continue block42;
                }
                case ']': {
                    buf.append("%5D");
                    continue block42;
                }
                case '^': {
                    buf.append("%5E");
                    continue block42;
                }
                case '`': {
                    buf.append("%60");
                    continue block42;
                }
                case '{': {
                    buf.append("%7B");
                    continue block42;
                }
                case '|': {
                    buf.append("%7C");
                    continue block42;
                }
                case '}': {
                    buf.append("%7D");
                    continue block42;
                }
                default: {
                    if (c < ' ' || c >= '\u007f') {
                        bytes = path.getBytes(__CHARSET);
                        break block42;
                    }
                    buf.append(c);
                }
            }
        }
        if (bytes != null) {
            while (i < bytes.length) {
                void var5_7 = bytes[i];
                switch (var5_7) {
                    case 37: {
                        buf.append("%25");
                        break;
                    }
                    case 63: {
                        buf.append("%3F");
                        break;
                    }
                    case 59: {
                        buf.append("%3B");
                        break;
                    }
                    case 35: {
                        buf.append("%23");
                        break;
                    }
                    case 34: {
                        buf.append("%22");
                        break;
                    }
                    case 39: {
                        buf.append("%27");
                        break;
                    }
                    case 60: {
                        buf.append("%3C");
                        break;
                    }
                    case 62: {
                        buf.append("%3E");
                        break;
                    }
                    case 32: {
                        buf.append("%20");
                        break;
                    }
                    case 91: {
                        buf.append("%5B");
                        break;
                    }
                    case 92: {
                        buf.append("%5C");
                        break;
                    }
                    case 93: {
                        buf.append("%5D");
                        break;
                    }
                    case 94: {
                        buf.append("%5E");
                        break;
                    }
                    case 96: {
                        buf.append("%60");
                        break;
                    }
                    case 123: {
                        buf.append("%7B");
                        break;
                    }
                    case 124: {
                        buf.append("%7C");
                        break;
                    }
                    case 125: {
                        buf.append("%7D");
                        break;
                    }
                    default: {
                        if (var5_7 < 32 || var5_7 >= 127) {
                            buf.append('%');
                            TypeUtil.toHex((byte)var5_7, (Appendable)buf);
                            break;
                        }
                        buf.append((char)var5_7);
                    }
                }
                ++i;
            }
        }
        return stringBuilder;
    }

    public static String encodeSpaces(String str) {
        return StringUtil.replace(str, " ", "%20");
    }

    /*
     * WARNING - void declaration
     */
    public static String encodeSpecific(String str, String charsToEncode) {
        void var3_3;
        if (str == null || str.length() == 0) {
            return null;
        }
        if (charsToEncode == null || charsToEncode.length() == 0) {
            return str;
        }
        char[] find = charsToEncode.toCharArray();
        int len = str.length();
        StringBuilder ret = new StringBuilder((int)((double)len * 0.2));
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            boolean escaped = false;
            char[] cArray = find;
            int n = find.length;
            for (int j = 0; j < n; ++j) {
                char f = cArray[j];
                if (c != f) continue;
                escaped = true;
                ret.append('%');
                int d = 0xF & (0xF0 & c) >> 4;
                ret.append((char)((d > 9 ? 55 : 48) + d));
                d = 0xF & c;
                ret.append((char)((d > 9 ? 55 : 48) + d));
                break;
            }
            if (escaped) continue;
            ret.append(c);
        }
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String decodeSpecific(String str, String charsToDecode) {
        void i;
        if (str == null || str.length() == 0) {
            return null;
        }
        if (charsToDecode == null || charsToDecode.length() == 0) {
            return str;
        }
        int idx = str.indexOf(37);
        if (idx == -1) {
            return str;
        }
        char[] find = charsToDecode.toCharArray();
        int len = str.length();
        Utf8StringBuilder ret = new Utf8StringBuilder(len);
        ret.append(str, 0, idx);
        while (i < len) {
            char c = str.charAt((int)i);
            switch (c) {
                case '%': {
                    if (i + 2 < len) {
                        char u = str.charAt((int)(i + true));
                        char l = str.charAt((int)(i + 2));
                        char result = (char)(0xFF & (TypeUtil.convertHexDigit(u) << 4) + TypeUtil.convertHexDigit(l));
                        boolean decoded = false;
                        char[] cArray = find;
                        int n = find.length;
                        for (int j = 0; j < n; ++j) {
                            char c2 = cArray[j];
                            if (c2 != result) continue;
                            ret.append(result);
                            decoded = true;
                            break;
                        }
                        if (decoded) {
                            i += 2;
                            break;
                        }
                        ret.append(c);
                        break;
                    }
                    throw new IllegalArgumentException("Bad URI % encoding");
                }
                default: {
                    ret.append(c);
                }
            }
            ++i;
        }
        return ret.toString();
    }

    public static StringBuilder encodeString(StringBuilder buf, String path, String encode) {
        StringBuilder stringBuilder;
        char c;
        int i;
        if (buf == null) {
            for (i = 0; i < path.length(); ++i) {
                c = path.charAt(i);
                if (c != '%' && encode.indexOf(c) < 0) continue;
                buf = new StringBuilder(path.length() << 1);
                break;
            }
            if (buf == null) {
                return null;
            }
        }
        for (i = 0; i < path.length(); ++i) {
            c = path.charAt(i);
            if (c == '%' || encode.indexOf(c) >= 0) {
                buf.append('%');
                StringUtil.append(buf, (byte)(0xFF & c), 16);
                continue;
            }
            buf.append(c);
        }
        return stringBuilder;
    }

    public static String decodePath(String path) {
        String string;
        return URIUtil.decodePath(path, 0, string.length());
    }

    /*
     * WARNING - void declaration
     */
    public static String decodePath(String path, int offset, int length) {
        try {
            Utf8StringBuilder builder = null;
            int end = offset + length;
            block8: for (int i = offset; i < end; ++i) {
                char c = path.charAt(i);
                switch (c) {
                    case '%': {
                        if (builder == null) {
                            builder = new Utf8StringBuilder(path.length());
                            builder.append(path, offset, i - offset);
                        }
                        if (i + 2 < end) {
                            char u = path.charAt(i + 1);
                            if (u == 'u') {
                                builder.append((char)(0xFFFF & TypeUtil.parseInt(path, i + 2, 4, 16)));
                                i += 5;
                                continue block8;
                            }
                            builder.append((byte)(0xFF & (TypeUtil.convertHexDigit(u) << 4) + TypeUtil.convertHexDigit(path.charAt(i + 2))));
                            i += 2;
                            continue block8;
                        }
                        throw new IllegalArgumentException("Bad URI % encoding");
                    }
                    case ';': {
                        if (builder == null) {
                            builder = new Utf8StringBuilder(path.length());
                            builder.append(path, offset, i - offset);
                        }
                        while (++i < end) {
                            if (path.charAt(i) != '/') continue;
                            builder.append('/');
                            continue block8;
                        }
                        continue block8;
                    }
                    default: {
                        void var6_9;
                        if (builder == null) continue block8;
                        builder.append((char)var6_9);
                    }
                }
            }
            if (builder != null) {
                return builder.toString();
            }
            if (offset == 0 && length == path.length()) {
                return path;
            }
            return path.substring(offset, end);
        }
        catch (Utf8Appendable.NotUtf8Exception e) {
            void var2_2;
            void var1_1;
            String string;
            int n = offset;
            LOG.debug(path.substring(n, n + length) + " " + e, new Object[0]);
            return URIUtil.decodeISO88591Path(string, (int)var1_1, (int)var2_2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            IllegalArgumentException e = illegalArgumentException;
            throw illegalArgumentException;
        }
        catch (Exception e) {
            void var3_6;
            throw new IllegalArgumentException("cannot decode URI", (Throwable)var3_6);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String decodeISO88591Path(String path, int offset, int length) {
        void var1_1;
        String string;
        void var2_2;
        StringBuilder builder = null;
        int end = offset + length;
        block4: for (int i = offset; i < end; ++i) {
            char c = path.charAt(i);
            switch (c) {
                case '%': {
                    if (builder == null) {
                        builder = new StringBuilder(path.length());
                        builder.append(path, offset, i - offset);
                    }
                    if (i + 2 < end) {
                        char u = path.charAt(i + 1);
                        if (u == 'u') {
                            builder.append((char)(0xFFFF & TypeUtil.parseInt(path, i + 2, 4, 16)));
                            i += 5;
                            continue block4;
                        }
                        builder.append((char)(0xFF & (TypeUtil.convertHexDigit(u) << 4) + TypeUtil.convertHexDigit(path.charAt(i + 2))));
                        i += 2;
                        continue block4;
                    }
                    throw new IllegalArgumentException();
                }
                case ';': {
                    if (builder == null) {
                        builder = new StringBuilder(path.length());
                        builder.append(path, offset, i - offset);
                    }
                    while (++i < end) {
                        if (path.charAt(i) != '/') continue;
                        builder.append('/');
                        continue block4;
                    }
                    continue block4;
                }
                default: {
                    void var6_6;
                    if (builder == null) continue block4;
                    builder.append((char)var6_6);
                }
            }
        }
        if (builder != null) {
            void var3_3;
            return var3_3.toString();
        }
        if (offset == 0 && var2_2 == path.length()) {
            return path;
        }
        return string.substring((int)var1_1, end);
    }

    /*
     * WARNING - void declaration
     */
    public static String addEncodedPaths(String p1, String p2) {
        void var3_3;
        String string;
        if (p1 == null || p1.length() == 0) {
            if (p1 != null && p2 == null) {
                return p1;
            }
            return p2;
        }
        if (p2 == null || p2.length() == 0) {
            return p1;
        }
        int split = p1.indexOf(59);
        if (split < 0) {
            split = p1.indexOf(63);
        }
        if (split == 0) {
            return p2 + p1;
        }
        if (split < 0) {
            split = p1.length();
        }
        StringBuilder buf = new StringBuilder(p1.length() + p2.length() + 2);
        buf.append(string);
        if (buf.charAt(split - 1) == '/') {
            if (p2.startsWith(SLASH)) {
                buf.deleteCharAt(split - 1);
                buf.insert(split - 1, p2);
            } else {
                buf.insert(split, p2);
            }
        } else if (p2.startsWith(SLASH)) {
            buf.insert(split, p2);
        } else {
            void var1_1;
            void var2_2;
            buf.insert(split, '/');
            buf.insert((int)(var2_2 + true), (String)var1_1);
        }
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String addPaths(String p1, String p2) {
        void var2_3;
        void var1_1;
        String string;
        void var3_4;
        if (p1 == null || p1.length() == 0) {
            if (p1 != null && p2 == null) {
                return p1;
            }
            return p2;
        }
        if (p2 == null || p2.length() == 0) {
            return p1;
        }
        boolean p1EndsWithSlash = p1.endsWith(SLASH);
        boolean p2StartsWithSlash = p2.startsWith(SLASH);
        if (p1EndsWithSlash && var3_4 != false) {
            if (p2.length() == 1) {
                return p1;
            }
            if (p1.length() == 1) {
                return p2;
            }
        }
        StringBuilder buf = new StringBuilder(p1.length() + p2.length() + 2);
        buf.append(p1);
        if (string.endsWith(SLASH)) {
            if (p2.startsWith(SLASH)) {
                StringBuilder stringBuilder = buf;
                stringBuilder.setLength(stringBuilder.length() - 1);
            }
        } else if (!p2.startsWith(SLASH)) {
            buf.append(SLASH);
        }
        buf.append((String)var1_1);
        return var2_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String addPathQuery(String path, String query) {
        void var1_1;
        String string;
        if (query == null) {
            return path;
        }
        if (path.indexOf(63) >= 0) {
            return path + '&' + query;
        }
        return string + '?' + (String)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static String getUriLastPathSegment(URI uri) {
        Object object;
        Object ssp = uri.getSchemeSpecificPart();
        int idx = ((String)ssp).indexOf("!/");
        if (idx != -1) {
            ssp = ((String)ssp).substring(0, idx);
        }
        if (((String)ssp).endsWith(SLASH)) {
            ssp = ((String)ssp).substring(0, ((String)ssp).length() - 1);
        }
        if ((idx = ((String)ssp).lastIndexOf(47)) != -1) {
            void var1_1;
            ssp = ((String)ssp).substring((int)(var1_1 + true));
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static String parentPath(String p) {
        if (p == null || SLASH.equals(p)) {
            return null;
        }
        int slash = p.lastIndexOf(47, p.length() - 2);
        if (slash >= 0) {
            void var1_1;
            String string;
            return string.substring(0, (int)(var1_1 + true));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String canonicalURI(String uri) {
        int i;
        if (uri == null || uri.isEmpty()) {
            return uri;
        }
        boolean slash = true;
        int end = uri.length();
        block10: for (i = 0; i < end; ++i) {
            char c = uri.charAt(i);
            switch (c) {
                case '/': {
                    slash = true;
                    continue block10;
                }
                case '.': {
                    if (slash) break block10;
                    slash = false;
                    continue block10;
                }
                case '#': 
                case '?': {
                    return uri;
                }
                default: {
                    slash = false;
                }
            }
        }
        if (i == end) {
            return uri;
        }
        StringBuilder canonical = new StringBuilder(uri.length());
        canonical.append(uri, 0, i);
        int dots = 1;
        ++i;
        block11: while (i < end) {
            char c = uri.charAt(i);
            switch (c) {
                case '/': {
                    if (URIUtil.doDotsSlash(canonical, dots)) {
                        return null;
                    }
                    slash = true;
                    dots = 0;
                    break;
                }
                case '#': 
                case '?': {
                    break block11;
                }
                case '.': {
                    if (dots > 0) {
                        ++dots;
                    } else if (slash) {
                        dots = 1;
                    } else {
                        canonical.append('.');
                    }
                    slash = false;
                    break;
                }
                default: {
                    while (dots-- > 0) {
                        canonical.append('.');
                    }
                    canonical.append(c);
                    dots = 0;
                    slash = false;
                }
            }
            ++i;
        }
        if (URIUtil.doDots(canonical, dots)) {
            return null;
        }
        if (i < end) {
            void var2_2;
            void var3_3;
            String string;
            canonical.append(string, (int)var3_3, (int)var2_2);
        }
        return canonical.toString();
    }

    @Deprecated
    public static String canonicalEncodedPath(String path) {
        return URIUtil.canonicalURI(path);
    }

    public static String canonicalPath(String path) {
        int i;
        if (path == null || path.isEmpty()) {
            return path;
        }
        boolean slash = true;
        int end = path.length();
        block8: for (i = 0; i < end; ++i) {
            char c = path.charAt(i);
            switch (c) {
                case '/': {
                    slash = true;
                    continue block8;
                }
                case '.': {
                    if (slash) break block8;
                    slash = false;
                    continue block8;
                }
                default: {
                    slash = false;
                }
            }
        }
        if (i == end) {
            return path;
        }
        StringBuilder canonical = new StringBuilder(path.length());
        canonical.append(path, 0, i);
        int dots = 1;
        ++i;
        while (i < end) {
            char c = path.charAt(i);
            switch (c) {
                case '/': {
                    if (URIUtil.doDotsSlash(canonical, dots)) {
                        return null;
                    }
                    slash = true;
                    dots = 0;
                    break;
                }
                case '.': {
                    if (dots > 0) {
                        ++dots;
                    } else if (slash) {
                        dots = 1;
                    } else {
                        canonical.append('.');
                    }
                    slash = false;
                    break;
                }
                default: {
                    while (dots-- > 0) {
                        canonical.append('.');
                    }
                    canonical.append(c);
                    dots = 0;
                    slash = false;
                }
            }
            ++i;
        }
        if (URIUtil.doDots(canonical, dots)) {
            return null;
        }
        return canonical.toString();
    }

    private static boolean doDots(StringBuilder canonical, int dots) {
        switch (dots) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                if (canonical.length() < 2) {
                    return true;
                }
                StringBuilder stringBuilder = canonical;
                stringBuilder.setLength(stringBuilder.length() - 1);
                StringBuilder stringBuilder2 = canonical;
                stringBuilder2.setLength(stringBuilder2.lastIndexOf(SLASH) + 1);
                break;
            }
            default: {
                while (dots-- > 0) {
                    canonical.append('.');
                }
                break block0;
            }
        }
        return false;
    }

    private static boolean doDotsSlash(StringBuilder canonical, int dots) {
        switch (dots) {
            case 0: {
                canonical.append('/');
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (canonical.length() < 2) {
                    return true;
                }
                StringBuilder stringBuilder = canonical;
                stringBuilder.setLength(stringBuilder.length() - 1);
                StringBuilder stringBuilder2 = canonical;
                stringBuilder2.setLength(stringBuilder2.lastIndexOf(SLASH) + 1);
                break;
            }
            default: {
                StringBuilder stringBuilder;
                while (dots-- > 0) {
                    canonical.append('.');
                }
                stringBuilder.append('/');
            }
        }
        return false;
    }

    public static String compactPath(String path) {
        int i;
        if (path == null || path.length() == 0) {
            return path;
        }
        int state = 0;
        int end = path.length();
        block8: for (i = 0; i < end; ++i) {
            char c = path.charAt(i);
            switch (c) {
                case '?': {
                    return path;
                }
                case '/': {
                    if (++state != 2) continue block8;
                    break block8;
                }
                default: {
                    state = 0;
                }
            }
        }
        if (state < 2) {
            return path;
        }
        StringBuilder buf = new StringBuilder(path.length());
        buf.append(path, 0, i);
        block9: while (i < end) {
            char c = path.charAt(i);
            switch (c) {
                case '?': {
                    buf.append(path, i, end);
                    break block9;
                }
                case '/': {
                    if (state++ != 0) break;
                    buf.append(c);
                    break;
                }
                default: {
                    state = 0;
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static boolean hasScheme(String uri) {
        for (int i = 0; i < uri.length(); ++i) {
            void var2_2;
            char c = uri.charAt(i);
            if (c == ':') {
                return true;
            }
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') && (i <= 0 || (c < '0' || c > '9') && c != '.' && c != '+' && var2_2 != 45)) break;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static String newURI(String scheme, String server, int port, String path, String query) {
        CharSequence charSequence;
        void var3_3;
        void var2_2;
        void var1_1;
        CharSequence builder = URIUtil.newURIBuilder(scheme, (String)var1_1, (int)var2_2);
        ((StringBuilder)builder).append((String)var3_3);
        if (query != null && query.length() > 0) {
            ((StringBuilder)builder).append('?').append(query);
        }
        return ((StringBuilder)charSequence).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static StringBuilder newURIBuilder(String scheme, String server, int port) {
        void var3_3;
        void var2_2;
        void var1_1;
        String string;
        StringBuilder builder = new StringBuilder();
        URIUtil.appendSchemeHostPort(builder, string, (String)var1_1, (int)var2_2);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static void appendSchemeHostPort(StringBuilder url, String scheme, String server, int port) {
        void var2_2;
        url.append(scheme).append("://").append(HostPort.normalizeHost((String)var2_2));
        if (port > 0) {
            void var1_1;
            int n = -1;
            switch (var1_1.hashCode()) {
                case 3213448: {
                    if (!var1_1.equals(HTTP)) break;
                    n = 0;
                    break;
                }
                case 99617003: {
                    if (!var1_1.equals(HTTPS)) break;
                    n = 1;
                }
            }
            switch (n) {
                case 0: {
                    if (port == 80) break;
                    url.append(':').append(port);
                    return;
                }
                case 1: {
                    if (port == 443) break;
                    url.append(':').append(port);
                    return;
                }
                default: {
                    void var3_4;
                    StringBuilder stringBuilder;
                    stringBuilder.append(':').append((int)var3_4);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void appendSchemeHostPort(StringBuffer url, String scheme, String server, int port) {
        StringBuffer stringBuffer = url;
        synchronized (stringBuffer) {
            void var2_3;
            url.append(scheme).append("://").append(HostPort.normalizeHost((String)var2_3));
            if (port > 0) {
                void var1_2;
                int n = -1;
                switch (var1_2.hashCode()) {
                    case 3213448: {
                        if (!var1_2.equals(HTTP)) break;
                        n = 0;
                        break;
                    }
                    case 99617003: {
                        if (!var1_2.equals(HTTPS)) break;
                        n = 1;
                    }
                }
                switch (n) {
                    case 0: {
                        if (port == 80) break;
                        url.append(':').append(port);
                        break;
                    }
                    case 1: {
                        if (port == 443) break;
                        url.append(':').append(port);
                        break;
                    }
                    default: {
                        void var3_5;
                        StringBuffer stringBuffer2;
                        stringBuffer2.append(':').append((int)var3_5);
                    }
                }
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean equalsIgnoreEncodings(String uriA, String uriB) {
        void var3_3;
        void var2_2;
        int lenA = uriA.length();
        int lenB = uriB.length();
        int a = 0;
        int b = 0;
        while (a < lenA && b < lenB) {
            int ob;
            int oa;
            int ca = oa = uriA.charAt(a++);
            if (oa == 37) {
                ca = URIUtil.lenientPercentDecode(uriA, a);
                if (ca == -1) {
                    ca = 37;
                } else {
                    a += 2;
                }
            }
            int cb = ob = uriB.charAt(b++);
            if (ob == 37) {
                cb = URIUtil.lenientPercentDecode(uriB, b);
                if (cb == -1) {
                    cb = 37;
                } else {
                    b += 2;
                }
            }
            if (ca == 47 && oa != ob) {
                return false;
            }
            if (ca == cb) continue;
            return false;
        }
        return a == var2_2 && b == var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static int lenientPercentDecode(String str, int offset) {
        if (offset >= str.length()) {
            return -1;
        }
        if (StringUtil.isHex(str, offset, 2)) {
            void var1_1;
            String string;
            return TypeUtil.parseInt(string, (int)var1_1, 2, 16);
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean equalsIgnoreEncodings(URI uriA, URI uriB) {
        void var1_1;
        URI uRI;
        while (true) {
            if (uriA.equals(uriB)) {
                return true;
            }
            if (uriA.getScheme() == null ? uriB.getScheme() != null : !uriA.getScheme().equalsIgnoreCase(uriB.getScheme())) {
                return false;
            }
            if (!"jar".equalsIgnoreCase(uriA.getScheme())) break;
            URI uriAssp = URI.create(uriA.getSchemeSpecificPart());
            URI uriBssp = URI.create(uriB.getSchemeSpecificPart());
        }
        if (uRI.getAuthority() == null ? var1_1.getAuthority() != null : !uRI.getAuthority().equals(var1_1.getAuthority())) {
            return false;
        }
        return URIUtil.equalsIgnoreEncodings(uRI.getPath(), var1_1.getPath());
    }

    /*
     * WARNING - void declaration
     */
    public static URI addPath(URI uri, String path) {
        void var2_3;
        void var0_1;
        void var1_2;
        String base = uri.toASCIIString();
        StringBuilder buf = new StringBuilder(base.length() + path.length() * 3);
        buf.append(base);
        if (buf.charAt(base.length() - 1) != '/') {
            buf.append('/');
        }
        boolean offset = path.charAt(0) == '/';
        URIUtil.encodePath(buf, (String)var1_2, (int)var0_1);
        return URI.create(var2_3.toString());
    }

    /*
     * WARNING - void declaration
     */
    public static String addQueries(String query1, String query2) {
        void var1_1;
        String string;
        if (StringUtil.isEmpty(query1)) {
            return query2;
        }
        if (StringUtil.isEmpty(query2)) {
            return query1;
        }
        return string + '&' + (String)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static URI getJarSource(URI uri) {
        try {
            if (!"jar".equals(uri.getScheme())) {
                return uri;
            }
            Object s = uri.getRawSchemeSpecificPart();
            int bangSlash = ((String)s).indexOf("!/");
            if (bangSlash >= 0) {
                void var1_2;
                s = ((String)s).substring(0, (int)var1_2);
            }
            return new URI((String)s);
        }
        catch (URISyntaxException e) {
            void var0_1;
            throw new IllegalArgumentException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String getJarSource(String uri) {
        String string;
        if (!uri.startsWith("jar:")) {
            return uri;
        }
        int bangSlash = uri.indexOf("!/");
        if (bangSlash >= 0) {
            void var1_1;
            return uri.substring(4, (int)var1_1);
        }
        return string.substring(4);
    }
}

