/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jetty.util.AbstractTrie;

public class TreeTrie<V>
extends AbstractTrie<V> {
    private static final int[] LOOKUP = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26, -1, 27, 30, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 28, 29, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1};
    private static final int INDEX = 32;
    private final TreeTrie<V>[] _nextIndex;
    private final List<TreeTrie<V>> _nextOther = new ArrayList<TreeTrie<V>>();
    private final char _c;
    private String _key;
    private V _value;

    public TreeTrie() {
        super(true);
        this._nextIndex = new TreeTrie[32];
        this._c = '\u0000';
    }

    /*
     * WARNING - void declaration
     */
    private TreeTrie(char c) {
        super(true);
        void var1_1;
        this._nextIndex = new TreeTrie[32];
        this._c = var1_1;
    }

    @Override
    public void clear() {
        Arrays.fill(this._nextIndex, null);
        this._nextOther.clear();
        this._key = null;
        this._value = null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean put(String s, V v) {
        void var2_2;
        void var1_1;
        TreeTrie<V> t = this;
        int limit = s.length();
        for (int k = 0; k < limit; ++k) {
            char c = s.charAt(k);
            int index = c >= '\u0000' && c < '\u007f' ? LOOKUP[c] : -1;
            if (index >= 0) {
                if (t._nextIndex[index] == null) {
                    t._nextIndex[index] = new TreeTrie<V>(c);
                }
                t = t._nextIndex[index];
                continue;
            }
            TreeTrie<V> n = null;
            int i = t._nextOther.size();
            while (i-- > 0) {
                n = t._nextOther.get(i);
                if (n._c == c) break;
                n = null;
            }
            if (n == null) {
                n = new TreeTrie<V>(c);
                t._nextOther.add(n);
            }
            t = n;
        }
        t._key = v == null ? null : var1_1;
        var3_3._value = var2_2;
        return true;
    }

    @Override
    public V get(String s, int offset, int len) {
        TreeTrie<V> t = this;
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(offset + i);
            int index = c >= '\u0000' && c < '\u007f' ? LOOKUP[c] : -1;
            if (index >= 0) {
                if (t._nextIndex[index] == null) {
                    return null;
                }
                t = t._nextIndex[index];
                continue;
            }
            TreeTrie<V> n = null;
            int j = t._nextOther.size();
            while (j-- > 0) {
                n = t._nextOther.get(j);
                if (n._c == c) break;
                n = null;
            }
            if (n == null) {
                return null;
            }
            t = n;
        }
        return t._value;
    }

    @Override
    public V get(ByteBuffer b, int offset, int len) {
        TreeTrie<V> t = this;
        for (int i = 0; i < len; ++i) {
            byte c = b.get(offset + i);
            int index = c >= 0 && c < 127 ? LOOKUP[c] : -1;
            if (index >= 0) {
                if (t._nextIndex[index] == null) {
                    return null;
                }
                t = t._nextIndex[index];
                continue;
            }
            TreeTrie<V> n = null;
            int j = t._nextOther.size();
            while (j-- > 0) {
                n = t._nextOther.get(j);
                if (n._c == c) break;
                n = null;
            }
            if (n == null) {
                return null;
            }
            t = n;
        }
        return t._value;
    }

    @Override
    public V getBest(byte[] b, int offset, int len) {
        TreeTrie<V> t = this;
        for (int i = 0; i < len; ++i) {
            byte c = b[offset + i];
            int index = c >= 0 && c < 127 ? LOOKUP[c] : -1;
            if (index >= 0) {
                if (t._nextIndex[index] == null) break;
                t = t._nextIndex[index];
            } else {
                TreeTrie<V> n = null;
                int j = t._nextOther.size();
                while (j-- > 0) {
                    n = t._nextOther.get(j);
                    if (n._c == c) break;
                    n = null;
                }
                if (n == null) break;
                t = n;
            }
            if (t._key == null) continue;
            Object best = ((AbstractTrie)t).getBest(b, offset + i + 1, len - i - 1);
            if (best == null) break;
            return best;
        }
        return t._value;
    }

    @Override
    public V getBest(String s, int offset, int len) {
        TreeTrie<V> t = this;
        for (int i = 0; i < len; ++i) {
            byte c = (byte)(0xFF & s.charAt(offset + i));
            int index = c >= 0 && c < 127 ? LOOKUP[c] : -1;
            if (index >= 0) {
                if (t._nextIndex[index] == null) break;
                t = t._nextIndex[index];
            } else {
                TreeTrie<V> n = null;
                int j = t._nextOther.size();
                while (j-- > 0) {
                    n = t._nextOther.get(j);
                    if (n._c == c) break;
                    n = null;
                }
                if (n == null) break;
                t = n;
            }
            if (t._key == null) continue;
            V best = t.getBest(s, offset + i + 1, len - i - 1);
            if (best == null) break;
            return best;
        }
        return t._value;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V getBest(ByteBuffer b, int offset, int len) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (b.hasArray()) {
            return ((AbstractTrie)this).getBest(b.array(), b.arrayOffset() + b.position() + offset, len);
        }
        return this.getBestByteBuffer((ByteBuffer)var1_1, (int)var2_2, (int)var3_3);
    }

    private V getBestByteBuffer(ByteBuffer b, int offset, int len) {
        TreeTrie<V> t = this;
        int pos = b.position() + offset;
        for (int i = 0; i < len; ++i) {
            byte c;
            int index;
            if ((index = (c = b.get(pos++)) >= 0 && c < 127 ? LOOKUP[c] : -1) >= 0) {
                if (t._nextIndex[index] == null) break;
                t = t._nextIndex[index];
            } else {
                TreeTrie<V> n = null;
                int j = t._nextOther.size();
                while (j-- > 0) {
                    n = t._nextOther.get(j);
                    if (n._c == c) break;
                    n = null;
                }
                if (n == null) break;
                t = n;
            }
            if (t._key == null) continue;
            V best = t.getBest(b, offset + i + 1, len - i - 1);
            if (best == null) break;
            return best;
        }
        return t._value;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder buf = new StringBuilder();
        TreeTrie.toString(buf, this);
        if (buf.length() == 0) {
            return "{}";
        }
        buf.setCharAt(0, '{');
        buf.append('}');
        return var1_1.toString();
    }

    private static <V> void toString(Appendable out, TreeTrie<V> t) {
        if (t != null) {
            int i;
            if (t._value != null) {
                try {
                    out.append(',');
                    out.append(t._key);
                    out.append('=');
                    out.append(t._value.toString());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            for (i = 0; i < 32; ++i) {
                if (t._nextIndex[i] == null) continue;
                TreeTrie.toString(out, t._nextIndex[i]);
            }
            i = t._nextOther.size();
            while (i-- > 0) {
                TreeTrie.toString(out, t._nextOther.get(i));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<String> keySet() {
        void var1_1;
        HashSet<String> keys = new HashSet<String>();
        TreeTrie.keySet(keys, this);
        return var1_1;
    }

    private static <V> void keySet(Set<String> set, TreeTrie<V> t) {
        if (t != null) {
            int i;
            if (t._key != null) {
                set.add(t._key);
            }
            for (i = 0; i < 32; ++i) {
                if (t._nextIndex[i] == null) continue;
                TreeTrie.keySet(set, t._nextIndex[i]);
            }
            i = t._nextOther.size();
            while (i-- > 0) {
                TreeTrie.keySet(set, t._nextOther.get(i));
            }
        }
    }

    @Override
    public boolean isFull() {
        return false;
    }
}

