/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class TopologicalSort<T> {
    private final Map<T, Set<T>> _dependencies = new HashMap<T, Set<T>>();

    /*
     * WARNING - void declaration
     */
    public void addDependency(T dependent, T dependency) {
        void var2_2;
        void var3_3;
        Set<T> set = this._dependencies.get(dependent);
        if (set == null) {
            void var1_1;
            set = new HashSet<T>();
            this._dependencies.put(var1_1, set);
        }
        var3_3.add(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void sort(T[] array) {
        void var1_1;
        void var2_2;
        ArrayList sorted = new ArrayList();
        HashSet visited = new HashSet();
        InitialOrderComparator<T> comparator = new InitialOrderComparator<T>(array);
        T[] TArray = array;
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            T t = TArray[i];
            this.visit(t, visited, sorted, comparator);
        }
        var2_2.toArray((T[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void sort(Collection<T> list) {
        void var2_2;
        void var1_1;
        ArrayList sorted = new ArrayList();
        HashSet visited = new HashSet();
        InitialOrderComparator<T> comparator = new InitialOrderComparator<T>(list);
        for (T t : list) {
            this.visit(t, visited, sorted, comparator);
        }
        list.clear();
        var1_1.addAll(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void visit(T item, Set<T> visited, List<T> sorted, Comparator<T> comparator) {
        void var3_3;
        if (!visited.contains(item)) {
            visited.add(item);
            Set<T> dependencies = this._dependencies.get(item);
            if (dependencies != null) {
                TreeSet<T> orderedDeps = new TreeSet<T>(comparator);
                orderedDeps.addAll(dependencies);
                try {
                    for (Object d : orderedDeps) {
                        this.visit(d, visited, sorted, comparator);
                    }
                }
                catch (CyclicException e) {
                    throw new CyclicException(item, e);
                }
            }
            sorted.add(item);
            return;
        }
        if (!var3_3.contains(item)) {
            void var1_1;
            throw new CyclicException(var1_1);
        }
    }

    public String toString() {
        return "TopologicalSort " + this._dependencies;
    }

    private static class CyclicException
    extends IllegalStateException {
        /*
         * WARNING - void declaration
         */
        CyclicException(Object item) {
            super("cyclic at " + var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        CyclicException(Object item, CyclicException e) {
            super("cyclic at " + var1_1, (Throwable)var2_2);
            void var2_2;
            void var1_1;
        }
    }

    private static class InitialOrderComparator<T>
    implements Comparator<T> {
        private final Map<T, Integer> _indexes = new HashMap<T, Integer>();

        /*
         * WARNING - void declaration
         */
        InitialOrderComparator(T[] initial) {
            void var1_1;
            int i = 0;
            for (void t : var1_1) {
                this._indexes.put(t, i++);
            }
        }

        /*
         * WARNING - void declaration
         */
        InitialOrderComparator(Collection<T> initial) {
            Iterator iterator;
            int i = 0;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var3_3;
                Object t = iterator.next();
                this._indexes.put(var3_3, i++);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compare(T o1, T o2) {
            void var3_3;
            void var1_1;
            void var2_2;
            Integer i1 = this._indexes.get(o1);
            Integer i2 = this._indexes.get(o2);
            if (i1 == null || i2 == null || i1.equals(var2_2)) {
                return 0;
            }
            if (var1_1.intValue() < var3_3.intValue()) {
                return -1;
            }
            return 1;
        }
    }
}

