/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.util.ArrayTrie;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.Trie;
import org.eclipse.jetty.util.TypeUtil;

public class StringUtil {
    private static final Trie<String> CHARSETS = new ArrayTrie<String>(256);
    public static final String ALL_INTERFACES = "0.0.0.0";
    public static final String CRLF = "\r\n";
    @Deprecated
    public static final String __LINE_SEPARATOR = System.lineSeparator();
    public static final String __ISO_8859_1 = "iso-8859-1";
    public static final String __UTF8 = "utf-8";
    public static final String __UTF16 = "utf-16";
    public static final char[] lowercases;
    private static final char[] uppercases;

    /*
     * WARNING - void declaration
     */
    public static String normalizeCharset(String s) {
        void var1_1;
        String n = CHARSETS.get(s);
        if (n == null) {
            String string;
            return string;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static String normalizeCharset(String s, int offset, int length) {
        void var3_3;
        String n = CHARSETS.get(s, offset, length);
        if (n == null) {
            void var2_2;
            String string;
            void var1_1;
            void v0 = var1_1;
            return string.substring((int)v0, (int)(v0 + var2_2));
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static String asciiToLowerCase(String s) {
        void var1_1;
        if (s == null) {
            return null;
        }
        char[] c = null;
        int i = s.length();
        while (i-- > 0) {
            char c2;
            void var3_3;
            char c1 = s.charAt(i);
            if (c1 > '\u007f' || var3_3 == (c2 = lowercases[c1])) continue;
            char[] cArray = s.toCharArray();
            c = cArray;
            cArray[i] = c2;
            break;
        }
        while (i-- > 0) {
            if (c[i] > 127) continue;
            c[i] = lowercases[c[i]];
        }
        if (c == null) {
            String string;
            return string;
        }
        return new String((char[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String asciiToUpperCase(String s) {
        void var1_1;
        if (s == null) {
            return null;
        }
        char[] c = null;
        int i = s.length();
        while (i-- > 0) {
            char c2;
            void var3_3;
            char c1 = s.charAt(i);
            if (c1 > '\u007f' || var3_3 == (c2 = uppercases[c1])) continue;
            char[] cArray = s.toCharArray();
            c = cArray;
            cArray[i] = c2;
            break;
        }
        while (i-- > 0) {
            if (c[i] > 127) continue;
            c[i] = uppercases[c[i]];
        }
        if (c == null) {
            String string;
            return string;
        }
        return new String((char[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String sanitizeFileSystemName(String str) {
        Object object;
        if (str == null) {
            return null;
        }
        char[] cArray = str.toCharArray();
        Object chars = cArray;
        int len = cArray.length;
        for (int i = 0; i < len; ++i) {
            void var3_3;
            Object c = chars[i];
            if (c > 31 && c < 127 && c != 124 && c != 62 && c != 60 && c != 47 && c != 38 && c != 92 && c != 46 && c != 58 && c != 61 && c != 34 && c != 44 && c != 42 && c != 63 && c != 33 && var3_3 != 32) continue;
            chars[i] = 95;
        }
        return String.valueOf((char[])object);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean startsWithIgnoreCase(String s, String w) {
        if (w == null) {
            return true;
        }
        if (s == null || s.length() < w.length()) {
            return false;
        }
        for (int i = 0; i < w.length(); ++i) {
            void var3_3;
            char c2;
            char c1 = s.charAt(i);
            if (c1 == (c2 = w.charAt(i))) continue;
            if (c1 <= '\u007f') {
                c1 = lowercases[c1];
            }
            if (c2 <= '\u007f') {
                c2 = lowercases[c2];
            }
            if (var3_3 == c2) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean endsWithIgnoreCase(String s, String w) {
        void i;
        int wl;
        if (w == null) {
            return true;
        }
        if (s == null) {
            return false;
        }
        int sl = s.length();
        if (sl < (wl = w.length())) {
            return false;
        }
        while (i-- > 0) {
            char c2;
            char c1;
            if ((c1 = s.charAt(--sl)) == (c2 = w.charAt((int)i))) continue;
            if (c1 <= '\u007f') {
                c1 = lowercases[c1];
            }
            if (c2 <= '\u007f') {
                c2 = lowercases[c2];
            }
            if (c1 == c2) continue;
            return false;
        }
        return true;
    }

    public static int indexFrom(String s, String chars) {
        for (int i = 0; i < s.length(); ++i) {
            if (chars.indexOf(s.charAt(i)) < 0) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static String replace(String str, char find, char with) {
        Object object;
        void i;
        if (str == null) {
            return null;
        }
        if (find == with) {
            return str;
        }
        int idx = str.indexOf(find, 0);
        if (idx == -1) {
            return str;
        }
        char[] cArray = str.toCharArray();
        Object chars = cArray;
        int len = cArray.length;
        while (i < len) {
            if (chars[i] == find) {
                chars[i] = with;
            }
            ++i;
        }
        return String.valueOf((char[])object);
    }

    /*
     * WARNING - void declaration
     */
    public static String replace(String s, String sub, String with) {
        if (s == null) {
            return null;
        }
        int c = 0;
        int i = s.indexOf(sub, 0);
        if (i == -1) {
            return s;
        }
        StringBuilder buf = new StringBuilder(s.length() + with.length());
        do {
            buf.append(s, c, i);
            buf.append(with);
        } while ((i = s.indexOf(sub, c = i + sub.length())) != -1);
        if (c < s.length()) {
            void var3_3;
            String string;
            buf.append(string.substring((int)var3_3));
        }
        return buf.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String replaceFirst(String original, String target, String replacement) {
        void var1_2;
        String string;
        void var2_3;
        void var3_4;
        int idx = original.indexOf(target);
        if (idx == -1) {
            return original;
        }
        int originalLen = original.length();
        StringBuilder buf = new StringBuilder(originalLen + replacement.length());
        buf.append(original, 0, idx);
        int offset = 0 + (var3_4 + target.length());
        buf.append((String)var2_3);
        buf.append(string, (int)var1_2, originalLen);
        return buf.toString();
    }

    @Deprecated
    public static String unquote(String s) {
        return QuotedStringTokenizer.unquote(s);
    }

    /*
     * WARNING - void declaration
     */
    public static void append(StringBuilder buf, String s, int offset, int length) {
        StringBuilder stringBuilder = buf;
        synchronized (stringBuilder) {
            void i;
            int end = offset + length;
            while (i < end && i < s.length()) {
                buf.append(s.charAt((int)i));
                ++i;
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void append(StringBuilder buf, byte b, int base) {
        void var3_3;
        StringBuilder stringBuilder;
        void var2_2;
        void var1_1;
        int bi = 0xFF & b;
        int c = 48 + bi / base % base;
        if (c > 57) {
            c = 97 + (c - 48 - 10);
        }
        buf.append((char)c);
        c = 48 + var1_1 % var2_2;
        if (c > 57) {
            c = 97 + (c - 48 - 10);
        }
        stringBuilder.append((char)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static void append2digits(StringBuffer buf, int i) {
        if (i < 100) {
            void var1_1;
            StringBuffer stringBuffer;
            buf.append((char)(i / 10 + 48));
            stringBuffer.append((char)(var1_1 % 10 + 48));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void append2digits(StringBuilder buf, int i) {
        if (i < 100) {
            void var1_1;
            StringBuilder stringBuilder;
            buf.append((char)(i / 10 + 48));
            stringBuilder.append((char)(var1_1 % 10 + 48));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String stringFrom(String s, int n) {
        void var2_2;
        StringBuilder stringBuilder = new StringBuilder(s.length() * n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(s);
        }
        return var2_2.toString();
    }

    public static String nonNull(String s) {
        String string;
        if (s == null) {
            return "";
        }
        return string;
    }

    public static boolean equals(String s, char[] buf, int offset, int length) {
        if (s.length() != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (buf[offset + i] == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static String toUTF8String(byte[] b, int offset, int length) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        return new String(byArray, (int)var1_1, (int)var2_2, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public static String toString(byte[] b, int offset, int length, String charset) {
        try {
            void var3_4;
            void var2_3;
            void var1_2;
            return new String(b, (int)var1_2, (int)var2_3, (String)var3_4);
        }
        catch (UnsupportedEncodingException e) {
            void var0_1;
            throw new IllegalArgumentException((Throwable)var0_1);
        }
    }

    public static int indexOfControlChars(String str) {
        if (str == null) {
            return -1;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (!Character.isISOControl(str.codePointAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static boolean isBlank(String str) {
        if (str == null) {
            return true;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(str.codePointAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(String str) {
        String string;
        return str == null || string.isEmpty();
    }

    public static boolean isNotBlank(String str) {
        if (str == null) {
            return false;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(str.codePointAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isUTF8(String charset) {
        String string;
        return __UTF8.equalsIgnoreCase(charset) || __UTF8.equalsIgnoreCase(StringUtil.normalizeCharset(string));
    }

    public static boolean isHex(String str, int offset, int length) {
        if (offset + length > str.length()) {
            return false;
        }
        for (int i = offset; i < offset + length; ++i) {
            char c = str.charAt(i);
            if (c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F' || c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static String printable(String name) {
        void var1_1;
        if (name == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            void var3_3;
            char c = name.charAt(i);
            if (Character.isISOControl(c)) continue;
            buf.append((char)var3_3);
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String printable(byte[] b) {
        void var1_1;
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            char c = (char)b[i];
            if (Character.isWhitespace(c) || c > ' ' && c < '\u007f') {
                void var3_3;
                buf.append((char)var3_3);
                continue;
            }
            buf.append("0x");
            TypeUtil.toHex(b[i], (Appendable)buf);
        }
        return var1_1.toString();
    }

    public static byte[] getBytes(String s) {
        return s.getBytes(StandardCharsets.ISO_8859_1);
    }

    public static byte[] getUtf8Bytes(String s) {
        return s.getBytes(StandardCharsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] getBytes(String s, String charset) {
        try {
            void var1_1;
            return s.getBytes((String)var1_1);
        }
        catch (Exception exception) {
            String string;
            return string.getBytes();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String sidBytesToString(byte[] sidBytes) {
        void var1_1;
        StringBuilder sidString = new StringBuilder();
        sidString.append("S-");
        sidString.append(sidBytes[0]).append('-');
        StringBuilder tmpBuilder = new StringBuilder();
        for (int i = 2; i <= 7; ++i) {
            tmpBuilder.append(Integer.toHexString(sidBytes[i] & 0xFF));
        }
        sidString.append(Long.parseLong(tmpBuilder.toString(), 16));
        int subAuthorityCount = sidBytes[1];
        for (int i = 0; i < subAuthorityCount; ++i) {
            int offset = i << 2;
            tmpBuilder.setLength(0);
            tmpBuilder.append(String.format("%02X%02X%02X%02X", sidBytes[offset + 11] & 0xFF, sidBytes[offset + 10] & 0xFF, sidBytes[offset + 9] & 0xFF, sidBytes[offset + 8] & 0xFF));
            sidString.append('-').append(Long.parseLong(tmpBuilder.toString(), 16));
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static byte[] sidStringToBytes(String sidString) {
        void var3_4;
        int i;
        String[] sidTokens = sidString.split("-");
        int subAuthorityCount = sidTokens.length - 3;
        int byteCount = 0;
        byte[] byArray = new byte[8 + 4 * subAuthorityCount];
        byte[] sidBytes = byArray;
        ++byteCount;
        byArray[0] = (byte)Integer.parseInt(sidTokens[1]);
        ++byteCount;
        sidBytes[1] = (byte)subAuthorityCount;
        String hexStr = Long.toHexString(Long.parseLong(sidTokens[2]));
        while (hexStr.length() < 12) {
            hexStr = "0" + hexStr;
        }
        for (i = 0; i < hexStr.length(); i += 2) {
            int n = byteCount++;
            int n2 = i;
            sidBytes[n] = (byte)Integer.parseInt(hexStr.substring(n2, n2 + 2), 16);
        }
        for (i = 3; i < sidTokens.length; ++i) {
            hexStr = Long.toHexString(Long.parseLong(sidTokens[i]));
            while (hexStr.length() < 8) {
                hexStr = "0" + hexStr;
            }
            for (int j = hexStr.length(); j > 0; j -= 2) {
                sidBytes[byteCount++] = (byte)Integer.parseInt(hexStr.substring(j - 2, j), 16);
            }
        }
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    public static int toInt(String string, int from) {
        String string2;
        void var3_3;
        void i;
        int val = 0;
        boolean started = false;
        boolean minus = false;
        while (i < string.length()) {
            char b = string.charAt((int)i);
            if (b <= ' ') {
                if (started) {
                    break;
                }
            } else if (b >= '0' && b <= '9') {
                val = val * 10 + (b - 48);
                started = true;
            } else {
                if (b != '-' || started) break;
                minus = true;
            }
            ++i;
        }
        if (var3_3 != false) {
            void var2_2;
            if (minus) {
                return -val;
            }
            return (int)var2_2;
        }
        throw new NumberFormatException(string2);
    }

    /*
     * WARNING - void declaration
     */
    public static long toLong(String string) {
        String string2;
        void var3_2;
        long val = 0L;
        boolean started = false;
        boolean minus = false;
        for (int i = 0; i < string.length(); ++i) {
            char b = string.charAt(i);
            if (b <= ' ') {
                if (!started) continue;
                break;
            }
            if (b >= '0' && b <= '9') {
                val = val * 10L + (long)(b - 48);
                started = true;
                continue;
            }
            if (b != '-' || started) break;
            minus = true;
        }
        if (var3_2 != false) {
            void var1_1;
            if (minus) {
                return -val;
            }
            return (long)var1_1;
        }
        throw new NumberFormatException(string2);
    }

    /*
     * WARNING - void declaration
     */
    public static String truncate(String str, int maxSize) {
        void var1_1;
        String string;
        if (str == null) {
            return null;
        }
        if (str.length() <= maxSize) {
            return str;
        }
        return string.substring(0, (int)var1_1);
    }

    public static String[] arrayFromString(String s) {
        String string;
        if (s == null) {
            return new String[0];
        }
        if (!s.startsWith("[") || !s.endsWith("]")) {
            throw new IllegalArgumentException();
        }
        if (s.length() == 2) {
            return new String[0];
        }
        return StringUtil.csvSplit(s, 1, string.length() - 2);
    }

    public static String[] csvSplit(String s) {
        String string;
        if (s == null) {
            return null;
        }
        return StringUtil.csvSplit(s, 0, string.length());
    }

    /*
     * WARNING - void declaration
     */
    public static String[] csvSplit(String s, int off, int len) {
        void var3_3;
        void var2_2;
        void var1_1;
        String string;
        if (s == null) {
            return null;
        }
        if (off < 0 || len < 0 || off > s.length()) {
            throw new IllegalArgumentException();
        }
        ArrayList<String> list = new ArrayList<String>();
        StringUtil.csvSplit(list, string, (int)var1_1, (int)var2_2);
        void v0 = var3_3;
        return v0.toArray(new String[v0.size()]);
    }

    public static List<String> csvSplit(List<String> list, String s, int off, int len) {
        List<String> list2;
        if (list == null) {
            list = new ArrayList<String>();
        }
        CsvSplitState state = CsvSplitState.PRE_DATA;
        StringBuilder out = new StringBuilder();
        int last = -1;
        block13: while (len > 0) {
            char ch = s.charAt(off++);
            --len;
            switch (state) {
                case PRE_DATA: {
                    if (Character.isWhitespace(ch)) continue block13;
                    if ('\"' == ch) {
                        state = CsvSplitState.QUOTE;
                        continue block13;
                    }
                    if (',' == ch) {
                        list.add("");
                        continue block13;
                    }
                    state = CsvSplitState.DATA;
                    out.append(ch);
                    continue block13;
                }
                case DATA: {
                    if (Character.isWhitespace(ch)) {
                        last = out.length();
                        out.append(ch);
                        state = CsvSplitState.WHITE;
                        continue block13;
                    }
                    if (',' == ch) {
                        list.add(out.toString());
                        out.setLength(0);
                        state = CsvSplitState.PRE_DATA;
                        continue block13;
                    }
                    out.append(ch);
                    continue block13;
                }
                case WHITE: {
                    if (Character.isWhitespace(ch)) {
                        out.append(ch);
                        continue block13;
                    }
                    if (',' == ch) {
                        out.setLength(last);
                        list.add(out.toString());
                        out.setLength(0);
                        state = CsvSplitState.PRE_DATA;
                        continue block13;
                    }
                    state = CsvSplitState.DATA;
                    out.append(ch);
                    last = -1;
                    continue block13;
                }
                case QUOTE: {
                    if ('\\' == ch) {
                        state = CsvSplitState.SLOSH;
                        continue block13;
                    }
                    if ('\"' == ch) {
                        list.add(out.toString());
                        out.setLength(0);
                        state = CsvSplitState.POST_DATA;
                        continue block13;
                    }
                    out.append(ch);
                    continue block13;
                }
                case SLOSH: {
                    out.append(ch);
                    state = CsvSplitState.QUOTE;
                    continue block13;
                }
                case POST_DATA: {
                    if (',' != ch) continue block13;
                    state = CsvSplitState.PRE_DATA;
                    continue block13;
                }
            }
        }
        switch (state) {
            case PRE_DATA: 
            case POST_DATA: {
                break;
            }
            case DATA: 
            case QUOTE: 
            case SLOSH: {
                list.add(out.toString());
                break;
            }
            case WHITE: {
                out.setLength(last);
                list.add(out.toString());
            }
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    public static String sanitizeXmlString(String html) {
        void var2_3;
        int i;
        if (html == null) {
            return null;
        }
        block10: for (i = 0; i < html.length(); ++i) {
            char c = html.charAt(i);
            switch (c) {
                case '\"': 
                case '&': 
                case '\'': 
                case '<': 
                case '>': {
                    break block10;
                }
                default: {
                    if (Character.isISOControl(c) && !Character.isWhitespace(c)) break block10;
                    continue block10;
                }
            }
        }
        if (i == html.length()) {
            return html;
        }
        StringBuilder out = new StringBuilder((html.length() << 2) / 3);
        out.append(html, 0, i);
        while (i < html.length()) {
            char c = html.charAt(i);
            switch (c) {
                case '&': {
                    out.append("&amp;");
                    break;
                }
                case '<': {
                    out.append("&lt;");
                    break;
                }
                case '>': {
                    out.append("&gt;");
                    break;
                }
                case '\'': {
                    out.append("&apos;");
                    break;
                }
                case '\"': {
                    out.append("&quot;");
                    break;
                }
                default: {
                    void var3_4;
                    if (Character.isISOControl(c) && !Character.isWhitespace(c)) {
                        out.append('?');
                        break;
                    }
                    out.append((char)var3_4);
                }
            }
            ++i;
        }
        return var2_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String strip(String str, String find) {
        void var1_1;
        return StringUtil.replace(str, (String)var1_1, "");
    }

    public static String valueOf(Object object) {
        Object object2;
        if (object == null) {
            return null;
        }
        return String.valueOf(object2);
    }

    static {
        CHARSETS.put(__UTF8, __UTF8);
        CHARSETS.put("utf8", __UTF8);
        CHARSETS.put(__UTF16, __UTF16);
        CHARSETS.put("utf16", __UTF16);
        CHARSETS.put(__ISO_8859_1, __ISO_8859_1);
        CHARSETS.put("iso_8859_1", __ISO_8859_1);
        lowercases = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f'};
        uppercases = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '{', '|', '}', '~', '\u007f'};
    }

    static enum CsvSplitState {
        PRE_DATA,
        QUOTE,
        SLOSH,
        DATA,
        WHITE,
        POST_DATA;

    }
}

