/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public interface SocketAddressResolver {
    public void resolve(String var1, int var2, Promise<List<InetSocketAddress>> var3);

    @ManagedObject(value="The asynchronous address resolver")
    public static class Async
    implements SocketAddressResolver {
        private static final Logger LOG = Log.getLogger(SocketAddressResolver.class);
        private final Executor executor;
        private final Scheduler scheduler;
        private final long timeout;

        /*
         * WARNING - void declaration
         */
        public Async(Executor executor, Scheduler scheduler, long timeout) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.executor = var1_1;
            this.scheduler = var2_2;
            this.timeout = var3_3;
        }

        public Executor getExecutor() {
            return this.executor;
        }

        public Scheduler getScheduler() {
            return this.scheduler;
        }

        @ManagedAttribute(value="The timeout, in milliseconds, to resolve an address", readonly=true)
        public long getTimeout() {
            return this.timeout;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void resolve(String host, int port, Promise<List<InetSocketAddress>> promise) {
            void var2_2;
            void var1_1;
            void var3_3;
            this.executor.execute(() -> this.lambda$resolve$1((Promise)var3_3, (String)var1_1, (int)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        private /* synthetic */ void lambda$resolve$1(Promise promise, String host, int port) {
            block12: {
                Scheduler.Task task = null;
                AtomicBoolean complete = new AtomicBoolean();
                if (this.timeout > 0L) {
                    Thread thread = Thread.currentThread();
                    task = this.scheduler.schedule(() -> {
                        if (complete.compareAndSet(false, true)) {
                            void var3_3;
                            void var2_2;
                            var2_2.failed(new TimeoutException("DNS timeout " + this.getTimeout() + " ms"));
                            var3_3.interrupt();
                        }
                    }, this.timeout, TimeUnit.MILLISECONDS);
                }
                try {
                    long start22 = System.nanoTime();
                    InetAddress[] addresses = InetAddress.getAllByName(host);
                    long elapsed = System.nanoTime() - start22;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Resolved {} in {} ms", host, TimeUnit.NANOSECONDS.toMillis(elapsed));
                    }
                    ArrayList<InetSocketAddress> result = new ArrayList<InetSocketAddress>(addresses.length);
                    InetAddress[] start22 = addresses;
                    int n = addresses.length;
                    for (int i = 0; i < n; ++i) {
                        InetAddress address = start22[i];
                        result.add(new InetSocketAddress(address, port));
                    }
                    if (complete.compareAndSet(false, true)) {
                        if (result.isEmpty()) {
                            promise.failed(new UnknownHostException());
                        } else {
                            void var2_3;
                            promise.succeeded(var2_3);
                        }
                    }
                    if (task == null) break block12;
                    task.cancel();
                }
                catch (Throwable x) {
                    try {
                        if (complete.compareAndSet(false, true)) {
                            void var1_1;
                            var1_1.failed(x);
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (task == null) break block12;
                        task.cancel();
                    }
                }
                return;
            }
        }
    }

    @ManagedObject(value="The synchronous address resolver")
    public static class Sync
    implements SocketAddressResolver {
        /*
         * WARNING - void declaration
         */
        @Override
        public void resolve(String host, int port, Promise<List<InetSocketAddress>> promise) {
            try {
                InetAddress[] addresses = InetAddress.getAllByName(host);
                ArrayList<InetSocketAddress> result = new ArrayList<InetSocketAddress>(addresses.length);
                for (InetAddress address : addresses) {
                    result.add(new InetSocketAddress(address, port));
                }
                if (!result.isEmpty()) {
                    promise.succeeded(result);
                    return;
                }
                promise.failed(new UnknownHostException());
            }
            catch (Throwable x) {
                void var1_2;
                void var3_4;
                var3_4.failed((Throwable)var1_2);
            }
        }
    }
}

