/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ConstantThrowable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Invocable;

public class SharedBlockingCallback {
    private static final Logger LOG = Log.getLogger(SharedBlockingCallback.class);
    private static final Throwable IDLE = new ConstantThrowable("IDLE");
    private static final Throwable SUCCEEDED = new ConstantThrowable("SUCCEEDED");
    private static final Throwable FAILED = new ConstantThrowable("FAILED");
    private final ReentrantLock _lock = new ReentrantLock();
    private final Condition _idle = this._lock.newCondition();
    private final Condition _complete = this._lock.newCondition();
    private Blocker _blocker = new Blocker(this);

    @Deprecated
    protected long getIdleTimeout() {
        return -1L;
    }

    public Blocker acquire() throws IOException {
        long idle = this.getIdleTimeout();
        this._lock.lock();
        try {
            while (this._blocker._state != IDLE) {
                if (idle > 0L && idle < 0x3FFFFFFFFFFFFFFFL) {
                    if (this._idle.await(idle << 1, TimeUnit.MILLISECONDS)) continue;
                    throw new IOException(new TimeoutException());
                }
                this._idle.await();
            }
            Blocker.access$002(this._blocker, null);
            Blocker blocker = this._blocker;
            return blocker;
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedIOException();
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean fail(Throwable cause) {
        Objects.requireNonNull(cause);
        this._lock.lock();
        try {
            if (this._blocker._state == null) {
                void var1_1;
                Blocker.access$002(this._blocker, new BlockerFailedException((Throwable)var1_1));
                this._complete.signalAll();
                return true;
            }
        }
        finally {
            this._lock.unlock();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected void notComplete(Blocker blocker) {
        void var1_1;
        LOG.warn("Blocker not complete {}", var1_1);
        if (LOG.isDebugEnabled()) {
            LOG.debug(new Throwable());
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Blocker access$802(SharedBlockingCallback x0, Blocker x1) {
        void var1_1;
        x0._blocker = var1_1;
        return x0._blocker;
    }

    private static class BlockerFailedException
    extends Exception {
        /*
         * WARNING - void declaration
         */
        public BlockerFailedException(Throwable cause) {
            super((Throwable)var1_1);
            void var1_1;
        }
    }

    private static class BlockerTimeoutException
    extends TimeoutException {
        private BlockerTimeoutException() {
        }
    }

    public class Blocker
    implements Closeable,
    Callback {
        private Throwable _state = SharedBlockingCallback.access$100();
        final /* synthetic */ SharedBlockingCallback this$0;

        /*
         * WARNING - void declaration
         */
        protected Blocker(SharedBlockingCallback this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.NON_BLOCKING;
        }

        @Override
        public void succeeded() {
            this.this$0._lock.lock();
            try {
                if (this._state == null) {
                    this._state = SUCCEEDED;
                    this.this$0._complete.signalAll();
                } else {
                    LOG.warn("Succeeded after {}", this._state.toString());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(this._state);
                    }
                }
                return;
            }
            finally {
                this.this$0._lock.unlock();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void failed(Throwable cause) {
            this.this$0._lock.lock();
            try {
                if (this._state == null) {
                    this._state = cause == null ? FAILED : (cause instanceof BlockerTimeoutException ? new IOException(cause) : cause);
                    this.this$0._complete.signalAll();
                } else if (this._state instanceof BlockerTimeoutException || this._state instanceof BlockerFailedException) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Failed after {}", this._state);
                    }
                } else {
                    LOG.warn("Failed after {}: {}", this._state, cause);
                    if (LOG.isDebugEnabled()) {
                        void var1_1;
                        LOG.debug(this._state);
                        LOG.debug((Throwable)var1_1);
                    }
                }
                return;
            }
            finally {
                this.this$0._lock.unlock();
            }
        }

        /*
         * WARNING - void declaration
         */
        public void block() throws IOException {
            long idle = this.this$0.getIdleTimeout();
            this.this$0._lock.lock();
            try {
                while (this._state == null) {
                    if (idle > 0L) {
                        long excess = Math.min(idle / 2L, 1000L);
                        if (this.this$0._complete.await(idle + excess, TimeUnit.MILLISECONDS)) continue;
                        this._state = new BlockerTimeoutException();
                        continue;
                    }
                    this.this$0._complete.await();
                }
                if (this._state == SUCCEEDED) {
                    return;
                }
                try {
                    if (this._state == IDLE) {
                        throw new IllegalStateException("IDLE");
                    }
                    if (this._state instanceof IOException) {
                        throw (IOException)this._state;
                    }
                    if (this._state instanceof CancellationException) {
                        throw (CancellationException)this._state;
                    }
                    if (this._state instanceof RuntimeException) {
                        throw (RuntimeException)this._state;
                    }
                    if (this._state instanceof Error) {
                        throw (Error)this._state;
                    }
                    throw new IOException(this._state);
                }
                catch (InterruptedException e) {
                    void var3_4;
                    this._state = var3_4;
                    throw new InterruptedIOException();
                }
            }
            finally {
                this.this$0._lock.unlock();
            }
        }

        @Override
        public void close() {
            this.this$0._lock.lock();
            try {
                if (this._state == IDLE) {
                    throw new IllegalStateException("IDLE");
                }
                if (this._state == null) {
                    this.this$0.notComplete(this);
                }
            }
            finally {
                try {
                    if (this._state != null && this._state != SUCCEEDED) {
                        SharedBlockingCallback.access$802(this.this$0, new Blocker(this.this$0));
                    } else {
                        this._state = IDLE;
                    }
                    this.this$0._idle.signalAll();
                    this.this$0._complete.signalAll();
                }
                finally {
                    this.this$0._lock.unlock();
                }
            }
        }

        public String toString() {
            this.this$0._lock.lock();
            try {
                String string = String.format("%s@%x{%s}", Blocker.class.getSimpleName(), this.hashCode(), this._state);
                return string;
            }
            finally {
                this.this$0._lock.unlock();
            }
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ Throwable access$002(Blocker x0, Throwable x1) {
            void var1_1;
            x0._state = var1_1;
            return x0._state;
        }
    }
}

