/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Predicate;
import org.eclipse.jetty.util.IncludeExcludeSet;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class Scanner
extends AbstractLifeCycle {
    public static final int DEFAULT_SCAN_DEPTH = 1;
    public static final int MAX_SCAN_DEPTH = Integer.MAX_VALUE;
    private static final Logger LOG = Log.getLogger(Scanner.class);
    private static int __scannerId = 0;
    private int _scanInterval;
    private int _scanCount = 0;
    private final List<Listener> _listeners = new ArrayList<Listener>();
    private final Map<String, TimeNSize> _prevScan = new HashMap<String, TimeNSize>();
    private final Map<String, TimeNSize> _currentScan = new HashMap<String, TimeNSize>();
    private FilenameFilter _filter;
    private final Map<Path, IncludeExcludeSet<PathMatcher, Path>> _scannables = new HashMap<Path, IncludeExcludeSet<PathMatcher, Path>>();
    private volatile boolean _running = false;
    private boolean _reportExisting = true;
    private boolean _reportDirs = true;
    private Timer _timer;
    private TimerTask _task;
    private int _scanDepth = 1;
    private final Map<String, Notification> _notifications = new HashMap<String, Notification>();

    public synchronized int getScanInterval() {
        return this._scanInterval;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setScanInterval(int scanInterval) {
        void var1_1;
        this._scanInterval = var1_1;
        this.schedule();
    }

    /*
     * WARNING - void declaration
     */
    public void setScanDirs(List<File> dirs) {
        Iterator iterator;
        this._scannables.clear();
        if (dirs == null) {
            return;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            File f = (File)iterator.next();
            this.addScanDir((File)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public synchronized void addScanDir(File dir) {
        if (dir == null) {
            return;
        }
        try {
            if (!dir.isDirectory()) {
                this.addFile(dir.toPath());
                return;
            }
            this.addDirectory(dir.toPath());
        }
        catch (Exception e) {
            void var1_2;
            LOG.warn((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void addFile(Path p) throws IOException {
        void var1_1;
        if (p == null) {
            throw new IllegalStateException("Null path");
        }
        File f = p.toFile();
        if (!f.exists() || f.isDirectory()) {
            void var2_2;
            throw new IllegalStateException("Not file or doesn't exist: " + var2_2.getCanonicalPath());
        }
        this._scannables.put((Path)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized IncludeExcludeSet<PathMatcher, Path> addDirectory(Path p) throws IOException {
        void var2_2;
        if (p == null) {
            throw new IllegalStateException("Null path");
        }
        File f = p.toFile();
        if (!f.exists() || !f.isDirectory()) {
            throw new IllegalStateException("Not directory or doesn't exist: " + f.getCanonicalPath());
        }
        IncludeExcludeSet<PathMatcher, Path> includesExcludes = this._scannables.get(p);
        if (includesExcludes == null) {
            void var1_1;
            includesExcludes = new IncludeExcludeSet(PathMatcherSet.class);
            this._scannables.put(var1_1.toRealPath(new LinkOption[0]), includesExcludes);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public List<File> getScanDirs() {
        void var1_1;
        ArrayList<File> files = new ArrayList<File>();
        for (Path p : this._scannables.keySet()) {
            void var3_3;
            files.add(var3_3.toFile());
        }
        return Collections.unmodifiableList(var1_1);
    }

    public Set<Path> getScannables() {
        return this._scannables.keySet();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setRecursive(boolean recursive) {
        void var1_1;
        this._scanDepth = var1_1 != false ? Integer.MAX_VALUE : 1;
    }

    @Deprecated
    public boolean getRecursive() {
        return this._scanDepth > 1;
    }

    public int getScanDepth() {
        return this._scanDepth;
    }

    /*
     * WARNING - void declaration
     */
    public void setScanDepth(int scanDepth) {
        void var1_1;
        this._scanDepth = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setFilenameFilter(FilenameFilter filter) {
        void var1_1;
        this._filter = var1_1;
    }

    @Deprecated
    public FilenameFilter getFilenameFilter() {
        return this._filter;
    }

    /*
     * WARNING - void declaration
     */
    public void setReportExistingFilesOnStartup(boolean reportExisting) {
        void var1_1;
        this._reportExisting = var1_1;
    }

    public boolean getReportExistingFilesOnStartup() {
        return this._reportExisting;
    }

    /*
     * WARNING - void declaration
     */
    public void setReportDirs(boolean dirs) {
        void var1_1;
        this._reportDirs = var1_1;
    }

    public boolean getReportDirs() {
        return this._reportDirs;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void addListener(Listener listener) {
        void var1_1;
        if (listener == null) {
            return;
        }
        this._listeners.add((Listener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void removeListener(Listener listener) {
        void var1_1;
        if (listener == null) {
            return;
        }
        this._listeners.remove(var1_1);
    }

    @Override
    public synchronized void doStart() {
        if (this._running) {
            return;
        }
        this._running = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scanner start: rprtExists={}, depth={}, rprtDirs={}, interval={}, filter={}, scannables={}", this._reportExisting, this._scanDepth, this._reportDirs, this._scanInterval, this._filter, this._scannables);
        }
        if (this._reportExisting) {
            this.scan();
            this.scan();
        } else {
            this.scanFiles();
            this._prevScan.putAll(this._currentScan);
        }
        this.schedule();
    }

    public TimerTask newTimerTask() {
        return new TimerTask(this){
            final /* synthetic */ Scanner this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public void run() {
                this.this$0.scan();
            }
        };
    }

    public Timer newTimer() {
        return new Timer("Scanner-" + __scannerId++, true);
    }

    public void schedule() {
        if (this._running) {
            if (this._timer != null) {
                this._timer.cancel();
            }
            if (this._task != null) {
                this._task.cancel();
            }
            if (this.getScanInterval() > 0) {
                this._timer = this.newTimer();
                this._task = this.newTimerTask();
                this._timer.schedule(this._task, 1010L * (long)this.getScanInterval(), 1010L * (long)this.getScanInterval());
            }
        }
    }

    @Override
    public synchronized void doStop() {
        if (this._running) {
            this._running = false;
            if (this._timer != null) {
                this._timer.cancel();
            }
            if (this._task != null) {
                this._task.cancel();
            }
            this._task = null;
            this._timer = null;
        }
    }

    public void reset() {
        if (!this.isStopped()) {
            throw new IllegalStateException("Not stopped");
        }
        this._scannables.clear();
        this._currentScan.clear();
        this._prevScan.clear();
    }

    public boolean exists(String path) {
        for (Path path2 : this._scannables.keySet()) {
            if (!path2.resolve(path).toFile().exists()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void scan() {
        Scanner scanner = this;
        scanner.reportScanStart(++scanner._scanCount);
        this.scanFiles();
        Scanner scanner2 = this;
        scanner2.reportDifferences(scanner2._currentScan, this._prevScan);
        this._prevScan.clear();
        this._prevScan.putAll(this._currentScan);
        Scanner scanner3 = this;
        scanner3.reportScanEnd(scanner3._scanCount);
        for (Listener l : this._listeners) {
            try {
                if (!(l instanceof ScanListener)) continue;
                ((ScanListener)l).scan();
            }
            catch (Throwable e) {
                void var2_3;
                LOG.warn((Throwable)var2_3);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void scanFiles() {
        this._currentScan.clear();
        for (Map.Entry<Path, IncludeExcludeSet<PathMatcher, Path>> entry : this._scannables.entrySet()) {
            Path p = entry.getKey();
            try {
                void var3_4;
                Files.walkFileTree(p, EnumSet.allOf(FileVisitOption.class), this._scanDepth, new Visitor(this, (Path)var3_4, entry.getValue(), this._currentScan));
            }
            catch (IOException e) {
                void var2_3;
                LOG.warn("Error scanning files.", (Throwable)var2_3);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void reportDifferences(Map<String, TimeNSize> currentScan, Map<String, TimeNSize> oldScan) {
        Object file;
        HashSet<String> oldScanKeys = new HashSet<String>(oldScan.keySet());
        for (Map.Entry<String, TimeNSize> entry : currentScan.entrySet()) {
            Notification old;
            file = entry.getKey();
            if (!oldScanKeys.contains(file)) {
                old = this._notifications.put((String)file, Notification.ADDED);
                if (old == null) continue;
                switch (old) {
                    case REMOVED: 
                    case CHANGED: {
                        this._notifications.put((String)file, Notification.CHANGED);
                    }
                }
                continue;
            }
            if (oldScan.get(file).equals(currentScan.get(file)) || (old = this._notifications.put((String)file, Notification.CHANGED)) != Notification.ADDED) continue;
            this._notifications.put((String)file, Notification.ADDED);
        }
        for (String file2 : oldScan.keySet()) {
            if (currentScan.containsKey(file2) || (file = this._notifications.put(file2, Notification.REMOVED)) != Notification.ADDED) continue;
            this._notifications.remove(file2);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("scanned " + this._scannables.keySet() + ": " + this._notifications, new Object[0]);
        }
        ArrayList<String> bulkChanges = new ArrayList<String>();
        Iterator<Map.Entry<String, Notification>> iter = this._notifications.entrySet().iterator();
        while (iter.hasNext()) {
            void var3_3;
            Map.Entry<String, Notification> entry = iter.next();
            String file3 = entry.getKey();
            if (!oldScan.containsKey(file3) ? currentScan.containsKey(file3) : !oldScan.get(file3).equals(currentScan.get(file3))) continue;
            Notification notification = entry.getValue();
            iter.remove();
            bulkChanges.add(file3);
            switch (2.$SwitchMap$org$eclipse$jetty$util$Scanner$Notification[var3_3.ordinal()]) {
                case 3: {
                    this.reportAddition(file3);
                    break;
                }
                case 2: {
                    this.reportChange(file3);
                    break;
                }
                case 1: {
                    this.reportRemoval(file3);
                }
            }
        }
        if (!bulkChanges.isEmpty()) {
            this.reportBulkChanges(bulkChanges);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void warn(Object listener, String filename, Throwable th) {
        void var3_3;
        void var2_2;
        void var1_1;
        LOG.warn(var1_1 + " failed on '" + (String)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void reportAddition(String filename) {
        for (Listener l : this._listeners) {
            try {
                if (!(l instanceof DiscreteListener)) continue;
                ((DiscreteListener)l).fileAdded(filename);
            }
            catch (Throwable e) {
                void var3_3;
                this.warn(var3_3, filename, e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void reportRemoval(String filename) {
        for (Listener l : this._listeners) {
            try {
                if (!(l instanceof DiscreteListener)) continue;
                ((DiscreteListener)l).fileRemoved(filename);
            }
            catch (Throwable e) {
                void var3_3;
                this.warn(var3_3, filename, e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void reportChange(String filename) {
        for (Listener l : this._listeners) {
            try {
                if (!(l instanceof DiscreteListener)) continue;
                ((DiscreteListener)l).fileChanged(filename);
            }
            catch (Throwable e) {
                void var3_3;
                this.warn(var3_3, filename, e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void reportBulkChanges(List<String> filenames) {
        for (Listener l : this._listeners) {
            try {
                if (!(l instanceof BulkListener)) continue;
                ((BulkListener)l).filesChanged(filenames);
            }
            catch (Throwable e) {
                void var3_3;
                this.warn(var3_3, filenames.toString(), e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void reportScanStart(int cycle) {
        for (Listener listener : this._listeners) {
            try {
                if (!(listener instanceof ScanCycleListener)) continue;
                ((ScanCycleListener)listener).scanStarted(cycle);
            }
            catch (Exception e) {
                void var3_3;
                LOG.warn(var3_3 + " failed on scan start for cycle " + cycle, e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void reportScanEnd(int cycle) {
        for (Listener listener : this._listeners) {
            try {
                if (!(listener instanceof ScanCycleListener)) continue;
                ((ScanCycleListener)listener).scanEnded(cycle);
            }
            catch (Exception e) {
                void var3_3;
                LOG.warn(var3_3 + " failed on scan end for cycle " + cycle, e);
            }
        }
    }

    public static interface ScanCycleListener
    extends Listener {
        public void scanStarted(int var1) throws Exception;

        public void scanEnded(int var1) throws Exception;
    }

    public static interface BulkListener
    extends Listener {
        public void filesChanged(List<String> var1) throws Exception;
    }

    public static interface DiscreteListener
    extends Listener {
        public void fileChanged(String var1) throws Exception;

        public void fileAdded(String var1) throws Exception;

        public void fileRemoved(String var1) throws Exception;
    }

    public static interface ScanListener
    extends Listener {
        public void scan();
    }

    public static interface Listener {
    }

    class Visitor
    implements FileVisitor<Path> {
        Map<String, TimeNSize> scanInfoMap;
        IncludeExcludeSet<PathMatcher, Path> rootIncludesExcludes;
        Path root;
        final /* synthetic */ Scanner this$0;

        /*
         * WARNING - void declaration
         */
        public Visitor(Scanner this$0, Path root, IncludeExcludeSet<PathMatcher, Path> rootIncludesExcludes, Map<String, TimeNSize> scanInfoMap) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.root = var2_2;
            this.rootIncludesExcludes = var3_3;
            this.scanInfoMap = scanInfoMap;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            if (!Files.exists(dir, new LinkOption[0])) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            File f = dir.toFile();
            if (this.this$0._reportDirs && !this.scanInfoMap.containsKey(f.getCanonicalPath())) {
                void var3_4;
                boolean accepted = false;
                if (this.rootIncludesExcludes != null && !this.rootIncludesExcludes.isEmpty()) {
                    void var1_1;
                    boolean bl = this.rootIncludesExcludes.test((Path)var1_1);
                    if (bl) {
                        accepted = true;
                    }
                } else if (this.this$0._filter == null || this.this$0._filter.accept(f.getParentFile(), f.getName())) {
                    accepted = true;
                }
                if (var3_4 != false) {
                    this.scanInfoMap.put(f.getCanonicalPath(), new TimeNSize(f.lastModified(), f.isDirectory() ? 0L : f.length()));
                    if (LOG.isDebugEnabled()) {
                        void var2_3;
                        LOG.debug("scan accepted dir {} mod={}", f, var2_3.lastModified());
                    }
                }
            }
            return FileVisitResult.CONTINUE;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            void var3_4;
            if (!Files.exists(file, new LinkOption[0])) {
                return FileVisitResult.CONTINUE;
            }
            File f = file.toFile();
            boolean accepted = false;
            if (f.isFile() || f.isDirectory() && this.this$0._reportDirs && !this.scanInfoMap.containsKey(f.getCanonicalPath())) {
                if (this.rootIncludesExcludes != null && !this.rootIncludesExcludes.isEmpty()) {
                    void var1_1;
                    boolean bl = this.rootIncludesExcludes.test((Path)var1_1);
                    if (bl) {
                        accepted = true;
                    }
                } else if (this.this$0._filter == null || this.this$0._filter.accept(f.getParentFile(), f.getName())) {
                    accepted = true;
                }
            }
            if (var3_4 != false) {
                this.scanInfoMap.put(f.getCanonicalPath(), new TimeNSize(f.lastModified(), f.isDirectory() ? 0L : f.length()));
                if (LOG.isDebugEnabled()) {
                    void var2_3;
                    LOG.debug("scan accepted {} mod={}", f, var2_3.lastModified());
                }
            }
            return FileVisitResult.CONTINUE;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            void var2_2;
            LOG.warn((Throwable)var2_2);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }
    }

    static class TimeNSize {
        final long _lastModified;
        final long _size;

        /*
         * WARNING - void declaration
         */
        public TimeNSize(long lastModified, long size) {
            void var3_2;
            void var1_1;
            this._lastModified = var1_1;
            this._size = var3_2;
        }

        public int hashCode() {
            return (int)this._lastModified ^ (int)this._size;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object o) {
            if (o instanceof TimeNSize) {
                void var1_1;
                TimeNSize tns = (TimeNSize)o;
                return tns._lastModified == this._lastModified && var1_1._size == this._size;
            }
            return false;
        }

        public String toString() {
            return "[lm=" + this._lastModified + ",s=" + this._size + "]";
        }
    }

    static class PathMatcherSet
    extends HashSet<PathMatcher>
    implements Predicate<Path> {
        PathMatcherSet() {
        }

        @Override
        public boolean test(Path p) {
            for (PathMatcher pathMatcher : this) {
                if (!pathMatcher.matches(p)) continue;
                return true;
            }
            return false;
        }
    }

    public static enum Notification {
        ADDED,
        CHANGED,
        REMOVED;

    }
}

