/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;

public class RolloverFileOutputStream
extends OutputStream {
    private static Timer __rollover;
    static final String YYYY_MM_DD = "yyyy_mm_dd";
    static final String ROLLOVER_FILE_DATE_FORMAT = "yyyy_MM_dd";
    static final String ROLLOVER_FILE_BACKUP_FORMAT = "HHmmssSSS";
    static final int ROLLOVER_FILE_RETAIN_DAYS = 31;
    private OutputStream _out;
    private RollTask _rollTask;
    private SimpleDateFormat _fileBackupFormat;
    private SimpleDateFormat _fileDateFormat;
    private String _filename;
    private File _file;
    private boolean _append;
    private int _retainDays;

    /*
     * WARNING - void declaration
     */
    public RolloverFileOutputStream(String filename) throws IOException {
        this((String)var1_1, true, 31);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public RolloverFileOutputStream(String filename, boolean append) throws IOException {
        this((String)var1_1, (boolean)var2_2, 31);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public RolloverFileOutputStream(String filename, boolean append, int retainDays) throws IOException {
        this((String)var1_1, (boolean)var2_2, (int)var3_3, TimeZone.getDefault());
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public RolloverFileOutputStream(String filename, boolean append, int retainDays, TimeZone zone) throws IOException {
        this((String)var1_1, (boolean)var2_2, (int)var3_3, zone, null, null, ZonedDateTime.now(zone.toZoneId()));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public RolloverFileOutputStream(String filename, boolean append, int retainDays, TimeZone zone, String dateFormat, String backupFormat) throws IOException {
        this((String)var1_1, (boolean)var2_2, (int)var3_3, zone, dateFormat, backupFormat, ZonedDateTime.now(zone.toZoneId()));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    RolloverFileOutputStream(String filename, boolean append, int retainDays, TimeZone zone, String dateFormat, String backupFormat, ZonedDateTime now) throws IOException {
        void var3_4;
        void var2_2;
        Class<RolloverFileOutputStream> clazz;
        if (dateFormat == null) {
            dateFormat = ROLLOVER_FILE_DATE_FORMAT;
        }
        this._fileDateFormat = new SimpleDateFormat(dateFormat);
        if (backupFormat == null) {
            backupFormat = ROLLOVER_FILE_BACKUP_FORMAT;
        }
        this._fileBackupFormat = new SimpleDateFormat(backupFormat);
        this._fileBackupFormat.setTimeZone(zone);
        this._fileDateFormat.setTimeZone(zone);
        if (filename != null && (filename = filename.trim()).length() == 0) {
            filename = null;
        }
        if (filename == null) {
            throw new IllegalArgumentException("Invalid filename");
        }
        this._filename = clazz;
        this._append = var2_2;
        this._retainDays = var3_4;
        this.setFile(now);
        clazz = RolloverFileOutputStream.class;
        synchronized (RolloverFileOutputStream.class) {
            if (__rollover == null) {
                __rollover = new Timer(RolloverFileOutputStream.class.getName(), true);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.scheduleNextRollover(now);
            return;
        }
    }

    public static ZonedDateTime toMidnight(ZonedDateTime now) {
        ZonedDateTime zonedDateTime;
        return now.toLocalDate().atStartOfDay(zonedDateTime.getZone()).plus(1L, ChronoUnit.DAYS);
    }

    /*
     * WARNING - void declaration
     */
    private void scheduleNextRollover(ZonedDateTime now) {
        Class<RolloverFileOutputStream> clazz;
        this._rollTask = new RollTask();
        ZonedDateTime zonedDateTime = RolloverFileOutputStream.toMidnight(now);
        long delay = zonedDateTime.toInstant().toEpochMilli() - clazz.toInstant().toEpochMilli();
        clazz = RolloverFileOutputStream.class;
        synchronized (RolloverFileOutputStream.class) {
            void var3_4;
            __rollover.schedule((TimerTask)this._rollTask, (long)var3_4);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String getFilename() {
        return this._filename;
    }

    public String getDatedFilename() {
        if (this._file == null) {
            return null;
        }
        return this._file.toString();
    }

    public int getRetainDays() {
        return this._retainDays;
    }

    /*
     * WARNING - void declaration
     */
    void setFile(ZonedDateTime now) throws IOException {
        File oldFile = null;
        File newFile = null;
        File backupFile = null;
        RolloverFileOutputStream rolloverFileOutputStream = this;
        synchronized (rolloverFileOutputStream) {
            File file = new File(this._filename);
            this._filename = file.getCanonicalPath();
            file = new File(this._filename);
            File dir = new File(file.getParent());
            if (!dir.isDirectory() || !dir.canWrite()) {
                throw new IOException("Cannot write log directory " + dir);
            }
            String filename = file.getName();
            int datePattern = filename.toLowerCase(Locale.ENGLISH).indexOf(YYYY_MM_DD);
            if (datePattern >= 0) {
                file = new File(dir, filename.substring(0, datePattern) + this._fileDateFormat.format(new Date(now.toInstant().toEpochMilli())) + filename.substring(datePattern + 10));
            }
            if (file.exists() && !file.canWrite()) {
                throw new IOException("Cannot write log file " + file);
            }
            if (this._out == null || datePattern >= 0) {
                oldFile = this._file;
                newFile = this._file = file;
                OutputStream oldOut = this._out;
                if (oldOut != null) {
                    oldOut.close();
                }
                if (!this._append && file.exists()) {
                    void var1_1;
                    backupFile = new File(file.toString() + "." + this._fileBackupFormat.format(new Date(var1_1.toInstant().toEpochMilli())));
                    this.renameFile(file, backupFile);
                }
                this._out = new FileOutputStream(file.toString(), this._append);
            }
        }
        if (newFile != null) {
            void var3_4;
            void var2_3;
            this.rollover((File)var2_3, backupFile, (File)var3_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void renameFile(File src, File dest) throws IOException {
        if (!src.renameTo(dest)) {
            try {
                Files.move(src.toPath(), dest.toPath(), new CopyOption[0]);
                return;
            }
            catch (IOException iOException) {
                void var1_1;
                void var2_2;
                Files.copy(src.toPath(), var2_2.toPath(), new CopyOption[0]);
                Files.deleteIfExists(var1_1.toPath());
            }
        }
    }

    protected void rollover(File oldFile, File backupFile, File newFile) {
    }

    /*
     * WARNING - void declaration
     */
    void removeOldFiles(ZonedDateTime now) {
        if (this._retainDays > 0) {
            long expired = now.minus(this._retainDays, ChronoUnit.DAYS).toInstant().toEpochMilli();
            File file = new File(this._filename);
            File dir = new File(file.getParent());
            String fn = file.getName();
            int s = fn.toLowerCase(Locale.ENGLISH).indexOf(YYYY_MM_DD);
            if (s < 0) {
                return;
            }
            String prefix = fn.substring(0, s);
            String suffix = fn.substring(s + 10);
            String[] logList = dir.list();
            for (int i = 0; i < logList.length; ++i) {
                void var1_1;
                File f;
                fn = logList[i];
                if (!fn.startsWith(prefix) || fn.indexOf(suffix, prefix.length()) < 0 || (f = new File(dir, fn)).lastModified() >= expired) continue;
                var1_1.delete();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(int b) throws IOException {
        RolloverFileOutputStream rolloverFileOutputStream = this;
        synchronized (rolloverFileOutputStream) {
            void var1_1;
            this._out.write((int)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(byte[] buf) throws IOException {
        RolloverFileOutputStream rolloverFileOutputStream = this;
        synchronized (rolloverFileOutputStream) {
            void var1_1;
            this._out.write((byte[])var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        RolloverFileOutputStream rolloverFileOutputStream = this;
        synchronized (rolloverFileOutputStream) {
            void var3_4;
            void var2_3;
            void var1_1;
            this._out.write((byte[])var1_1, (int)var2_3, (int)var3_4);
            return;
        }
    }

    @Override
    public void flush() throws IOException {
        RolloverFileOutputStream rolloverFileOutputStream = this;
        synchronized (rolloverFileOutputStream) {
            this._out.flush();
            return;
        }
    }

    @Override
    public void close() throws IOException {
        Object object = this;
        synchronized (object) {
            try {
                this._out.close();
            }
            finally {
                this._out = null;
                this._file = null;
            }
        }
        object = RolloverFileOutputStream.class;
        synchronized (RolloverFileOutputStream.class) {
            if (this._rollTask != null) {
                this._rollTask.cancel();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(RolloverFileOutputStream x0, ZonedDateTime x1) {
        void var1_1;
        x0.scheduleNextRollover((ZonedDateTime)var1_1);
    }

    private class RollTask
    extends TimerTask {
        private RollTask() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            try {
                void var1_1;
                ZonedDateTime now = ZonedDateTime.now(RolloverFileOutputStream.this._fileDateFormat.getTimeZone().toZoneId());
                RolloverFileOutputStream.this.setFile(now);
                RolloverFileOutputStream.this.removeOldFiles(now);
                RolloverFileOutputStream.access$200(RolloverFileOutputStream.this, (ZonedDateTime)var1_1);
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                throwable.printStackTrace(System.err);
                return;
            }
        }
    }
}

