/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jetty.util.log.Log;

public interface Promise<C> {
    default public void succeeded(C result) {
    }

    default public void failed(Throwable x) {
    }

    public static <T> Promise<T> from(CompletableFuture<? super T> completable) {
        CompletableFuture<? super T> completableFuture;
        if (completable instanceof Promise) {
            return (Promise)((Object)completable);
        }
        return new Promise<T>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void succeeded(T result) {
                void var1_1;
                completableFuture.complete(var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void failed(Throwable x) {
                void var1_1;
                completableFuture.completeExceptionally((Throwable)var1_1);
            }
        };
    }

    public static class Wrapper<W>
    implements Promise<W> {
        private final Promise<W> promise;

        /*
         * WARNING - void declaration
         */
        public Wrapper(Promise<W> promise) {
            void var1_1;
            this.promise = (Promise)Objects.requireNonNull(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void succeeded(W result) {
            void var1_1;
            this.promise.succeeded(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void failed(Throwable x) {
            void var1_1;
            this.promise.failed((Throwable)var1_1);
        }

        public Promise<W> getPromise() {
            return this.promise;
        }

        /*
         * WARNING - void declaration
         */
        public Promise<W> unwrap() {
            void var1_1;
            Promise<W> result = this.promise;
            while (result instanceof Wrapper) {
                result = ((Wrapper)result).unwrap();
            }
            return var1_1;
        }
    }

    public static class Completable<S>
    extends CompletableFuture<S>
    implements Promise<S> {
        /*
         * WARNING - void declaration
         */
        @Override
        public void succeeded(S result) {
            void var1_1;
            this.complete(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void failed(Throwable x) {
            void var1_1;
            this.completeExceptionally((Throwable)var1_1);
        }
    }

    public static class Adapter<U>
    implements Promise<U> {
        /*
         * WARNING - void declaration
         */
        @Override
        public void failed(Throwable x) {
            void var1_1;
            Log.getLogger(this.getClass()).warn((Throwable)var1_1);
        }
    }
}

