/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.jetty.util.AtomicBiInteger;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Locker;

@ManagedObject
public class Pool<T>
implements AutoCloseable,
Dumpable {
    private static final Logger LOGGER = Log.getLogger(Pool.class);
    private final List<Entry> entries = new CopyOnWriteArrayList<Entry>();
    private final int maxEntries;
    private final StrategyType strategyType;
    private final Locker locker = new Locker();
    private final ThreadLocal<Entry> cache;
    private final AtomicInteger nextIndex;
    private volatile boolean closed;
    @Deprecated
    private volatile int maxUsage = -1;
    @Deprecated
    private volatile int maxMultiplex = -1;

    /*
     * WARNING - void declaration
     */
    public Pool(StrategyType strategyType, int maxEntries) {
        this((StrategyType)var1_1, (int)var2_2, false);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Pool(StrategyType strategyType, int maxEntries, boolean cache) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.maxEntries = var2_2;
        this.strategyType = Objects.requireNonNull(strategyType);
        this.cache = var3_3 != false ? new ThreadLocal() : null;
        this.nextIndex = var1_1 == StrategyType.ROUND_ROBIN ? new AtomicInteger() : null;
    }

    @ManagedAttribute(value="The number of reserved entries")
    public int getReservedCount() {
        return (int)this.entries.stream().filter(Entry::isReserved).count();
    }

    @ManagedAttribute(value="The number of idle entries")
    public int getIdleCount() {
        return (int)this.entries.stream().filter(Entry::isIdle).count();
    }

    @ManagedAttribute(value="The number of in-use entries")
    public int getInUseCount() {
        return (int)this.entries.stream().filter(Entry::isInUse).count();
    }

    @ManagedAttribute(value="The number of closed entries")
    public int getClosedCount() {
        return (int)this.entries.stream().filter(Entry::isClosed).count();
    }

    @ManagedAttribute(value="The maximum number of entries")
    public int getMaxEntries() {
        return this.maxEntries;
    }

    @ManagedAttribute(value="The default maximum multiplex count of entries")
    @Deprecated
    public int getMaxMultiplex() {
        if (this.maxMultiplex == -1) {
            return 1;
        }
        return this.maxMultiplex;
    }

    @Deprecated
    protected int getMaxMultiplex(T pooled) {
        return this.getMaxMultiplex();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public final void setMaxMultiplex(int maxMultiplex) {
        void var1_1;
        Locker.Lock l;
        block10: {
            if (maxMultiplex <= 0) {
                throw new IllegalArgumentException("Max multiplex must be >= 1");
            }
            l = this.locker.lock();
            try {
                if (!this.closed) break block10;
                if (l != null) {
                    l.close();
                }
                return;
            }
            catch (Throwable throwable) {
                if (l != null) {
                    try {
                        void var2_3;
                        var2_3.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        if (this.entries.stream().anyMatch(MonoEntry.class::isInstance)) {
            throw new IllegalStateException("Pool entries do not support multiplexing");
        }
        this.maxMultiplex = var1_1;
        if (l != null) {
            l.close();
            return;
        }
    }

    @ManagedAttribute(value="The default maximum usage count of entries")
    @Deprecated
    public int getMaxUsageCount() {
        return this.maxUsage;
    }

    @Deprecated
    protected int getMaxUsageCount(T pooled) {
        return this.getMaxUsageCount();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public final void setMaxUsageCount(int maxUsageCount) {
        void var1_2;
        Locker.Lock l;
        block10: {
            if (maxUsageCount == 0) {
                throw new IllegalArgumentException("Max usage count must be != 0");
            }
            l = this.locker.lock();
            try {
                if (!this.closed) break block10;
                if (l != null) {
                    l.close();
                }
                return;
            }
            catch (Throwable copy) {
                if (l != null) {
                    try {
                        void var2_4;
                        var2_4.close();
                    }
                    catch (Throwable throwable) {
                        copy.addSuppressed(throwable);
                    }
                }
                throw copy;
            }
        }
        if (this.entries.stream().anyMatch(MonoEntry.class::isInstance)) {
            throw new IllegalStateException("Pool entries do not support max usage");
        }
        this.maxUsage = maxUsageCount;
        List copy = this.entries.stream().filter(entry -> {
            void var1_1;
            return entry.isIdleAndOverUsed() && this.remove((Entry)entry) && ((Entry)var1_1).pooled instanceof Closeable;
        }).map(entry -> (Closeable)((Entry)entry).pooled).collect(Collectors.toList());
        if (l != null) {
            l.close();
        }
        var1_2.forEach(IO::close);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public Entry reserve(int allotment) {
        void var1_2;
        Locker.Lock l;
        block14: {
            block13: {
                block12: {
                    l = this.locker.lock();
                    try {
                        if (!this.closed) break block12;
                        if (l != null) {
                            l.close();
                        }
                        return null;
                    }
                    catch (Throwable throwable) {
                        if (l != null) {
                            try {
                                void var2_4;
                                var2_4.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                }
                int n = this.maxEntries - this.entries.size();
                if (n > 0) break block13;
                if (l != null) {
                    l.close();
                }
                return null;
            }
            if (allotment < 0 || this.getReservedCount() * this.getMaxMultiplex() < allotment) break block14;
            if (l != null) {
                l.close();
            }
            return null;
        }
        Entry entry = this.newEntry();
        this.entries.add(entry);
        if (l != null) {
            l.close();
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public Entry reserve() {
        void var3_5;
        Locker.Lock l;
        block14: {
            block13: {
                l = this.locker.lock();
                try {
                    if (!this.closed) break block13;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("{} is closed, returning null reserved entry", this);
                    }
                    if (l != null) {
                        l.close();
                    }
                    return null;
                }
                catch (Throwable throwable) {
                    if (l != null) {
                        try {
                            void var1_1;
                            var1_1.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            int entriesSize = this.entries.size();
            if (entriesSize < this.maxEntries) break block14;
            if (LOGGER.isDebugEnabled()) {
                void var2_2;
                LOGGER.debug("{} has no space: {} >= {}, returning null reserved entry", this, (int)var2_2, this.maxEntries);
            }
            if (l != null) {
                l.close();
            }
            return null;
        }
        Entry entry = this.newEntry();
        this.entries.add(entry);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{} returning new reserved entry {}", this, entry);
        }
        void var2_3 = var3_5;
        if (l != null) {
            l.close();
        }
        return var2_3;
    }

    private Entry newEntry() {
        if (this.maxMultiplex >= 0 || this.maxUsage >= 0) {
            return new MultiEntry();
        }
        return new MonoEntry();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public Entry acquireAt(int idx) {
        if (this.closed) {
            return null;
        }
        try {
            Entry entry = this.entries.get(idx);
            if (entry.tryAcquire()) {
                void var1_2;
                return var1_2;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        return null;
    }

    public Entry acquire() {
        Entry entry;
        if (this.closed) {
            return null;
        }
        int size = this.entries.size();
        if (size == 0) {
            return null;
        }
        if (this.cache != null && (entry = this.cache.get()) != null && entry.tryAcquire()) {
            return entry;
        }
        int index = this.startIndex(size);
        int tries = size;
        while (tries-- > 0) {
            try {
                Entry entry2 = this.entries.get(index);
                if (entry2 != null && entry2.tryAcquire()) {
                    return entry2;
                }
            }
            catch (IndexOutOfBoundsException e) {
                LOGGER.ignore(e);
                size = this.entries.size();
                if (size == 0) break;
            }
            index = (index + 1) % size;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private int startIndex(int size) {
        switch (this.strategyType) {
            case FIRST: {
                return 0;
            }
            case RANDOM: {
                return ThreadLocalRandom.current().nextInt(size);
            }
            case ROUND_ROBIN: {
                return this.nextIndex.getAndUpdate(c -> {
                    int n;
                    return Math.max(0, n + 1);
                }) % size;
            }
            case THREAD_ID: {
                void var1_1;
                return (int)(Thread.currentThread().getId() % (long)var1_1);
            }
        }
        throw new IllegalArgumentException("Unknown strategy type: " + (Object)((Object)this.strategyType));
    }

    /*
     * WARNING - void declaration
     */
    public Entry acquire(Function<Entry, T> creator) {
        void var1_1;
        T value;
        Entry entry = this.acquire();
        if (entry != null) {
            return entry;
        }
        entry = this.reserve();
        if (entry == null) {
            return null;
        }
        try {
            value = creator.apply(entry);
        }
        catch (Throwable th) {
            void value2;
            this.remove(entry);
            throw value2;
        }
        if (value == null) {
            this.remove(entry);
            return null;
        }
        if (entry.enable(var1_1, true)) {
            void var2_3;
            return var2_3;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean release(Entry entry) {
        void var2_2;
        if (this.closed) {
            return false;
        }
        boolean released = entry.tryRelease();
        if (released && this.cache != null) {
            void var1_1;
            this.cache.set((Entry)var1_1);
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean remove(Entry entry) {
        void var2_2;
        if (this.closed) {
            return false;
        }
        if (!entry.tryRemove()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Attempt to remove an object from the pool that is still in use: {}", entry);
            }
            return false;
        }
        boolean removed = this.entries.remove(entry);
        if (!removed && LOGGER.isDebugEnabled()) {
            void var1_1;
            LOGGER.debug("Attempt to remove an object from the pool that does not exist: {}", var1_1);
        }
        return (boolean)var2_2;
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Closing {}", this);
        }
        Locker.Lock l = this.locker.lock();
        try {
            this.closed = true;
            ArrayList<Entry> copy = new ArrayList<Entry>(this.entries);
            this.entries.clear();
            if (l != null) {
                l.close();
            }
        }
        catch (Throwable copy) {
            if (l != null) {
                try {
                    Iterator iterator;
                    ((Locker.Lock)((Object)iterator)).close();
                }
                catch (Throwable throwable) {
                    copy.addSuppressed(throwable);
                }
            }
            throw copy;
        }
        for (Entry entry : copy) {
            void var1_2;
            boolean bl = entry.tryRemove();
            if (bl) {
                if (!(entry.pooled instanceof Closeable)) continue;
                IO.close((Closeable)entry.pooled);
                continue;
            }
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Pooled object still in use: {}", var1_2);
        }
    }

    public int size() {
        return this.entries.size();
    }

    public Collection<Entry> values() {
        return Collections.unmodifiableCollection(this.entries);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void dump(Appendable out, String indent) throws IOException {
        void var2_2;
        Dumpable.dumpObjects(out, (String)var2_2, this, new DumpableCollection("entries", this.entries));
    }

    public String toString() {
        return String.format("%s@%x[inUse=%d,size=%d,capacity=%d,closed=%b]", this.getClass().getSimpleName(), this.hashCode(), this.getInUseCount(), this.size(), this.getMaxEntries(), this.isClosed());
    }

    class MultiEntry
    extends Entry {
        private final AtomicBiInteger state;

        /*
         * WARNING - void declaration
         */
        MultiEntry() {
            void var1_1;
            super((Pool)var1_1);
            this.state = new AtomicBiInteger(Integer.MIN_VALUE, 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        void setUsageCount(int usageCount) {
            void var1_1;
            this.state.getAndSetHi((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected boolean tryEnable(boolean acquire) {
            void var1_1;
            int usage = acquire ? 1 : 0;
            return this.state.compareAndSet(Integer.MIN_VALUE, usage, 0, (int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        boolean tryAcquire() {
            int multiplexCount;
            void var3_2;
            void var1_1;
            do {
                int newUsageCount;
                long encoded = this.state.get();
                int usageCount = AtomicBiInteger.getHi(encoded);
                multiplexCount = AtomicBiInteger.getLo(encoded);
                boolean bl = usageCount < 0;
                if (bl) {
                    return false;
                }
                Object pooled = this.getPooled();
                int maxUsageCount = Pool.this.getMaxUsageCount(pooled);
                int maxMultiplexed = Pool.this.getMaxMultiplex(pooled);
                if (maxMultiplexed > 0 && multiplexCount >= maxMultiplexed) {
                    return false;
                }
                if (maxUsageCount > 0 && usageCount >= maxUsageCount) {
                    return false;
                }
                int n = newUsageCount = usageCount == Integer.MAX_VALUE ? Integer.MAX_VALUE : usageCount + 1;
            } while (!this.state.compareAndSet((long)var1_1, (int)var3_2, multiplexCount + 1));
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        boolean tryRelease() {
            void var3_4;
            void var2_2;
            boolean bl;
            int newMultiplexCount;
            int usageCount;
            long encoded;
            do {
                if (bl = (usageCount = AtomicBiInteger.getHi(encoded = this.state.get())) < 0) {
                    return false;
                }
                newMultiplexCount = AtomicBiInteger.getLo(encoded) - 1;
                if (newMultiplexCount >= 0) continue;
                throw new IllegalStateException("Cannot release an already released entry");
            } while (!this.state.compareAndSet(encoded, usageCount, newMultiplexCount));
            int currentMaxUsageCount = Pool.this.getMaxUsageCount(this.getPooled());
            boolean bl2 = currentMaxUsageCount > 0 && var2_2 >= var3_4;
            return !bl2 || bl;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        boolean tryRemove() {
            void var2_3;
            long encoded;
            int multiplexCount;
            int newMultiplexCount;
            void var3_4;
            boolean bl;
            do {
                encoded = this.state.get();
                int usageCount = AtomicBiInteger.getHi(encoded);
            } while (!(bl = this.state.compareAndSet((int)var3_4, -1, bl ? 1 : 0, newMultiplexCount = Math.max((multiplexCount = AtomicBiInteger.getLo(encoded)) - 1, 0))));
            return var2_3 == false;
        }

        @Override
        public boolean isClosed() {
            return this.state.getHi() < 0;
        }

        @Override
        public boolean isReserved() {
            return this.state.getHi() == Integer.MIN_VALUE;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean isIdle() {
            void var1_1;
            long encoded = this.state.get();
            return AtomicBiInteger.getHi(encoded) >= 0 && AtomicBiInteger.getLo((long)var1_1) == 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean isInUse() {
            void var1_1;
            long encoded = this.state.get();
            return AtomicBiInteger.getHi(encoded) >= 0 && AtomicBiInteger.getLo((long)var1_1) > 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean isOverUsed() {
            void var1_1;
            void var2_2;
            int maxUsageCount = Pool.this.getMaxUsageCount();
            int usageCount = this.state.getHi();
            return maxUsageCount > 0 && var2_2 >= var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        boolean isIdleAndOverUsed() {
            void var2_3;
            void var1_1;
            int maxUsageCount = Pool.this.getMaxUsageCount();
            long encoded = this.state.get();
            int usageCount = AtomicBiInteger.getHi(encoded);
            int multiplexCount = AtomicBiInteger.getLo(encoded);
            return maxUsageCount > 0 && usageCount >= var1_1 && var2_3 == false;
        }

        @Override
        int getUsageCount() {
            return Math.max(this.state.getHi(), 0);
        }

        /*
         * WARNING - void declaration
         */
        public String toString() {
            void var1_2;
            void var3_3;
            void var2_4;
            long encoded = this.state.get();
            int usageCount = AtomicBiInteger.getHi(encoded);
            int multiplexCount = AtomicBiInteger.getLo(encoded);
            String state = usageCount < 0 ? (usageCount == Integer.MIN_VALUE ? "PENDING" : "CLOSED") : (multiplexCount == 0 ? "IDLE" : "ACTIVE");
            return String.format("%s@%x{%s,usage=%d,multiplex=%d,pooled=%s}", this.getClass().getSimpleName(), this.hashCode(), var2_4, Math.max((int)var3_3, 0), Math.max((int)var1_2, 0), this.getPooled());
        }
    }

    private class MonoEntry
    extends Entry {
        private final AtomicInteger state;

        private MonoEntry() {
            super(Pool.this);
            this.state = new AtomicInteger(Integer.MIN_VALUE);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected boolean tryEnable(boolean acquire) {
            void var1_1;
            return this.state.compareAndSet(Integer.MIN_VALUE, var1_1 != false ? 1 : 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        boolean tryAcquire() {
            void var1_1;
            do {
                int s;
                if ((s = this.state.get()) == 0) continue;
                return false;
            } while (!this.state.compareAndSet((int)var1_1, 1));
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        boolean tryRelease() {
            void var1_1;
            do {
                int s;
                if ((s = this.state.get()) < 0) {
                    return false;
                }
                if (s != 0) continue;
                throw new IllegalStateException("Cannot release an already released entry");
            } while (!this.state.compareAndSet((int)var1_1, 0));
            return true;
        }

        @Override
        boolean tryRemove() {
            this.state.set(-1);
            return true;
        }

        @Override
        public boolean isClosed() {
            return this.state.get() < 0;
        }

        @Override
        public boolean isReserved() {
            return this.state.get() == Integer.MIN_VALUE;
        }

        @Override
        public boolean isIdle() {
            return this.state.get() == 0;
        }

        @Override
        public boolean isInUse() {
            return this.state.get() == 1;
        }

        /*
         * WARNING - void declaration
         */
        public String toString() {
            void var1_1;
            switch (this.state.get()) {
                case -2147483648: {
                    String s = "PENDING";
                    break;
                }
                case -1: {
                    String s = "CLOSED";
                    break;
                }
                case 0: {
                    String s = "IDLE";
                    break;
                }
                default: {
                    String s = "ACTIVE";
                }
            }
            return String.format("%s@%x{%s,pooled=%s}", this.getClass().getSimpleName(), this.hashCode(), var1_1, this.getPooled());
        }
    }

    public abstract class Entry {
        private T pooled;
        final /* synthetic */ Pool this$0;

        /*
         * WARNING - void declaration
         */
        public Entry(Pool this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public boolean enable(T pooled, boolean acquire) {
            void var2_2;
            void var1_1;
            Objects.requireNonNull(pooled);
            if (!this.isReserved()) {
                if (this.isClosed()) {
                    return false;
                }
                throw new IllegalStateException("Entry already enabled: " + this);
            }
            this.pooled = var1_1;
            if (this.tryEnable((boolean)var2_2)) {
                return true;
            }
            this.pooled = null;
            if (this.isClosed()) {
                return false;
            }
            throw new IllegalStateException("Entry already enabled: " + this);
        }

        public T getPooled() {
            return this.pooled;
        }

        public boolean release() {
            return this.this$0.release(this);
        }

        public boolean remove() {
            return this.this$0.remove(this);
        }

        abstract boolean tryEnable(boolean var1);

        abstract boolean tryAcquire();

        abstract boolean tryRelease();

        abstract boolean tryRemove();

        public abstract boolean isClosed();

        public abstract boolean isReserved();

        public abstract boolean isIdle();

        public abstract boolean isInUse();

        @Deprecated
        public boolean isOverUsed() {
            return false;
        }

        boolean isIdleAndOverUsed() {
            return false;
        }

        int getUsageCount() {
            return 0;
        }

        void setUsageCount(int usageCount) {
        }
    }

    public static enum StrategyType {
        FIRST,
        RANDOM,
        THREAD_ID,
        ROUND_ROBIN;

    }
}

