/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.eclipse.jetty.util.IncludeExcludeSet;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class PathWatcher
extends AbstractLifeCycle
implements Runnable {
    private static final boolean IS_WINDOWS;
    static final Logger LOG;
    private static final WatchEvent.Kind<?>[] WATCH_EVENT_KINDS;
    private static final WatchEvent.Kind<?>[] WATCH_DIR_KINDS;
    private WatchService watchService;
    private final List<Config> configs = new ArrayList<Config>();
    private final Map<WatchKey, Config> keys = new ConcurrentHashMap<WatchKey, Config>();
    private final List<EventListener> listeners = new CopyOnWriteArrayList<EventListener>();
    private final Map<Path, PathWatchEvent> pending = new LinkedHashMap<Path, PathWatchEvent>(32, 0.75f, false);
    private final List<PathWatchEvent> events = new ArrayList<PathWatchEvent>();
    private long updateQuietTimeDuration = 1000L;
    private TimeUnit updateQuietTimeUnit = TimeUnit.MILLISECONDS;
    private Thread thread;
    private boolean _notifyExistingOnStart = true;

    protected static <T> WatchEvent<T> cast(WatchEvent<?> event) {
        return event;
    }

    public Collection<Config> getConfigs() {
        return this.configs;
    }

    /*
     * WARNING - void declaration
     */
    public void watch(Path file) {
        void var1_1;
        void var3_3;
        Path abs = file;
        if (!abs.isAbsolute()) {
            abs = file.toAbsolutePath();
        }
        Config config = null;
        Path parent = abs.getParent();
        for (Config c : this.configs) {
            if (!c.getPath().equals(parent)) continue;
            config = c;
            break;
        }
        if (config == null) {
            void var2_2;
            config = new Config(var2_2.getParent());
            config.addIncludeGlobRelative("");
            config.addIncludeGlobRelative(file.getFileName().toString());
            this.watch(config);
            return;
        }
        var3_3.addIncludeGlobRelative(var1_1.getFileName().toString());
    }

    /*
     * WARNING - void declaration
     */
    public void watch(Config config) {
        void var1_1;
        this.configs.add((Config)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addListener(EventListener listener) {
        void var1_1;
        this.listeners.add((EventListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void appendConfigId(StringBuilder s) {
        void var1_1;
        ArrayList<Path> dirs = new ArrayList<Path>();
        for (Config config : this.keys.values()) {
            dirs.add(config.path);
        }
        Collections.sort(dirs);
        s.append("[");
        if (dirs.size() > 0) {
            s.append(dirs.get(0));
            if (dirs.size() > 1) {
                void var2_2;
                s.append(" (+").append(var2_2.size() - 1).append(")");
            }
        } else {
            s.append("<null>");
        }
        var1_1.append("]");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doStart() throws Exception {
        this.watchService = FileSystems.getDefault().newWatchService();
        PathWatcher pathWatcher = this;
        pathWatcher.setUpdateQuietTime(pathWatcher.getUpdateQuietTimeMillis(), TimeUnit.MILLISECONDS);
        Iterator<Config> iterator = this.configs.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            Config c = iterator.next();
            this.registerTree(c.getPath(), (Config)var2_2, this.isNotifyExistingOnStart());
        }
        StringBuilder threadId = new StringBuilder();
        threadId.append("PathWatcher@");
        threadId.append(Integer.toHexString(this.hashCode()));
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} -> {}", this, threadId);
        }
        this.thread = new Thread((Runnable)this, ((StringBuilder)((Object)iterator)).toString());
        this.thread.setDaemon(true);
        this.thread.start();
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        if (this.watchService != null) {
            this.watchService.close();
        }
        this.watchService = null;
        this.thread = null;
        this.keys.clear();
        this.pending.clear();
        this.events.clear();
        super.doStop();
    }

    public void reset() {
        if (!this.isStopped()) {
            throw new IllegalStateException("PathWatcher must be stopped before reset.");
        }
        this.configs.clear();
        this.listeners.clear();
    }

    protected boolean isNotifiable() {
        return this.isStarted() || !this.isStarted() && this.isNotifyExistingOnStart();
    }

    public Iterator<EventListener> getListeners() {
        return this.listeners.iterator();
    }

    public long getUpdateQuietTimeMillis() {
        return TimeUnit.MILLISECONDS.convert(this.updateQuietTimeDuration, this.updateQuietTimeUnit);
    }

    /*
     * WARNING - void declaration
     */
    private void registerTree(Path dir, Config config, boolean notify) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("registerTree {} {} {}", dir, config, notify);
        }
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new IllegalArgumentException(dir.toString());
        }
        this.register(dir, config);
        MultiException me = new MultiException();
        try (Object stream = Files.list(dir);){
            void var2_4;
            void var3_6;
            stream.forEach(arg_0 -> this.lambda$registerTree$0((boolean)var3_6, (Config)var2_4, me, arg_0));
        }
        try {
            me.ifExceptionThrow();
            return;
        }
        catch (IOException iOException) {
            stream = iOException;
            throw iOException;
        }
        catch (Throwable ex) {
            void var1_3;
            throw new IOException((Throwable)var1_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void registerDir(Path path, Config config) throws IOException {
        void var1_1;
        void var2_2;
        if (LOG.isDebugEnabled()) {
            LOG.debug("registerDir {} {}", path, config);
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalArgumentException(path.toString());
        }
        this.register(path, var2_2.asSubConfig((Path)var1_1), WATCH_DIR_KINDS);
    }

    /*
     * WARNING - void declaration
     */
    protected void register(Path path, Config config) throws IOException {
        void var2_2;
        void var1_1;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Registering watch on {}", path);
        }
        this.register((Path)var1_1, (Config)var2_2, WATCH_EVENT_KINDS);
    }

    /*
     * WARNING - void declaration
     */
    private void register(Path path, Config config, WatchEvent.Kind<?>[] kinds) throws IOException {
        void var2_2;
        void var1_1;
        void var3_3;
        WatchKey key = path.register(this.watchService, (WatchEvent.Kind<?>)var3_3);
        this.keys.put((WatchKey)var1_1, (Config)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public boolean removeListener(Listener listener) {
        void var1_1;
        return this.listeners.remove(var1_1);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        if (PathWatcher.LOG.isDebugEnabled()) {
            PathWatcher.LOG.debug("Starting java.nio file watching with {}", new Object[]{this.watchService});
        }
        waitTime = this.getUpdateQuietTimeMillis();
        watch = this.watchService;
        while (this.isRunning() && this.thread == Thread.currentThread()) {
            try {
                block10: {
                    block9: {
                        now = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
                        for (Map.Entry<WatchKey, Config> e : this.keys.entrySet()) {
                            k = e.getKey();
                            var7_6 = e.getValue();
                            if (var7_6.isPaused(now) || k.reset()) continue;
                            this.keys.remove(k);
                            if (!this.keys.isEmpty()) continue;
                            return;
                        }
                        if (PathWatcher.LOG.isDebugEnabled()) {
                            PathWatcher.LOG.debug("Waiting for poll({})", waitTime);
                        }
                        if (waitTime >= 0L) break block9;
                        v0 = watch.take();
                        ** GOTO lbl28
                    }
                    if (waitTime <= 0L) break block10;
                    v0 = watch.poll(waitTime, this.updateQuietTimeUnit);
                    ** GOTO lbl28
                }
                while (true) {
                    v0 = key = watch.poll();
lbl28:
                    // 3 sources

                    if (v0 == null) break;
                    this.handleKey(key);
                }
                waitTime = this.processPending();
                this.notifyEvents();
            }
            catch (ClosedWatchServiceException v1) {
                return;
            }
            catch (InterruptedException e) {
                if (this.isRunning()) {
                    PathWatcher.LOG.warn(e);
                    continue;
                }
                PathWatcher.LOG.ignore(e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handleKey(WatchKey key) {
        Iterator<WatchEvent<?>> iterator;
        Config config = this.keys.get(key);
        if (config == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("WatchKey not recognized: {}", key);
            }
            return;
        }
        block6: for (WatchEvent<?> watchEvent : iterator.pollEvents()) {
            Path parent;
            WatchEvent<Path> ev = PathWatcher.cast(watchEvent);
            Path name = (Path)ev.context();
            Path path = config.resolve(name);
            if (LOG.isDebugEnabled()) {
                LOG.debug("handleKey? {} {} {}", ev.kind(), config.toShortPath(path), config);
            }
            if (ev.kind() == StandardWatchEventKinds.ENTRY_MODIFY && Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0])) continue;
            if (config.test(path)) {
                this.handleWatchEvent(path, new PathWatchEvent(this, path, ev, config));
            } else if (config.getRecurseDepth() == -1) {
                parent = path.getParent();
                Config parentConfig = config.getParent();
                this.handleWatchEvent(parent, new PathWatchEvent(this, parent, PathWatchEventType.MODIFIED, parentConfig));
                continue;
            }
            if (parent.kind() != StandardWatchEventKinds.ENTRY_CREATE) continue;
            try {
                void var4_5;
                switch (config.handleDir((Path)var4_5)) {
                    case ENTER: {
                        this.registerTree((Path)var4_5, config.asSubConfig((Path)var4_5), true);
                        continue block6;
                    }
                    case WATCH: {
                        this.registerDir((Path)var4_5, config);
                    }
                }
            }
            catch (IOException e) {
                void var3_4;
                LOG.warn((Throwable)var3_4);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handleWatchEvent(Path path, PathWatchEvent event) {
        PathWatchEvent existing = this.pending.get(path);
        if (LOG.isDebugEnabled()) {
            LOG.debug("handleWatchEvent {} {} <= {}", path, event, existing);
        }
        switch (event.getType()) {
            case ADDED: {
                if (existing != null && existing.getType() == PathWatchEventType.MODIFIED) {
                    this.events.add(new PathWatchEvent(this, path, PathWatchEventType.DELETED, existing.getConfig()));
                }
                this.pending.put(path, event);
                return;
            }
            case MODIFIED: {
                if (existing == null) {
                    this.pending.put(path, event);
                    return;
                }
                existing.modified();
                return;
            }
            case DELETED: 
            case UNKNOWN: {
                void var2_2;
                void var3_3;
                if (var3_3 != null) {
                    void var1_1;
                    this.pending.remove(var1_1);
                }
                this.events.add((PathWatchEvent)var2_2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private long processPending() {
        void var3_2;
        if (LOG.isDebugEnabled()) {
            LOG.debug("processPending> {}", this.pending.values());
        }
        long now = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
        long wait = Long.MAX_VALUE;
        for (PathWatchEvent event : new ArrayList<PathWatchEvent>(this.pending.values())) {
            Path path = event.getPath();
            if (this.pending.containsKey(path.getParent())) continue;
            if (event.isQuiet(now, this.getUpdateQuietTimeMillis())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("isQuiet {}", event);
                }
                this.pending.remove(path);
                this.events.add(event);
                continue;
            }
            long msToCheck = event.toQuietCheck(now, this.getUpdateQuietTimeMillis());
            if (LOG.isDebugEnabled()) {
                LOG.debug("pending {} {}", event, msToCheck);
            }
            if (msToCheck >= wait) continue;
            wait = msToCheck;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("processPending< {}", this.pending.values());
        }
        if (wait == Long.MAX_VALUE) {
            return -1L;
        }
        return (long)var3_2;
    }

    /*
     * WARNING - void declaration
     */
    private void notifyEvents() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("notifyEvents {}", this.events.size());
        }
        if (this.events.isEmpty()) {
            return;
        }
        boolean eventListeners = false;
        for (EventListener listener : this.listeners) {
            if (listener instanceof EventListListener) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("notifyEvents {} {}", listener, this.events);
                    }
                    ((EventListListener)listener).onPathWatchEvents(this.events);
                }
                catch (Throwable t) {
                    LOG.warn(t);
                }
                continue;
            }
            eventListeners = true;
        }
        if (eventListeners) {
            for (PathWatchEvent event : this.events) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("notifyEvent {} {}", event, this.listeners);
                }
                for (EventListener listener : this.listeners) {
                    if (!(listener instanceof Listener)) continue;
                    try {
                        ((Listener)listener).onPathWatchEvent(event);
                    }
                    catch (Throwable t) {
                        void var1_3;
                        LOG.warn((Throwable)var1_3);
                    }
                }
            }
        }
        this.events.clear();
    }

    /*
     * WARNING - void declaration
     */
    public void setNotifyExistingOnStart(boolean notify) {
        void var1_1;
        this._notifyExistingOnStart = var1_1;
    }

    public boolean isNotifyExistingOnStart() {
        return this._notifyExistingOnStart;
    }

    /*
     * WARNING - void declaration
     */
    public void setUpdateQuietTime(long duration, TimeUnit unit) {
        void var3_2;
        void var1_1;
        long desiredMillis = unit.toMillis(duration);
        if (IS_WINDOWS && desiredMillis < 1000L) {
            LOG.warn("Quiet Time is too low for Microsoft Windows: {} < 1000 ms (defaulting to 1000 ms)", desiredMillis);
            this.updateQuietTimeDuration = 1000L;
            this.updateQuietTimeUnit = TimeUnit.MILLISECONDS;
            return;
        }
        this.updateQuietTimeDuration = var1_1;
        this.updateQuietTimeUnit = var3_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toString() {
        void var1_1;
        StringBuilder s = new StringBuilder(this.getClass().getName());
        this.appendConfigId(s);
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$registerTree$0(boolean notify, Config config, MultiException me, Path p) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("registerTree? {}", p);
        }
        try {
            if (notify && config.test(p)) {
                this.pending.put(p, new PathWatchEvent(this, p, PathWatchEventType.ADDED, config));
            }
            switch (config.handleDir(p)) {
                case ENTER: {
                    this.registerTree(p, config.asSubConfig(p), notify);
                    break;
                }
                case WATCH: {
                    void var2_3;
                    this.registerDir(p, (Config)var2_3);
                }
                default: {
                    return;
                }
            }
        }
        catch (IOException e) {
            void var1_2;
            void var3_4;
            var3_4.add((Throwable)var1_2);
        }
    }

    static {
        String os = System.getProperty("os.name");
        if (os == null) {
            IS_WINDOWS = false;
        } else {
            String string;
            string = string.toLowerCase(Locale.ENGLISH);
            IS_WINDOWS = string.contains("windows");
        }
        LOG = Log.getLogger(PathWatcher.class);
        WATCH_EVENT_KINDS = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
        WATCH_DIR_KINDS = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE};
    }

    public static class PathMatcherSet
    extends HashSet<PathMatcher>
    implements Predicate<Path> {
        @Override
        public boolean test(Path path) {
            for (PathMatcher pathMatcher : this) {
                if (!pathMatcher.matches(path)) continue;
                return true;
            }
            return false;
        }
    }

    private static class ExactPathMatcher
    implements PathMatcher {
        private final Path path;

        /*
         * WARNING - void declaration
         */
        ExactPathMatcher(Path path) {
            void var1_1;
            this.path = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean matches(Path path) {
            void var1_1;
            return this.path.equals(var1_1);
        }
    }

    public static enum PathWatchEventType {
        ADDED,
        DELETED,
        MODIFIED,
        UNKNOWN;

    }

    public class PathWatchEvent {
        private final Path path;
        private final PathWatchEventType type;
        private final Config config;
        long checked;
        long modified;
        long length;
        final /* synthetic */ PathWatcher this$0;

        /*
         * WARNING - void declaration
         */
        public PathWatchEvent(PathWatcher this$0, Path path, PathWatchEventType type, Config config) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.path = var2_2;
            this.type = var3_3;
            this.config = config;
            this.checked = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            this.check();
        }

        public Config getConfig() {
            return this.config;
        }

        /*
         * WARNING - void declaration
         */
        public PathWatchEvent(PathWatcher this$0, Path path, WatchEvent<Path> event, Config config) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.path = var2_2;
            this.type = event.kind() == StandardWatchEventKinds.ENTRY_CREATE ? PathWatchEventType.ADDED : (event.kind() == StandardWatchEventKinds.ENTRY_DELETE ? PathWatchEventType.DELETED : (var3_3.kind() == StandardWatchEventKinds.ENTRY_MODIFY ? PathWatchEventType.MODIFIED : PathWatchEventType.UNKNOWN));
            this.config = config;
            this.checked = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            this.check();
        }

        private void check() {
            if (Files.exists(this.path, new LinkOption[0])) {
                try {
                    this.modified = Files.getLastModifiedTime(this.path, new LinkOption[0]).toMillis();
                    this.length = Files.size(this.path);
                    return;
                }
                catch (IOException iOException) {}
            }
            this.modified = -1L;
            this.length = -1L;
        }

        /*
         * WARNING - void declaration
         */
        public boolean isQuiet(long now, long quietTime) {
            void var1_1;
            long lastModified = this.modified;
            long lastLength = this.length;
            this.check();
            if (lastModified == this.modified && lastLength == this.length) {
                void var3_2;
                return now - this.checked >= var3_2;
            }
            this.checked = var1_1;
            return false;
        }

        /*
         * WARNING - void declaration
         */
        public long toQuietCheck(long now, long quietTime) {
            void var1_1;
            long check = quietTime - (var1_1 - this.checked);
            if (check <= 0L) {
                void var3_2;
                return (long)var3_2;
            }
            return check;
        }

        /*
         * WARNING - void declaration
         */
        public void modified() {
            void var1_1;
            long now;
            this.checked = now = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            this.check();
            this.config.setPauseUntil((long)(var1_1 + this.this$0.getUpdateQuietTimeMillis()));
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object obj) {
            void var1_1;
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PathWatchEvent other = (PathWatchEvent)obj;
            if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
                return false;
            }
            return this.type == var1_1.type;
        }

        public Path getPath() {
            return this.path;
        }

        public PathWatchEventType getType() {
            return this.type;
        }

        @Deprecated
        public int getCount() {
            return 1;
        }

        /*
         * WARNING - void declaration
         */
        public int hashCode() {
            void var1_1;
            int result = 31 + (this.path == null ? 0 : this.path.hashCode());
            var1_1 = var1_1 * 31 + (this.type == null ? 0 : this.type.hashCode());
            return (int)var1_1;
        }

        public String toString() {
            return String.format("PathWatchEvent[%8s|%s]", new Object[]{this.type, this.path});
        }
    }

    public static interface EventListListener
    extends EventListener {
        public void onPathWatchEvents(List<PathWatchEvent> var1);
    }

    public static interface Listener
    extends EventListener {
        public void onPathWatchEvent(PathWatchEvent var1);
    }

    public static enum DirAction {
        IGNORE,
        WATCH,
        ENTER;

    }

    public static class Config
    implements Predicate<Path> {
        public static final int UNLIMITED_DEPTH = -9999;
        private static final String PATTERN_SEP;
        protected final Config parent;
        protected final Path path;
        protected final IncludeExcludeSet<PathMatcher, Path> includeExclude;
        protected int recurseDepth = 0;
        protected boolean excludeHidden = false;
        protected long pauseUntil;

        /*
         * WARNING - void declaration
         */
        public Config(Path path) {
            this((Path)var1_1, null);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Config(Path path, Config parent) {
            void var2_2;
            IncludeExcludeSet<PathMatcher, Path> includeExcludeSet;
            this.parent = parent;
            if (parent == null) {
                IncludeExcludeSet<PathMatcher, Path> includeExcludeSet2;
                includeExcludeSet = includeExcludeSet2;
                super(PathMatcherSet.class);
            } else {
                includeExcludeSet = parent.includeExclude;
            }
            this.includeExclude = includeExcludeSet;
            Path dir = path;
            if (!Files.exists(path, new LinkOption[0])) {
                throw new IllegalStateException("Path does not exist: " + path);
            }
            if (!Files.isDirectory(path, new LinkOption[0])) {
                void var1_1;
                dir = path.getParent();
                this.includeExclude.include(new ExactPathMatcher((Path)var1_1));
                this.setRecurseDepth(0);
            }
            this.path = var2_2;
        }

        public Config getParent() {
            return this.parent;
        }

        /*
         * WARNING - void declaration
         */
        public void setPauseUntil(long time) {
            if (time > this.pauseUntil) {
                void var1_1;
                this.pauseUntil = var1_1;
            }
        }

        /*
         * WARNING - void declaration
         */
        public boolean isPaused(long now) {
            void var1_1;
            if (this.pauseUntil == 0L) {
                return false;
            }
            if (this.pauseUntil > var1_1) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("PAUSED {}", this);
                }
                return true;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("unpaused {}", this);
            }
            this.pauseUntil = 0L;
            return false;
        }

        /*
         * WARNING - void declaration
         */
        public void addExclude(PathMatcher matcher) {
            void var1_1;
            this.includeExclude.exclude((PathMatcher)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void addExclude(String syntaxAndPattern) {
            void var1_1;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding exclude: [{}]", syntaxAndPattern);
            }
            Config config = this;
            config.addExclude(config.path.getFileSystem().getPathMatcher((String)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        public void addExcludeGlobRelative(String pattern) {
            void var1_1;
            Config config = this;
            config.addExclude(config.toGlobPattern(this.path, (String)var1_1));
        }

        public void addExcludeHidden() {
            if (!this.excludeHidden) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding hidden files and directories to exclusions", new Object[0]);
                }
                this.excludeHidden = true;
            }
        }

        /*
         * WARNING - void declaration
         */
        public void addExcludes(List<String> syntaxAndPatterns) {
            for (String syntaxAndPattern : syntaxAndPatterns) {
                void var2_2;
                this.addExclude((String)var2_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void addInclude(PathMatcher matcher) {
            void var1_1;
            this.includeExclude.include((PathMatcher)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void addInclude(String syntaxAndPattern) {
            void var1_1;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding include: [{}]", syntaxAndPattern);
            }
            Config config = this;
            config.addInclude(config.path.getFileSystem().getPathMatcher((String)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        public void addIncludeGlobRelative(String pattern) {
            void var1_1;
            Config config = this;
            config.addInclude(config.toGlobPattern(this.path, (String)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        public void addIncludes(List<String> syntaxAndPatterns) {
            for (String syntaxAndPattern : syntaxAndPatterns) {
                void var2_2;
                this.addInclude((String)var2_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        public Config asSubConfig(Path dir) {
            void var2_2;
            void var1_1;
            Config subconfig = new Config(dir, this);
            if (dir == this.path) {
                throw new IllegalStateException("sub " + dir.toString() + " of " + this);
            }
            subconfig.recurseDepth = this.recurseDepth == -9999 ? -9999 : this.recurseDepth - (var1_1.getNameCount() - this.path.getNameCount());
            if (LOG.isDebugEnabled()) {
                LOG.debug("subconfig {} of {}", subconfig, this.path);
            }
            return var2_2;
        }

        public int getRecurseDepth() {
            return this.recurseDepth;
        }

        public boolean isRecurseDepthUnlimited() {
            return this.recurseDepth == -9999;
        }

        public Path getPath() {
            return this.path;
        }

        /*
         * WARNING - void declaration
         */
        public Path resolve(Path path) {
            void var1_1;
            if (Files.isDirectory(this.path, new LinkOption[0])) {
                return this.path.resolve(path);
            }
            if (Files.exists(this.path, new LinkOption[0])) {
                return this.path;
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean test(Path path) {
            void var2_2;
            int depth;
            if (this.excludeHidden && this.isHidden(path)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("test({}) -> [Hidden]", this.toShortPath(path));
                }
                return false;
            }
            if (!path.startsWith(this.path)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("test({}) -> [!child {}]", this.toShortPath(path), this.path);
                }
                return false;
            }
            if (this.recurseDepth != -9999 && (depth = path.getNameCount() - this.path.getNameCount() - 1) > this.recurseDepth) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("test({}) -> [depth {}>{}]", this.toShortPath(path), depth, this.recurseDepth);
                }
                return false;
            }
            boolean matched = this.includeExclude.test(path);
            if (LOG.isDebugEnabled()) {
                void var1_1;
                LOG.debug("test({}) -> {}", this.toShortPath((Path)var1_1), matched);
            }
            return (boolean)var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public void setRecurseDepth(int depth) {
            void var1_1;
            this.recurseDepth = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private String toGlobPattern(Path path, String subPattern) {
            void var3_3;
            void var1_1;
            Object c;
            int n;
            int n2;
            Object object;
            StringBuilder s = new StringBuilder();
            s.append("glob:");
            boolean needDelim = false;
            Path root = path.getRoot();
            if (root != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Path: {} -> Root: {}", path, root);
                }
                char[] cArray = root.toString().toCharArray();
                object = cArray;
                n2 = cArray.length;
                for (n = 0; n < n2; ++n) {
                    c = object[n];
                    if (c == 92) {
                        s.append(PATTERN_SEP);
                        continue;
                    }
                    s.append((char)c);
                }
            } else {
                needDelim = true;
            }
            for (Path segment : var1_1) {
                if (needDelim) {
                    s.append(PATTERN_SEP);
                }
                s.append(segment);
                needDelim = true;
            }
            if (subPattern != null && subPattern.length() > 0) {
                void var2_2;
                if (needDelim) {
                    s.append(PATTERN_SEP);
                }
                char[] cArray = var2_2.toCharArray();
                object = cArray;
                n2 = cArray.length;
                for (n = 0; n < n2; ++n) {
                    c = object[n];
                    if (c == 47) {
                        s.append(PATTERN_SEP);
                        continue;
                    }
                    s.append((char)c);
                }
            }
            return var3_3.toString();
        }

        /*
         * WARNING - void declaration
         */
        DirAction handleDir(Path path) {
            try {
                if (!Files.isDirectory(path, new LinkOption[0])) {
                    return DirAction.IGNORE;
                }
                if (this.excludeHidden && this.isHidden(path)) {
                    return DirAction.IGNORE;
                }
                if (this.getRecurseDepth() == 0) {
                    return DirAction.WATCH;
                }
                return DirAction.ENTER;
            }
            catch (Exception e) {
                void var1_2;
                LOG.ignore((Throwable)var1_2);
                return DirAction.IGNORE;
            }
        }

        /*
         * WARNING - void declaration
         */
        public boolean isHidden(Path path) {
            try {
                void var1_1;
                if (!path.startsWith(this.path)) {
                    return true;
                }
                for (int i = this.path.getNameCount(); i < path.getNameCount(); ++i) {
                    if (!path.getName(i).toString().startsWith(".")) continue;
                    return true;
                }
                return Files.exists(path, new LinkOption[0]) && Files.isHidden((Path)var1_1);
            }
            catch (IOException e) {
                void var2_3;
                LOG.ignore((Throwable)var2_3);
                return false;
            }
        }

        /*
         * WARNING - void declaration
         */
        public String toShortPath(Path path) {
            void var1_1;
            if (!path.startsWith(this.path)) {
                return path.toString();
            }
            return this.path.relativize((Path)var1_1).toString();
        }

        /*
         * WARNING - void declaration
         */
        public String toString() {
            void var1_1;
            StringBuilder s = new StringBuilder();
            s.append(this.path).append(" [depth=");
            if (this.recurseDepth == -9999) {
                s.append("UNLIMITED");
            } else {
                s.append(this.recurseDepth);
            }
            s.append(']');
            return var1_1.toString();
        }

        /*
         * WARNING - void declaration
         */
        static {
            void var0;
            String sep = File.separator;
            if (File.separatorChar == '\\') {
                sep = "\\\\";
            }
            PATTERN_SEP = var0;
        }
    }
}

