/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import org.eclipse.jetty.util.JavaVersion;
import org.eclipse.jetty.util.TypeUtil;

public class MultiReleaseJarFile
implements Closeable {
    private static final String META_INF_VERSIONS = "META-INF/versions/";
    private final JarFile jarFile;
    private final int platform;
    private final boolean multiRelease;
    private final Map<String, VersionedJarEntry> entries;

    /*
     * WARNING - void declaration
     */
    public MultiReleaseJarFile(File file) throws IOException {
        this((File)var1_1, JavaVersion.VERSION.getPlatform(), false);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public MultiReleaseJarFile(File file, int javaPlatform, boolean includeDirectories2) throws IOException {
        void var1_1;
        if (file == null || !file.exists() || !file.canRead() || file.isDirectory()) {
            throw new IllegalArgumentException("bad jar file: " + file);
        }
        this.jarFile = new JarFile(file, true, 1);
        this.platform = javaPlatform;
        Manifest manifest = this.jarFile.getManifest();
        this.multiRelease = manifest == null ? false : Boolean.parseBoolean(String.valueOf(manifest.getMainAttributes().getValue("Multi-Release")));
        TreeMap map = new TreeMap();
        this.jarFile.stream().map(x$0 -> {
            void var1_1;
            return new VersionedJarEntry((JarEntry)var1_1);
        }).filter(e -> {
            void var1_1;
            return (includeDirectories2 || !e.isDirectory()) && var1_1.isApplicable();
        }).forEach(e -> {
            void var1_1;
            map.compute(e.name, (arg_0, arg_1) -> MultiReleaseJarFile.lambda$new$2((VersionedJarEntry)var1_1, arg_0, arg_1));
        });
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            void var3_5;
            VersionedJarEntry outer;
            Map.Entry includeDirectories2 = i.next();
            VersionedJarEntry entry = (VersionedJarEntry)includeDirectories2.getValue();
            if (!entry.inner || (outer = entry.outer == null ? null : (VersionedJarEntry)map.get(entry.outer)) != null && outer.version == var3_5.version) continue;
            i.remove();
        }
        this.entries = Collections.unmodifiableMap(var1_1);
    }

    public boolean isMultiRelease() {
        return this.multiRelease;
    }

    public int getVersion() {
        return this.platform;
    }

    public Stream<VersionedJarEntry> stream() {
        return this.entries.values().stream();
    }

    /*
     * WARNING - void declaration
     */
    public VersionedJarEntry getEntry(String name) {
        void var1_1;
        return this.entries.get(var1_1);
    }

    @Override
    public void close() throws IOException {
        if (this.jarFile != null) {
            this.jarFile.close();
        }
    }

    public String toString() {
        return String.format("%s[%b,%d]", this.jarFile.getName(), this.isMultiRelease(), this.getVersion());
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ VersionedJarEntry lambda$new$2(VersionedJarEntry e, String k, VersionedJarEntry v) {
        void var2_2;
        if (v == null || v.isReplacedBy(e)) {
            VersionedJarEntry versionedJarEntry;
            return versionedJarEntry;
        }
        return var2_2;
    }

    public class VersionedJarEntry {
        final JarEntry entry;
        final String name;
        final int version;
        final boolean inner;
        final String outer;

        /*
         * WARNING - void declaration
         */
        VersionedJarEntry(JarEntry entry) {
            void var3_4;
            void var2_2;
            int v = 0;
            String name = entry.getName();
            if (name.startsWith(MultiReleaseJarFile.META_INF_VERSIONS)) {
                v = -1;
                int index = name.indexOf(47, 18);
                if (index > 18 && index < name.length()) {
                    try {
                        v = TypeUtil.parseInt(name, 18, index - 18, 10);
                        name = name.substring(index + 1);
                    }
                    catch (NumberFormatException x) {
                        void var2_3;
                        void var1_1;
                        throw new RuntimeException("illegal version in " + ((MultiReleaseJarFile)var1_1).jarFile, (Throwable)var2_3);
                    }
                }
            }
            this.entry = var2_2;
            this.name = name;
            this.version = var3_4;
            this.inner = name.contains("$") && name.toLowerCase(Locale.ENGLISH).endsWith(".class");
            this.outer = this.inner ? name.substring(0, name.indexOf(36)) + ".class" : null;
        }

        public String getName() {
            return this.name;
        }

        public String getNameInJar() {
            return this.entry.getName();
        }

        public int getVersion() {
            return this.version;
        }

        public boolean isVersioned() {
            return this.version > 0;
        }

        public boolean isDirectory() {
            return this.entry.isDirectory();
        }

        public InputStream getInputStream() throws IOException {
            return MultiReleaseJarFile.this.jarFile.getInputStream(this.entry);
        }

        boolean isApplicable() {
            if (MultiReleaseJarFile.this.multiRelease) {
                return (this.version == 0 || this.version == MultiReleaseJarFile.this.platform) && this.name.length() > 0;
            }
            return this.version == 0;
        }

        /*
         * WARNING - void declaration
         */
        boolean isReplacedBy(VersionedJarEntry entry) {
            void var1_1;
            if (this.isDirectory()) {
                return entry.version == 0;
            }
            return this.name.equals(entry.name) && var1_1.version > this.version;
        }

        public String toString() {
            return String.format("%s->%s[%d]", this.name, this.entry.getName(), this.version);
        }
    }
}

