/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class MultiException
extends Exception {
    private static final String DEFAULT_MESSAGE = "Multiple exceptions";
    private List<Throwable> nested;

    public MultiException() {
        super(DEFAULT_MESSAGE, null, false, false);
        this.nested = new ArrayList<Throwable>();
    }

    /*
     * WARNING - void declaration
     */
    private MultiException(List<Throwable> nested) {
        super(DEFAULT_MESSAGE);
        Iterator iterator;
        this.nested = new ArrayList<Throwable>(nested);
        if (nested.size() > 0) {
            this.initCause(nested.get(0));
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            Throwable t = (Throwable)iterator.next();
            if (t == this) continue;
            this.addSuppressed((Throwable)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void add(Throwable e) {
        void var1_1;
        if (e instanceof MultiException) {
            MultiException me = (MultiException)e;
            this.nested.addAll(var1_1.nested);
            return;
        }
        this.nested.add((Throwable)var1_1);
    }

    public int size() {
        if (this.nested == null) {
            return 0;
        }
        return this.nested.size();
    }

    public List<Throwable> getThrowables() {
        if (this.nested == null) {
            return Collections.emptyList();
        }
        return this.nested;
    }

    /*
     * WARNING - void declaration
     */
    public Throwable getThrowable(int i) {
        void var1_1;
        return this.nested.get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void ifExceptionThrow() throws Exception {
        if (this.nested == null) {
            return;
        }
        switch (this.nested.size()) {
            case 0: {
                return;
            }
            case 1: {
                Throwable th = this.nested.get(0);
                if (th instanceof Error) {
                    throw (Error)th;
                }
                if (th instanceof Exception) {
                    void var1_1;
                    throw (Exception)var1_1;
                }
                throw new MultiException(this.nested);
            }
        }
        throw new MultiException(this.nested);
    }

    /*
     * WARNING - void declaration
     */
    public void ifExceptionThrowRuntime() throws Error {
        if (this.nested == null) {
            return;
        }
        switch (this.nested.size()) {
            case 0: {
                return;
            }
            case 1: {
                void var1_1;
                Throwable th = this.nested.get(0);
                if (th instanceof Error) {
                    throw (Error)th;
                }
                if (th instanceof RuntimeException) {
                    throw (RuntimeException)th;
                }
                throw new RuntimeException((Throwable)var1_1);
            }
        }
        throw new RuntimeException(new MultiException(this.nested));
    }

    public void ifExceptionThrowMulti() throws MultiException {
        if (this.nested == null) {
            return;
        }
        if (this.nested.size() > 0) {
            throw new MultiException(this.nested);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void ifExceptionThrowSuppressed() throws Exception {
        void var1_1;
        if (this.nested == null || this.nested.size() == 0) {
            return;
        }
        Throwable th = this.nested.get(0);
        if (!(th instanceof Error) && !(th instanceof Exception)) {
            th = new MultiException(Collections.emptyList());
        }
        for (Throwable s : this.nested) {
            void var3_3;
            if (s == th) continue;
            th.addSuppressed((Throwable)var3_3);
        }
        if (th instanceof Error) {
            throw (Error)th;
        }
        throw (Exception)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toString() {
        void var1_1;
        StringBuilder str = new StringBuilder();
        str.append(MultiException.class.getSimpleName());
        if (this.nested == null || this.nested.size() <= 0) {
            str.append("[]");
        } else {
            str.append(this.nested);
        }
        return var1_1.toString();
    }
}

