/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.File;
import java.net.URL;
import java.security.CodeSource;
import java.util.Optional;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;

public class ManifestUtils {
    private ManifestUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Optional<Manifest> getManifest(Class<?> klass) {
        Optional<Manifest> optional;
        CodeSource location;
        CodeSource codeSource = klass.getProtectionDomain().getCodeSource();
        if (codeSource == null || (location = codeSource.getLocation()) == null) return Optional.empty();
        CodeSource jarFile = new JarFile(new File(((URL)((Object)location)).toURI()));
        try {
            optional = Optional.of(((JarFile)((Object)jarFile)).getManifest());
        }
        catch (Throwable throwable) {
            try {
                try {
                    CodeSource codeSource2;
                    ((ZipFile)((Object)codeSource2)).close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable throwable3) {
                return Optional.empty();
            }
        }
        ((ZipFile)((Object)jarFile)).close();
        return optional;
    }

    /*
     * WARNING - void declaration
     */
    public static Optional<String> getVersion(Class<?> klass) {
        Optional<String> version = ManifestUtils.getManifest(klass).map(Manifest::getMainAttributes).map(attributes -> attributes.getValue("Implementation-Version"));
        if (version.isPresent()) {
            void var1_1;
            return var1_1;
        }
        try {
            Object object;
            Object module = klass.getClass().getMethod("getModule", new Class[0]).invoke(klass, new Object[0]);
            Object descriptor = module.getClass().getMethod("getDescriptor", new Class[0]).invoke(module, new Object[0]);
            return (Optional)descriptor.getClass().getMethod("rawVersion", new Class[0]).invoke(object, new Object[0]);
        }
        catch (Throwable throwable) {
            return Optional.empty();
        }
    }
}

