/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class LeakDetector<T>
extends AbstractLifeCycle
implements Runnable {
    private static final Logger LOG = Log.getLogger(LeakDetector.class);
    private final ReferenceQueue<T> queue = new ReferenceQueue();
    private final ConcurrentMap<String, LeakInfo> resources = new ConcurrentHashMap<String, LeakInfo>();
    private Thread thread;

    /*
     * WARNING - void declaration
     */
    public boolean acquired(T resource) {
        void var2_2;
        LeakInfo leakInfo;
        String id = this.id(resource);
        leakInfo = this.resources.putIfAbsent(id, new LeakInfo(leakInfo, (String)var2_2));
        return leakInfo == null;
    }

    public boolean released(T resource) {
        LeakInfo leakInfo;
        String id = this.id(resource);
        return (leakInfo = (LeakInfo)this.resources.remove(leakInfo)) != null;
    }

    public String id(T resource) {
        return String.valueOf(System.identityHashCode(resource));
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        LeakDetector leakDetector = this;
        this.thread = new Thread((Runnable)leakDetector, leakDetector.getClass().getSimpleName());
        this.thread.setDaemon(true);
        this.thread.start();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this.thread.interrupt();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        try {
            while (this.isRunning()) {
                void var1_1;
                LeakInfo leakInfo = (LeakInfo)this.queue.remove();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Resource GC'ed: {}", leakInfo);
                }
                if (this.resources.remove(leakInfo.id) == null) continue;
                this.leaked((LeakInfo)var1_1);
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void leaked(LeakInfo leakInfo) {
        void var1_1;
        LOG.warn("Resource leaked: " + leakInfo.description, ((LeakInfo)var1_1).stackFrames);
    }

    public class LeakInfo
    extends PhantomReference<T> {
        private final String id;
        private final String description;
        private final Throwable stackFrames;

        /*
         * WARNING - void declaration
         */
        private LeakInfo(T referent, String id) {
            void var2_2;
            void var3_3;
            void var1_1;
            super(referent, ((LeakDetector)var1_1).queue);
            this.id = var3_3;
            this.description = var2_2.toString();
            this.stackFrames = new Throwable();
        }

        public String getResourceDescription() {
            return this.description;
        }

        public Throwable getStackFrames() {
            return this.stackFrames;
        }

        public String toString() {
            return this.description;
        }
    }
}

