/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.InputStream;
import java.time.Instant;
import java.util.Properties;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class Jetty {
    private static final Logger LOG;
    public static final String VERSION;
    public static final String POWERED_BY;
    public static final boolean STABLE;
    public static final String GIT_HASH;
    public static final String BUILD_TIMESTAMP;
    private static final Properties __buildProperties;

    private Jetty() {
    }

    /*
     * WARNING - void declaration
     */
    private static String formatTimestamp(String timestamp) {
        try {
            long l = Long.parseLong(timestamp);
            return Instant.ofEpochMilli(l).toString();
        }
        catch (NumberFormatException e) {
            void var1_2;
            LOG.ignore((Throwable)var1_2);
            return "unknown";
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_4;
        void var0;
        LOG = Log.getLogger(Jetty.class);
        __buildProperties = new Properties();
        try (InputStream inputStream = Jetty.class.getResourceAsStream("/org/eclipse/jetty/version/build.properties");){
            __buildProperties.load(inputStream);
        }
        catch (Exception e) {
            LOG.ignore(e);
        }
        String gitHash = __buildProperties.getProperty("buildNumber", "unknown");
        if (gitHash.startsWith("${")) {
            gitHash = "unknown";
        }
        GIT_HASH = var0;
        System.setProperty("jetty.git.hash", GIT_HASH);
        BUILD_TIMESTAMP = Jetty.formatTimestamp(__buildProperties.getProperty("timestamp", "unknown"));
        Package pkg = Jetty.class.getPackage();
        VERSION = pkg != null && "Eclipse Jetty Project".equals(pkg.getImplementationVendor()) && pkg.getImplementationVersion() != null ? var1_4.getImplementationVersion() : System.getProperty("jetty.version", __buildProperties.getProperty("version", "9.4.z-SNAPSHOT"));
        POWERED_BY = "<a href=\"https://eclipse.org/jetty\">Powered by Jetty:// " + VERSION + "</a>";
        STABLE = !VERSION.matches("^.*\\.(RC|M)[0-9]+$");
    }
}

