/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.IOException;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.thread.Locker;

public abstract class IteratingCallback
implements Callback {
    private Locker _locker = new Locker();
    private State _state;
    private Throwable _failure;
    private boolean _iterate;

    protected IteratingCallback() {
        this._state = State.IDLE;
    }

    /*
     * WARNING - void declaration
     */
    protected IteratingCallback(boolean needReset) {
        void var1_1;
        this._state = var1_1 != false ? State.SUCCEEDED : State.IDLE;
    }

    protected abstract Action process() throws Throwable;

    protected void onCompleteSuccess() {
    }

    protected void onCompleteFailure(Throwable cause) {
    }

    /*
     * WARNING - void declaration
     */
    public void iterate() {
        void var1_1;
        boolean process22 = false;
        Locker.Lock lock = this._locker.lock();
        try {
            switch (this._state) {
                case PENDING: 
                case CALLED: {
                    break;
                }
                case IDLE: {
                    this._state = State.PROCESSING;
                    process22 = true;
                    break;
                }
                case PROCESSING: {
                    this._iterate = true;
                    break;
                }
                case FAILED: 
                case SUCCEEDED: {
                    break;
                }
                default: {
                    throw new IllegalStateException(this.toString());
                }
            }
            if (lock != null) {
                lock.close();
            }
        }
        catch (Throwable process22) {
            if (lock != null) {
                try {
                    void var2_3;
                    var2_3.close();
                }
                catch (Throwable throwable) {
                    process22.addSuppressed(throwable);
                }
            }
            throw process22;
        }
        if (var1_1 != false) {
            this.processing();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void processing() {
        void var2_3;
        void var1_1;
        boolean notifyCompleteSuccess = false;
        Throwable notifyCompleteFailure = null;
        block24: while (true) {
            Action action = null;
            try {
                action = this.process();
            }
            catch (Throwable x) {
                this.failed(x);
            }
            Locker.Lock lock = this._locker.lock();
            try {
                switch (this._state) {
                    case PROCESSING: {
                        if (action == null) throw new IllegalStateException(String.format("%s[action=%s]", new Object[]{this, action}));
                        switch (action) {
                            case IDLE: {
                                if (this._iterate) {
                                    this._iterate = false;
                                    continue block24;
                                }
                                this._state = State.IDLE;
                                break block24;
                            }
                            case SCHEDULED: {
                                this._state = State.PENDING;
                                break block24;
                            }
                            case SUCCEEDED: {
                                this._iterate = false;
                                this._state = State.SUCCEEDED;
                                notifyCompleteSuccess = true;
                                break block24;
                            }
                            default: {
                                throw new IllegalStateException(String.format("%s[action=%s]", new Object[]{this, action}));
                            }
                        }
                    }
                    case CALLED: {
                        if (action != Action.SCHEDULED) {
                            throw new IllegalStateException(String.format("%s[action=%s]", new Object[]{this, action}));
                        }
                        this._state = State.PROCESSING;
                        continue block24;
                    }
                    case FAILED: 
                    case CLOSED: {
                        notifyCompleteFailure = this._failure;
                        this._failure = null;
                        break block24;
                    }
                    case SUCCEEDED: {
                        break block24;
                    }
                    default: {
                        void var3_5;
                        throw new IllegalStateException(String.format("%s[action=%s]", this, var3_5));
                    }
                }
            }
            finally {
                if (lock == null) continue;
                lock.close();
                continue;
            }
            break;
        }
        if (var1_1 != false) {
            this.onCompleteSuccess();
            return;
        }
        if (notifyCompleteFailure == null) return;
        this.onCompleteFailure((Throwable)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void succeeded() {
        void var1_1;
        boolean process22 = false;
        Locker.Lock lock = this._locker.lock();
        try {
            switch (this._state) {
                case PROCESSING: {
                    this._state = State.CALLED;
                    break;
                }
                case PENDING: {
                    this._state = State.PROCESSING;
                    process22 = true;
                    break;
                }
                case FAILED: 
                case CLOSED: {
                    break;
                }
                default: {
                    throw new IllegalStateException(this.toString());
                }
            }
            if (lock != null) {
                lock.close();
            }
        }
        catch (Throwable process22) {
            if (lock != null) {
                try {
                    void var2_3;
                    var2_3.close();
                }
                catch (Throwable throwable) {
                    process22.addSuppressed(throwable);
                }
            }
            throw process22;
        }
        if (var1_1 != false) {
            this.processing();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void failed(Throwable x2) {
        void var2_3;
        boolean failure2 = false;
        Locker.Lock lock = this._locker.lock();
        try {
            switch (this._state) {
                case CALLED: 
                case IDLE: 
                case FAILED: 
                case SUCCEEDED: 
                case CLOSED: {
                    break;
                }
                case PENDING: {
                    this._state = State.FAILED;
                    failure2 = true;
                    break;
                }
                case PROCESSING: {
                    this._state = State.FAILED;
                    this._failure = x2;
                    break;
                }
                default: {
                    throw new IllegalStateException(this.toString());
                }
            }
            if (lock != null) {
                lock.close();
            }
        }
        catch (Throwable x2) {
            if (lock != null) {
                try {
                    void var3_5;
                    var3_5.close();
                }
                catch (Throwable failure2) {
                    x2.addSuppressed(failure2);
                }
            }
            throw x2;
        }
        if (var2_3 != false) {
            void var1_1;
            this.onCompleteFailure((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void close() {
        String failure22 = null;
        Locker.Lock lock = this._locker.lock();
        try {
            switch (this._state) {
                case IDLE: 
                case FAILED: 
                case SUCCEEDED: {
                    this._state = State.CLOSED;
                    break;
                }
                case PROCESSING: {
                    this._failure = new IOException(String.format("Close %s in state %s", new Object[]{this, this._state}));
                    this._state = State.CLOSED;
                    break;
                }
                case CLOSED: {
                    break;
                }
                default: {
                    failure22 = String.format("Close %s in state %s", new Object[]{this, this._state});
                    this._state = State.CLOSED;
                }
            }
            if (lock != null) {
                lock.close();
            }
        }
        catch (Throwable failure22) {
            if (lock != null) {
                try {
                    void var2_3;
                    var2_3.close();
                }
                catch (Throwable throwable) {
                    failure22.addSuppressed(throwable);
                }
            }
            throw failure22;
        }
        if (failure22 != null) {
            void var1_1;
            this.onCompleteFailure(new IOException((String)var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    boolean isIdle() {
        Locker.Lock lock = this._locker.lock();
        try {
            boolean bl;
            boolean bl2 = bl = this._state == State.IDLE;
            if (lock != null) {
                lock.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (lock != null) {
                try {
                    void var1_1;
                    var1_1.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean isClosed() {
        Locker.Lock lock = this._locker.lock();
        try {
            boolean bl;
            boolean bl2 = bl = this._state == State.CLOSED;
            if (lock != null) {
                lock.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (lock != null) {
                try {
                    void var1_1;
                    var1_1.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean isFailed() {
        Locker.Lock lock = this._locker.lock();
        try {
            boolean bl;
            boolean bl2 = bl = this._state == State.FAILED;
            if (lock != null) {
                lock.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (lock != null) {
                try {
                    void var1_1;
                    var1_1.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean isSucceeded() {
        Locker.Lock lock = this._locker.lock();
        try {
            boolean bl;
            boolean bl2 = bl = this._state == State.SUCCEEDED;
            if (lock != null) {
                lock.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (lock != null) {
                try {
                    void var1_1;
                    var1_1.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean reset() {
        Locker.Lock lock = this._locker.lock();
        try {
            switch (this._state) {
                case IDLE: {
                    if (lock == null) return true;
                    lock.close();
                    return true;
                }
                case FAILED: 
                case SUCCEEDED: {
                    this._state = State.IDLE;
                    this._failure = null;
                    this._iterate = false;
                    if (lock == null) return true;
                    lock.close();
                    return true;
                }
            }
            if (lock == null) return false;
            lock.close();
            return false;
        }
        catch (Throwable throwable) {
            if (lock == null) throw throwable;
            try {
                void var1_1;
                var1_1.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public String toString() {
        return String.format("%s@%x[%s]", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this._state});
    }

    protected static enum Action {
        IDLE,
        SCHEDULED,
        SUCCEEDED;

    }

    private static enum State {
        IDLE,
        PROCESSING,
        PENDING,
        CALLED,
        SUCCEEDED,
        FAILED,
        CLOSED;

    }
}

