/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class IntrospectionUtil {
    public static boolean isJavaBeanCompliantSetter(Method method) {
        Method method2;
        if (method == null) {
            return false;
        }
        if (method.getReturnType() != Void.TYPE) {
            return false;
        }
        if (!method.getName().startsWith("set")) {
            return false;
        }
        return method2.getParameterCount() == 1;
    }

    /*
     * WARNING - void declaration
     */
    public static Method findMethod(Class<?> clazz, String methodName, Class<?>[] args, boolean checkInheritance, boolean strictArgs) throws NoSuchMethodException {
        Class<?> clazz2;
        void var1_1;
        void var3_3;
        if (clazz == null) {
            throw new NoSuchMethodException("No class");
        }
        if (methodName == null || methodName.trim().equals("")) {
            throw new NoSuchMethodException("No method name");
        }
        Method method = null;
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length && method == null; ++i) {
            if (!methods[i].getName().equals(methodName) || !IntrospectionUtil.checkParams(methods[i].getParameterTypes(), args == null ? new Class[]{} : args, strictArgs)) continue;
            method = methods[i];
        }
        if (method != null) {
            return method;
        }
        if (var3_3 != false) {
            void var2_2;
            return IntrospectionUtil.findInheritedMethod(clazz.getPackage(), clazz.getSuperclass(), methodName, var2_2, strictArgs);
        }
        throw new NoSuchMethodException("No such method " + (String)var1_1 + " on class " + clazz2.getName());
    }

    /*
     * WARNING - void declaration
     */
    public static Field findField(Class<?> clazz, String targetName, Class<?> targetType, boolean checkInheritance, boolean strictType) throws NoSuchFieldException {
        if (clazz == null) {
            throw new NoSuchFieldException("No class");
        }
        if (targetName == null) {
            throw new NoSuchFieldException("No field name");
        }
        try {
            void var3_3;
            Field field = clazz.getDeclaredField(targetName);
            if (strictType ? field.getType().equals(targetType) : field.getType().isAssignableFrom(targetType)) {
                return field;
            }
            if (var3_3 != false) {
                return IntrospectionUtil.findInheritedField(clazz.getPackage(), clazz.getSuperclass(), targetName, targetType, strictType);
            }
            throw new NoSuchFieldException("No field with name " + targetName + " in class " + clazz.getName() + " of type " + targetType);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            void var2_2;
            void var1_1;
            Class<?> clazz2;
            return IntrospectionUtil.findInheritedField(clazz.getPackage(), clazz2.getSuperclass(), (String)var1_1, var2_2, strictType);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isInheritable(Package pack, Member member) {
        void var1_1;
        Package package_;
        void var2_2;
        if (pack == null) {
            return false;
        }
        if (member == null) {
            return false;
        }
        int modifiers = member.getModifiers();
        if (Modifier.isPublic(modifiers)) {
            return true;
        }
        if (Modifier.isProtected(modifiers)) {
            return true;
        }
        return !Modifier.isPrivate((int)var2_2) && package_.equals(var1_1.getDeclaringClass().getPackage());
    }

    /*
     * WARNING - void declaration
     */
    public static boolean checkParams(Class<?>[] formalParams, Class<?>[] actualParams, boolean strict) {
        Class<?>[] classArray;
        void var3_3;
        int j;
        void var2_2;
        if (formalParams == null) {
            return actualParams == null;
        }
        if (actualParams == null) {
            return false;
        }
        if (formalParams.length != actualParams.length) {
            return false;
        }
        if (formalParams.length == 0) {
            return true;
        }
        if (var2_2 != false) {
            for (j = 0; j < formalParams.length && formalParams[j].equals(actualParams[j]); ++j) {
            }
        } else {
            while (j < formalParams.length && formalParams[j].isAssignableFrom(actualParams[j])) {
                ++j;
            }
        }
        return var3_3 == classArray.length;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSameSignature(Method methodA, Method methodB) {
        void var3_3;
        void var2_2;
        void var1_1;
        Method method;
        if (methodA == null) {
            return false;
        }
        if (methodB == null) {
            return false;
        }
        List<Class<?>> parameterTypesA = Arrays.asList(methodA.getParameterTypes());
        List<Class<?>> parameterTypesB = Arrays.asList(methodB.getParameterTypes());
        return method.getName().equals(var1_1.getName()) && var2_2.containsAll((Collection<?>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isTypeCompatible(Class<?> formalType, Class<?> actualType, boolean strict) {
        void var1_1;
        Class<?> clazz;
        void var2_2;
        if (formalType == null) {
            return actualType == null;
        }
        if (actualType == null) {
            return false;
        }
        if (var2_2 != false) {
            return formalType.equals(actualType);
        }
        return clazz.isAssignableFrom((Class<?>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean containsSameMethodSignature(Method method, Class<?> c, boolean checkPackage) {
        void var2_2;
        if (checkPackage && !c.getPackage().equals(method.getDeclaringClass().getPackage())) {
            return false;
        }
        boolean samesig = false;
        Method[] methods = c.getDeclaredMethods();
        for (int i = 0; i < methods.length && !samesig; ++i) {
            if (!IntrospectionUtil.isSameSignature(method, methods[i])) continue;
            samesig = true;
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean containsSameFieldName(Field field, Class<?> c, boolean checkPackage) {
        void var2_2;
        if (checkPackage && !c.getPackage().equals(field.getDeclaringClass().getPackage())) {
            return false;
        }
        boolean sameName = false;
        Field[] fields = c.getDeclaredFields();
        for (int i = 0; i < fields.length && !sameName; ++i) {
            if (!fields[i].getName().equals(field.getName())) continue;
            sameName = true;
        }
        return (boolean)var2_2;
    }

    protected static Method findInheritedMethod(Package pack, Class<?> clazz, String methodName, Class<?>[] args, boolean strictArgs) throws NoSuchMethodException {
        while (true) {
            if (clazz == null) {
                throw new NoSuchMethodException("No class");
            }
            if (methodName == null) {
                throw new NoSuchMethodException("No method name");
            }
            Method method = null;
            Method[] methods = clazz.getDeclaredMethods();
            for (int i = 0; i < methods.length && method == null; ++i) {
                if (!methods[i].getName().equals(methodName) || !IntrospectionUtil.isInheritable(pack, methods[i]) || !IntrospectionUtil.checkParams(methods[i].getParameterTypes(), args, strictArgs)) continue;
                method = methods[i];
            }
            if (method != null) {
                return method;
            }
            Package package_ = clazz.getPackage();
            clazz = clazz.getSuperclass();
            pack = package_;
        }
    }

    protected static Field findInheritedField(Package pack, Class<?> clazz, String fieldName, Class<?> fieldType, boolean strictType) throws NoSuchFieldException {
        while (true) {
            if (clazz == null) {
                throw new NoSuchFieldException("No class");
            }
            if (fieldName == null) {
                throw new NoSuchFieldException("No field name");
            }
            try {
                Field field = clazz.getDeclaredField(fieldName);
                if (IntrospectionUtil.isInheritable(pack, field) && IntrospectionUtil.isTypeCompatible(fieldType, field.getType(), strictType)) {
                    return field;
                }
                return IntrospectionUtil.findInheritedField(clazz.getPackage(), clazz.getSuperclass(), fieldName, fieldType, strictType);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                Package package_ = clazz.getPackage();
                clazz = clazz.getSuperclass();
                pack = package_;
                continue;
            }
            break;
        }
    }
}

