/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public class IncludeExcludeSet<T, P>
implements Predicate<P> {
    private final Set<T> _includes;
    private final Predicate<P> _includePredicate;
    private final Set<T> _excludes;
    private final Predicate<P> _excludePredicate;

    public IncludeExcludeSet() {
        this(HashSet.class);
    }

    /*
     * WARNING - void declaration
     */
    public <SET extends Set<T>> IncludeExcludeSet(Class<SET> setClass) {
        try {
            this._includes = (Set)((Class)setClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this._excludes = (Set)((Class)setClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this._includePredicate = this._includes instanceof Predicate ? (Predicate<Object>)((Object)this._includes) : new SetContainsPredicate<P>(this._includes);
            if (!(this._excludes instanceof Predicate)) {
                this._excludePredicate = new SetContainsPredicate<P>(this._excludes);
                return;
            }
            this._excludePredicate = (Predicate)((Object)this._excludes);
        }
        catch (RuntimeException runtimeException) {
            setClass = runtimeException;
            throw runtimeException;
        }
        catch (Exception e) {
            void var1_2;
            throw new RuntimeException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public <SET extends Set<T>> IncludeExcludeSet(Set<T> includeSet, Predicate<P> includePredicate, Set<T> excludeSet, Predicate<P> excludePredicate) {
        void var3_3;
        void var2_2;
        void var1_1;
        Objects.requireNonNull(includeSet, "Include Set");
        Objects.requireNonNull(includePredicate, "Include Predicate");
        Objects.requireNonNull(excludeSet, "Exclude Set");
        Objects.requireNonNull(excludePredicate, "Exclude Predicate");
        this._includes = var1_1;
        this._includePredicate = var2_2;
        this._excludes = var3_3;
        this._excludePredicate = excludePredicate;
    }

    /*
     * WARNING - void declaration
     */
    public void include(T element) {
        void var1_1;
        this._includes.add(var1_1);
    }

    public void include(T ... element) {
        T[] TArray = element;
        int n = element.length;
        for (int i = 0; i < n; ++i) {
            T e = TArray[i];
            this._includes.add(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void exclude(T element) {
        void var1_1;
        this._excludes.add(var1_1);
    }

    public void exclude(T ... element) {
        T[] TArray = element;
        int n = element.length;
        for (int i = 0; i < n; ++i) {
            T e = TArray[i];
            this._excludes.add(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean matches(P t) {
        void var1_1;
        return this.test(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean test(P t) {
        void var1_1;
        if (!this._includes.isEmpty() && !this._includePredicate.test(t)) {
            return false;
        }
        return !this._excludePredicate.test(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Boolean isIncludedAndNotExcluded(P item) {
        void var1_1;
        if (this._excludePredicate.test(item)) {
            return Boolean.FALSE;
        }
        if (this._includePredicate.test(var1_1)) {
            return Boolean.TRUE;
        }
        return null;
    }

    public boolean hasIncludes() {
        return !this._includes.isEmpty();
    }

    public boolean hasExcludes() {
        return !this._excludes.isEmpty();
    }

    public int size() {
        return this._includes.size() + this._excludes.size();
    }

    public Set<T> getIncluded() {
        return this._includes;
    }

    public Set<T> getExcluded() {
        return this._excludes;
    }

    public void clear() {
        this._includes.clear();
        this._excludes.clear();
    }

    public String toString() {
        return String.format("%s@%x{i=%s,ip=%s,e=%s,ep=%s}", this.getClass().getSimpleName(), this.hashCode(), this._includes, this._includePredicate == this._includes ? "SELF" : this._includePredicate, this._excludes, this._excludePredicate == this._excludes ? "SELF" : this._excludePredicate);
    }

    public boolean isEmpty() {
        return this._includes.isEmpty() && this._excludes.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public static <T1, T2> boolean matchCombined(T1 item1, IncludeExcludeSet<?, T1> set1, T2 item2, IncludeExcludeSet<?, T2> set2) {
        void var3_3;
        void var1_1;
        Object match1 = set1.isIncludedAndNotExcluded(item1);
        Boolean match2 = set2.isIncludedAndNotExcluded(item2);
        if (Boolean.FALSE.equals(match1) || Boolean.FALSE.equals(match2)) {
            return false;
        }
        if (var1_1.hasIncludes() || var3_3.hasIncludes()) {
            void var2_2;
            Object object;
            return Boolean.TRUE.equals(object) || Boolean.TRUE.equals(var2_2);
        }
        return true;
    }

    private static class SetContainsPredicate<T>
    implements Predicate<T> {
        private final Set<T> set;

        /*
         * WARNING - void declaration
         */
        public SetContainsPredicate(Set<T> set) {
            void var1_1;
            this.set = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean test(T item) {
            void var1_1;
            return this.set.contains(var1_1);
        }

        public String toString() {
            return "CONTAINS";
        }
    }
}

