/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jetty.util.LazyList;

public class IPAddressMap<TYPE>
extends HashMap<String, TYPE> {
    private final HashMap<String, IPAddrPattern> _patterns = new HashMap();

    public IPAddressMap() {
        super(11);
    }

    /*
     * WARNING - void declaration
     */
    public IPAddressMap(int capacity) {
        super((int)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public TYPE put(String addrSpec, TYPE object) throws IllegalArgumentException {
        void var2_2;
        void var1_1;
        if (addrSpec == null || addrSpec.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid IP address pattern: " + addrSpec);
        }
        String spec = addrSpec.trim();
        if (this._patterns.get(spec) == null) {
            this._patterns.put(spec, new IPAddrPattern(spec));
        }
        return super.put(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public TYPE get(Object key) {
        void var1_1;
        return (TYPE)super.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public TYPE match(String addr) {
        void var1_1;
        Map.Entry<String, TYPE> entry = this.getMatch(addr);
        if (entry == null) {
            return null;
        }
        return (TYPE)var1_1.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public Map.Entry<String, TYPE> getMatch(String addr) {
        if (addr != null) {
            for (Map.Entry entry : super.entrySet()) {
                void var3_3;
                if (!this._patterns.get(entry.getKey()).match(addr)) continue;
                return var3_3;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Object getLazyMatches(String addr) {
        void var2_2;
        if (addr == null) {
            return LazyList.getList(super.entrySet());
        }
        Object entries = null;
        for (Map.Entry entry : super.entrySet()) {
            if (!this._patterns.get(entry.getKey()).match(addr)) continue;
            entries = LazyList.add(entries, entry);
        }
        return var2_2;
    }

    private static class OctetPattern
    extends BitSet {
        private final BitSet _mask = new BitSet(256);

        /*
         * WARNING - void declaration
         */
        public OctetPattern(String octetSpec) throws IllegalArgumentException {
            try {
                if (octetSpec != null) {
                    String spec = octetSpec.trim();
                    if (spec.length() != 0) {
                        StringTokenizer parts = new StringTokenizer(spec, ",");
                        while (parts.hasMoreTokens()) {
                            String part = parts.nextToken().trim();
                            if (part.length() <= 0) continue;
                            if (part.indexOf(45) < 0) {
                                int value = Integer.parseInt(part);
                                this._mask.set(value);
                                continue;
                            }
                            int low = 0;
                            int high = 255;
                            String[] bounds = part.split("-", -2);
                            if (bounds.length != 2) {
                                throw new IllegalArgumentException("Invalid octet spec: " + octetSpec);
                            }
                            if (bounds[0].length() > 0) {
                                low = Integer.parseInt(bounds[0]);
                            }
                            if (bounds[1].length() > 0) {
                                void var3_4;
                                high = Integer.parseInt((String)var3_4[1]);
                            }
                            if (low > high) {
                                throw new IllegalArgumentException("Invalid octet spec: " + octetSpec);
                            }
                            this._mask.set(low, high + 1);
                        }
                    }
                } else {
                    return;
                }
                this._mask.set(0, 255);
            }
            catch (NumberFormatException ex) {
                void var2_3;
                void var1_1;
                throw new IllegalArgumentException("Invalid octet spec: " + (String)var1_1, (Throwable)var2_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        public boolean match(String value) throws IllegalArgumentException {
            if (value == null || value.trim().length() == 0) {
                throw new IllegalArgumentException("Invalid octet: " + value);
            }
            try {
                void var2_2;
                int number = Integer.parseInt(value);
                return this.match((int)var2_2);
            }
            catch (NumberFormatException numberFormatException) {
                void var1_1;
                throw new IllegalArgumentException("Invalid octet: " + (String)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        public boolean match(int number) throws IllegalArgumentException {
            void var1_1;
            if (number < 0 || number > 255) {
                throw new IllegalArgumentException("Invalid octet: " + number);
            }
            return this._mask.get((int)var1_1);
        }
    }

    private static class IPAddrPattern {
        private final OctetPattern[] _octets = new OctetPattern[4];

        /*
         * WARNING - void declaration
         */
        public IPAddrPattern(String value) throws IllegalArgumentException {
            if (value == null || value.trim().length() == 0) {
                throw new IllegalArgumentException("Invalid IP address pattern: " + value);
            }
            try {
                StringTokenizer parts = new StringTokenizer(value, ".");
                for (int idx = 0; idx < 4; ++idx) {
                    void var3_5;
                    String part = parts.hasMoreTokens() ? parts.nextToken().trim() : "0-255";
                    int len = part.length();
                    if (len == 0 && parts.hasMoreTokens()) {
                        throw new IllegalArgumentException("Invalid IP address pattern: " + value);
                    }
                    this._octets[idx] = new OctetPattern((String)(len == 0 ? "0-255" : var3_5));
                }
                return;
            }
            catch (IllegalArgumentException ex) {
                void var2_3;
                void var1_1;
                throw new IllegalArgumentException("Invalid IP address pattern: " + (String)var1_1, (Throwable)var2_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        public boolean match(String value) throws IllegalArgumentException {
            if (value == null || value.trim().length() == 0) {
                throw new IllegalArgumentException("Invalid IP address: " + value);
            }
            try {
                void var3_4;
                StringTokenizer parts = new StringTokenizer(value, ".");
                boolean result = true;
                for (int idx = 0; idx < 4; ++idx) {
                    if (!parts.hasMoreTokens()) {
                        throw new IllegalArgumentException("Invalid IP address: " + value);
                    }
                    if (!(result &= this._octets[idx].match(parts.nextToken()))) break;
                }
                return (boolean)var3_4;
            }
            catch (IllegalArgumentException ex) {
                void var2_3;
                void var1_1;
                throw new IllegalArgumentException("Invalid IP address: " + (String)var1_1, (Throwable)var2_3);
            }
        }
    }
}

