/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.net.CookieManager;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class HttpCookieStore
implements CookieStore {
    private final CookieStore delegate = new CookieManager().getCookieStore();

    /*
     * WARNING - void declaration
     */
    @Override
    public void add(URI uri, HttpCookie cookie) {
        void var2_2;
        void var1_1;
        this.delegate.add((URI)var1_1, (HttpCookie)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<HttpCookie> get(URI uri) {
        void var1_1;
        return this.delegate.get((URI)var1_1);
    }

    @Override
    public List<HttpCookie> getCookies() {
        return this.delegate.getCookies();
    }

    @Override
    public List<URI> getURIs() {
        return this.delegate.getURIs();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean remove(URI uri, HttpCookie cookie) {
        void var2_2;
        void var1_1;
        return this.delegate.remove((URI)var1_1, (HttpCookie)var2_2);
    }

    @Override
    public boolean removeAll() {
        return this.delegate.removeAll();
    }

    /*
     * WARNING - void declaration
     */
    public static List<HttpCookie> matchPath(URI uri, List<HttpCookie> cookies) {
        void var2_2;
        Iterator iterator;
        if (cookies == null || cookies.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>(4);
        Object path = uri.getPath();
        if (path == null || ((String)path).trim().isEmpty()) {
            path = "/";
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            HttpCookie cookie = (HttpCookie)iterator.next();
            String cookiePath = cookie.getPath();
            if (cookiePath == null) {
                result.add(cookie);
                continue;
            }
            if (((String)path).equals(cookiePath)) {
                result.add(cookie);
                continue;
            }
            if (!((String)path).startsWith(cookiePath) || !cookiePath.endsWith("/") && ((String)path).charAt(cookiePath.length()) != '/') continue;
            result.add(var3_3);
        }
        return var2_2;
    }

    public static class Empty
    implements CookieStore {
        @Override
        public void add(URI uri, HttpCookie cookie) {
        }

        @Override
        public List<HttpCookie> get(URI uri) {
            return Collections.emptyList();
        }

        @Override
        public List<HttpCookie> getCookies() {
            return Collections.emptyList();
        }

        @Override
        public List<URI> getURIs() {
            return Collections.emptyList();
        }

        @Override
        public boolean remove(URI uri, HttpCookie cookie) {
            return false;
        }

        @Override
        public boolean removeAll() {
            return false;
        }
    }
}

