/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;

public class HostPort {
    private final String _host;
    private final int _port;

    /*
     * WARNING - void declaration
     */
    public HostPort(String host, int port) {
        void var2_2;
        void var1_1;
        this._host = HostPort.normalizeHost((String)var1_1);
        this._port = var2_2;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HostPort(String authority) throws IllegalArgumentException {
        if (authority == null) {
            throw new IllegalArgumentException("No Authority");
        }
        try {
            void var1_1;
            if (authority.isEmpty()) {
                this._host = authority;
                this._port = 0;
                return;
            }
            if (authority.charAt(0) == '[') {
                int close = authority.lastIndexOf(93);
                if (close < 0) {
                    throw new IllegalArgumentException("Bad IPv6 host");
                }
                this._host = authority.substring(0, close + 1);
                if (authority.length() > close + 1) {
                    if (authority.charAt(close + 1) != ':') {
                        throw new IllegalArgumentException("Bad IPv6 port");
                    }
                    this._port = HostPort.parsePort(authority.substring(close + 2));
                    return;
                }
                this._port = 0;
                return;
            }
            int c = authority.lastIndexOf(58);
            if (c >= 0) {
                if (c != authority.indexOf(58)) {
                    this._host = "[" + authority + "]";
                    this._port = 0;
                    return;
                } else {
                    this._host = authority.substring(0, c);
                    this._port = HostPort.parsePort(authority.substring(c + 1));
                }
                return;
            }
            this._host = var1_1;
            this._port = 0;
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            IllegalArgumentException c = illegalArgumentException;
            throw illegalArgumentException;
        }
        catch (Exception ex) {
            void var2_5;
            throw new IllegalArgumentException("Bad HostPort", (Throwable)var2_5);
        }
    }

    @ManagedAttribute(value="host")
    public String getHost() {
        return this._host;
    }

    @ManagedAttribute(value="port")
    public int getPort() {
        return this._port;
    }

    /*
     * WARNING - void declaration
     */
    public int getPort(int defaultPort) {
        void var1_1;
        if (this._port > 0) {
            return this._port;
        }
        return (int)var1_1;
    }

    public boolean hasHost() {
        return StringUtil.isNotBlank(this._host);
    }

    public boolean hasPort() {
        return this._port > 0;
    }

    public String toString() {
        if (this._port > 0) {
            return this._host + ":" + this._port;
        }
        return this._host;
    }

    public static String normalizeHost(String host) {
        String string;
        if (host == null || host.isEmpty() || host.charAt(0) == '[' || host.indexOf(58) < 0) {
            return host;
        }
        return "[" + string + "]";
    }

    /*
     * WARNING - void declaration
     */
    public static int parsePort(String rawPort) throws IllegalArgumentException {
        void var0_1;
        if (StringUtil.isEmpty(rawPort)) {
            throw new IllegalArgumentException("Bad port");
        }
        int port = Integer.parseInt(rawPort);
        if (port <= 0 || port > 65535) {
            throw new IllegalArgumentException("Bad port");
        }
        return (int)var0_1;
    }
}

