/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class Fields
implements Iterable<Field> {
    private final boolean caseSensitive;
    private final Map<String, Field> fields;

    public Fields() {
        this(false);
    }

    /*
     * WARNING - void declaration
     */
    public Fields(boolean caseSensitive) {
        void var1_1;
        this.caseSensitive = var1_1;
        this.fields = new LinkedHashMap<String, Field>();
    }

    /*
     * WARNING - void declaration
     */
    public Fields(Fields original, boolean immutable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.caseSensitive = original.caseSensitive;
        LinkedHashMap<String, Field> copy = new LinkedHashMap<String, Field>();
        copy.putAll(var1_1.fields);
        this.fields = var2_2 != false ? Collections.unmodifiableMap(copy) : var3_3;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Fields that = (Fields)obj;
        if (this.getSize() != that.getSize()) {
            return false;
        }
        if (this.caseSensitive != that.caseSensitive) {
            return false;
        }
        for (Map.Entry<String, Field> entry : this.fields.entrySet()) {
            Field field;
            String name = entry.getKey();
            if ((field = (Field)field.getValue()).equals(that.get(name), this.caseSensitive)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.fields.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public Set<String> getNames() {
        void var1_1;
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Field field : this.fields.values()) {
            void var3_3;
            result.add(var3_3.getName());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private String normalizeName(String name) {
        void var1_1;
        if (this.caseSensitive) {
            return name;
        }
        return var1_1.toLowerCase(Locale.ENGLISH);
    }

    /*
     * WARNING - void declaration
     */
    public Field get(String name) {
        void var1_1;
        return this.fields.get(this.normalizeName((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void put(String name, String value) {
        void var2_2;
        void var1_1;
        Field field = new Field(name, value);
        this.fields.put(this.normalizeName((String)var1_1), (Field)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void put(Field field) {
        if (field != null) {
            void var1_1;
            this.fields.put(this.normalizeName(field.getName()), (Field)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void add(String name, String value) {
        void var3_3;
        void var2_2;
        String key = this.normalizeName(name);
        Field field = this.fields.get(key);
        if (field == null) {
            void var1_1;
            field = new Field((String)var1_1, value);
            this.fields.put(key, field);
            return;
        }
        field = new Field(field.getName(), (List)field.getValues(), new String[]{var2_2});
        this.fields.put((String)var3_3, field);
    }

    /*
     * WARNING - void declaration
     */
    public Field remove(String name) {
        void var1_1;
        return this.fields.remove(this.normalizeName((String)var1_1));
    }

    public void clear() {
        this.fields.clear();
    }

    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public int getSize() {
        return this.fields.size();
    }

    @Override
    public Iterator<Field> iterator() {
        return this.fields.values().iterator();
    }

    public String toString() {
        return this.fields.toString();
    }

    public static class Field {
        private final String name;
        private final List<String> values;

        /*
         * WARNING - void declaration
         */
        public Field(String name, String value) {
            this((String)var1_1, Collections.singletonList(var2_2), new String[0]);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private Field(String name, List<String> values, String ... moreValues) {
            void var1_1;
            void var3_3;
            void var2_2;
            this.name = name;
            ArrayList list = new ArrayList(values.size() + moreValues.length);
            list.addAll(var2_2);
            list.addAll(Arrays.asList(var3_3));
            this.values = Collections.unmodifiableList(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Field that, boolean caseSensitive) {
            void var1_1;
            void var2_2;
            if (this == that) {
                return true;
            }
            if (that == null) {
                return false;
            }
            if (var2_2 != false) {
                return this.equals(that);
            }
            return this.name.equalsIgnoreCase(that.name) && this.values.equals(var1_1.values);
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object obj) {
            void var1_1;
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Field that = (Field)obj;
            return this.name.equals(that.name) && this.values.equals(var1_1.values);
        }

        /*
         * WARNING - void declaration
         */
        public int hashCode() {
            void var1_1;
            int result = this.name.hashCode();
            var1_1 = var1_1 * 31 + this.values.hashCode();
            return (int)var1_1;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.values.get(0);
        }

        /*
         * WARNING - void declaration
         */
        public Integer getValueAsInt() {
            void var1_1;
            String value = this.getValue();
            if (value == null) {
                return null;
            }
            return Integer.valueOf((String)var1_1);
        }

        public List<String> getValues() {
            return this.values;
        }

        public boolean hasMultipleValues() {
            return this.values.size() > 1;
        }

        public String toString() {
            return String.format("%s=%s", this.name, this.values);
        }
    }
}

