/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import org.eclipse.jetty.util.Decorator;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class DeprecationWarning
implements Decorator {
    private static final Logger LOG = Log.getLogger(DeprecationWarning.class);

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T decorate(T o) {
        void var1_1;
        if (o == null) {
            return null;
        }
        Class<?> clazz = o.getClass();
        try {
            Class<?>[] classArray = clazz.getAnnotation(Deprecated.class);
            if (classArray != null) {
                LOG.warn("Using @Deprecated Class {}", clazz.getName());
            }
        }
        catch (Throwable t) {
            void var3_4;
            LOG.ignore((Throwable)var3_4);
        }
        this.verifyIndirectTypes(clazz.getSuperclass(), clazz, "Class");
        for (Class<?> ifaceClazz : clazz.getInterfaces()) {
            this.verifyIndirectTypes(ifaceClazz, clazz, "Interface");
        }
        return var1_1;
    }

    private void verifyIndirectTypes(Class<?> superClazz, Class<?> clazz, String typeName) {
        try {
            while (superClazz != null && superClazz != Object.class) {
                Deprecated deprecated = superClazz.getAnnotation(Deprecated.class);
                if (deprecated != null) {
                    LOG.warn("Using indirect @Deprecated {} {} - (seen from {})", typeName, superClazz.getName(), clazz);
                }
                superClazz = superClazz.getSuperclass();
            }
            return;
        }
        catch (Throwable t) {
            LOG.ignore(t);
            return;
        }
    }

    @Override
    public void destroy(Object o) {
    }
}

