/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jetty.util.Decorator;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class DecoratedObjectFactory
implements Iterable<Decorator> {
    private static final Logger LOG = Log.getLogger(DecoratedObjectFactory.class);
    public static final String ATTR = DecoratedObjectFactory.class.getName();
    private List<Decorator> decorators = new ArrayList<Decorator>();

    /*
     * WARNING - void declaration
     */
    public void addDecorator(Decorator decorator) {
        void var1_1;
        LOG.debug("Adding Decorator: {}", decorator);
        this.decorators.add((Decorator)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean removeDecorator(Decorator decorator) {
        void var1_1;
        LOG.debug("Remove Decorator: {}", decorator);
        return this.decorators.remove(var1_1);
    }

    public void clear() {
        this.decorators.clear();
    }

    /*
     * WARNING - void declaration
     */
    public <T> T createInstance(Class<T> clazz) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        void var1_1;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating Instance: " + clazz, new Object[0]);
        }
        T o = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        return this.decorate(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public <T> T decorate(T obj) {
        void var1_1;
        T f = obj;
        for (int i = this.decorators.size() - 1; i >= 0; --i) {
            f = this.decorators.get(i).decorate(f);
        }
        return var1_1;
    }

    public void destroy(Object obj) {
        for (Decorator decorator : this.decorators) {
            decorator.destroy(obj);
        }
    }

    public List<Decorator> getDecorators() {
        return Collections.unmodifiableList(this.decorators);
    }

    @Override
    public Iterator<Decorator> iterator() {
        return this.decorators.iterator();
    }

    /*
     * WARNING - void declaration
     */
    public void setDecorators(List<? extends Decorator> decorators) {
        this.decorators.clear();
        if (decorators != null) {
            void var1_1;
            this.decorators.addAll((Collection<Decorator>)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder str = new StringBuilder();
        str.append(this.getClass().getName()).append("[decorators=");
        str.append(this.decorators.size());
        str.append("]");
        return var1_1.toString();
    }
}

