/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateCache {
    public static final String DEFAULT_FORMAT = "EEE MMM dd HH:mm:ss zzz yyyy";
    private final String _formatString;
    private final String _tzFormatString;
    private final DateTimeFormatter _tzFormat;
    private final Locale _locale;
    private final ZoneId _zoneId;
    private volatile Tick _tick;

    public DateCache() {
        this(DEFAULT_FORMAT);
    }

    /*
     * WARNING - void declaration
     */
    public DateCache(String format) {
        this((String)var1_1, null, TimeZone.getDefault());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DateCache(String format, Locale l) {
        this((String)var1_1, (Locale)var2_2, TimeZone.getDefault());
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DateCache(String format, Locale l, String tz) {
        this((String)var1_1, (Locale)var2_2, TimeZone.getTimeZone((String)var3_3));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DateCache(String format, Locale l, TimeZone tz) {
        void var3_6;
        this._formatString = format;
        this._locale = l;
        int zIndex = this._formatString.indexOf("ZZZ");
        if (zIndex >= 0) {
            void var1_3;
            void var2_5;
            String ss1 = this._formatString.substring(0, zIndex);
            String ss2 = this._formatString.substring(zIndex + 3);
            int tzOffset = tz.getRawOffset();
            StringBuilder sb = new StringBuilder(this._formatString.length() + 10);
            sb.append(ss1);
            sb.append("'");
            if (tzOffset >= 0) {
                sb.append('+');
            } else {
                tzOffset = -tzOffset;
                sb.append('-');
            }
            int raw = tzOffset / 60000;
            int hr = raw / 60;
            int min = raw % 60;
            if (hr < 10) {
                sb.append('0');
            }
            sb.append(hr);
            if (min < 10) {
                sb.append('0');
            }
            sb.append((int)var2_5);
            sb.append('\'');
            sb.append((String)var1_3);
            this._tzFormatString = sb.toString();
        } else {
            this._tzFormatString = this._formatString;
        }
        this._tzFormat = this._locale != null ? DateTimeFormatter.ofPattern(this._tzFormatString, this._locale) : DateTimeFormatter.ofPattern(this._tzFormatString);
        this._zoneId = var3_6.toZoneId();
        this._tzFormat.withZone(this._zoneId);
        this._tick = null;
    }

    public TimeZone getTimeZone() {
        return TimeZone.getTimeZone(this._zoneId);
    }

    /*
     * WARNING - void declaration
     */
    public String format(Date inDate) {
        void var2_2;
        long seconds = inDate.getTime() / 1000L;
        Tick tick = this._tick;
        if (tick == null || var2_2 != tick._seconds) {
            void var1_1;
            return ZonedDateTime.ofInstant(var1_1.toInstant(), this._zoneId).format(this._tzFormat);
        }
        return tick._string;
    }

    /*
     * WARNING - void declaration
     */
    public String format(long inDate) {
        void var3_2;
        long seconds = inDate / 1000L;
        Tick tick = this._tick;
        if (tick == null || var3_2 != tick._seconds) {
            void var1_1;
            return ZonedDateTime.ofInstant(Instant.ofEpochMilli((long)var1_1), this._zoneId).format(this._tzFormat);
        }
        return tick._string;
    }

    /*
     * WARNING - void declaration
     */
    public String formatNow(long now) {
        void var1_1;
        void var3_2;
        long seconds = now / 1000L;
        Tick tick = this._tick;
        if (tick != null && tick._seconds == var3_2) {
            return tick._string;
        }
        return this.formatTick((long)var1_1)._string;
    }

    public String now() {
        return this.formatNow(System.currentTimeMillis());
    }

    public Tick tick() {
        return this.formatTick(System.currentTimeMillis());
    }

    /*
     * WARNING - void declaration
     */
    protected Tick formatTick(long now) {
        long seconds = now / 1000L;
        Tick tick = this._tick;
        if (tick == null || tick._seconds != seconds) {
            void var1_2;
            void var3_3;
            String s = ZonedDateTime.ofInstant(Instant.ofEpochMilli(now), this._zoneId).format(this._tzFormat);
            tick = this._tick = new Tick((long)var3_3, (String)var1_2);
        }
        return tick;
    }

    public String getFormatString() {
        return this._formatString;
    }

    public static class Tick {
        final long _seconds;
        final String _string;

        /*
         * WARNING - void declaration
         */
        public Tick(long seconds, String string) {
            void var3_2;
            void var1_1;
            this._seconds = var1_1;
            this._string = var3_2;
        }
    }
}

