/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;

public interface CharsetStringBuilder {
    public void append(byte var1);

    public void append(char var1);

    /*
     * WARNING - void declaration
     */
    default public void append(byte[] bytes) {
        void var1_1;
        this.append(bytes, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    default public void append(byte[] b, int offset, int length) {
        void i;
        int end = offset + length;
        while (i < end) {
            this.append(b[i]);
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    default public void append(CharSequence chars, int offset, int length) {
        void i;
        int end = offset + length;
        while (i < end) {
            this.append(chars.charAt((int)i));
            ++i;
        }
    }

    default public void append(ByteBuffer buf) {
        int end = buf.position() + buf.remaining();
        while (buf.position() < end) {
            this.append(buf.get());
        }
    }

    public String build() throws CharacterCodingException;

    public void reset();

    public static CharsetStringBuilder forCharset(Charset charset) {
        Charset charset2;
        Objects.requireNonNull(charset);
        if (charset == StandardCharsets.ISO_8859_1) {
            return new Iso88591StringBuilder();
        }
        if (charset == StandardCharsets.US_ASCII) {
            return new UsAsciiStringBuilder();
        }
        return new DecoderStringBuilder(charset2.newDecoder());
    }

    public static class DecoderStringBuilder
    implements CharsetStringBuilder {
        private final CharsetDecoder _decoder;
        private final StringBuilder _stringBuilder = new StringBuilder(32);
        private ByteBuffer _buffer = ByteBuffer.allocate(32);

        /*
         * WARNING - void declaration
         */
        public DecoderStringBuilder(CharsetDecoder charsetDecoder) {
            void var1_1;
            this._decoder = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private void ensureSpace(int needed) {
            int space = this._buffer.remaining();
            if (space < needed) {
                void var3_3;
                void var2_2;
                void var1_1;
                int position = this._buffer.position();
                this._buffer = ByteBuffer.wrap(Arrays.copyOf(this._buffer.array(), this._buffer.capacity() + var1_1 - var2_2 + 32));
                this._buffer.position((int)var3_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void append(byte b) {
            void var1_1;
            this.ensureSpace(1);
            this._buffer.put((byte)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void append(char c) {
            void var1_1;
            if (this._buffer.position() > 0) {
                try {
                    this._buffer.flip();
                    this._stringBuilder.append(this._decoder.decode(this._buffer));
                    this._buffer.clear();
                }
                catch (CharacterCodingException e) {
                    void var1_2;
                    throw new RuntimeException((Throwable)var1_2);
                }
            }
            this._stringBuilder.append((char)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void append(CharSequence chars, int offset, int length) {
            void var3_4;
            void var1_1;
            void var2_3;
            if (this._buffer.position() > 0) {
                try {
                    this._buffer.flip();
                    this._stringBuilder.append(this._decoder.decode(this._buffer));
                    this._buffer.clear();
                }
                catch (CharacterCodingException e) {
                    void var1_2;
                    throw new RuntimeException((Throwable)var1_2);
                }
            }
            void v0 = var2_3;
            this._stringBuilder.append((CharSequence)var1_1, (int)v0, (int)(v0 + var3_4));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void append(byte[] b, int offset, int length) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.ensureSpace(length);
            this._buffer.put((byte[])var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void append(ByteBuffer buf) {
            void var1_1;
            this.ensureSpace(buf.remaining());
            this._buffer.put((ByteBuffer)var1_1);
        }

        @Override
        public String build() throws CharacterCodingException {
            try {
                String string;
                if (this._buffer.position() > 0) {
                    this._buffer.flip();
                    CharSequence decoded = this._decoder.decode(this._buffer);
                    this._buffer.clear();
                    if (this._stringBuilder.length() == 0) {
                        decoded = decoded.toString();
                        return decoded;
                    }
                    this._stringBuilder.append((CharSequence)string);
                }
                string = this._stringBuilder.toString();
                return string;
            }
            finally {
                this._stringBuilder.setLength(0);
            }
        }

        @Override
        public void reset() {
            this._stringBuilder.setLength(0);
        }
    }

    public static class UsAsciiStringBuilder
    implements CharsetStringBuilder {
        private final StringBuilder _builder = new StringBuilder();

        /*
         * WARNING - void declaration
         */
        @Override
        public void append(byte b) {
            void var1_1;
            if (b < 0) {
                throw new IllegalArgumentException();
            }
            this._builder.append((char)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void append(char c) {
            void var1_1;
            this._builder.append((char)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void append(CharSequence chars, int offset, int length) {
            void var3_3;
            void var1_1;
            void var2_2;
            void v0 = var2_2;
            this._builder.append((CharSequence)var1_1, (int)v0, (int)(v0 + var3_3));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String build() {
            void var1_1;
            String s = this._builder.toString();
            this._builder.setLength(0);
            return var1_1;
        }

        @Override
        public void reset() {
            this._builder.setLength(0);
        }
    }

    public static class Iso88591StringBuilder
    implements CharsetStringBuilder {
        private final StringBuilder _builder = new StringBuilder();

        /*
         * WARNING - void declaration
         */
        @Override
        public void append(byte b) {
            void var1_1;
            this._builder.append((char)(0xFF & var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void append(char c) {
            void var1_1;
            this._builder.append((char)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void append(CharSequence chars, int offset, int length) {
            void var3_3;
            void var1_1;
            void var2_2;
            void v0 = var2_2;
            this._builder.append((CharSequence)var1_1, (int)v0, (int)(v0 + var3_3));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String build() {
            void var1_1;
            String s = this._builder.toString();
            this._builder.setLength(0);
            return var1_1;
        }

        @Override
        public void reset() {
            this._builder.setLength(0);
        }
    }
}

