/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.eclipse.jetty.util.thread.Invocable;

public interface Callback
extends Invocable {
    public static final Callback NOOP = new Callback(){

        @Override
        public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.NON_BLOCKING;
        }
    };

    default public void succeeded() {
    }

    default public void failed(Throwable x) {
    }

    public static Callback from(CompletableFuture<?> completable) {
        return Callback.from(completable, Invocable.InvocationType.NON_BLOCKING);
    }

    /*
     * WARNING - void declaration
     */
    public static Callback from(CompletableFuture<?> completable, Invocable.InvocationType invocation) {
        void var1_1;
        CompletableFuture<?> completableFuture;
        if (completable instanceof Callback) {
            return (Callback)((Object)completable);
        }
        return new Callback((Invocable.InvocationType)var1_1){
            final /* synthetic */ Invocable.InvocationType val$invocation;
            {
                this.val$invocation = invocationType;
            }

            @Override
            public void succeeded() {
                completableFuture.complete(null);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void failed(Throwable x) {
                void var1_1;
                completableFuture.completeExceptionally((Throwable)var1_1);
            }

            @Override
            public Invocable.InvocationType getInvocationType() {
                return this.val$invocation;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static Callback from(Runnable success, Consumer<Throwable> failure) {
        void var1_1;
        Runnable runnable;
        return Callback.from(Invocable.InvocationType.BLOCKING, runnable, (Consumer<Throwable>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Callback from(Invocable.InvocationType invocationType, Runnable success, Consumer<Throwable> failure) {
        Invocable.InvocationType invocationType2;
        void var2_2;
        void var1_1;
        return new Callback((Runnable)var1_1, (Consumer)var2_2, invocationType2){
            final /* synthetic */ Runnable val$success;
            final /* synthetic */ Consumer val$failure;
            final /* synthetic */ Invocable.InvocationType val$invocationType;
            {
                this.val$success = runnable;
                this.val$failure = consumer;
                this.val$invocationType = invocationType;
            }

            @Override
            public void succeeded() {
                this.val$success.run();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void failed(Throwable x) {
                void var1_1;
                this.val$failure.accept(var1_1);
            }

            @Override
            public Invocable.InvocationType getInvocationType() {
                return this.val$invocationType;
            }
        };
    }

    public static Callback from(Runnable completed) {
        Runnable runnable;
        return new Completing(){

            @Override
            public void completed() {
                runnable.run();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static Callback from(Callback callback, Runnable completed) {
        void var1_1;
        Callback callback2;
        return new Nested(callback2, (Runnable)var1_1){
            final /* synthetic */ Runnable val$completed;
            {
                void var1_1;
                this.val$completed = runnable;
                super((Callback)var1_1);
            }

            @Override
            public void completed() {
                this.val$completed.run();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static Callback from(Runnable completed, Callback callback) {
        void var1_1;
        Runnable runnable;
        return new Callback((Callback)var1_1){
            final /* synthetic */ Callback val$callback;
            {
                this.val$callback = callback;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void succeeded() {
                try {
                    runnable.run();
                    this.val$callback.succeeded();
                    return;
                }
                catch (Throwable t) {
                    void var1_1;
                    this.val$callback.failed((Throwable)var1_1);
                    return;
                }
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void failed(Throwable x) {
                void var1_1;
                try {
                    runnable.run();
                }
                catch (Throwable t) {
                    void var2_2;
                    x.addSuppressed((Throwable)var2_2);
                }
                this.val$callback.failed((Throwable)var1_1);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static Callback combine(Callback cb1, Callback cb2) {
        void var1_1;
        Callback callback;
        if (cb1 == null || cb1 == cb2) {
            return cb2;
        }
        if (cb2 == null) {
            return cb1;
        }
        return new Callback((Callback)var1_1){
            final /* synthetic */ Callback val$cb2;
            {
                this.val$cb2 = callback2;
            }

            @Override
            public void succeeded() {
                try {
                    callback.succeeded();
                    return;
                }
                finally {
                    this.val$cb2.succeeded();
                }
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void failed(Throwable x) {
                try {
                    callback.failed(x);
                    this.val$cb2.failed(x);
                    return;
                }
                catch (Throwable t) {
                    try {
                        if (x != t) {
                            void var2_2;
                            x.addSuppressed((Throwable)var2_2);
                        }
                        this.val$cb2.failed(x);
                        return;
                    }
                    catch (Throwable throwable) {
                        void var1_1;
                        this.val$cb2.failed((Throwable)var1_1);
                        throw throwable;
                    }
                }
            }

            @Override
            public Invocable.InvocationType getInvocationType() {
                return Invocable.combine(Invocable.getInvocationType(callback), Invocable.getInvocationType(this.val$cb2));
            }
        };
    }

    public static class Completable
    extends CompletableFuture<Void>
    implements Callback {
        private final Invocable.InvocationType invocation;

        public Completable() {
            this(Invocable.InvocationType.NON_BLOCKING);
        }

        /*
         * WARNING - void declaration
         */
        public Completable(Invocable.InvocationType invocation) {
            void var1_1;
            this.invocation = var1_1;
        }

        @Override
        public void succeeded() {
            this.complete(null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void failed(Throwable x) {
            void var1_1;
            this.completeExceptionally((Throwable)var1_1);
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            return this.invocation;
        }
    }

    public static class Nested
    extends Completing {
        private final Callback callback;

        /*
         * WARNING - void declaration
         */
        public Nested(Callback callback) {
            void var1_1;
            this.callback = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Nested(Nested nested) {
            void var1_1;
            this.callback = var1_1.callback;
        }

        public Callback getCallback() {
            return this.callback;
        }

        @Override
        public void succeeded() {
            try {
                this.callback.succeeded();
                return;
            }
            finally {
                this.completed();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void failed(Throwable x) {
            try {
                void var1_1;
                this.callback.failed((Throwable)var1_1);
                return;
            }
            finally {
                this.completed();
            }
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            return this.callback.getInvocationType();
        }
    }

    public static class Completing
    implements Callback {
        @Override
        public void succeeded() {
            this.completed();
        }

        @Override
        public void failed(Throwable x) {
            this.completed();
        }

        public void completed() {
        }
    }
}

