/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.eclipse.jetty.util.ByteArrayOutputStream2;

public class ByteArrayISO8859Writer
extends Writer {
    private byte[] _buf;
    private int _size;
    private ByteArrayOutputStream2 _bout = null;
    private OutputStreamWriter _writer = null;
    private boolean _fixed = false;

    public ByteArrayISO8859Writer() {
        this._buf = new byte[2048];
    }

    /*
     * WARNING - void declaration
     */
    public ByteArrayISO8859Writer(int capacity) {
        void var1_1;
        this._buf = new byte[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public ByteArrayISO8859Writer(byte[] buf) {
        void var1_1;
        this._buf = var1_1;
        this._fixed = true;
    }

    public Object getLock() {
        return this.lock;
    }

    public int size() {
        return this._size;
    }

    public int capacity() {
        return this._buf.length;
    }

    public int spareCapacity() {
        return this._buf.length - this._size;
    }

    /*
     * WARNING - void declaration
     */
    public void setLength(int l) {
        void var1_1;
        this._size = var1_1;
    }

    public byte[] getBuf() {
        return this._buf;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this._buf, 0, this._size);
    }

    /*
     * WARNING - void declaration
     */
    public void write(char c) throws IOException {
        void var1_2;
        this.ensureSpareCapacity(1);
        if (c >= '\u0000' && c <= '\u007f') {
            this._buf[this._size++] = (byte)c;
            return;
        }
        char[] ca = new char[]{c};
        this.writeEncoded((char[])var1_2, 0, 1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(char[] ca) throws IOException {
        this.ensureSpareCapacity(ca.length);
        for (int i = 0; i < ca.length; ++i) {
            void var3_3;
            char c = ca[i];
            if (c < '\u0000' || c > '\u007f') {
                this.writeEncoded(ca, i, ca.length - i);
                return;
            }
            this._buf[this._size++] = (byte)var3_3;
        }
    }

    @Override
    public void write(char[] ca, int offset, int length) throws IOException {
        this.ensureSpareCapacity(length);
        for (int i = 0; i < length; ++i) {
            char c = ca[offset + i];
            if (c < '\u0000' || c > '\u007f') {
                this.writeEncoded(ca, offset + i, length - i);
                return;
            }
            this._buf[this._size++] = (byte)c;
        }
    }

    @Override
    public void write(String s) throws IOException {
        if (s == null) {
            this.write("null", 0, 4);
            return;
        }
        int length = s.length();
        this.ensureSpareCapacity(length);
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c < '\u0000' || c > '\u007f') {
                this.writeEncoded(s.toCharArray(), i, length - i);
                return;
            }
            this._buf[this._size++] = (byte)c;
        }
    }

    @Override
    public void write(String s, int offset, int length) throws IOException {
        this.ensureSpareCapacity(length);
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(offset + i);
            if (c < '\u0000' || c > '\u007f') {
                this.writeEncoded(s.toCharArray(), offset + i, length - i);
                return;
            }
            this._buf[this._size++] = (byte)c;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeEncoded(char[] ca, int offset, int length) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this._bout == null) {
            this._bout = new ByteArrayOutputStream2(2 * length);
            this._writer = new OutputStreamWriter((OutputStream)this._bout, StandardCharsets.ISO_8859_1);
        } else {
            this._bout.reset();
        }
        this._writer.write((char[])var1_1, (int)var2_2, (int)var3_3);
        this._writer.flush();
        ByteArrayISO8859Writer byteArrayISO8859Writer = this;
        byteArrayISO8859Writer.ensureSpareCapacity(byteArrayISO8859Writer._bout.getCount());
        System.arraycopy(this._bout.getBuf(), 0, this._buf, this._size, this._bout.getCount());
        this._size += this._bout.getCount();
    }

    @Override
    public void flush() {
    }

    public void resetWriter() {
        this._size = 0;
    }

    @Override
    public void close() {
    }

    public void destroy() {
        this._buf = null;
    }

    /*
     * WARNING - void declaration
     */
    public void ensureSpareCapacity(int n) throws IOException {
        if (this._size + n > this._buf.length) {
            void var1_1;
            if (this._fixed) {
                throw new IOException("Buffer overflow: " + this._buf.length);
            }
            this._buf = Arrays.copyOf(this._buf, (this._buf.length + var1_1 << 2) / 3);
        }
    }

    public byte[] getByteArray() {
        return Arrays.copyOf(this._buf, this._size);
    }
}

