/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;

public class BufferUtil {
    static final int TEMP_BUFFER_SIZE = 4096;
    static final byte SPACE = 32;
    static final byte MINUS = 45;
    static final byte[] DIGIT = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    public static final ByteBuffer EMPTY_BUFFER = ByteBuffer.wrap(new byte[0]);
    private static final int[] decDivisors = new int[]{1000000000, 100000000, 10000000, 1000000, 100000, 10000, 1000, 100, 10, 1};
    private static final int[] hexDivisors = new int[]{0x10000000, 0x1000000, 0x100000, 65536, 4096, 256, 16, 1};
    private static final long[] decDivisorsL = new long[]{1000000000000000000L, 100000000000000000L, 10000000000000000L, 1000000000000000L, 100000000000000L, 10000000000000L, 1000000000000L, 100000000000L, 10000000000L, 1000000000L, 100000000L, 10000000L, 1000000L, 100000L, 10000L, 1000L, 100L, 10L, 1L};

    /*
     * WARNING - void declaration
     */
    public static ByteBuffer allocate(int capacity) {
        void var0_1;
        ByteBuffer buf = ByteBuffer.allocate(capacity);
        buf.limit(0);
        return var0_1;
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuffer allocateDirect(int capacity) {
        void var0_1;
        ByteBuffer buf = ByteBuffer.allocateDirect(capacity);
        buf.limit(0);
        return var0_1;
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuffer copy(ByteBuffer buffer) {
        void var2_2;
        void var1_1;
        ByteBuffer byteBuffer;
        if (buffer == null) {
            return null;
        }
        int p = buffer.position();
        ByteBuffer clone = buffer.isDirect() ? ByteBuffer.allocateDirect(buffer.remaining()) : ByteBuffer.allocate(buffer.remaining());
        clone.put(buffer);
        clone.flip();
        byteBuffer.position((int)var1_1);
        return var2_2;
    }

    public static void reset(ByteBuffer buffer) {
        if (buffer != null) {
            ByteBuffer byteBuffer;
            buffer.order(ByteOrder.BIG_ENDIAN);
            buffer.position(0);
            byteBuffer.limit(0);
        }
    }

    public static void clear(ByteBuffer buffer) {
        if (buffer != null) {
            ByteBuffer byteBuffer;
            buffer.position(0);
            byteBuffer.limit(0);
        }
    }

    public static void clearToFill(ByteBuffer buffer) {
        if (buffer != null) {
            ByteBuffer byteBuffer;
            buffer.position(0);
            ByteBuffer byteBuffer2 = byteBuffer;
            byteBuffer2.limit(byteBuffer2.capacity());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static int flipToFill(ByteBuffer buffer) {
        void var1_1;
        void var3_3;
        ByteBuffer byteBuffer;
        void var2_2;
        int limit;
        int position = buffer.position();
        if (position == (limit = buffer.limit())) {
            buffer.position(0);
            ByteBuffer byteBuffer2 = buffer;
            byteBuffer2.limit(byteBuffer2.capacity());
            return 0;
        }
        int capacity = buffer.capacity();
        if (limit == capacity) {
            buffer.compact();
            return 0;
        }
        buffer.position((int)var2_2);
        byteBuffer.limit((int)var3_3);
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static void flipToFlush(ByteBuffer buffer, int position) {
        void var1_1;
        ByteBuffer byteBuffer;
        ByteBuffer byteBuffer2 = buffer;
        byteBuffer2.limit(byteBuffer2.position());
        byteBuffer.position((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void putIntLittleEndian(ByteBuffer buffer, int value) {
        void var2_2;
        ByteBuffer byteBuffer;
        void var1_1;
        int p = BufferUtil.flipToFill(buffer);
        buffer.put((byte)value);
        buffer.put((byte)(value >>> 8));
        buffer.put((byte)(value >>> 16));
        buffer.put((byte)(var1_1 >>> 24));
        BufferUtil.flipToFlush(byteBuffer, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] toArray(ByteBuffer buffer) {
        void var1_2;
        ByteBuffer byteBuffer;
        if (buffer.hasArray()) {
            void var2_3;
            byte[] array = buffer.array();
            int from = buffer.arrayOffset() + buffer.position();
            void v0 = var2_3;
            return Arrays.copyOfRange(array, (int)v0, (int)(v0 + buffer.remaining()));
        }
        byte[] to = new byte[buffer.remaining()];
        byteBuffer.slice().get(to);
        return var1_2;
    }

    public static boolean isTheEmptyBuffer(ByteBuffer buf) {
        boolean bl = buf == EMPTY_BUFFER;
        return bl;
    }

    public static boolean isEmpty(ByteBuffer buf) {
        ByteBuffer byteBuffer;
        return buf == null || byteBuffer.remaining() == 0;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isEmpty(ByteBuffer[] buf) {
        ByteBuffer[] byteBufferArray;
        if (buf == null || buf.length == 0) {
            return true;
        }
        for (ByteBuffer b : byteBufferArray) {
            void var3_3;
            if (b == null || !var3_3.hasRemaining()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static long remaining(ByteBuffer ... buf) {
        void var1_1;
        long remaining = 0L;
        if (buf != null) {
            ByteBuffer[] byteBufferArray;
            for (ByteBuffer b : byteBufferArray) {
                if (b == null) continue;
                remaining += (long)b.remaining();
            }
        }
        return (long)var1_1;
    }

    public static boolean hasContent(ByteBuffer buf) {
        ByteBuffer byteBuffer;
        return buf != null && byteBuffer.remaining() > 0;
    }

    public static boolean isFull(ByteBuffer buf) {
        ByteBuffer byteBuffer;
        return buf != null && buf.limit() == byteBuffer.capacity();
    }

    public static int length(ByteBuffer buffer) {
        ByteBuffer byteBuffer;
        if (buffer == null) {
            return 0;
        }
        return byteBuffer.remaining();
    }

    public static int space(ByteBuffer buffer) {
        ByteBuffer byteBuffer;
        if (buffer == null) {
            return 0;
        }
        return buffer.capacity() - byteBuffer.limit();
    }

    /*
     * WARNING - void declaration
     */
    public static boolean compact(ByteBuffer buffer) {
        ByteBuffer byteBuffer;
        void var1_1;
        if (buffer.position() == 0) {
            return false;
        }
        boolean full = buffer.limit() == buffer.capacity();
        buffer.compact().flip();
        return var1_1 != false && buffer.limit() < byteBuffer.capacity();
    }

    /*
     * WARNING - void declaration
     */
    public static int put(ByteBuffer from, ByteBuffer to) {
        void var2_2;
        int put;
        int remaining = from.remaining();
        if (remaining > 0) {
            if (remaining <= to.remaining()) {
                to.put(from);
                ByteBuffer byteBuffer = from;
                byteBuffer.position(byteBuffer.limit());
            } else if (from.hasArray()) {
                put = to.remaining();
                to.put(from.array(), from.arrayOffset() + from.position(), put);
                ByteBuffer byteBuffer = from;
                byteBuffer.position(byteBuffer.position() + put);
            } else {
                ByteBuffer byteBuffer;
                void var3_3;
                void var1_1;
                put = to.remaining();
                ByteBuffer slice = from.slice();
                slice.limit(put);
                var1_1.put((ByteBuffer)var3_3);
                ByteBuffer byteBuffer2 = byteBuffer;
                byteBuffer2.position(byteBuffer2.position() + put);
            }
        } else {
            put = 0;
        }
        return (int)var2_2;
    }

    public static int flipPutFlip(ByteBuffer from, ByteBuffer to) {
        ByteBuffer byteBuffer;
        return BufferUtil.append(to, byteBuffer);
    }

    /*
     * WARNING - void declaration
     */
    public static void append(ByteBuffer to, byte[] b, int off, int len) throws BufferOverflowException {
        int pos = BufferUtil.flipToFill(to);
        try {
            void var3_4;
            void var2_3;
            void var1_1;
            to.put((byte[])var1_1, (int)var2_3, (int)var3_4);
        }
        catch (Throwable throwable) {
            ByteBuffer byteBuffer;
            BufferUtil.flipToFlush(byteBuffer, pos);
            throw throwable;
        }
        BufferUtil.flipToFlush(to, pos);
    }

    /*
     * WARNING - void declaration
     */
    public static void append(ByteBuffer to, byte b) {
        int pos = BufferUtil.flipToFill(to);
        try {
            void var1_1;
            to.put((byte)var1_1);
        }
        catch (Throwable throwable) {
            void var2_3;
            ByteBuffer byteBuffer;
            BufferUtil.flipToFlush(byteBuffer, (int)var2_3);
            throw throwable;
        }
        BufferUtil.flipToFlush(to, pos);
    }

    /*
     * WARNING - void declaration
     */
    public static int append(ByteBuffer to, ByteBuffer b) {
        int n;
        int pos = BufferUtil.flipToFill(to);
        try {
            void var1_1;
            n = BufferUtil.put((ByteBuffer)var1_1, to);
        }
        catch (Throwable throwable) {
            void var2_4;
            ByteBuffer byteBuffer;
            BufferUtil.flipToFlush(byteBuffer, (int)var2_4);
            throw throwable;
        }
        BufferUtil.flipToFlush(to, pos);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static int fill(ByteBuffer to, byte[] b, int off, int len) {
        void var1_2;
        int pos = BufferUtil.flipToFill(to);
        try {
            void var3_5;
            void var2_4;
            void var1_1;
            int take;
            int remaining = to.remaining();
            take = remaining < len ? remaining : take;
            to.put((byte[])var1_1, (int)var2_4, take);
            var1_2 = var3_5;
        }
        catch (Throwable throwable) {
            ByteBuffer byteBuffer;
            BufferUtil.flipToFlush(byteBuffer, pos);
            throw throwable;
        }
        BufferUtil.flipToFlush(to, pos);
        return (int)var1_2;
    }

    public static void readFrom(File file, ByteBuffer buffer) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        try {
            FileChannel channel = raf.getChannel();
            for (long needed = raf.length(); needed > 0L && buffer.hasRemaining(); needed -= (long)channel.read(buffer)) {
            }
        }
        catch (Throwable throwable) {
            try {
                RandomAccessFile randomAccessFile;
                randomAccessFile.close();
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        raf.close();
    }

    public static void readFrom(InputStream is, int needed, ByteBuffer buffer) throws IOException {
        int l;
        ByteBuffer tmp = BufferUtil.allocate(8192);
        while (needed > 0 && buffer.hasRemaining() && (l = is.read(tmp.array(), 0, 8192)) >= 0) {
            tmp.position(0);
            tmp.limit(l);
            buffer.put(tmp);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeTo(ByteBuffer buffer, OutputStream out) throws IOException {
        if (buffer.hasArray()) {
            out.write(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
            ByteBuffer byteBuffer = buffer;
            byteBuffer.position(byteBuffer.position() + buffer.remaining());
            return;
        }
        byte[] bytes = new byte[Math.min(buffer.remaining(), 4096)];
        while (buffer.hasRemaining()) {
            void var3_3;
            int byteCountToWrite = Math.min(buffer.remaining(), 4096);
            buffer.get(bytes, 0, byteCountToWrite);
            out.write(bytes, 0, (int)var3_3);
        }
    }

    public static String toString(ByteBuffer buffer) {
        return BufferUtil.toString(buffer, StandardCharsets.ISO_8859_1);
    }

    public static String toUTF8String(ByteBuffer buffer) {
        return BufferUtil.toString(buffer, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public static String toString(ByteBuffer buffer, Charset charset) {
        void var1_1;
        ByteBuffer byteBuffer;
        void var2_2;
        if (buffer == null) {
            return null;
        }
        byte[] array = buffer.hasArray() ? buffer.array() : null;
        if (array == null) {
            byte[] to = new byte[buffer.remaining()];
            buffer.slice().get(to);
            return new String(to, 0, ((void)var2_2).length, charset);
        }
        return new String((byte[])var2_2, buffer.arrayOffset() + buffer.position(), byteBuffer.remaining(), (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String toString(ByteBuffer buffer, int position, int length, Charset charset) {
        void var3_4;
        void var2_3;
        void var1_1;
        ByteBuffer byteBuffer;
        if (buffer == null) {
            return null;
        }
        byte[] array = buffer.hasArray() ? buffer.array() : null;
        if (array == null) {
            void var1_2;
            ByteBuffer ro = buffer.asReadOnlyBuffer();
            ro.position(position);
            ro.limit(position + length);
            byte[] to = new byte[length];
            byteBuffer.get(to);
            return new String(to, 0, ((void)var1_2).length, charset);
        }
        return new String(array, byteBuffer.arrayOffset() + var1_1, (int)var2_3, (Charset)var3_4);
    }

    public static int toInt(ByteBuffer buffer) {
        ByteBuffer byteBuffer;
        ByteBuffer byteBuffer2 = buffer;
        return BufferUtil.toInt(byteBuffer2, byteBuffer2.position(), byteBuffer.remaining());
    }

    /*
     * WARNING - void declaration
     */
    public static int toInt(ByteBuffer buffer, int position, int length) {
        ByteBuffer byteBuffer;
        void i;
        int val = 0;
        boolean started = false;
        boolean minus = false;
        int limit = position + length;
        if (length <= 0) {
            throw new NumberFormatException(BufferUtil.toString(buffer, position, length, StandardCharsets.UTF_8));
        }
        while (i < limit) {
            byte b = buffer.get((int)i);
            if (b <= 32) {
                if (started) {
                    break;
                }
            } else if (b >= 48 && b <= 57) {
                val = val * 10 + (b - 48);
                started = true;
            } else {
                void var2_2;
                if (var2_2 != 45 || started) break;
                minus = true;
            }
            ++i;
        }
        if (started) {
            void var3_3;
            if (minus) {
                return -val;
            }
            return (int)var3_3;
        }
        throw new NumberFormatException(BufferUtil.toString(byteBuffer));
    }

    /*
     * WARNING - void declaration
     */
    public static int takeInt(ByteBuffer buffer) {
        ByteBuffer byteBuffer;
        void var2_2;
        int i;
        int val = 0;
        boolean started = false;
        boolean minus = false;
        for (i = buffer.position(); i < buffer.limit(); ++i) {
            byte b = buffer.get(i);
            if (b <= 32) {
                if (!started) continue;
                break;
            }
            if (b >= 48 && b <= 57) {
                val = val * 10 + (b - 48);
                started = true;
                continue;
            }
            if (b != 45 || started) break;
            minus = true;
        }
        if (var2_2 != false) {
            void var1_1;
            void var3_3;
            buffer.position(i);
            if (var3_3 != false) {
                return -val;
            }
            return (int)var1_1;
        }
        throw new NumberFormatException(BufferUtil.toString(byteBuffer));
    }

    /*
     * WARNING - void declaration
     */
    public static long toLong(ByteBuffer buffer) {
        ByteBuffer byteBuffer;
        void var3_2;
        long val = 0L;
        boolean started = false;
        boolean minus = false;
        for (int i = buffer.position(); i < buffer.limit(); ++i) {
            byte b = buffer.get(i);
            if (b <= 32) {
                if (!started) continue;
                break;
            }
            if (b >= 48 && b <= 57) {
                val = val * 10L + (long)(b - 48);
                started = true;
                continue;
            }
            if (b != 45 || started) break;
            minus = true;
        }
        if (var3_2 != false) {
            void var1_1;
            if (minus) {
                return -val;
            }
            return (long)var1_1;
        }
        throw new NumberFormatException(BufferUtil.toString(byteBuffer));
    }

    public static void putHexInt(ByteBuffer buffer, int n) {
        if (n < 0) {
            buffer.put((byte)45);
            if (n == Integer.MIN_VALUE) {
                buffer.put((byte)56);
                buffer.put((byte)48);
                buffer.put((byte)48);
                buffer.put((byte)48);
                buffer.put((byte)48);
                buffer.put((byte)48);
                buffer.put((byte)48);
                buffer.put((byte)48);
                return;
            }
            n = -n;
        }
        if (n < 16) {
            buffer.put(DIGIT[n]);
            return;
        }
        boolean started = false;
        int[] nArray = hexDivisors;
        int n2 = hexDivisors.length;
        for (int i = 0; i < n2; ++i) {
            int hexDivisor = nArray[i];
            if (n < hexDivisor) {
                if (!started) continue;
                buffer.put((byte)48);
                continue;
            }
            started = true;
            int d = n / hexDivisor;
            buffer.put(DIGIT[d]);
            n -= d * hexDivisor;
        }
    }

    public static void putDecInt(ByteBuffer buffer, int n) {
        if (n < 0) {
            buffer.put((byte)45);
            if (n == Integer.MIN_VALUE) {
                buffer.put((byte)50);
                n = 147483648;
            } else {
                n = -n;
            }
        }
        if (n < 10) {
            buffer.put(DIGIT[n]);
            return;
        }
        boolean started = false;
        int[] nArray = decDivisors;
        int n2 = decDivisors.length;
        for (int i = 0; i < n2; ++i) {
            int decDivisor = nArray[i];
            if (n < decDivisor) {
                if (!started) continue;
                buffer.put((byte)48);
                continue;
            }
            started = true;
            int d = n / decDivisor;
            buffer.put(DIGIT[d]);
            n -= d * decDivisor;
        }
    }

    public static void putDecLong(ByteBuffer buffer, long n) {
        if (n < 0L) {
            buffer.put((byte)45);
            if (n == Long.MIN_VALUE) {
                buffer.put((byte)57);
                n = 223372036854775808L;
            } else {
                n = -n;
            }
        }
        if (n < 10L) {
            buffer.put(DIGIT[(int)n]);
            return;
        }
        boolean started = false;
        long[] lArray = decDivisorsL;
        int n2 = decDivisorsL.length;
        for (int i = 0; i < n2; ++i) {
            long aDecDivisorsL = lArray[i];
            if (n < aDecDivisorsL) {
                if (!started) continue;
                buffer.put((byte)48);
                continue;
            }
            started = true;
            long d = n / aDecDivisorsL;
            buffer.put(DIGIT[(int)d]);
            n -= d * aDecDivisorsL;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuffer toBuffer(int value) {
        void var1_1;
        int n;
        ByteBuffer buf = ByteBuffer.allocate(32);
        BufferUtil.putDecInt(buf, n);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuffer toBuffer(long value) {
        void var2_1;
        long l;
        ByteBuffer buf = ByteBuffer.allocate(32);
        BufferUtil.putDecLong(buf, l);
        return var2_1;
    }

    public static ByteBuffer toBuffer(String s) {
        return BufferUtil.toBuffer(s, StandardCharsets.ISO_8859_1);
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuffer toBuffer(String s, Charset charset) {
        void var1_1;
        String string;
        if (s == null) {
            return EMPTY_BUFFER;
        }
        return BufferUtil.toBuffer(string.getBytes((Charset)var1_1));
    }

    public static ByteBuffer toBuffer(byte[] array) {
        byte[] byArray;
        if (array == null) {
            return EMPTY_BUFFER;
        }
        return BufferUtil.toBuffer(array, 0, byArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuffer toBuffer(byte[] array, int offset, int length) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        if (array == null) {
            return EMPTY_BUFFER;
        }
        return ByteBuffer.wrap(byArray, (int)var1_1, (int)var2_2);
    }

    public static ByteBuffer toDirectBuffer(String s) {
        return BufferUtil.toDirectBuffer(s, StandardCharsets.ISO_8859_1);
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuffer toDirectBuffer(String s, Charset charset) {
        void var1_1;
        Object object;
        if (s == null) {
            return EMPTY_BUFFER;
        }
        byte[] byArray = s.getBytes(charset);
        Object bytes = byArray;
        ByteBuffer buf = ByteBuffer.allocateDirect(byArray.length);
        buf.put((byte[])object);
        buf.flip();
        return var1_1;
    }

    public static ByteBuffer toMappedBuffer(File file) throws IOException {
        File file2;
        return BufferUtil.toMappedBuffer(file.toPath(), 0L, file2.length());
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuffer toMappedBuffer(Path filePath, long pos, long len) throws IOException {
        MappedByteBuffer mappedByteBuffer;
        block5: {
            FileChannel channel = FileChannel.open(filePath, StandardOpenOption.READ);
            try {
                void var3_5;
                void var1_2;
                mappedByteBuffer = channel.map(FileChannel.MapMode.READ_ONLY, (long)var1_2, (long)var3_5);
                if (channel == null) break block5;
            }
            catch (Throwable throwable) {
                if (channel != null) {
                    try {
                        FileChannel fileChannel;
                        fileChannel.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            channel.close();
        }
        return mappedByteBuffer;
    }

    @Deprecated
    public static boolean isMappedBuffer(ByteBuffer buffer) {
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ByteBuffer toBuffer(Resource resource, boolean direct) throws IOException {
        void var1_3;
        void var3_7;
        ByteBuffer buffer2;
        block8: {
            long len = resource.length();
            if (len < 0L) {
                throw new IllegalArgumentException("invalid resource: " + resource + " len=" + len);
            }
            if (len > Integer.MAX_VALUE) {
                return null;
            }
            int ilen = (int)len;
            buffer2 = direct ? BufferUtil.allocateDirect(ilen) : BufferUtil.allocate(ilen);
            int pos = BufferUtil.flipToFill(buffer2);
            if (resource.getFile() != null) {
                BufferUtil.readFrom(resource.getFile(), buffer2);
            } else {
                Closeable is = resource.getInputStream();
                try {
                    void var2_6;
                    BufferUtil.readFrom((InputStream)is, (int)var2_6, buffer2);
                    if (is == null) break block8;
                }
                catch (Throwable buffer2) {
                    if (is == null) throw buffer2;
                    try {
                        Closeable closeable;
                        ((InputStream)closeable).close();
                        throw buffer2;
                    }
                    catch (Throwable throwable) {
                        buffer2.addSuppressed(throwable);
                    }
                    throw buffer2;
                }
                ((InputStream)is).close();
            }
        }
        BufferUtil.flipToFlush(buffer2, (int)var3_7);
        return var1_3;
    }

    /*
     * WARNING - void declaration
     */
    public static String toSummaryString(ByteBuffer buffer) {
        void var1_1;
        ByteBuffer byteBuffer;
        if (buffer == null) {
            return "null";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("[p=");
        buf.append(buffer.position());
        buf.append(",l=");
        buf.append(buffer.limit());
        buf.append(",c=");
        buf.append(buffer.capacity());
        buf.append(",r=");
        buf.append(byteBuffer.remaining());
        buf.append("]");
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String toDetailString(ByteBuffer[] buffer) {
        void var1_1;
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        for (int i = 0; i < buffer.length; ++i) {
            if (i > 0) {
                builder.append(',');
            }
            builder.append(BufferUtil.toDetailString(buffer[i]));
        }
        builder.append(']');
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static void idString(ByteBuffer buffer, StringBuilder out) {
        void var1_1;
        Object object;
        out.append(buffer.getClass().getSimpleName());
        out.append("@");
        if (buffer.hasArray() && buffer.arrayOffset() == 4) {
            out.append('T');
            byte[] byArray = buffer.array();
            Object array = byArray;
            TypeUtil.toHex(byArray[0], (Appendable)out);
            TypeUtil.toHex((byte)array[1], (Appendable)out);
            TypeUtil.toHex((byte)array[2], (Appendable)out);
            TypeUtil.toHex((byte)object[3], (Appendable)out);
            return;
        }
        var1_1.append(Integer.toHexString(System.identityHashCode(object)));
    }

    /*
     * WARNING - void declaration
     */
    public static String toIDString(ByteBuffer buffer) {
        void var1_1;
        ByteBuffer byteBuffer;
        StringBuilder buf = new StringBuilder();
        BufferUtil.idString(byteBuffer, buf);
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String toDetailString(ByteBuffer buffer) {
        void var1_1;
        ByteBuffer byteBuffer;
        if (buffer == null) {
            return "null";
        }
        StringBuilder buf = new StringBuilder();
        BufferUtil.idString(buffer, buf);
        buf.append("[p=");
        buf.append(buffer.position());
        buf.append(",l=");
        buf.append(buffer.limit());
        buf.append(",c=");
        buf.append(buffer.capacity());
        buf.append(",r=");
        buf.append(buffer.remaining());
        buf.append("]={");
        BufferUtil.appendDebugString(buf, byteBuffer);
        buf.append("}");
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static void appendDebugString(StringBuilder buf, ByteBuffer buffer) {
        buffer = buffer.asReadOnlyBuffer();
        try {
            void var1_1;
            int i;
            for (i = 0; i < buffer.position(); ++i) {
                BufferUtil.appendContentChar(buf, buffer.get(i));
                if (i != 8 || buffer.position() <= 16) continue;
                buf.append("...");
                i = buffer.position() - 8;
            }
            buf.append("<<<");
            for (i = buffer.position(); i < buffer.limit(); ++i) {
                BufferUtil.appendContentChar(buf, buffer.get(i));
                if (i != buffer.position() + 24 || buffer.limit() <= buffer.position() + 48) continue;
                buf.append("...");
                i = buffer.limit() - 24;
            }
            buf.append(">>>");
            int limit = buffer.limit();
            ByteBuffer byteBuffer = buffer;
            byteBuffer.limit(byteBuffer.capacity());
            for (int i2 = limit; i2 < buffer.capacity(); ++i2) {
                BufferUtil.appendContentChar(buf, buffer.get(i2));
                if (i2 != limit + 8 || buffer.capacity() <= limit + 16) continue;
                buf.append("...");
                i2 = buffer.capacity() - 8;
            }
            var1_1.limit(limit);
            return;
        }
        catch (Throwable x) {
            StringBuilder stringBuilder;
            void var2_3;
            Log.getRootLogger().ignore((Throwable)var2_3);
            stringBuilder.append("!!concurrent mod!!");
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void appendContentChar(StringBuilder buf, byte b) {
        void var1_1;
        StringBuilder stringBuilder;
        if (b == 92) {
            buf.append("\\\\");
            return;
        }
        if (b >= 32 && b <= 126) {
            buf.append((char)b);
            return;
        }
        if (b == 13) {
            buf.append("\\r");
            return;
        }
        if (b == 10) {
            buf.append("\\n");
            return;
        }
        if (b == 9) {
            buf.append("\\t");
            return;
        }
        stringBuilder.append("\\x").append(TypeUtil.toHexString((byte)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static String toHexSummary(ByteBuffer buffer) {
        void var1_1;
        if (buffer == null) {
            return "null";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("b[").append(buffer.remaining()).append("]=");
        for (int i = buffer.position(); i < buffer.limit(); ++i) {
            TypeUtil.toHex(buffer.get(i), (Appendable)buf);
            if (i != buffer.position() + 24 || buffer.limit() <= buffer.position() + 32) continue;
            buf.append("...");
            i = buffer.limit() - 8;
        }
        return var1_1.toString();
    }

    public static String toHexString(ByteBuffer buffer) {
        ByteBuffer byteBuffer;
        if (buffer == null) {
            return "null";
        }
        return TypeUtil.toHexString(BufferUtil.toArray(byteBuffer));
    }

    public static void putCRLF(ByteBuffer buffer) {
        ByteBuffer byteBuffer;
        buffer.put((byte)13);
        byteBuffer.put((byte)10);
    }

    public static boolean isPrefix(ByteBuffer prefix, ByteBuffer buffer) {
        if (prefix.remaining() > buffer.remaining()) {
            return false;
        }
        int bi = buffer.position();
        for (int i = prefix.position(); i < prefix.limit(); ++i) {
            if (prefix.get(i) == buffer.get(bi++)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuffer ensureCapacity(ByteBuffer buffer, int capacity) {
        if (buffer == null) {
            return BufferUtil.allocate(capacity);
        }
        if (buffer.capacity() >= capacity) {
            return buffer;
        }
        if (buffer.hasArray()) {
            ByteBuffer byteBuffer;
            void var1_1;
            return ByteBuffer.wrap(Arrays.copyOfRange(buffer.array(), buffer.arrayOffset(), buffer.arrayOffset() + var1_1), buffer.position(), byteBuffer.remaining());
        }
        throw new UnsupportedOperationException();
    }
}

