/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jetty.util.MemoryUtils;

public class BlockingArrayQueue<E>
extends AbstractList<E>
implements BlockingQueue<E> {
    private static final int HEAD_OFFSET = MemoryUtils.getIntegersPerCacheLine() - 1;
    private static final int TAIL_OFFSET = HEAD_OFFSET + MemoryUtils.getIntegersPerCacheLine();
    public static final int DEFAULT_CAPACITY = 128;
    public static final int DEFAULT_GROWTH = 64;
    private final int _maxCapacity;
    private final int _growCapacity;
    private final int[] _indexes = new int[TAIL_OFFSET + 1];
    private final Lock _tailLock = new ReentrantLock();
    private final AtomicInteger _size = new AtomicInteger();
    private final Lock _headLock = new ReentrantLock();
    private final Condition _notEmpty = this._headLock.newCondition();
    private Object[] _elements;

    public BlockingArrayQueue() {
        this._elements = new Object[128];
        this._growCapacity = 64;
        this._maxCapacity = Integer.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    public BlockingArrayQueue(int maxCapacity) {
        void var1_1;
        this._elements = new Object[maxCapacity];
        this._growCapacity = -1;
        this._maxCapacity = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public BlockingArrayQueue(int capacity, int growBy) {
        void var2_2;
        void var1_1;
        this._elements = new Object[var1_1];
        this._growCapacity = var2_2;
        this._maxCapacity = Integer.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    public BlockingArrayQueue(int capacity, int growBy, int maxCapacity) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (capacity > maxCapacity) {
            throw new IllegalArgumentException();
        }
        this._elements = new Object[var1_1];
        this._growCapacity = var2_2;
        this._maxCapacity = var3_3;
    }

    @Override
    public void clear() {
        this._tailLock.lock();
        try {
            this._headLock.lock();
            try {
                this._indexes[BlockingArrayQueue.HEAD_OFFSET] = 0;
                this._indexes[BlockingArrayQueue.TAIL_OFFSET] = 0;
                this._size.set(0);
            }
            finally {
                this._headLock.unlock();
            }
            return;
        }
        finally {
            this._tailLock.unlock();
        }
    }

    @Override
    public int size() {
        return this._size.get();
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E poll() {
        void var1_1;
        if (this._size.get() == 0) {
            return null;
        }
        Object e = null;
        this._headLock.lock();
        try {
            if (this._size.get() > 0) {
                void var2_3;
                int head = this._indexes[HEAD_OFFSET];
                e = this._elements[head];
                this._elements[head] = null;
                this._indexes[BlockingArrayQueue.HEAD_OFFSET] = (var2_3 + true) % this._elements.length;
                if (this._size.decrementAndGet() > 0) {
                    this._notEmpty.signal();
                }
            }
        }
        finally {
            this._headLock.unlock();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E peek() {
        void var1_1;
        if (this._size.get() == 0) {
            return null;
        }
        Object e = null;
        this._headLock.lock();
        try {
            if (this._size.get() > 0) {
                e = this._elements[this._indexes[HEAD_OFFSET]];
            }
        }
        finally {
            this._headLock.unlock();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E remove() {
        void var1_1;
        E e = this.poll();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E element() {
        void var1_1;
        E e = this.peek();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean offer(E e) {
        void var1_3;
        Objects.requireNonNull(e);
        this._tailLock.lock();
        try {
            void var2_6;
            int size = this._size.get();
            if (size >= this._maxCapacity) {
                return false;
            }
            if (size == this._elements.length) {
                this._headLock.lock();
                try {
                    if (!this.grow()) {
                        return false;
                    }
                }
                finally {
                    this._headLock.unlock();
                }
            }
            int tail = this._indexes[TAIL_OFFSET];
            this._elements[tail] = e;
            this._indexes[BlockingArrayQueue.TAIL_OFFSET] = (var2_6 + true) % this._elements.length;
            boolean notEmpty = this._size.getAndIncrement() == 0;
        }
        finally {
            this._tailLock.unlock();
        }
        if (var1_3 != false) {
            this._headLock.lock();
            try {
                this._notEmpty.signal();
            }
            finally {
                this._headLock.unlock();
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean add(E e) {
        void var1_1;
        if (this.offer(var1_1)) {
            return true;
        }
        throw new IllegalStateException();
    }

    @Override
    public void put(E o) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offer(E o, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E take() throws InterruptedException {
        void var1_3;
        this._headLock.lockInterruptibly();
        try {
            void var2_2;
            try {
                while (this._size.get() == 0) {
                    this._notEmpty.await();
                }
            }
            catch (InterruptedException ex) {
                this._notEmpty.signal();
                throw ex;
            }
            int head = this._indexes[HEAD_OFFSET];
            Object e = this._elements[head];
            this._elements[head] = null;
            this._indexes[BlockingArrayQueue.HEAD_OFFSET] = (var2_2 + true) % this._elements.length;
            if (this._size.decrementAndGet() > 0) {
                this._notEmpty.signal();
            }
        }
        finally {
            this._headLock.unlock();
        }
        return var1_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E poll(long time, TimeUnit unit) throws InterruptedException {
        void var1_2;
        long nanos = unit.toNanos(time);
        this._headLock.lockInterruptibly();
        try {
            void var2_7;
            while (this._size.get() == 0) {
                if (nanos <= 0L) {
                    return null;
                }
                try {
                    nanos = this._notEmpty.awaitNanos(nanos);
                }
                catch (InterruptedException x) {
                    this._notEmpty.signal();
                    throw x;
                }
            }
            int head = this._indexes[HEAD_OFFSET];
            Object e = this._elements[head];
            this._elements[head] = null;
            this._indexes[BlockingArrayQueue.HEAD_OFFSET] = (var2_7 + true) % this._elements.length;
            if (this._size.decrementAndGet() > 0) {
                this._notEmpty.signal();
            }
        }
        finally {
            this._headLock.unlock();
        }
        return var1_2;
    }

    @Override
    public boolean remove(Object o) {
        this._tailLock.lock();
        try {
            block11: {
                this._headLock.lock();
                if (!this.isEmpty()) break block11;
                this._headLock.unlock();
                return false;
            }
            try {
                int head = this._indexes[HEAD_OFFSET];
                int tail = this._indexes[TAIL_OFFSET];
                int capacity = this._elements.length;
                int i = head;
                do {
                    if (Objects.equals(this._elements[i], o)) {
                        this.remove(i >= head ? i - head : capacity - head + i);
                        this._headLock.unlock();
                        return true;
                    }
                    if (++i != capacity) continue;
                    i = 0;
                } while (i != tail);
                this._headLock.unlock();
                return false;
            }
            catch (Throwable throwable) {
                this._headLock.unlock();
                throw throwable;
            }
        }
        finally {
            this._tailLock.unlock();
        }
    }

    @Override
    public int remainingCapacity() {
        this._tailLock.lock();
        try {
            this._headLock.lock();
            try {
                int n = this.getCapacity() - this.size();
                this._headLock.unlock();
                return n;
            }
            catch (Throwable throwable) {
                this._headLock.unlock();
                throw throwable;
            }
        }
        finally {
            this._tailLock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int drainTo(Collection<? super E> c) {
        void var1_1;
        return this.drainTo((Collection<? super E>)var1_1, Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        void var3_5;
        this._tailLock.lock();
        try {
            this._headLock.lock();
            try {
                int elements;
                if (this._size.get() == 0) {
                    return 0;
                }
                int head = this._indexes[HEAD_OFFSET];
                int tail = this._indexes[TAIL_OFFSET];
                int capacity = this._elements.length;
                int i = head;
                for (elements = 0; elements < maxElements && (i != tail || elements <= 0); ++elements) {
                    c.add(this._elements[i]);
                    if (++i != capacity) continue;
                    i = 0;
                }
                if (i == tail) {
                    this._indexes[BlockingArrayQueue.HEAD_OFFSET] = 0;
                    this._indexes[BlockingArrayQueue.TAIL_OFFSET] = 0;
                    this._size.set(0);
                } else {
                    this._indexes[BlockingArrayQueue.HEAD_OFFSET] = i;
                    this._size.addAndGet(-elements);
                }
            }
            finally {
                this._headLock.unlock();
            }
        }
        finally {
            this._tailLock.unlock();
        }
        return (int)var3_5;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E get(int index) {
        this._tailLock.lock();
        try {
            Object object;
            this._headLock.lock();
            try {
                void var1_1;
                if (index < 0 || index >= this._size.get()) {
                    throw new IndexOutOfBoundsException("!(0<" + index + "<=" + this._size + ")");
                }
                int i = this._indexes[HEAD_OFFSET] + index;
                int capacity = this._elements.length;
                if (i >= capacity) {
                    void var2_5;
                    i -= var2_5;
                }
                object = this._elements[var1_1];
                this._headLock.unlock();
            }
            catch (Throwable throwable) {
                this._headLock.unlock();
                throw throwable;
            }
            return (E)object;
        }
        finally {
            this._tailLock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void add(int index, E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this._tailLock.lock();
        try {
            this._headLock.lock();
            try {
                int size = this._size.get();
                if (index < 0 || index > size) {
                    throw new IndexOutOfBoundsException("!(0<" + index + "<=" + this._size + ")");
                }
                if (index == size) {
                    this.add(e);
                } else {
                    if (this._indexes[TAIL_OFFSET] == this._indexes[HEAD_OFFSET] && !this.grow()) {
                        throw new IllegalStateException("full");
                    }
                    int i = this._indexes[HEAD_OFFSET] + index;
                    int capacity = this._elements.length;
                    if (i >= capacity) {
                        i -= capacity;
                    }
                    this._size.incrementAndGet();
                    int tail = this._indexes[TAIL_OFFSET];
                    this._indexes[BlockingArrayQueue.TAIL_OFFSET] = tail = (tail + 1) % capacity;
                    if (i < tail) {
                        System.arraycopy(this._elements, i, this._elements, i + 1, tail - i);
                        this._elements[i] = e;
                    } else {
                        void var2_4;
                        void var3_5;
                        if (tail > 0) {
                            System.arraycopy(this._elements, 0, this._elements, 1, tail);
                            this._elements[0] = this._elements[capacity - 1];
                        }
                        System.arraycopy(this._elements, i, this._elements, i + 1, (int)(var3_5 - i - true));
                        this._elements[var1_1] = var2_4;
                    }
                }
            }
            finally {
                this._headLock.unlock();
            }
            return;
        }
        finally {
            this._tailLock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E set(int index, E e) {
        Objects.requireNonNull(e);
        this._tailLock.lock();
        try {
            void var1_2;
            this._headLock.lock();
            try {
                void var3_7;
                void var2_5;
                if (index < 0 || index >= this._size.get()) {
                    throw new IndexOutOfBoundsException("!(0<" + index + "<=" + this._size + ")");
                }
                int i = this._indexes[HEAD_OFFSET] + index;
                int capacity = this._elements.length;
                if (i >= capacity) {
                    i -= capacity;
                }
                Object old = this._elements[i];
                this._elements[var1_1] = var2_5;
                var1_2 = var3_7;
                this._headLock.unlock();
            }
            catch (Throwable throwable) {
                this._headLock.unlock();
                throw throwable;
            }
            return var1_2;
        }
        finally {
            this._tailLock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E remove(int index) {
        this._tailLock.lock();
        try {
            void var1_2;
            this._headLock.lock();
            try {
                void var3_6;
                if (index < 0 || index >= this._size.get()) {
                    throw new IndexOutOfBoundsException("!(0<" + index + "<=" + this._size + ")");
                }
                int i = this._indexes[HEAD_OFFSET] + index;
                int capacity = this._elements.length;
                if (i >= capacity) {
                    i -= capacity;
                }
                Object old = this._elements[i];
                int tail = this._indexes[TAIL_OFFSET];
                if (i < tail) {
                    System.arraycopy(this._elements, i + 1, this._elements, i, tail - i);
                    int n = TAIL_OFFSET;
                    this._indexes[n] = this._indexes[n] - 1;
                } else {
                    void var1_1;
                    System.arraycopy(this._elements, i + 1, this._elements, i, capacity - var1_1 - 1);
                    this._elements[capacity - 1] = this._elements[0];
                    if (tail > 0) {
                        System.arraycopy(this._elements, 1, this._elements, 0, tail);
                        int n = TAIL_OFFSET;
                        this._indexes[n] = this._indexes[n] - 1;
                    } else {
                        void var2_5;
                        this._indexes[BlockingArrayQueue.TAIL_OFFSET] = var2_5 - true;
                    }
                    this._elements[this._indexes[BlockingArrayQueue.TAIL_OFFSET]] = null;
                }
                this._size.decrementAndGet();
                var1_2 = var3_6;
                this._headLock.unlock();
            }
            catch (Throwable throwable) {
                this._headLock.unlock();
                throw throwable;
            }
            return var1_2;
        }
        finally {
            this._tailLock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ListIterator<E> listIterator(int index) {
        this._tailLock.lock();
        try {
            this._headLock.lock();
            try {
                void var1_1;
                void var2_4;
                Object[] elements = new Object[this.size()];
                if (this.size() > 0) {
                    int head = this._indexes[HEAD_OFFSET];
                    int tail = this._indexes[TAIL_OFFSET];
                    if (head < tail) {
                        System.arraycopy(this._elements, head, elements, 0, tail - head);
                    } else {
                        void var3_5;
                        int chunk = this._elements.length - head;
                        System.arraycopy(this._elements, (int)var3_5, elements, 0, chunk);
                        System.arraycopy(this._elements, 0, elements, chunk, tail);
                    }
                }
                Itr itr = new Itr((Object[])var2_4, (int)var1_1);
                this._headLock.unlock();
                return itr;
            }
            catch (Throwable throwable) {
                this._headLock.unlock();
                throw throwable;
            }
        }
        finally {
            this._tailLock.unlock();
        }
    }

    public int getCapacity() {
        this._tailLock.lock();
        try {
            int n = this._elements.length;
            return n;
        }
        finally {
            this._tailLock.unlock();
        }
    }

    public int getMaxCapacity() {
        return this._maxCapacity;
    }

    /*
     * WARNING - void declaration
     */
    private boolean grow() {
        if (this._growCapacity <= 0) {
            return false;
        }
        this._tailLock.lock();
        try {
            this._headLock.lock();
            try {
                void var3_7;
                int newTail;
                int head = this._indexes[HEAD_OFFSET];
                int tail = this._indexes[TAIL_OFFSET];
                int capacity = this._elements.length;
                Object[] elements = new Object[capacity + this._growCapacity];
                if (head < tail) {
                    newTail = tail - head;
                    System.arraycopy(this._elements, head, elements, 0, newTail);
                } else if (head > tail || this._size.get() > 0) {
                    void var2_4;
                    void var1_1;
                    newTail = capacity + tail - head;
                    int cut = capacity - head;
                    System.arraycopy(this._elements, (int)var1_1, elements, 0, cut);
                    System.arraycopy(this._elements, 0, elements, cut, (int)var2_4);
                } else {
                    newTail = 0;
                }
                this._elements = elements;
                this._indexes[BlockingArrayQueue.HEAD_OFFSET] = 0;
                this._indexes[BlockingArrayQueue.TAIL_OFFSET] = var3_7;
                this._headLock.unlock();
                return true;
            }
            catch (Throwable throwable) {
                this._headLock.unlock();
                throw throwable;
            }
        }
        finally {
            this._tailLock.unlock();
        }
    }

    private class Itr
    implements ListIterator<E> {
        private final Object[] _elements;
        private int _cursor;

        /*
         * WARNING - void declaration
         */
        public Itr(Object[] elements, int offset) {
            void var3_3;
            void var2_2;
            this._elements = var2_2;
            this._cursor = var3_3;
        }

        @Override
        public boolean hasNext() {
            return this._cursor < this._elements.length;
        }

        @Override
        public E next() {
            return this._elements[this._cursor++];
        }

        @Override
        public boolean hasPrevious() {
            return this._cursor > 0;
        }

        @Override
        public E previous() {
            return this._elements[--this._cursor];
        }

        @Override
        public int nextIndex() {
            return this._cursor + 1;
        }

        @Override
        public int previousIndex() {
            return this._cursor - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }
    }
}

