/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.component.Dumpable;

public class AttributesMap
implements Attributes,
Dumpable {
    private final AtomicReference<ConcurrentMap<String, Object>> _map = new AtomicReference();

    public AttributesMap() {
    }

    /*
     * WARNING - void declaration
     */
    public AttributesMap(AttributesMap attributes) {
        ConcurrentMap<String, Object> map = attributes.map();
        if (map != null) {
            void var1_1;
            this._map.set(new ConcurrentHashMap(var1_1));
        }
    }

    private ConcurrentMap<String, Object> map() {
        return this._map.get();
    }

    /*
     * WARNING - void declaration
     */
    private ConcurrentMap<String, Object> ensureMap() {
        void var1_1;
        ConcurrentMap<String, Object> map;
        do {
            if ((map = this.map()) == null) continue;
            return map;
        } while (!this._map.compareAndSet(null, map = new ConcurrentHashMap<String, Object>()));
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeAttribute(String name) {
        ConcurrentMap<String, Object> map = this.map();
        if (map != null) {
            void var1_1;
            void var2_2;
            var2_2.remove(var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setAttribute(String name, Object attribute) {
        void var2_2;
        void var1_1;
        if (attribute == null) {
            this.removeAttribute(name);
            return;
        }
        this.ensureMap().put((String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object getAttribute(String name) {
        void var1_1;
        void var2_2;
        ConcurrentMap<String, Object> map = this.map();
        if (map == null) {
            return null;
        }
        return var2_2.get(var1_1);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.getAttributeNameSet());
    }

    @Override
    public Set<String> getAttributeNameSet() {
        return this.keySet();
    }

    /*
     * WARNING - void declaration
     */
    public Set<Map.Entry<String, Object>> getAttributeEntrySet() {
        void var1_1;
        ConcurrentMap<String, Object> map = this.map();
        if (map == null) {
            return Collections.emptySet();
        }
        return var1_1.entrySet();
    }

    public static Enumeration<String> getAttributeNamesCopy(Attributes attrs) {
        ArrayList<String> arrayList;
        if (attrs instanceof AttributesMap) {
            return Collections.enumeration(((AttributesMap)attrs).keySet());
        }
        arrayList = new ArrayList<String>(Collections.list(arrayList.getAttributeNames()));
        return Collections.enumeration(arrayList);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void clearAttributes() {
        ConcurrentMap<String, Object> map = this.map();
        if (map != null) {
            void var1_1;
            var1_1.clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    public int size() {
        void var1_1;
        ConcurrentMap<String, Object> map = this.map();
        if (map == null) {
            return 0;
        }
        return var1_1.size();
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        ConcurrentMap<String, Object> map = this.map();
        if (map == null) {
            return "{}";
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    private Set<String> keySet() {
        void var1_1;
        ConcurrentMap<String, Object> map = this.map();
        if (map == null) {
            return Collections.emptySet();
        }
        return var1_1.keySet();
    }

    /*
     * WARNING - void declaration
     */
    public void addAll(Attributes attributes) {
        Enumeration<String> e = attributes.getAttributeNames();
        while (e.hasMoreElements()) {
            void var3_3;
            String name = e.nextElement();
            this.setAttribute(name, attributes.getAttribute((String)var3_3));
        }
    }

    @Override
    public String dump() {
        return Dumpable.dump(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void dump(Appendable out, String indent) throws IOException {
        void var2_2;
        Dumpable.dumpObjects(out, (String)var2_2, String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode()), this.map());
    }
}

