/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jetty.util.AbstractTrie;
import org.eclipse.jetty.util.MathUtils;

public class ArrayTrie<V>
extends AbstractTrie<V> {
    private static final int ROW_SIZE = 32;
    private static final int MAX_CAPACITY = 65534;
    private static final int[] __lookup = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26, -1, 27, 30, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 28, 29, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1};
    private final char[] _rowIndex;
    private final String[] _key;
    private final V[] _value;
    private char[][] _bigIndex;
    private char _rows;

    public ArrayTrie() {
        this(128);
    }

    /*
     * WARNING - void declaration
     */
    public ArrayTrie(int capacity) {
        super(true);
        void var1_1;
        if (capacity > 65534) {
            throw new IllegalArgumentException("Capacity " + capacity + " > 65534");
        }
        this._value = new Object[capacity + 1];
        this._rowIndex = new char[capacity + 1 << 5];
        this._key = new String[var1_1 + true];
    }

    @Override
    public void clear() {
        this._rows = '\u0000';
        Arrays.fill(this._value, null);
        Arrays.fill(this._rowIndex, '\u0000');
        Arrays.fill(this._key, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean put(String s, V v) {
        void var2_2;
        void var1_1;
        int t = 0;
        int limit = s.length();
        if (limit > 65534) {
            return false;
        }
        for (int k = 0; k < limit; ++k) {
            char c = s.charAt(k);
            int index = __lookup[c & 0x7F];
            if (index >= 0) {
                int idx = (t << 5) + index;
                if ((t = this._rowIndex[idx]) != 0) continue;
                this._rows = (char)MathUtils.cappedAdd(this._rows, 1, this._value.length);
                if (this._rows == this._value.length) {
                    return false;
                }
                this._rowIndex[idx] = this._rows;
                t = this._rowIndex[idx];
                continue;
            }
            if (c > '\u007f') {
                throw new IllegalArgumentException("non ascii character");
            }
            if (this._bigIndex == null) {
                this._bigIndex = new char[this._value.length][];
            }
            if (t >= this._bigIndex.length) {
                return false;
            }
            char[] big = this._bigIndex[t];
            if (big == null) {
                this._bigIndex[t] = new char[128];
                big = this._bigIndex[t];
            }
            if ((t = big[c]) != 0) continue;
            this._rows = (char)MathUtils.cappedAdd(this._rows, 1, this._value.length);
            if (this._rows == this._value.length) {
                return false;
            }
            big[c] = this._rows;
            t = big[c];
        }
        if (t >= this._key.length) {
            this._rows = (char)this._key.length;
            return false;
        }
        this._key[t] = v == null ? null : var1_1;
        this._value[var3_3] = var2_2;
        return true;
    }

    @Override
    public V get(String s, int offset, int len) {
        char c;
        int t = 0;
        for (int i = 0; i < len; ++i) {
            int idx;
            char c2 = s.charAt(offset + i);
            if (c2 > '\u007f') {
                return null;
            }
            int index = __lookup[c2 & 0x7F];
            if (index >= 0) {
                idx = (t << 5) + index;
                if ((idx = this._rowIndex[idx]) != 0) continue;
                return null;
            }
            char[] big = this._bigIndex == null ? null : this._bigIndex[idx];
            if (big == null) {
                return null;
            }
            c = big[c2 & 0x7F];
            if (c != '\u0000') continue;
            return null;
        }
        return this._value[c];
    }

    @Override
    public V get(ByteBuffer b, int offset, int len) {
        char c;
        int t = 0;
        for (int i = 0; i < len; ++i) {
            int idx;
            byte c2 = b.get(offset + i);
            int index = __lookup[c2 & 0x7F];
            if (index >= 0) {
                idx = (t << 5) + index;
                if ((idx = this._rowIndex[idx]) != 0) continue;
                return null;
            }
            char[] big = this._bigIndex == null ? null : this._bigIndex[idx];
            if (big == null) {
                return null;
            }
            c = big[c2];
            if (c != '\u0000') continue;
            return null;
        }
        return this._value[c];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V getBest(byte[] b, int offset, int len) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getBest(0, (byte[])var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V getBest(ByteBuffer b, int offset, int len) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (b.hasArray()) {
            return this.getBest(0, b.array(), b.arrayOffset() + b.position() + offset, len);
        }
        return this.getBest(0, (ByteBuffer)var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V getBest(String s, int offset, int len) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getBest(0, (String)var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private V getBest(int t, String s, int offset, int len) {
        void var1_1;
        char[] big;
        int idx;
        int nt;
        char c;
        int index;
        int pos = offset;
        for (int i = 0; i < len && ((index = __lookup[(c = s.charAt(pos++)) & 0x7F]) >= 0 ? (nt = this._rowIndex[idx = (t << 5) + index]) != 0 : (big = this._bigIndex == null ? null : this._bigIndex[t]) != null && (nt = big[nt]) != 0); ++i) {
            if (this._key[t] != null) {
                V best = this.getBest(nt, s, offset + i + 1, len - i - 1);
                if (best != null) {
                    return best;
                }
                return this._value[t];
            }
            t = nt;
        }
        return this._value[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    private V getBest(int t, byte[] b, int offset, int len) {
        void var1_1;
        char[] big;
        int idx;
        int nt;
        byte c;
        int index;
        for (int i = 0; i < len && ((index = __lookup[(c = b[offset + i]) & 0x7F]) >= 0 ? (nt = this._rowIndex[idx = (t << 5) + index]) != 0 : (big = this._bigIndex == null ? null : this._bigIndex[t]) != null && (nt = big[nt]) != 0); ++i) {
            if (this._key[t] != null) {
                V best = this.getBest(nt, b, offset + i + 1, len - i - 1);
                if (best == null) break;
                return best;
            }
            t = nt;
        }
        return this._value[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    private V getBest(int t, ByteBuffer b, int offset, int len) {
        void var1_1;
        int pos = b.position() + offset;
        for (int i = 0; i < len; ++i) {
            int nt;
            byte c;
            int index;
            if (pos >= b.limit()) {
                return null;
            }
            if ((index = __lookup[(c = b.get(pos++)) & 0x7F]) >= 0) {
                int idx = (t << 5) + index;
                nt = this._rowIndex[idx];
                if (nt == 0) break;
            } else {
                char[] big = this._bigIndex == null ? null : this._bigIndex[t];
                if (big == null || (nt = big[nt]) == 0) break;
                t = nt;
            }
            if (this._key[t] != null) {
                V best = this.getBest(nt, b, offset + i + 1, len - i - 1);
                if (best == null) break;
                return best;
            }
            t = nt;
        }
        return this._value[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var2_2;
        int rows = this._rows;
        if (rows == 0) {
            return "{}";
        }
        StringBuilder buf = new StringBuilder();
        int c = 123;
        for (int i = 0; i <= rows; ++i) {
            String key = this._key[i];
            if (key == null) continue;
            buf.append((char)c).append(key).append('=').append(this._value[i]);
            c = 44;
        }
        buf.append('}');
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<String> keySet() {
        void var1_1;
        HashSet<String> keys = new HashSet<String>();
        String[] stringArray = this._key;
        int n = this._key.length;
        for (int i = 0; i < n; ++i) {
            String k = stringArray[i];
            if (k == null) continue;
            keys.add(k);
        }
        return var1_1;
    }

    @Override
    public boolean isFull() {
        return this._rows >= this._key.length;
    }
}

