/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.util.AbstractTrie;
import org.eclipse.jetty.util.MathUtils;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.Trie;

public class ArrayTernaryTrie<V>
extends AbstractTrie<V> {
    private static int LO = 1;
    private static int EQ = 2;
    private static int HI = 3;
    private static final int ROW_SIZE = 4;
    public static final int MAX_CAPACITY = 65534;
    private final char[] _tree;
    private final String[] _key;
    private final V[] _value;
    private char _rows;

    public ArrayTernaryTrie() {
        this(128);
    }

    /*
     * WARNING - void declaration
     */
    public ArrayTernaryTrie(boolean insensitive) {
        this((boolean)var1_1, 128);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ArrayTernaryTrie(int capacity) {
        this(true, (int)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ArrayTernaryTrie(boolean insensitive, int capacity) {
        super((boolean)var1_1);
        void var2_2;
        void var1_1;
        if (capacity > 65534) {
            throw new IllegalArgumentException("Capacity " + capacity + " > 65534");
        }
        this._value = new Object[capacity + 1];
        this._tree = new char[capacity + 1 << 2];
        this._key = new String[var2_2 + true];
    }

    /*
     * WARNING - void declaration
     */
    public ArrayTernaryTrie(ArrayTernaryTrie<V> trie, double factor) {
        super(trie.isCaseInsensitive());
        void var2_3;
        void var1_1;
        int capacity = (int)((double)trie._value.length * factor);
        if (capacity > 65534) {
            throw new IllegalArgumentException("Capacity " + capacity + " > 65534");
        }
        this._rows = trie._rows;
        this._value = Arrays.copyOf(trie._value, capacity);
        this._tree = Arrays.copyOf(trie._tree, capacity << 2);
        this._key = Arrays.copyOf(var1_1._key, (int)var2_3);
    }

    @Override
    public void clear() {
        this._rows = '\u0000';
        Arrays.fill(this._value, null);
        Arrays.fill(this._tree, '\u0000');
        Arrays.fill(this._key, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean put(String s, V v) {
        void var2_2;
        void var1_1;
        char t = '\u0000';
        int limit = s.length();
        if (limit > 65534) {
            return false;
        }
        for (int k = 0; k < limit; ++k) {
            int diff;
            char c = s.charAt(k);
            if (this.isCaseInsensitive() && c < '\u0080') {
                c = StringUtil.lowercases[c];
            }
            do {
                if (this._rows == '\ufffe') {
                    return false;
                }
                int row = 4 * t;
                if (t == this._rows) {
                    this._rows = (char)MathUtils.cappedAdd(this._rows, 1, this._key.length);
                    if (this._rows == this._key.length) {
                        return false;
                    }
                    this._tree[row] = c;
                }
                if ((diff = (t = this._tree[row]) - c) == 0) {
                    int last = row + EQ;
                    t = this._tree[last];
                } else {
                    t = diff < 0 ? this._tree[last += LO] : this._tree[last += HI];
                }
                if (t != '\u0000') continue;
                t = this._rows;
                this._tree[last] = t;
            } while (diff != 0);
        }
        if (t == this._rows) {
            if (this._rows == this._key.length) {
                return false;
            }
            this._rows = (char)(this._rows + '\u0001');
        }
        this._key[t] = v == null ? null : var1_1;
        this._value[var3_3] = var2_2;
        return true;
    }

    @Override
    public V get(String s, int offset, int len) {
        char c;
        int t = 0;
        int i = 0;
        block0: while (i < len) {
            int diff;
            int row;
            char c2 = s.charAt(offset + i++);
            if (this.isCaseInsensitive() && c2 < '\u0080') {
                c2 = StringUtil.lowercases[c2];
            }
            do {
                char c3;
                if ((diff = (c3 = this._tree[row = 4 * t]) - c2) != 0) continue;
                if ((row = this._tree[row + EQ]) != 0) continue block0;
                return null;
            } while ((c = this._tree[row + ArrayTernaryTrie.hilo(diff)]) != '\u0000');
            return null;
        }
        return this._value[c];
    }

    @Override
    public V get(ByteBuffer b, int offset, int len) {
        char c;
        int t = 0;
        offset += b.position();
        int i = 0;
        block0: while (i < len) {
            int diff;
            int row;
            byte c2 = (byte)(b.get(offset + i++) & 0x7F);
            if (this.isCaseInsensitive()) {
                c2 = (byte)StringUtil.lowercases[c2];
            }
            do {
                char c3;
                if ((diff = (c3 = this._tree[row = 4 * t]) - c2) != 0) continue;
                if ((row = this._tree[row + EQ]) != 0) continue block0;
                return null;
            } while ((c = this._tree[row + ArrayTernaryTrie.hilo(diff)]) != '\u0000');
            return null;
        }
        return this._value[c];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V getBest(String s) {
        void var1_1;
        return this.getBest(0, s, 0, var1_1.length());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V getBest(String s, int offset, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getBest(0, (String)var1_1, (int)var2_2, (int)var3_3);
    }

    private V getBest(int t, String s, int offset, int len) {
        int node = t;
        int end = offset + len;
        block0: while (offset < end) {
            int diff;
            char c;
            char c2 = s.charAt(offset++);
            --len;
            if (this.isCaseInsensitive() && c2 < '\u0080') {
                c2 = StringUtil.lowercases[c2];
            }
            do {
                int row;
                char c3;
                if ((diff = (c3 = this._tree[row = 4 * t]) - c2) != 0) continue;
                if ((row = this._tree[row + EQ]) == 0) break block0;
                if (this._key[row] == null) continue block0;
                node = row;
                V better = this.getBest(row, s, offset, len);
                if (better == null) continue block0;
                return better;
            } while ((c = this._tree[c + ArrayTernaryTrie.hilo(diff)]) != '\u0000');
        }
        return this._value[node];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V getBest(ByteBuffer b, int offset, int len) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (b.hasArray()) {
            return this.getBest(0, b.array(), b.arrayOffset() + b.position() + offset, len);
        }
        return this.getBest(0, (ByteBuffer)var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V getBest(byte[] b, int offset, int len) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getBest(0, (byte[])var1_1, (int)var2_2, (int)var3_3);
    }

    private V getBest(int t, byte[] b, int offset, int len) {
        int node = t;
        int end = offset + len;
        block0: while (offset < end) {
            int diff;
            char c;
            byte c2 = (byte)(b[offset++] & 0x7F);
            --len;
            if (this.isCaseInsensitive()) {
                c2 = (byte)StringUtil.lowercases[c2];
            }
            do {
                int row;
                char c3;
                if ((diff = (c3 = this._tree[row = 4 * t]) - c2) != 0) continue;
                if ((row = this._tree[row + EQ]) == 0) break block0;
                if (this._key[row] == null) continue block0;
                node = row;
                V better = this.getBest(row, b, offset, len);
                if (better == null) continue block0;
                return better;
            } while ((c = this._tree[c + ArrayTernaryTrie.hilo(diff)]) != '\u0000');
        }
        return this._value[node];
    }

    private V getBest(int t, ByteBuffer b, int offset, int len) {
        int node = t;
        int o = offset + b.position();
        block0: for (int i = 0; i < len; ++i) {
            if (o + i >= b.limit()) {
                return null;
            }
            byte c = (byte)(b.get(o + i) & 0x7F);
            if (this.isCaseInsensitive()) {
                c = (byte)StringUtil.lowercases[c];
            }
            while (true) {
                char c2;
                int row;
                char c3;
                int diff;
                if ((diff = (c3 = this._tree[row = 4 * t]) - c) == 0) {
                    if ((row = this._tree[row + EQ]) == 0) break block0;
                    if (this._key[row] == null) continue block0;
                    node = row;
                    V best = this.getBest(row, b, offset + i + 1, len - i - 1);
                    if (best == null) continue block0;
                    return best;
                }
                if ((c2 = this._tree[c2 + ArrayTernaryTrie.hilo(diff)]) == '\u0000') break block0;
            }
        }
        return this._value[node];
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder buf = new StringBuilder();
        for (int r = 0; r < this._rows; ++r) {
            if (this._key[r] == null || this._value[r] == null) continue;
            buf.append(',');
            buf.append(this._key[r]);
            buf.append('=');
            buf.append(this._value[r].toString());
        }
        if (buf.length() == 0) {
            return "{}";
        }
        buf.setCharAt(0, '{');
        buf.append('}');
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<String> keySet() {
        void var1_1;
        HashSet<String> keys = new HashSet<String>();
        for (int r = 0; r < this._rows; ++r) {
            if (this._key[r] == null || this._value[r] == null) continue;
            keys.add(this._key[r]);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public int size() {
        void var1_1;
        int s = 0;
        for (int r = 0; r < this._rows; ++r) {
            if (this._key[r] == null || this._value[r] == null) continue;
            ++s;
        }
        return (int)var1_1;
    }

    public boolean isEmpty() {
        for (int r = 0; r < this._rows; ++r) {
            if (this._key[r] == null || this._value[r] == null) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public Set<Map.Entry<String, V>> entrySet() {
        void var1_1;
        HashSet<AbstractMap.SimpleEntry<String, V>> entries = new HashSet<AbstractMap.SimpleEntry<String, V>>();
        for (int r = 0; r < this._rows; ++r) {
            if (this._key[r] == null || this._value[r] == null) continue;
            entries.add(new AbstractMap.SimpleEntry<String, V>(this._key[r], this._value[r]));
        }
        return var1_1;
    }

    @Override
    public boolean isFull() {
        return this._rows == this._key.length;
    }

    public static int hilo(int diff) {
        int n;
        return 1 + (n | Integer.MAX_VALUE) / 0x3FFFFFFF;
    }

    /*
     * WARNING - void declaration
     */
    public void dump() {
        for (int r = 0; r < this._rows; ++r) {
            void var2_2;
            char c = this._tree[r << 2];
            System.err.printf("%4d [%s,%d,%d,%d] '%s':%s%n", r, c < ' ' || c > '\u007f' ? "" + c : "'" + (char)var2_2 + "'", (int)this._tree[(r << 2) + LO], (int)this._tree[(r << 2) + EQ], (int)this._tree[(r << 2) + HI], this._key[r], this._value[r]);
        }
    }

    public static class Growing<V>
    implements Trie<V> {
        private final int _growby;
        private ArrayTernaryTrie<V> _trie;

        public Growing() {
            this(1024, 1024);
        }

        /*
         * WARNING - void declaration
         */
        public Growing(int capacity, int growby) {
            void var1_1;
            void var2_2;
            this._growby = var2_2;
            this._trie = new ArrayTernaryTrie((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public Growing(boolean insensitive, int capacity, int growby) {
            void var2_2;
            void var1_1;
            void var3_3;
            this._growby = var3_3;
            this._trie = new ArrayTernaryTrie((boolean)var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean put(V v) {
            void var1_1;
            return this.put(v.toString(), var1_1);
        }

        public int hashCode() {
            return this._trie.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V remove(String s) {
            void var1_1;
            return this._trie.remove((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V get(String s) {
            void var1_1;
            return this._trie.get((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V get(ByteBuffer b) {
            void var1_1;
            return this._trie.get((ByteBuffer)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V getBest(byte[] b, int offset, int len) {
            void var3_3;
            void var2_2;
            void var1_1;
            return ((AbstractTrie)this._trie).getBest((byte[])var1_1, (int)var2_2, (int)var3_3);
        }

        @Override
        public boolean isCaseInsensitive() {
            return this._trie.isCaseInsensitive();
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object obj) {
            void var1_1;
            return this._trie.equals(var1_1);
        }

        @Override
        public void clear() {
            this._trie.clear();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean put(String s, V v) {
            boolean bl;
            boolean added = this._trie.put(s, v);
            while (!added && this._growby > 0) {
                void var3_4;
                int newCapacity = ((ArrayTernaryTrie)this._trie)._key.length + this._growby;
                if (newCapacity > 65534) {
                    return false;
                }
                ArrayTernaryTrie<V> bigger = new ArrayTernaryTrie<V>(this._trie.isCaseInsensitive(), newCapacity);
                for (Map.Entry<String, V> entry : this._trie.entrySet()) {
                    bigger.put(entry.getKey(), entry.getValue());
                }
                this._trie = var3_4;
                bl = this._trie.put(s, v);
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V get(String s, int offset, int len) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this._trie.get((String)var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V get(ByteBuffer b, int offset, int len) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this._trie.get((ByteBuffer)var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V getBest(String s) {
            void var1_1;
            return ((AbstractTrie)this._trie).getBest((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V getBest(String s, int offset, int length) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this._trie.getBest((String)var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V getBest(ByteBuffer b, int offset, int len) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this._trie.getBest((ByteBuffer)var1_1, (int)var2_2, (int)var3_3);
        }

        public String toString() {
            return this._trie.toString();
        }

        @Override
        public Set<String> keySet() {
            return this._trie.keySet();
        }

        @Override
        public boolean isFull() {
            return false;
        }

        public void dump() {
            this._trie.dump();
        }

        public boolean isEmpty() {
            return this._trie.isEmpty();
        }

        public int size() {
            return this._trie.size();
        }
    }
}

