/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.logging.Log;

public class Jdk14Logger
implements Serializable,
Log {
    private static final long serialVersionUID = 4784713551416303804L;
    protected static final Level dummyLevel = Level.FINE;
    protected transient Logger logger = null;
    protected String name = null;

    /*
     * WARNING - void declaration
     */
    public Jdk14Logger(String name) {
        void var1_1;
        this.name = var1_1;
        this.logger = this.getLogger();
    }

    /*
     * WARNING - void declaration
     */
    protected void log(Level level, String msg, Throwable ex) {
        Logger logger = this.getLogger();
        if (logger.isLoggable(level)) {
            void var3_3;
            void var2_2;
            void var1_1;
            Serializable serializable = new Throwable();
            StackTraceElement[] locations = serializable.getStackTrace();
            String cname = this.name;
            String method = "unknown";
            if (locations != null && locations.length > 2) {
                serializable = locations[2];
                method = ((StackTraceElement)serializable).getMethodName();
            }
            if (ex == null) {
                logger.logp(level, cname, method, msg);
                return;
            }
            logger.logp((Level)var1_1, cname, method, (String)var2_2, (Throwable)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void debug(Object message) {
        void var1_1;
        this.log(Level.FINE, String.valueOf(var1_1), null);
    }

    /*
     * WARNING - void declaration
     */
    public void debug(Object message, Throwable exception) {
        void var2_2;
        void var1_1;
        this.log(Level.FINE, String.valueOf(var1_1), (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void error(Object message) {
        void var1_1;
        this.log(Level.SEVERE, String.valueOf(var1_1), null);
    }

    /*
     * WARNING - void declaration
     */
    public void error(Object message, Throwable exception) {
        void var2_2;
        void var1_1;
        this.log(Level.SEVERE, String.valueOf(var1_1), (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void fatal(Object message) {
        void var1_1;
        this.log(Level.SEVERE, String.valueOf(var1_1), null);
    }

    /*
     * WARNING - void declaration
     */
    public void fatal(Object message, Throwable exception) {
        void var2_2;
        void var1_1;
        this.log(Level.SEVERE, String.valueOf(var1_1), (Throwable)var2_2);
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger(this.name);
        }
        return this.logger;
    }

    /*
     * WARNING - void declaration
     */
    public void info(Object message) {
        void var1_1;
        this.log(Level.INFO, String.valueOf(var1_1), null);
    }

    /*
     * WARNING - void declaration
     */
    public void info(Object message, Throwable exception) {
        void var2_2;
        void var1_1;
        this.log(Level.INFO, String.valueOf(var1_1), (Throwable)var2_2);
    }

    public boolean isDebugEnabled() {
        return this.getLogger().isLoggable(Level.FINE);
    }

    public boolean isErrorEnabled() {
        return this.getLogger().isLoggable(Level.SEVERE);
    }

    public boolean isFatalEnabled() {
        return this.getLogger().isLoggable(Level.SEVERE);
    }

    public boolean isInfoEnabled() {
        return this.getLogger().isLoggable(Level.INFO);
    }

    public boolean isTraceEnabled() {
        return this.getLogger().isLoggable(Level.FINEST);
    }

    public boolean isWarnEnabled() {
        return this.getLogger().isLoggable(Level.WARNING);
    }

    /*
     * WARNING - void declaration
     */
    public void trace(Object message) {
        void var1_1;
        this.log(Level.FINEST, String.valueOf(var1_1), null);
    }

    /*
     * WARNING - void declaration
     */
    public void trace(Object message, Throwable exception) {
        void var2_2;
        void var1_1;
        this.log(Level.FINEST, String.valueOf(var1_1), (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void warn(Object message) {
        void var1_1;
        this.log(Level.WARNING, String.valueOf(var1_1), null);
    }

    /*
     * WARNING - void declaration
     */
    public void warn(Object message, Throwable exception) {
        void var2_2;
        void var1_1;
        this.log(Level.WARNING, String.valueOf(var1_1), (Throwable)var2_2);
    }
}

