/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging;

import java.lang.reflect.Constructor;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.NoOpLog;

public class LogSource {
    protected static Hashtable logs = new Hashtable();
    protected static boolean log4jIsAvailable = false;
    protected static boolean jdk14IsAvailable = false;
    protected static Constructor logImplctor = null;

    private LogSource() {
    }

    /*
     * WARNING - void declaration
     */
    public static void setLogImplementation(String classname) throws LinkageError, NoSuchMethodException, SecurityException, ClassNotFoundException {
        try {
            void var1_1;
            Class<?> clazz;
            Class<?> logclass = Class.forName(classname);
            Class[] classArray = new Class[1];
            Class[] argtypes = classArray;
            classArray[0] = "".getClass();
            logImplctor = clazz.getConstructor((Class<?>)var1_1);
            return;
        }
        catch (Throwable throwable) {
            logImplctor = null;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void setLogImplementation(Class logclass) throws LinkageError, ExceptionInInitializerError, NoSuchMethodException, SecurityException {
        void var1_1;
        Class clazz;
        Class[] classArray = new Class[1];
        Class[] argtypes = classArray;
        classArray[0] = "".getClass();
        logImplctor = clazz.getConstructor((Class<?>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Log getInstance(String name) {
        void var1_1;
        Log log = (Log)logs.get(name);
        if (log == null) {
            String string;
            log = LogSource.makeNewLogInstance(name);
            logs.put(string, log);
        }
        return var1_1;
    }

    public static Log getInstance(Class clazz) {
        return LogSource.getInstance(clazz.getName());
    }

    /*
     * WARNING - void declaration
     */
    public static Log makeNewLogInstance(String name) {
        void var1_1;
        Log log;
        try {
            Object[] args = new Object[]{name};
            log = (Log)logImplctor.newInstance(args);
        }
        catch (Throwable throwable) {
            log = null;
        }
        if (log == null) {
            String string;
            log = new NoOpLog(string);
        }
        return var1_1;
    }

    public static String[] getLogNames() {
        return logs.keySet().toArray(new String[logs.size()]);
    }

    /*
     * WARNING - void declaration
     */
    static {
        try {
            log4jIsAvailable = null != Class.forName("org.apache.log4j.Logger");
        }
        catch (Throwable throwable) {
            log4jIsAvailable = false;
        }
        try {
            jdk14IsAvailable = null != Class.forName("java.util.logging.Logger") && null != Class.forName("org.apache.commons.logging.impl.Jdk14Logger");
        }
        catch (Throwable throwable) {
            jdk14IsAvailable = false;
        }
        String name = null;
        try {
            name = System.getProperty("org.apache.commons.logging.log");
            if (name == null) {
                name = System.getProperty("org.apache.commons.logging.Log");
            }
        }
        catch (Throwable throwable) {}
        if (name != null) {
            try {
                void var0;
                LogSource.setLogImplementation((String)var0);
            }
            catch (Throwable throwable) {
                try {
                    LogSource.setLogImplementation("org.apache.commons.logging.impl.NoOpLog");
                }
                catch (Throwable throwable2) {}
            }
        } else {
            try {
                if (log4jIsAvailable) {
                    LogSource.setLogImplementation("org.apache.commons.logging.impl.Log4JLogger");
                } else if (jdk14IsAvailable) {
                    LogSource.setLogImplementation("org.apache.commons.logging.impl.Jdk14Logger");
                } else {
                    LogSource.setLogImplementation("org.apache.commons.logging.impl.NoOpLog");
                }
            }
            catch (Throwable throwable) {
                try {
                    LogSource.setLogImplementation("org.apache.commons.logging.impl.NoOpLog");
                }
                catch (Throwable throwable3) {}
            }
        }
    }
}

