/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.channel.epoll.AbstractEpollChannel;
import io.netty.channel.epoll.Native;
import io.netty.util.internal.ObjectUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

final class TcpMd5Util {
    /*
     * WARNING - void declaration
     */
    static Collection<InetAddress> newTcpMd5Sigs(AbstractEpollChannel channel, Collection<InetAddress> current, Map<InetAddress, byte[]> newKeys) throws IOException {
        void var2_2;
        void var1_1;
        ObjectUtil.checkNotNull((Object)((Object)channel), (String)"channel");
        ObjectUtil.checkNotNull(current, (String)"current");
        ObjectUtil.checkNotNull(newKeys, (String)"newKeys");
        for (Map.Entry<InetAddress, byte[]> e : newKeys.entrySet()) {
            byte[] key = e.getValue();
            ObjectUtil.checkNotNullWithIAE((Object)e.getKey(), (String)"e.getKey");
            ObjectUtil.checkNonEmpty((byte[])key, (String)e.getKey().toString());
            if (key.length <= Native.TCP_MD5SIG_MAXKEYLEN) continue;
            throw new IllegalArgumentException("newKeys[" + e.getKey() + "] has a key with invalid length; should not exceed the maximum length (" + Native.TCP_MD5SIG_MAXKEYLEN + ')');
        }
        Iterator<Map.Entry<InetAddress, Object>> iterator = var1_1.iterator();
        while (iterator.hasNext()) {
            InetAddress addr = (InetAddress)((Object)iterator.next());
            if (newKeys.containsKey(addr)) continue;
            channel.socket.setTcpMd5Sig(addr, null);
        }
        if (newKeys.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList addresses = new ArrayList(newKeys.size());
        for (Map.Entry e : var2_2.entrySet()) {
            channel.socket.setTcpMd5Sig((InetAddress)e.getKey(), (byte[])e.getValue());
            addresses.add(e.getKey());
        }
        return iterator;
    }

    private TcpMd5Util() {
    }
}

