/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.unix.IovArray;
import io.netty.channel.unix.Limits;
import io.netty.channel.unix.NativeInetAddress;
import io.netty.channel.unix.SegmentedDatagramPacket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

final class NativeDatagramPacketArray {
    private final NativeDatagramPacket[] packets = new NativeDatagramPacket[Limits.UIO_MAX_IOV];
    private final IovArray iovArray = new IovArray();
    private final byte[] ipv4Bytes = new byte[4];
    private final MyMessageProcessor processor = new MyMessageProcessor();
    private int count;

    NativeDatagramPacketArray() {
        for (int i = 0; i < this.packets.length; ++i) {
            this.packets[i] = new NativeDatagramPacket(this);
        }
    }

    /*
     * WARNING - void declaration
     */
    final boolean addWritable(ByteBuf buf, int index, int len) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.add0((ByteBuf)var1_1, (int)var2_2, (int)var3_3, 0, null);
    }

    /*
     * WARNING - void declaration
     */
    private boolean add0(ByteBuf buf, int index, int len, int segmentLen, InetSocketAddress recipient) {
        void var3_3;
        void var2_2;
        NativeDatagramPacket nativeDatagramPacket;
        if (this.count == this.packets.length) {
            return false;
        }
        if (len == 0) {
            return true;
        }
        int offset = this.iovArray.count();
        if (offset == Limits.IOV_MAX || !this.iovArray.add((ByteBuf)nativeDatagramPacket, (int)var2_2, (int)var3_3)) {
            return false;
        }
        nativeDatagramPacket = this.packets[this.count];
        NativeDatagramPacket.access$100(nativeDatagramPacket, this.iovArray.memoryAddress(offset), this.iovArray.count() - offset, segmentLen, recipient);
        ++this.count;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    final void add(ChannelOutboundBuffer buffer, boolean connected, int maxMessagesPerWrite) throws Exception {
        void var1_1;
        void var3_3;
        void var2_2;
        MyMessageProcessor.access$202(this.processor, (boolean)var2_2);
        MyMessageProcessor.access$302(this.processor, (int)var3_3);
        var1_1.forEachFlushedMessage((ChannelOutboundBuffer.MessageProcessor)this.processor);
    }

    final int count() {
        return this.count;
    }

    final NativeDatagramPacket[] packets() {
        return this.packets;
    }

    final void clear() {
        this.count = 0;
        this.iovArray.clear();
    }

    final void release() {
        this.iovArray.release();
    }

    /*
     * WARNING - void declaration
     */
    private static InetSocketAddress newAddress(byte[] addr, int addrLen, int port, int scopeId, byte[] ipv4Bytes) throws UnknownHostException {
        void var2_2;
        Object object;
        Object address;
        if (addrLen == ipv4Bytes.length) {
            void var1_1;
            System.arraycopy(addr, 0, ipv4Bytes, 0, (int)var1_1);
            address = InetAddress.getByAddress(ipv4Bytes);
        } else {
            void var3_3;
            address = Inet6Address.getByAddress(null, address, (int)var3_3);
        }
        return new InetSocketAddress((InetAddress)object, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$400(NativeDatagramPacketArray x0, ByteBuf x1, int x2, int x3, int x4, InetSocketAddress x5) {
        void var3_3;
        void var2_2;
        void var1_1;
        return x0.add0((ByteBuf)var1_1, (int)var2_2, (int)var3_3, x4, x5);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ InetSocketAddress access$600(byte[] x0, int x1, int x2, int x3, byte[] x4) throws UnknownHostException {
        void var3_3;
        void var2_2;
        void var1_1;
        return NativeDatagramPacketArray.newAddress(x0, (int)var1_1, (int)var2_2, (int)var3_3, x4);
    }

    public final class NativeDatagramPacket {
        private long memoryAddress;
        private int count;
        private final byte[] senderAddr = new byte[16];
        private int senderAddrLen;
        private int senderScopeId;
        private int senderPort;
        private final byte[] recipientAddr = new byte[16];
        private int recipientAddrLen;
        private int recipientScopeId;
        private int recipientPort;
        private int segmentSize;
        final /* synthetic */ NativeDatagramPacketArray this$0;

        /*
         * WARNING - void declaration
         */
        public NativeDatagramPacket(NativeDatagramPacketArray this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private void init(long memoryAddress, int count, int segmentSize, InetSocketAddress recipient) {
            void var3_3;
            this.memoryAddress = memoryAddress;
            this.count = var3_3;
            this.segmentSize = segmentSize;
            this.senderScopeId = 0;
            this.senderPort = 0;
            this.senderAddrLen = 0;
            if (recipient == null) {
                this.recipientScopeId = 0;
                this.recipientPort = 0;
                this.recipientAddrLen = 0;
                return;
            }
            InetAddress address = recipient.getAddress();
            if (address instanceof Inet6Address) {
                System.arraycopy(address.getAddress(), 0, this.recipientAddr, 0, this.recipientAddr.length);
                this.recipientScopeId = ((Inet6Address)address).getScopeId();
            } else {
                void var1_2;
                NativeInetAddress.copyIpv4MappedIpv6Address((byte[])var1_2.getAddress(), (byte[])this.recipientAddr);
                this.recipientScopeId = 0;
            }
            this.recipientAddrLen = this.recipientAddr.length;
            this.recipientPort = recipient.getPort();
        }

        final boolean hasSender() {
            return this.senderPort > 0;
        }

        /*
         * WARNING - void declaration
         */
        final DatagramPacket newDatagramPacket(ByteBuf buffer, InetSocketAddress recipient) throws UnknownHostException {
            void var3_3;
            void var2_2;
            void var1_1;
            InetSocketAddress sender = NativeDatagramPacketArray.access$600(this.senderAddr, this.senderAddrLen, this.senderPort, this.senderScopeId, this.this$0.ipv4Bytes);
            if (this.recipientAddrLen != 0) {
                recipient = NativeDatagramPacketArray.access$600(this.recipientAddr, this.recipientAddrLen, this.recipientPort, this.recipientScopeId, this.this$0.ipv4Bytes);
            }
            ByteBuf byteBuf = buffer;
            ByteBuf slice = byteBuf.retainedSlice(byteBuf.readerIndex(), this.count);
            if (this.segmentSize > 0) {
                return new SegmentedDatagramPacket(slice, this.segmentSize, recipient, sender);
            }
            return new DatagramPacket((ByteBuf)var1_1, (InetSocketAddress)var2_2, (InetSocketAddress)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$100(NativeDatagramPacket x0, long x1, int x2, int x3, InetSocketAddress x4) {
            void var3_2;
            void var1_1;
            x0.init((long)var1_1, (int)var3_2, x3, x4);
        }
    }

    private final class MyMessageProcessor
    implements ChannelOutboundBuffer.MessageProcessor {
        private boolean connected;
        private int maxMessagesPerWrite;

        private MyMessageProcessor() {
        }

        /*
         * WARNING - void declaration
         */
        public final boolean processMessage(Object msg) {
            void var1_2;
            void added;
            boolean added2;
            if (msg instanceof DatagramPacket) {
                void var3_4;
                void var2_3;
                DatagramPacket packet = (DatagramPacket)msg;
                ByteBuf buf = (ByteBuf)packet.content();
                int segmentSize = 0;
                if (packet instanceof SegmentedDatagramPacket) {
                    int seg = ((SegmentedDatagramPacket)packet).segmentSize();
                    if (buf.readableBytes() > seg) {
                        segmentSize = seg;
                    }
                }
                ByteBuf byteBuf = buf;
                added2 = NativeDatagramPacketArray.access$400(NativeDatagramPacketArray.this, byteBuf, byteBuf.readerIndex(), var2_3.readableBytes(), (int)var3_4, (InetSocketAddress)packet.recipient());
            } else if (added instanceof ByteBuf && this.connected) {
                ByteBuf buf;
                ByteBuf byteBuf = buf = (ByteBuf)added;
                added2 = NativeDatagramPacketArray.access$400(NativeDatagramPacketArray.this, byteBuf, byteBuf.readerIndex(), buf.readableBytes(), 0, null);
            } else {
                added2 = false;
            }
            if (var1_2 != false) {
                --this.maxMessagesPerWrite;
                return this.maxMessagesPerWrite > 0;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ boolean access$202(MyMessageProcessor x0, boolean x1) {
            void var1_1;
            x0.connected = var1_1;
            return x0.connected;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ int access$302(MyMessageProcessor x0, int x1) {
            void var1_1;
            x0.maxMessagesPerWrite = var1_1;
            return x0.maxMessagesPerWrite;
        }
    }
}

