/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.channel.DefaultFileRegion;
import io.netty.channel.epoll.EpollEventArray;
import io.netty.channel.epoll.NativeDatagramPacketArray;
import io.netty.channel.epoll.NativeStaticallyReferencedJniMethods;
import io.netty.channel.unix.Errors;
import io.netty.channel.unix.FileDescriptor;
import io.netty.channel.unix.PeerCredentials;
import io.netty.channel.unix.Socket;
import io.netty.channel.unix.Unix;
import io.netty.util.internal.ClassInitializerUtil;
import io.netty.util.internal.NativeLibraryLoader;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.ThrowableUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.channels.FileChannel;
import java.nio.channels.Selector;

public final class Native {
    private static final InternalLogger logger;
    static final InetAddress INET6_ANY;
    static final InetAddress INET_ANY;
    public static final int EPOLLIN;
    public static final int EPOLLOUT;
    public static final int EPOLLRDHUP;
    public static final int EPOLLET;
    public static final int EPOLLERR;
    public static final boolean IS_SUPPORTING_SENDMMSG;
    static final boolean IS_SUPPORTING_RECVMMSG;
    static final boolean IS_SUPPORTING_UDP_SEGMENT;
    private static final int TFO_ENABLED_CLIENT_MASK = 1;
    private static final int TFO_ENABLED_SERVER_MASK = 2;
    private static final int TCP_FASTOPEN_MODE;
    static final boolean IS_SUPPORTING_TCP_FASTOPEN_CLIENT;
    static final boolean IS_SUPPORTING_TCP_FASTOPEN_SERVER;
    @Deprecated
    public static final boolean IS_SUPPORTING_TCP_FASTOPEN;
    public static final int TCP_MD5SIG_MAXKEYLEN;
    public static final String KERNEL_VERSION;

    private static native int registerUnix();

    public static FileDescriptor newEventFd() {
        return new FileDescriptor(Native.eventFd());
    }

    public static FileDescriptor newTimerFd() {
        return new FileDescriptor(Native.timerFd());
    }

    private static native boolean isSupportingUdpSegment();

    private static native int eventFd();

    private static native int timerFd();

    public static native void eventFdWrite(int var0, long var1);

    public static native void eventFdRead(int var0);

    public static FileDescriptor newEpollCreate() {
        return new FileDescriptor(Native.epollCreate());
    }

    private static native int epollCreate();

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static int epollWait(FileDescriptor epollFd, EpollEventArray events, FileDescriptor timerFd, int timeoutSec, int timeoutNs) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        long l = Native.epollWait(epollFd, (EpollEventArray)var1_1, (FileDescriptor)var2_2, (int)var3_3, timeoutNs, -1L);
        return Native.epollReady(l);
    }

    /*
     * WARNING - void declaration
     */
    static long epollWait(FileDescriptor epollFd, EpollEventArray events, FileDescriptor timerFd, int timeoutSec, int timeoutNs, long millisThreshold) throws IOException {
        void var3_4;
        void var2_3;
        void var1_2;
        long result;
        int ready;
        if (timeoutSec == 0 && timeoutNs == 0) {
            return (long)Native.epollWait(epollFd, events, 0) << 32;
        }
        if (timeoutSec == Integer.MAX_VALUE) {
            timeoutSec = 0;
            timeoutNs = 0;
        }
        if ((ready = Native.epollReady(result = Native.epollWait0(epollFd.intValue(), events.memoryAddress(), var1_2.length(), var2_3.intValue(), (int)var3_4, timeoutNs, millisThreshold))) < 0) {
            void var0_1;
            throw Errors.newIOException((String)"epoll_wait", (int)var0_1);
        }
        return result;
    }

    static int epollReady(long result) {
        return (int)(result >> 32);
    }

    static boolean epollTimerWasUsed(long result) {
        return (result & 0xFFL) != 0L;
    }

    /*
     * WARNING - void declaration
     */
    static int epollWait(FileDescriptor epollFd, EpollEventArray events, boolean immediatePoll) throws IOException {
        void var2_2;
        void var1_1;
        return Native.epollWait(epollFd, (EpollEventArray)var1_1, var2_2 != false ? 0 : -1);
    }

    /*
     * WARNING - void declaration
     */
    static int epollWait(FileDescriptor epollFd, EpollEventArray events, int timeoutMillis) throws IOException {
        void var0_1;
        void var2_3;
        void var1_2;
        int ready = Native.epollWait(epollFd.intValue(), events.memoryAddress(), var1_2.length(), (int)var2_3);
        if (ready < 0) {
            throw Errors.newIOException((String)"epoll_wait", (int)ready);
        }
        return (int)var0_1;
    }

    /*
     * WARNING - void declaration
     */
    public static int epollBusyWait(FileDescriptor epollFd, EpollEventArray events) throws IOException {
        void var0_1;
        void var1_2;
        int ready = Native.epollBusyWait0(epollFd.intValue(), events.memoryAddress(), var1_2.length());
        if (ready < 0) {
            throw Errors.newIOException((String)"epoll_wait", (int)ready);
        }
        return (int)var0_1;
    }

    private static native long epollWait0(int var0, long var1, int var3, int var4, int var5, int var6, long var7);

    private static native int epollWait(int var0, long var1, int var3, int var4);

    private static native int epollBusyWait0(int var0, long var1, int var3);

    /*
     * WARNING - void declaration
     */
    public static void epollCtlAdd(int efd, int fd, int flags) throws IOException {
        void var2_2;
        void var1_1;
        int res = Native.epollCtlAdd0(efd, (int)var1_1, (int)var2_2);
        if (res < 0) {
            int n;
            throw Errors.newIOException((String)"epoll_ctl", (int)n);
        }
    }

    private static native int epollCtlAdd0(int var0, int var1, int var2);

    /*
     * WARNING - void declaration
     */
    public static void epollCtlMod(int efd, int fd, int flags) throws IOException {
        void var2_2;
        void var1_1;
        int res = Native.epollCtlMod0(efd, (int)var1_1, (int)var2_2);
        if (res < 0) {
            int n;
            throw Errors.newIOException((String)"epoll_ctl", (int)n);
        }
    }

    private static native int epollCtlMod0(int var0, int var1, int var2);

    /*
     * WARNING - void declaration
     */
    public static void epollCtlDel(int efd, int fd) throws IOException {
        void var1_1;
        int res = Native.epollCtlDel0(efd, (int)var1_1);
        if (res < 0) {
            int n;
            throw Errors.newIOException((String)"epoll_ctl", (int)n);
        }
    }

    private static native int epollCtlDel0(int var0, int var1);

    /*
     * WARNING - void declaration
     */
    public static int splice(int fd, long offIn, int fdOut, long offOut, long len) throws IOException {
        int n;
        void var3_2;
        void var1_1;
        int res = Native.splice0(fd, (long)var1_1, (int)var3_2, offOut, len);
        if (res >= 0) {
            return res;
        }
        return Errors.ioResult((String)"splice", (int)n);
    }

    private static native int splice0(int var0, long var1, int var3, long var4, long var6);

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static int sendmmsg(int fd, NativeDatagramPacketArray.NativeDatagramPacket[] msgs, int offset, int len) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        return Native.sendmmsg(fd, Socket.isIPv6Preferred(), (NativeDatagramPacketArray.NativeDatagramPacket[])var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static int sendmmsg(int fd, boolean ipv6, NativeDatagramPacketArray.NativeDatagramPacket[] msgs, int offset, int len) throws IOException {
        int n;
        void var3_3;
        void var2_2;
        void var1_1;
        int res = Native.sendmmsg0(fd, (boolean)var1_1, (NativeDatagramPacketArray.NativeDatagramPacket[])var2_2, (int)var3_3, len);
        if (res >= 0) {
            return res;
        }
        return Errors.ioResult((String)"sendmmsg", (int)n);
    }

    private static native int sendmmsg0(int var0, boolean var1, NativeDatagramPacketArray.NativeDatagramPacket[] var2, int var3, int var4);

    /*
     * WARNING - void declaration
     */
    static int recvmmsg(int fd, boolean ipv6, NativeDatagramPacketArray.NativeDatagramPacket[] msgs, int offset, int len) throws IOException {
        int n;
        void var3_3;
        void var2_2;
        void var1_1;
        int res = Native.recvmmsg0(fd, (boolean)var1_1, (NativeDatagramPacketArray.NativeDatagramPacket[])var2_2, (int)var3_3, len);
        if (res >= 0) {
            return res;
        }
        return Errors.ioResult((String)"recvmmsg", (int)n);
    }

    private static native int recvmmsg0(int var0, boolean var1, NativeDatagramPacketArray.NativeDatagramPacket[] var2, int var3, int var4);

    /*
     * WARNING - void declaration
     */
    static int recvmsg(int fd, boolean ipv6, NativeDatagramPacketArray.NativeDatagramPacket packet) throws IOException {
        int n;
        void var2_2;
        void var1_1;
        int res = Native.recvmsg0(fd, (boolean)var1_1, (NativeDatagramPacketArray.NativeDatagramPacket)var2_2);
        if (res >= 0) {
            return res;
        }
        return Errors.ioResult((String)"recvmsg", (int)n);
    }

    private static native int recvmsg0(int var0, boolean var1, NativeDatagramPacketArray.NativeDatagramPacket var2);

    public static native int sizeofEpollEvent();

    public static native int offsetofEpollData();

    /*
     * WARNING - void declaration
     */
    private static void loadNativeLibrary() {
        String name = PlatformDependent.normalizedOs();
        if (!"linux".equals(name)) {
            throw new IllegalStateException("Only supported on Linux");
        }
        String staticLibName = "netty_transport_native_epoll";
        String sharedLibName = staticLibName + '_' + PlatformDependent.normalizedArch();
        ClassLoader cl = PlatformDependent.getClassLoader(Native.class);
        try {
            NativeLibraryLoader.load((String)sharedLibName, (ClassLoader)cl);
            return;
        }
        catch (UnsatisfiedLinkError e1) {
            try {
                void var1_2;
                void var2_3;
                NativeLibraryLoader.load((String)staticLibName, (ClassLoader)var2_3);
                logger.debug("Failed to load {}", (Object)var1_2, (Object)e1);
                return;
            }
            catch (UnsatisfiedLinkError e2) {
                void var3_4;
                void var0_1;
                ThrowableUtil.addSuppressed((Throwable)e1, (Throwable)var0_1);
                throw var3_4;
            }
        }
    }

    private Native() {
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    static {
        block17: {
            void var0;
            logger = InternalLoggerFactory.getInstance(Native.class);
            Selector selector = null;
            try {
                selector = Selector.open();
            }
            catch (IOException iOException) {}
            try {
                INET_ANY = InetAddress.getByName("0.0.0.0");
                INET6_ANY = InetAddress.getByName("::");
            }
            catch (UnknownHostException e) {
                void var0_1;
                throw new ExceptionInInitializerError((Throwable)var0_1);
            }
            ClassInitializerUtil.tryLoadClasses(Native.class, (Class[])new Class[]{PeerCredentials.class, DefaultFileRegion.class, FileChannel.class, java.io.FileDescriptor.class, NativeDatagramPacketArray.NativeDatagramPacket.class});
            Native.offsetofEpollData();
            try {
                if (var0 != null) {
                    var0.close();
                }
                break block17;
            }
            catch (IOException iOException) {}
            break block17;
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                try {
                    Native.loadNativeLibrary();
                }
                catch (Throwable throwable) {
                    try {
                        if (var0 != null) {
                            var0.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (var0 != null) {
                        var0.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        Unix.registerInternal((Runnable)new Runnable(){

            @Override
            public final void run() {
                Native.registerUnix();
            }
        });
        EPOLLIN = NativeStaticallyReferencedJniMethods.epollin();
        EPOLLOUT = NativeStaticallyReferencedJniMethods.epollout();
        EPOLLRDHUP = NativeStaticallyReferencedJniMethods.epollrdhup();
        EPOLLET = NativeStaticallyReferencedJniMethods.epollet();
        EPOLLERR = NativeStaticallyReferencedJniMethods.epollerr();
        IS_SUPPORTING_SENDMMSG = NativeStaticallyReferencedJniMethods.isSupportingSendmmsg();
        IS_SUPPORTING_RECVMMSG = NativeStaticallyReferencedJniMethods.isSupportingRecvmmsg();
        IS_SUPPORTING_UDP_SEGMENT = Native.isSupportingUdpSegment();
        TCP_FASTOPEN_MODE = NativeStaticallyReferencedJniMethods.tcpFastopenMode();
        IS_SUPPORTING_TCP_FASTOPEN_CLIENT = (TCP_FASTOPEN_MODE & 1) == 1;
        IS_SUPPORTING_TCP_FASTOPEN_SERVER = (TCP_FASTOPEN_MODE & 2) == 2;
        IS_SUPPORTING_TCP_FASTOPEN = IS_SUPPORTING_TCP_FASTOPEN_CLIENT || IS_SUPPORTING_TCP_FASTOPEN_SERVER;
        TCP_MD5SIG_MAXKEYLEN = NativeStaticallyReferencedJniMethods.tcpMd5SigMaxKeyLen();
        KERNEL_VERSION = NativeStaticallyReferencedJniMethods.kernelVersion();
    }
}

