/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.channel.ChannelException;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.epoll.EpollTcpInfo;
import io.netty.channel.epoll.Native;
import io.netty.channel.epoll.NativeDatagramPacketArray;
import io.netty.channel.epoll.VSockAddress;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.unix.Errors;
import io.netty.channel.unix.NativeInetAddress;
import io.netty.channel.unix.PeerCredentials;
import io.netty.channel.unix.Socket;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SocketUtils;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;

public final class LinuxSocket
extends Socket {
    private static final long MAX_UINT32_T = 0xFFFFFFFFL;

    /*
     * WARNING - void declaration
     */
    LinuxSocket(int fd) {
        super((int)var1_1);
        void var1_1;
    }

    final InternetProtocolFamily family() {
        if (this.ipv6) {
            return InternetProtocolFamily.IPv6;
        }
        return InternetProtocolFamily.IPv4;
    }

    /*
     * WARNING - void declaration
     */
    final int sendmmsg(NativeDatagramPacketArray.NativeDatagramPacket[] msgs, int offset, int len) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        return Native.sendmmsg(this.intValue(), this.ipv6, (NativeDatagramPacketArray.NativeDatagramPacket[])var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    final int recvmmsg(NativeDatagramPacketArray.NativeDatagramPacket[] msgs, int offset, int len) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        return Native.recvmmsg(this.intValue(), this.ipv6, (NativeDatagramPacketArray.NativeDatagramPacket[])var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    final int recvmsg(NativeDatagramPacketArray.NativeDatagramPacket msg) throws IOException {
        void var1_1;
        return Native.recvmsg(this.intValue(), this.ipv6, (NativeDatagramPacketArray.NativeDatagramPacket)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final void setTimeToLive(int ttl) throws IOException {
        void var1_1;
        LinuxSocket.setTimeToLive(this.intValue(), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final void setInterface(InetAddress address) throws IOException {
        void var1_1;
        void var2_2;
        NativeInetAddress a = NativeInetAddress.newInstance((InetAddress)address);
        LinuxSocket.setInterface(this.intValue(), this.ipv6, a.address(), var2_2.scopeId(), LinuxSocket.interfaceIndex((InetAddress)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    final void setNetworkInterface(NetworkInterface netInterface) throws IOException {
        void var1_1;
        void var2_2;
        InetAddress address = LinuxSocket.deriveInetAddress(netInterface, this.family() == InternetProtocolFamily.IPv6);
        if (address.equals(this.family() == InternetProtocolFamily.IPv4 ? Native.INET_ANY : Native.INET6_ANY)) {
            throw new IOException("NetworkInterface does not support " + this.family());
        }
        NativeInetAddress nativeAddress = NativeInetAddress.newInstance((InetAddress)address);
        LinuxSocket.setInterface(this.intValue(), this.ipv6, nativeAddress.address(), var2_2.scopeId(), LinuxSocket.interfaceIndex((NetworkInterface)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    final InetAddress getInterface() throws IOException {
        Enumeration addresses;
        NetworkInterface inf = this.getNetworkInterface();
        if (inf != null && (addresses = SocketUtils.addressesFromNetworkInterface((NetworkInterface)inf)).hasMoreElements()) {
            void var1_1;
            return (InetAddress)var1_1.nextElement();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    final NetworkInterface getNetworkInterface() throws IOException {
        int ret = LinuxSocket.getInterface(this.intValue(), this.ipv6);
        if (this.ipv6) {
            if (PlatformDependent.javaVersion() >= 7) {
                return NetworkInterface.getByIndex(ret);
            }
            return null;
        }
        InetAddress address = LinuxSocket.inetAddress(ret);
        if (address != null) {
            void var1_2;
            return NetworkInterface.getByInetAddress((InetAddress)var1_2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static InetAddress inetAddress(int value) {
        byte[] var1 = new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
        try {
            void var0_1;
            return InetAddress.getByAddress((byte[])var0_1);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    final void joinGroup(InetAddress group, NetworkInterface netInterface, InetAddress source) throws IOException {
        void var2_2;
        NativeInetAddress g = NativeInetAddress.newInstance((InetAddress)group);
        boolean isIpv6 = group instanceof Inet6Address;
        NativeInetAddress i = NativeInetAddress.newInstance((InetAddress)LinuxSocket.deriveInetAddress(netInterface, isIpv6));
        if (source != null) {
            void var1_1;
            void var3_3;
            if (source.getClass() != group.getClass()) {
                throw new IllegalArgumentException("Source address is different type to group");
            }
            NativeInetAddress s = NativeInetAddress.newInstance((InetAddress)var3_3);
            LinuxSocket.joinSsmGroup(this.intValue(), this.ipv6 && isIpv6, g.address(), i.address(), g.scopeId(), LinuxSocket.interfaceIndex(netInterface), var1_1.address());
            return;
        }
        LinuxSocket.joinGroup(this.intValue(), this.ipv6 && isIpv6, g.address(), i.address(), g.scopeId(), LinuxSocket.interfaceIndex((NetworkInterface)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    final void leaveGroup(InetAddress group, NetworkInterface netInterface, InetAddress source) throws IOException {
        void var2_2;
        NativeInetAddress g = NativeInetAddress.newInstance((InetAddress)group);
        boolean isIpv6 = group instanceof Inet6Address;
        NativeInetAddress i = NativeInetAddress.newInstance((InetAddress)LinuxSocket.deriveInetAddress(netInterface, isIpv6));
        if (source != null) {
            void var1_1;
            void var3_3;
            if (source.getClass() != group.getClass()) {
                throw new IllegalArgumentException("Source address is different type to group");
            }
            NativeInetAddress s = NativeInetAddress.newInstance((InetAddress)var3_3);
            LinuxSocket.leaveSsmGroup(this.intValue(), this.ipv6 && isIpv6, g.address(), i.address(), g.scopeId(), LinuxSocket.interfaceIndex(netInterface), var1_1.address());
            return;
        }
        LinuxSocket.leaveGroup(this.intValue(), this.ipv6 && isIpv6, g.address(), i.address(), g.scopeId(), LinuxSocket.interfaceIndex((NetworkInterface)var2_2));
    }

    private static int interfaceIndex(NetworkInterface networkInterface) {
        if (PlatformDependent.javaVersion() >= 7) {
            NetworkInterface networkInterface2;
            return networkInterface2.getIndex();
        }
        return -1;
    }

    private static int interfaceIndex(InetAddress address) throws IOException {
        Object iface;
        if (PlatformDependent.javaVersion() >= 7 && (iface = NetworkInterface.getByInetAddress(address)) != null) {
            Object object;
            return ((NetworkInterface)object).getIndex();
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    final void setTcpDeferAccept(int deferAccept) throws IOException {
        void var1_1;
        LinuxSocket.setTcpDeferAccept(this.intValue(), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final void setTcpQuickAck(boolean quickAck) throws IOException {
        void var1_1;
        LinuxSocket.setTcpQuickAck(this.intValue(), var1_1 != false ? 1 : 0);
    }

    /*
     * WARNING - void declaration
     */
    final void setTcpCork(boolean tcpCork) throws IOException {
        void var1_1;
        LinuxSocket.setTcpCork(this.intValue(), var1_1 != false ? 1 : 0);
    }

    /*
     * WARNING - void declaration
     */
    final void setSoBusyPoll(int loopMicros) throws IOException {
        void var1_1;
        LinuxSocket.setSoBusyPoll(this.intValue(), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final void setTcpNotSentLowAt(long tcpNotSentLowAt) throws IOException {
        void var1_1;
        if (tcpNotSentLowAt < 0L || tcpNotSentLowAt > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("tcpNotSentLowAt must be a uint32_t");
        }
        LinuxSocket.setTcpNotSentLowAt(this.intValue(), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final void setTcpFastOpen(int tcpFastopenBacklog) throws IOException {
        void var1_1;
        LinuxSocket.setTcpFastOpen(this.intValue(), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final void setTcpKeepIdle(int seconds) throws IOException {
        void var1_1;
        LinuxSocket.setTcpKeepIdle(this.intValue(), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final void setTcpKeepIntvl(int seconds) throws IOException {
        void var1_1;
        LinuxSocket.setTcpKeepIntvl(this.intValue(), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final void setTcpKeepCnt(int probes) throws IOException {
        void var1_1;
        LinuxSocket.setTcpKeepCnt(this.intValue(), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final void setTcpUserTimeout(int milliseconds) throws IOException {
        void var1_1;
        LinuxSocket.setTcpUserTimeout(this.intValue(), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final void setIpBindAddressNoPort(boolean enabled) throws IOException {
        void var1_1;
        LinuxSocket.setIpBindAddressNoPort(this.intValue(), var1_1 != false ? 1 : 0);
    }

    /*
     * WARNING - void declaration
     */
    final void setIpFreeBind(boolean enabled) throws IOException {
        void var1_1;
        LinuxSocket.setIpFreeBind(this.intValue(), var1_1 != false ? 1 : 0);
    }

    /*
     * WARNING - void declaration
     */
    final void setIpTransparent(boolean enabled) throws IOException {
        void var1_1;
        LinuxSocket.setIpTransparent(this.intValue(), var1_1 != false ? 1 : 0);
    }

    /*
     * WARNING - void declaration
     */
    final void setIpRecvOrigDestAddr(boolean enabled) throws IOException {
        void var1_1;
        LinuxSocket.setIpRecvOrigDestAddr(this.intValue(), var1_1 != false ? 1 : 0);
    }

    final int getTimeToLive() throws IOException {
        return LinuxSocket.getTimeToLive(this.intValue());
    }

    /*
     * WARNING - void declaration
     */
    final void getTcpInfo(EpollTcpInfo info) throws IOException {
        void var1_1;
        LinuxSocket.getTcpInfo(this.intValue(), var1_1.info);
    }

    /*
     * WARNING - void declaration
     */
    final void setTcpMd5Sig(InetAddress address, byte[] key) throws IOException {
        void var2_2;
        void var1_1;
        NativeInetAddress a = NativeInetAddress.newInstance((InetAddress)address);
        LinuxSocket.setTcpMd5Sig(this.intValue(), this.ipv6, a.address(), var1_1.scopeId(), (byte[])var2_2);
    }

    final boolean isTcpCork() throws IOException {
        return LinuxSocket.isTcpCork(this.intValue()) != 0;
    }

    final int getSoBusyPoll() throws IOException {
        return LinuxSocket.getSoBusyPoll(this.intValue());
    }

    final int getTcpDeferAccept() throws IOException {
        return LinuxSocket.getTcpDeferAccept(this.intValue());
    }

    final boolean isTcpQuickAck() throws IOException {
        return LinuxSocket.isTcpQuickAck(this.intValue()) != 0;
    }

    final long getTcpNotSentLowAt() throws IOException {
        return (long)LinuxSocket.getTcpNotSentLowAt(this.intValue()) & 0xFFFFFFFFL;
    }

    final int getTcpKeepIdle() throws IOException {
        return LinuxSocket.getTcpKeepIdle(this.intValue());
    }

    final int getTcpKeepIntvl() throws IOException {
        return LinuxSocket.getTcpKeepIntvl(this.intValue());
    }

    final int getTcpKeepCnt() throws IOException {
        return LinuxSocket.getTcpKeepCnt(this.intValue());
    }

    final int getTcpUserTimeout() throws IOException {
        return LinuxSocket.getTcpUserTimeout(this.intValue());
    }

    final boolean isIpBindAddressNoPort() throws IOException {
        return LinuxSocket.isIpBindAddressNoPort(this.intValue()) != 0;
    }

    final boolean isIpFreeBind() throws IOException {
        return LinuxSocket.isIpFreeBind(this.intValue()) != 0;
    }

    final boolean isIpTransparent() throws IOException {
        return LinuxSocket.isIpTransparent(this.intValue()) != 0;
    }

    final boolean isIpRecvOrigDestAddr() throws IOException {
        return LinuxSocket.isIpRecvOrigDestAddr(this.intValue()) != 0;
    }

    final PeerCredentials getPeerCredentials() throws IOException {
        return LinuxSocket.getPeerCredentials(this.intValue());
    }

    final boolean isLoopbackModeDisabled() throws IOException {
        return LinuxSocket.getIpMulticastLoop(this.intValue(), this.ipv6) == 0;
    }

    /*
     * WARNING - void declaration
     */
    final void setLoopbackModeDisabled(boolean loopbackModeDisabled) throws IOException {
        void var1_1;
        LinuxSocket.setIpMulticastLoop(this.intValue(), this.ipv6, var1_1 != false ? 0 : 1);
    }

    final boolean isUdpGro() throws IOException {
        return LinuxSocket.isUdpGro(this.intValue()) != 0;
    }

    /*
     * WARNING - void declaration
     */
    final void setUdpGro(boolean gro) throws IOException {
        void var1_1;
        LinuxSocket.setUdpGro(this.intValue(), var1_1 != false ? 1 : 0);
    }

    /*
     * WARNING - void declaration
     */
    final long sendFile(DefaultFileRegion src, long baseOffset, long offset, long length) throws IOException {
        void var2_2;
        void var1_1;
        src.open();
        long res = LinuxSocket.sendFile(this.intValue(), (DefaultFileRegion)var1_1, (long)var2_2, offset, length);
        if (res >= 0L) {
            return res;
        }
        return Errors.ioResult((String)"sendfile", (int)((int)res));
    }

    /*
     * WARNING - void declaration
     */
    public final void bindVSock(VSockAddress address) throws IOException {
        int res = LinuxSocket.bindVSock(this.intValue(), address.getCid(), address.getPort());
        if (res < 0) {
            void var1_2;
            throw Errors.newIOException((String)"bindVSock", (int)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean connectVSock(VSockAddress address) throws IOException {
        int res = LinuxSocket.connectVSock(this.intValue(), address.getCid(), address.getPort());
        if (res < 0) {
            void var1_2;
            return Errors.handleConnectErrno((String)"connectVSock", (int)var1_2);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final VSockAddress remoteVSockAddress() {
        void var1_2;
        void var2_3;
        byte[] addr = LinuxSocket.remoteVSockAddress(this.intValue());
        if (addr == null) {
            return null;
        }
        int cid = LinuxSocket.getIntAt(addr, 0);
        int port = LinuxSocket.getIntAt(addr, 4);
        return new VSockAddress((int)var2_3, (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public final VSockAddress localVSockAddress() {
        void var1_2;
        void var2_3;
        byte[] addr = LinuxSocket.localVSockAddress(this.intValue());
        if (addr == null) {
            return null;
        }
        int cid = LinuxSocket.getIntAt(addr, 0);
        int port = LinuxSocket.getIntAt(addr, 4);
        return new VSockAddress((int)var2_3, (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    private static int getIntAt(byte[] array, int startIndex) {
        void var1_1;
        byte[] byArray;
        return array[startIndex] << 24 | (array[startIndex + 1] & 0xFF) << 16 | (array[startIndex + 2] & 0xFF) << 8 | byArray[var1_1 + 3] & 0xFF;
    }

    /*
     * WARNING - void declaration
     */
    private static InetAddress deriveInetAddress(NetworkInterface netInterface, boolean ipv6) {
        void var2_2;
        InetAddress ipAny;
        InetAddress inetAddress = ipAny = ipv6 ? Native.INET6_ANY : Native.INET_ANY;
        if (netInterface != null) {
            Enumeration<InetAddress> ias = netInterface.getInetAddresses();
            while (ias.hasMoreElements()) {
                void var3_3;
                InetAddress ia = (InetAddress)ias.nextElement();
                boolean bl = ia instanceof Inet6Address;
                if (bl != ipv6) continue;
                return var3_3;
            }
        }
        return var2_2;
    }

    public static LinuxSocket newSocket(int fd) {
        int n;
        return new LinuxSocket(n);
    }

    public static LinuxSocket newVSockStream() {
        return new LinuxSocket(LinuxSocket.newVSockStream0());
    }

    /*
     * WARNING - void declaration
     */
    static int newVSockStream0() {
        void var0;
        int res = LinuxSocket.newVSockStreamFd();
        if (res < 0) {
            throw new ChannelException((Throwable)Errors.newIOException((String)"newVSockStream", (int)res));
        }
        return (int)var0;
    }

    public static LinuxSocket newSocketStream(boolean ipv6) {
        boolean bl;
        return new LinuxSocket(LinuxSocket.newSocketStream0((boolean)bl));
    }

    public static LinuxSocket newSocketStream(InternetProtocolFamily protocol) {
        InternetProtocolFamily internetProtocolFamily;
        return new LinuxSocket(LinuxSocket.newSocketStream0((InternetProtocolFamily)internetProtocolFamily));
    }

    public static LinuxSocket newSocketStream() {
        return LinuxSocket.newSocketStream(LinuxSocket.isIPv6Preferred());
    }

    public static LinuxSocket newSocketDgram(boolean ipv6) {
        boolean bl;
        return new LinuxSocket(LinuxSocket.newSocketDgram0((boolean)bl));
    }

    public static LinuxSocket newSocketDgram(InternetProtocolFamily family) {
        InternetProtocolFamily internetProtocolFamily;
        return new LinuxSocket(LinuxSocket.newSocketDgram0((InternetProtocolFamily)internetProtocolFamily));
    }

    public static LinuxSocket newSocketDgram() {
        return LinuxSocket.newSocketDgram(LinuxSocket.isIPv6Preferred());
    }

    public static LinuxSocket newSocketDomain() {
        return new LinuxSocket(LinuxSocket.newSocketDomain0());
    }

    public static LinuxSocket newSocketDomainDgram() {
        return new LinuxSocket(LinuxSocket.newSocketDomainDgram0());
    }

    private static native int newVSockStreamFd();

    private static native int bindVSock(int var0, int var1, int var2);

    private static native int connectVSock(int var0, int var1, int var2);

    private static native byte[] remoteVSockAddress(int var0);

    private static native byte[] localVSockAddress(int var0);

    private static native void joinGroup(int var0, boolean var1, byte[] var2, byte[] var3, int var4, int var5) throws IOException;

    private static native void joinSsmGroup(int var0, boolean var1, byte[] var2, byte[] var3, int var4, int var5, byte[] var6) throws IOException;

    private static native void leaveGroup(int var0, boolean var1, byte[] var2, byte[] var3, int var4, int var5) throws IOException;

    private static native void leaveSsmGroup(int var0, boolean var1, byte[] var2, byte[] var3, int var4, int var5, byte[] var6) throws IOException;

    private static native long sendFile(int var0, DefaultFileRegion var1, long var2, long var4, long var6) throws IOException;

    private static native int getTcpDeferAccept(int var0) throws IOException;

    private static native int isTcpQuickAck(int var0) throws IOException;

    private static native int isTcpCork(int var0) throws IOException;

    private static native int getSoBusyPoll(int var0) throws IOException;

    private static native int getTcpNotSentLowAt(int var0) throws IOException;

    private static native int getTcpKeepIdle(int var0) throws IOException;

    private static native int getTcpKeepIntvl(int var0) throws IOException;

    private static native int getTcpKeepCnt(int var0) throws IOException;

    private static native int getTcpUserTimeout(int var0) throws IOException;

    private static native int getTimeToLive(int var0) throws IOException;

    private static native int isIpBindAddressNoPort(int var0) throws IOException;

    private static native int isIpFreeBind(int var0) throws IOException;

    private static native int isIpTransparent(int var0) throws IOException;

    private static native int isIpRecvOrigDestAddr(int var0) throws IOException;

    private static native void getTcpInfo(int var0, long[] var1) throws IOException;

    private static native PeerCredentials getPeerCredentials(int var0) throws IOException;

    private static native void setTcpDeferAccept(int var0, int var1) throws IOException;

    private static native void setTcpQuickAck(int var0, int var1) throws IOException;

    private static native void setTcpCork(int var0, int var1) throws IOException;

    private static native void setSoBusyPoll(int var0, int var1) throws IOException;

    private static native void setTcpNotSentLowAt(int var0, int var1) throws IOException;

    private static native void setTcpFastOpen(int var0, int var1) throws IOException;

    private static native void setTcpKeepIdle(int var0, int var1) throws IOException;

    private static native void setTcpKeepIntvl(int var0, int var1) throws IOException;

    private static native void setTcpKeepCnt(int var0, int var1) throws IOException;

    private static native void setTcpUserTimeout(int var0, int var1) throws IOException;

    private static native void setIpBindAddressNoPort(int var0, int var1) throws IOException;

    private static native void setIpFreeBind(int var0, int var1) throws IOException;

    private static native void setIpTransparent(int var0, int var1) throws IOException;

    private static native void setIpRecvOrigDestAddr(int var0, int var1) throws IOException;

    private static native void setTcpMd5Sig(int var0, boolean var1, byte[] var2, int var3, byte[] var4) throws IOException;

    private static native void setInterface(int var0, boolean var1, byte[] var2, int var3, int var4) throws IOException;

    private static native int getInterface(int var0, boolean var1);

    private static native int getIpMulticastLoop(int var0, boolean var1) throws IOException;

    private static native void setIpMulticastLoop(int var0, boolean var1, int var2) throws IOException;

    private static native void setTimeToLive(int var0, int var1) throws IOException;

    private static native int isUdpGro(int var0) throws IOException;

    private static native void setUdpGro(int var0, int var1) throws IOException;
}

