/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.epoll.AbstractEpollChannel;
import io.netty.channel.epoll.AbstractEpollStreamChannel;
import io.netty.channel.epoll.EpollEventLoop;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannelConfig;
import io.netty.channel.epoll.EpollTcpInfo;
import io.netty.channel.epoll.LinuxSocket;
import io.netty.channel.epoll.Native;
import io.netty.channel.epoll.TcpMd5Util;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Executor;

public final class EpollSocketChannel
extends AbstractEpollStreamChannel
implements SocketChannel {
    private final EpollSocketChannelConfig config;
    private volatile Collection<InetAddress> tcpMd5SigAddresses = Collections.emptyList();

    public EpollSocketChannel() {
        super(LinuxSocket.newSocketStream(), false);
        this.config = new EpollSocketChannelConfig(this);
    }

    /*
     * WARNING - void declaration
     */
    public EpollSocketChannel(InternetProtocolFamily protocol) {
        super(LinuxSocket.newSocketStream((InternetProtocolFamily)var1_1), false);
        void var1_1;
        this.config = new EpollSocketChannelConfig(this);
    }

    /*
     * WARNING - void declaration
     */
    public EpollSocketChannel(int fd) {
        super((int)var1_1);
        void var1_1;
        this.config = new EpollSocketChannelConfig(this);
    }

    /*
     * WARNING - void declaration
     */
    EpollSocketChannel(LinuxSocket fd, boolean active) {
        super((LinuxSocket)var1_1, (boolean)var2_2);
        void var2_2;
        void var1_1;
        this.config = new EpollSocketChannelConfig(this);
    }

    /*
     * WARNING - void declaration
     */
    EpollSocketChannel(Channel parent, LinuxSocket fd, InetSocketAddress remoteAddress) {
        super(parent, (LinuxSocket)var2_2, (SocketAddress)var3_3);
        void var3_3;
        void var2_2;
        this.config = new EpollSocketChannelConfig(this);
        if (parent instanceof EpollServerSocketChannel) {
            void var1_1;
            this.tcpMd5SigAddresses = ((EpollServerSocketChannel)var1_1).tcpMd5SigAddresses();
        }
    }

    public final EpollTcpInfo tcpInfo() {
        return this.tcpInfo(new EpollTcpInfo());
    }

    /*
     * WARNING - void declaration
     */
    public final EpollTcpInfo tcpInfo(EpollTcpInfo info) {
        try {
            this.socket.getTcpInfo(info);
            return info;
        }
        catch (IOException e) {
            void var1_2;
            throw new ChannelException((Throwable)var1_2);
        }
    }

    public final InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    public final InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public final EpollSocketChannelConfig config() {
        return this.config;
    }

    public final ServerSocketChannel parent() {
        return (ServerSocketChannel)super.parent();
    }

    @Override
    protected final AbstractEpollChannel.AbstractEpollUnsafe newUnsafe() {
        return new EpollSocketChannelUnsafe();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final boolean doConnect0(SocketAddress remote) throws Exception {
        void var1_1;
        if (Native.IS_SUPPORTING_TCP_FASTOPEN_CLIENT && this.config.isTcpFastOpenConnect()) {
            ChannelOutboundBuffer outbound = this.unsafe().outboundBuffer();
            outbound.addFlush();
            Object curr = outbound.current();
            if (curr instanceof ByteBuf) {
                void var3_3;
                ByteBuf initialData = (ByteBuf)curr;
                long localFlushedAmount = this.doWriteOrSendBytes((ByteBuf)var3_3, (InetSocketAddress)remote, true);
                if (localFlushedAmount > 0L) {
                    void var2_2;
                    var2_2.removeBytes(localFlushedAmount);
                    return true;
                }
            }
        }
        return super.doConnect0((SocketAddress)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final void setTcpMd5Sig(Map<InetAddress, byte[]> keys) throws IOException {
        EpollSocketChannel epollSocketChannel = this;
        synchronized (epollSocketChannel) {
            void var1_1;
            this.tcpMd5SigAddresses = TcpMd5Util.newTcpMd5Sigs(this, this.tcpMd5SigAddresses, (Map<InetAddress, byte[]>)var1_1);
            return;
        }
    }

    private final class EpollSocketChannelUnsafe
    extends AbstractEpollStreamChannel.EpollStreamUnsafe {
        private EpollSocketChannelUnsafe() {
            super(EpollSocketChannel.this);
        }

        @Override
        protected final Executor prepareToClose() {
            try {
                if (EpollSocketChannel.this.isOpen() && EpollSocketChannel.this.config().getSoLinger() > 0) {
                    ((EpollEventLoop)EpollSocketChannel.this.eventLoop()).remove(EpollSocketChannel.this);
                    return GlobalEventExecutor.INSTANCE;
                }
            }
            catch (Throwable throwable) {}
            return null;
        }
    }
}

