/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import io.netty.channel.epoll.AbstractEpollServerChannel;
import io.netty.channel.epoll.EpollEventLoop;
import io.netty.channel.epoll.EpollServerSocketChannelConfig;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.epoll.LinuxSocket;
import io.netty.channel.epoll.Native;
import io.netty.channel.epoll.TcpMd5Util;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.unix.NativeInetAddress;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public final class EpollServerSocketChannel
extends AbstractEpollServerChannel
implements ServerSocketChannel {
    private final EpollServerSocketChannelConfig config;
    private volatile Collection<InetAddress> tcpMd5SigAddresses = Collections.emptyList();

    public EpollServerSocketChannel() {
        this((InternetProtocolFamily)null);
    }

    /*
     * WARNING - void declaration
     */
    public EpollServerSocketChannel(InternetProtocolFamily protocol) {
        super(LinuxSocket.newSocketStream((InternetProtocolFamily)var1_1), false);
        void var1_1;
        this.config = new EpollServerSocketChannelConfig(this);
    }

    /*
     * WARNING - void declaration
     */
    public EpollServerSocketChannel(int fd) {
        this(new LinuxSocket((int)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    EpollServerSocketChannel(LinuxSocket fd) {
        super((LinuxSocket)var1_1);
        void var1_1;
        this.config = new EpollServerSocketChannelConfig(this);
    }

    /*
     * WARNING - void declaration
     */
    EpollServerSocketChannel(LinuxSocket fd, boolean active) {
        super((LinuxSocket)var1_1, (boolean)var2_2);
        void var2_2;
        void var1_1;
        this.config = new EpollServerSocketChannelConfig(this);
    }

    @Override
    protected final boolean isCompatible(EventLoop loop) {
        return loop instanceof EpollEventLoop;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void doBind(SocketAddress localAddress) throws Exception {
        int tcpFastopen;
        super.doBind(localAddress);
        if (Native.IS_SUPPORTING_TCP_FASTOPEN_SERVER && (tcpFastopen = this.config.getTcpFastopen()) > 0) {
            void var1_2;
            this.socket.setTcpFastOpen((int)var1_2);
        }
        this.socket.listen(this.config.getBacklog());
        this.active = true;
    }

    public final InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    public final InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public final EpollServerSocketChannelConfig config() {
        return this.config;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final Channel newChildChannel(int fd, byte[] address, int offset, int len) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        return new EpollSocketChannel((Channel)this, new LinuxSocket((int)var1_1), NativeInetAddress.address((byte[])var2_2, (int)var3_3, (int)len));
    }

    final Collection<InetAddress> tcpMd5SigAddresses() {
        return this.tcpMd5SigAddresses;
    }

    /*
     * WARNING - void declaration
     */
    final void setTcpMd5Sig(Map<InetAddress, byte[]> keys) throws IOException {
        EpollServerSocketChannel epollServerSocketChannel = this;
        synchronized (epollServerSocketChannel) {
            void var1_1;
            this.tcpMd5SigAddresses = TcpMd5Util.newTcpMd5Sigs(this, this.tcpMd5SigAddresses, (Map<InetAddress, byte[]>)var1_1);
            return;
        }
    }
}

