/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.channel.Channel;
import io.netty.channel.epoll.AbstractEpollServerChannel;
import io.netty.channel.epoll.EpollDomainSocketChannel;
import io.netty.channel.epoll.EpollServerChannelConfig;
import io.netty.channel.epoll.LinuxSocket;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.channel.unix.FileDescriptor;
import io.netty.channel.unix.ServerDomainSocketChannel;
import io.netty.channel.unix.Socket;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.net.SocketAddress;

public final class EpollServerDomainSocketChannel
extends AbstractEpollServerChannel
implements ServerDomainSocketChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(EpollServerDomainSocketChannel.class);
    private final EpollServerChannelConfig config = new EpollServerChannelConfig(this);
    private volatile DomainSocketAddress local;

    public EpollServerDomainSocketChannel() {
        super(LinuxSocket.newSocketDomain(), false);
    }

    /*
     * WARNING - void declaration
     */
    public EpollServerDomainSocketChannel(int fd) {
        super((int)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public EpollServerDomainSocketChannel(int fd, boolean active) {
        super(new LinuxSocket((int)var1_1), (boolean)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    EpollServerDomainSocketChannel(LinuxSocket fd) {
        super((LinuxSocket)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    EpollServerDomainSocketChannel(LinuxSocket fd, boolean active) {
        super((LinuxSocket)var1_1, (boolean)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final Channel newChildChannel(int fd, byte[] addr, int offset, int len) throws Exception {
        void var1_1;
        return new EpollDomainSocketChannel((Channel)this, (FileDescriptor)new Socket((int)var1_1));
    }

    protected final DomainSocketAddress localAddress0() {
        return this.local;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void doBind(SocketAddress localAddress) throws Exception {
        void var1_1;
        this.socket.bind(localAddress);
        this.socket.listen(this.config.getBacklog());
        this.local = (DomainSocketAddress)var1_1;
        this.active = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void doClose() throws Exception {
        File file;
        boolean bl;
        DomainSocketAddress local;
        try {
            super.doClose();
            local = this.local;
        }
        catch (Throwable throwable) {
            File file2;
            boolean bl2;
            DomainSocketAddress local2 = this.local;
            if (local2 != null && !(bl2 = (file2 = new File(local2.path())).delete()) && logger.isDebugEnabled()) {
                void var2_5;
                logger.debug("Failed to delete a domain socket file: {}", (Object)var2_5.path());
            }
            throw throwable;
        }
        if (local != null && !(bl = (file = new File(local.path())).delete()) && logger.isDebugEnabled()) {
            void var1_1;
            logger.debug("Failed to delete a domain socket file: {}", (Object)var1_1.path());
        }
    }

    @Override
    public final EpollServerChannelConfig config() {
        return this.config;
    }

    public final DomainSocketAddress remoteAddress() {
        return (DomainSocketAddress)super.remoteAddress();
    }

    public final DomainSocketAddress localAddress() {
        return (DomainSocketAddress)super.localAddress();
    }
}

