/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelOption;
import io.netty.channel.MessageSizeEstimator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.ServerChannelRecvByteBufAllocator;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.AbstractEpollChannel;
import io.netty.channel.epoll.EpollChannelConfig;
import io.netty.channel.epoll.EpollMode;
import io.netty.channel.socket.ServerSocketChannelConfig;
import io.netty.util.NetUtil;
import io.netty.util.internal.ObjectUtil;
import java.io.IOException;
import java.util.Map;

public class EpollServerChannelConfig
extends EpollChannelConfig
implements ServerSocketChannelConfig {
    private volatile int backlog = NetUtil.SOMAXCONN;
    private volatile int pendingFastOpenRequestsThreshold;

    /*
     * WARNING - void declaration
     */
    EpollServerChannelConfig(AbstractEpollChannel channel) {
        super((Channel)var1_1, (RecvByteBufAllocator)new ServerChannelRecvByteBufAllocator());
        void var1_1;
    }

    @Override
    public Map<ChannelOption<?>, Object> getOptions() {
        EpollServerChannelConfig epollServerChannelConfig = this;
        return epollServerChannelConfig.getOptions(super.getOptions(), new ChannelOption[]{ChannelOption.SO_RCVBUF, ChannelOption.SO_REUSEADDR, ChannelOption.SO_BACKLOG, ChannelOption.TCP_FASTOPEN});
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T getOption(ChannelOption<T> option) {
        void var1_1;
        if (option == ChannelOption.SO_RCVBUF) {
            return (T)Integer.valueOf(this.getReceiveBufferSize());
        }
        if (option == ChannelOption.SO_REUSEADDR) {
            return (T)Boolean.valueOf(this.isReuseAddress());
        }
        if (option == ChannelOption.SO_BACKLOG) {
            return (T)Integer.valueOf(this.getBacklog());
        }
        if (option == ChannelOption.TCP_FASTOPEN) {
            return (T)Integer.valueOf(this.getTcpFastopen());
        }
        return super.getOption(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> boolean setOption(ChannelOption<T> option, T value) {
        this.validate(option, value);
        if (option == ChannelOption.SO_RCVBUF) {
            this.setReceiveBufferSize((Integer)value);
        } else if (option == ChannelOption.SO_REUSEADDR) {
            this.setReuseAddress((Boolean)value);
        } else if (option == ChannelOption.SO_BACKLOG) {
            this.setBacklog((Integer)value);
        } else if (option == ChannelOption.TCP_FASTOPEN) {
            this.setTcpFastopen((Integer)value);
        } else {
            void var2_2;
            void var1_1;
            return super.setOption(var1_1, var2_2);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isReuseAddress() {
        try {
            return ((AbstractEpollChannel)this.channel).socket.isReuseAddress();
        }
        catch (IOException e) {
            void var1_1;
            throw new ChannelException((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public EpollServerChannelConfig setReuseAddress(boolean reuseAddress) {
        try {
            ((AbstractEpollChannel)this.channel).socket.setReuseAddress(reuseAddress);
            return this;
        }
        catch (IOException e) {
            void var1_2;
            throw new ChannelException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public int getReceiveBufferSize() {
        try {
            return ((AbstractEpollChannel)this.channel).socket.getReceiveBufferSize();
        }
        catch (IOException e) {
            void var1_1;
            throw new ChannelException((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public EpollServerChannelConfig setReceiveBufferSize(int receiveBufferSize) {
        try {
            ((AbstractEpollChannel)this.channel).socket.setReceiveBufferSize(receiveBufferSize);
            return this;
        }
        catch (IOException e) {
            void var1_2;
            throw new ChannelException((Throwable)var1_2);
        }
    }

    public int getBacklog() {
        return this.backlog;
    }

    /*
     * WARNING - void declaration
     */
    public EpollServerChannelConfig setBacklog(int backlog) {
        void var1_1;
        ObjectUtil.checkPositiveOrZero((int)backlog, (String)"backlog");
        this.backlog = var1_1;
        return this;
    }

    public int getTcpFastopen() {
        return this.pendingFastOpenRequestsThreshold;
    }

    /*
     * WARNING - void declaration
     */
    public EpollServerChannelConfig setTcpFastopen(int pendingFastOpenRequestsThreshold) {
        void var1_1;
        this.pendingFastOpenRequestsThreshold = ObjectUtil.checkPositiveOrZero((int)var1_1, (String)"pendingFastOpenRequestsThreshold");
        return this;
    }

    public EpollServerChannelConfig setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public EpollServerChannelConfig setConnectTimeoutMillis(int connectTimeoutMillis) {
        void var1_1;
        super.setConnectTimeoutMillis((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public EpollServerChannelConfig setMaxMessagesPerRead(int maxMessagesPerRead) {
        void var1_1;
        super.setMaxMessagesPerRead((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public EpollServerChannelConfig setWriteSpinCount(int writeSpinCount) {
        void var1_1;
        super.setWriteSpinCount((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public EpollServerChannelConfig setAllocator(ByteBufAllocator allocator) {
        void var1_1;
        super.setAllocator((ByteBufAllocator)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public EpollServerChannelConfig setRecvByteBufAllocator(RecvByteBufAllocator allocator) {
        void var1_1;
        super.setRecvByteBufAllocator((RecvByteBufAllocator)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public EpollServerChannelConfig setAutoRead(boolean autoRead) {
        void var1_1;
        super.setAutoRead((boolean)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public EpollServerChannelConfig setWriteBufferHighWaterMark(int writeBufferHighWaterMark) {
        void var1_1;
        super.setWriteBufferHighWaterMark((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public EpollServerChannelConfig setWriteBufferLowWaterMark(int writeBufferLowWaterMark) {
        void var1_1;
        super.setWriteBufferLowWaterMark((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public EpollServerChannelConfig setWriteBufferWaterMark(WriteBufferWaterMark writeBufferWaterMark) {
        void var1_1;
        super.setWriteBufferWaterMark((WriteBufferWaterMark)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public EpollServerChannelConfig setMessageSizeEstimator(MessageSizeEstimator estimator) {
        void var1_1;
        super.setMessageSizeEstimator((MessageSizeEstimator)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public EpollServerChannelConfig setEpollMode(EpollMode mode) {
        void var1_1;
        super.setEpollMode((EpollMode)var1_1);
        return this;
    }
}

