/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.EventLoopTaskQueueFactory;
import io.netty.channel.SelectStrategy;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.channel.epoll.AbstractEpollChannel;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventArray;
import io.netty.channel.epoll.Native;
import io.netty.channel.epoll.NativeDatagramPacketArray;
import io.netty.channel.unix.FileDescriptor;
import io.netty.channel.unix.IovArray;
import io.netty.util.IntSupplier;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.netty.util.concurrent.RejectedExecutionHandler;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;

public class EpollEventLoop
extends SingleThreadEventLoop {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(EpollEventLoop.class);
    private static final long EPOLL_WAIT_MILLIS_THRESHOLD = SystemPropertyUtil.getLong((String)"io.netty.channel.epoll.epollWaitThreshold", (long)10L);
    private FileDescriptor epollFd;
    private FileDescriptor eventFd;
    private FileDescriptor timerFd;
    private final IntObjectMap<AbstractEpollChannel> channels = new IntObjectHashMap(4096);
    private final boolean allowGrowing;
    private final EpollEventArray events;
    private IovArray iovArray;
    private NativeDatagramPacketArray datagramPacketArray;
    private final SelectStrategy selectStrategy;
    private final IntSupplier selectNowSupplier = new IntSupplier(this){
        final /* synthetic */ EpollEventLoop this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        public int get() throws Exception {
            return this.this$0.epollWaitNow();
        }
    };
    private static final long AWAKE = -1L;
    private static final long NONE = Long.MAX_VALUE;
    private final AtomicLong nextWakeupNanos = new AtomicLong(-1L);
    private boolean pendingWakeup;
    private volatile int ioRatio = 50;
    private static final long MAX_SCHEDULED_TIMERFD_NS = 999999999L;

    /*
     * WARNING - void declaration
     */
    EpollEventLoop(EventLoopGroup parent, Executor executor, int maxEvents, SelectStrategy strategy, RejectedExecutionHandler rejectedExecutionHandler, EventLoopTaskQueueFactory taskQueueFactory, EventLoopTaskQueueFactory tailTaskQueueFactory) {
        super((EventLoopGroup)var1_1, (Executor)var2_2, false, EpollEventLoop.newTaskQueue(taskQueueFactory), EpollEventLoop.newTaskQueue(tailTaskQueueFactory), rejectedExecutionHandler);
        void var2_2;
        void var1_1;
        this.selectStrategy = (SelectStrategy)ObjectUtil.checkNotNull((Object)strategy, (String)"strategy");
        if (maxEvents == 0) {
            this.allowGrowing = true;
            this.events = new EpollEventArray(4096);
        } else {
            void var3_3;
            this.allowGrowing = false;
            this.events = new EpollEventArray((int)var3_3);
        }
        this.openFileDescriptors();
    }

    /*
     * WARNING - void declaration
     */
    public void openFileDescriptors() {
        FileDescriptor epollFd = null;
        FileDescriptor eventFd = null;
        FileDescriptor timerFd = null;
        try {
            this.epollFd = epollFd = Native.newEpollCreate();
            this.eventFd = eventFd = Native.newEventFd();
            try {
                Native.epollCtlAdd(epollFd.intValue(), eventFd.intValue(), Native.EPOLLIN | Native.EPOLLET);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to add eventFd filedescriptor to epoll", e);
            }
            this.timerFd = timerFd = Native.newTimerFd();
            try {
                Native.epollCtlAdd(epollFd.intValue(), timerFd.intValue(), Native.EPOLLIN | Native.EPOLLET);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to add timerFd filedescriptor to epoll", e);
            }
        }
        catch (Throwable throwable) {
            void var3_3;
            void var2_2;
            void var1_1;
            EpollEventLoop.closeFileDescriptor((FileDescriptor)var1_1);
            EpollEventLoop.closeFileDescriptor((FileDescriptor)var2_2);
            EpollEventLoop.closeFileDescriptor((FileDescriptor)var3_3);
            throw throwable;
        }
    }

    private static void closeFileDescriptor(FileDescriptor fd) {
        if (fd != null) {
            try {
                FileDescriptor fileDescriptor;
                fileDescriptor.close();
                return;
            }
            catch (Exception exception) {}
        }
    }

    private static Queue<Runnable> newTaskQueue(EventLoopTaskQueueFactory queueFactory) {
        EventLoopTaskQueueFactory eventLoopTaskQueueFactory;
        if (queueFactory == null) {
            return EpollEventLoop.newTaskQueue0(DEFAULT_MAX_PENDING_TASKS);
        }
        return eventLoopTaskQueueFactory.newTaskQueue(DEFAULT_MAX_PENDING_TASKS);
    }

    IovArray cleanIovArray() {
        if (this.iovArray == null) {
            this.iovArray = new IovArray();
        } else {
            this.iovArray.clear();
        }
        return this.iovArray;
    }

    NativeDatagramPacketArray cleanDatagramPacketArray() {
        if (this.datagramPacketArray == null) {
            this.datagramPacketArray = new NativeDatagramPacketArray();
        } else {
            this.datagramPacketArray.clear();
        }
        return this.datagramPacketArray;
    }

    protected void wakeup(boolean inEventLoop) {
        if (!inEventLoop && this.nextWakeupNanos.getAndSet(-1L) != -1L) {
            Native.eventFdWrite(this.eventFd.intValue(), 1L);
        }
    }

    protected boolean beforeScheduledTaskSubmitted(long deadlineNanos) {
        return deadlineNanos < this.nextWakeupNanos.get();
    }

    protected boolean afterScheduledTaskSubmitted(long deadlineNanos) {
        return deadlineNanos < this.nextWakeupNanos.get();
    }

    /*
     * WARNING - void declaration
     */
    void add(AbstractEpollChannel ch) throws IOException {
        void var1_1;
        void var2_2;
        assert (this.inEventLoop());
        int fd = ch.socket.intValue();
        Native.epollCtlAdd(this.epollFd.intValue(), fd, ch.flags);
        AbstractEpollChannel old = (AbstractEpollChannel)((Object)this.channels.put((int)var2_2, (Object)ch));
        assert (old == null || !var1_1.isOpen());
    }

    /*
     * WARNING - void declaration
     */
    void modify(AbstractEpollChannel ch) throws IOException {
        void var1_1;
        assert (this.inEventLoop());
        Native.epollCtlMod(this.epollFd.intValue(), ch.socket.intValue(), var1_1.flags);
    }

    /*
     * WARNING - void declaration
     */
    void remove(AbstractEpollChannel ch) throws IOException {
        void var1_1;
        assert (this.inEventLoop());
        int fd = ch.socket.intValue();
        AbstractEpollChannel old = (AbstractEpollChannel)((Object)this.channels.remove(fd));
        if (old != null && old != ch) {
            void var3_3;
            this.channels.put(fd, (Object)var3_3);
            assert (!ch.isOpen());
        } else if (var1_1.isOpen()) {
            void var2_2;
            Native.epollCtlDel(this.epollFd.intValue(), (int)var2_2);
        }
    }

    protected Queue<Runnable> newTaskQueue(int maxPendingTasks) {
        return EpollEventLoop.newTaskQueue0(maxPendingTasks);
    }

    private static Queue<Runnable> newTaskQueue0(int maxPendingTasks) {
        int n;
        if (maxPendingTasks == Integer.MAX_VALUE) {
            return PlatformDependent.newMpscQueue();
        }
        return PlatformDependent.newMpscQueue((int)n);
    }

    public int getIoRatio() {
        return this.ioRatio;
    }

    /*
     * WARNING - void declaration
     */
    public void setIoRatio(int ioRatio) {
        void var1_1;
        if (ioRatio <= 0 || ioRatio > 100) {
            throw new IllegalArgumentException("ioRatio: " + ioRatio + " (expected: 0 < ioRatio <= 100)");
        }
        this.ioRatio = var1_1;
    }

    public int registeredChannels() {
        return this.channels.size();
    }

    /*
     * WARNING - void declaration
     */
    public Iterator<Channel> registeredChannelsIterator() {
        void var1_1;
        assert (this.inEventLoop());
        IntObjectMap<AbstractEpollChannel> ch = this.channels;
        if (ch.isEmpty()) {
            return SingleThreadEventLoop.ChannelsReadOnlyIterator.empty();
        }
        return new SingleThreadEventLoop.ChannelsReadOnlyIterator((Iterable)var1_1.values());
    }

    /*
     * WARNING - void declaration
     */
    private long epollWait(long deadlineNanos) throws IOException {
        void var2_4;
        void var1_2;
        void var3_3;
        if (deadlineNanos == Long.MAX_VALUE) {
            return Native.epollWait(this.epollFd, this.events, this.timerFd, Integer.MAX_VALUE, 0, EPOLL_WAIT_MILLIS_THRESHOLD);
        }
        long totalDelay = EpollEventLoop.deadlineToDelayNanos((long)deadlineNanos);
        int delaySeconds = (int)Math.min(totalDelay / 1000000000L, Integer.MAX_VALUE);
        int delayNanos = (int)Math.min((long)(var3_3 - (long)delaySeconds * 1000000000L), 999999999L);
        return Native.epollWait(this.epollFd, this.events, this.timerFd, (int)var1_2, (int)var2_4, EPOLL_WAIT_MILLIS_THRESHOLD);
    }

    private int epollWaitNoTimerChange() throws IOException {
        return Native.epollWait(this.epollFd, this.events, false);
    }

    private int epollWaitNow() throws IOException {
        return Native.epollWait(this.epollFd, this.events, true);
    }

    private int epollBusyWait() throws IOException {
        return Native.epollBusyWait(this.epollFd, this.events);
    }

    private int epollWaitTimeboxed() throws IOException {
        return Native.epollWait(this.epollFd, this.events, 1000);
    }

    /*
     * Exception decompiling
     */
    protected void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 10[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - void declaration
     */
    void handleLoopException(Throwable t) {
        void var1_1;
        logger.warn("Unexpected exception in the selector loop.", (Throwable)var1_1);
        try {
            Thread.sleep(1000L);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    private void closeAll() {
        AbstractEpollChannel[] abstractEpollChannelArray = this.channels.values().toArray(new AbstractEpollChannel[0]);
        AbstractEpollChannel[] abstractEpollChannelArray2 = abstractEpollChannelArray;
        abstractEpollChannelArray2 = abstractEpollChannelArray;
        int n = abstractEpollChannelArray.length;
        for (int i = 0; i < n; ++i) {
            AbstractEpollChannel ch = abstractEpollChannelArray2[i];
            ch.unsafe().close(ch.unsafe().voidPromise());
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean processReady(EpollEventArray events, int ready) {
        void var3_3;
        boolean timerFired = false;
        for (int i = 0; i < ready; ++i) {
            int fd = events.fd(i);
            if (fd == this.eventFd.intValue()) {
                this.pendingWakeup = false;
                continue;
            }
            if (fd == this.timerFd.intValue()) {
                timerFired = true;
                continue;
            }
            long ev = events.events(i);
            AbstractEpollChannel ch = (AbstractEpollChannel)((Object)this.channels.get(fd));
            if (ch != null) {
                AbstractEpollChannel.AbstractEpollUnsafe unsafe = (AbstractEpollChannel.AbstractEpollUnsafe)ch.unsafe();
                if ((ev & (long)(Native.EPOLLERR | Native.EPOLLOUT)) != 0L) {
                    unsafe.epollOutReady();
                }
                if ((ev & (long)(Native.EPOLLERR | Native.EPOLLIN)) != 0L) {
                    unsafe.epollInReady();
                }
                if ((ev & (long)Native.EPOLLRDHUP) == 0L) continue;
                unsafe.epollRdHupReady();
                continue;
            }
            try {
                void var5_5;
                Native.epollCtlDel(this.epollFd.intValue(), (int)var5_5);
                continue;
            }
            catch (IOException iOException) {}
        }
        return (boolean)var3_3;
    }

    protected void cleanup() {
        try {
            this.closeFileDescriptors();
            return;
        }
        finally {
            if (this.iovArray != null) {
                this.iovArray.release();
                this.iovArray = null;
            }
            if (this.datagramPacketArray != null) {
                this.datagramPacketArray.release();
                this.datagramPacketArray = null;
            }
            this.events.free();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void closeFileDescriptors() {
        block8: while (this.pendingWakeup) {
            try {
                int count = this.epollWaitTimeboxed();
                if (count == 0) break;
                for (int i = 0; i < count; ++i) {
                    if (this.events.fd(i) != this.eventFd.intValue()) continue;
                    this.pendingWakeup = false;
                    continue block8;
                }
            }
            catch (IOException iOException) {
            }
        }
        try {
            this.eventFd.close();
        }
        catch (IOException e) {
            logger.warn("Failed to close the event fd.", (Throwable)e);
        }
        try {
            this.timerFd.close();
        }
        catch (IOException e) {
            logger.warn("Failed to close the timer fd.", (Throwable)e);
        }
        try {
            this.epollFd.close();
            return;
        }
        catch (IOException e) {
            void var1_4;
            logger.warn("Failed to close the epoll fd.", (Throwable)var1_4);
            return;
        }
    }

    static {
        Epoll.ensureAvailability();
    }
}

