/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.channel.epoll.Native;
import io.netty.channel.unix.Buffer;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;

public final class EpollEventArray {
    private static final int EPOLL_EVENT_SIZE = Native.sizeofEpollEvent();
    private static final int EPOLL_DATA_OFFSET = Native.offsetofEpollData();
    private ByteBuffer memory;
    private long memoryAddress;
    private int length;

    /*
     * WARNING - void declaration
     */
    EpollEventArray(int length) {
        void var1_1;
        if (length <= 0) {
            throw new IllegalArgumentException("length must be >= 1 but was " + length);
        }
        this.length = length;
        this.memory = Buffer.allocateDirectWithNativeOrder((int)EpollEventArray.calculateBufferCapacity((int)var1_1));
        this.memoryAddress = Buffer.memoryAddress((ByteBuffer)this.memory);
    }

    final long memoryAddress() {
        return this.memoryAddress;
    }

    final int length() {
        return this.length;
    }

    /*
     * WARNING - void declaration
     */
    final void increase() {
        void var1_1;
        this.length <<= 1;
        ByteBuffer buffer = Buffer.allocateDirectWithNativeOrder((int)EpollEventArray.calculateBufferCapacity(this.length));
        Buffer.free((ByteBuffer)this.memory);
        this.memory = buffer;
        this.memoryAddress = Buffer.memoryAddress((ByteBuffer)var1_1);
    }

    final void free() {
        Buffer.free((ByteBuffer)this.memory);
        this.memoryAddress = 0L;
    }

    /*
     * WARNING - void declaration
     */
    final int events(int index) {
        void var1_1;
        return this.getInt((int)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    final int fd(int index) {
        void var1_1;
        return this.getInt((int)var1_1, EPOLL_DATA_OFFSET);
    }

    /*
     * WARNING - void declaration
     */
    private int getInt(int index, int offset) {
        void var2_2;
        void var1_1;
        if (PlatformDependent.hasUnsafe()) {
            void var3_3;
            long n = (long)index * (long)EPOLL_EVENT_SIZE;
            return PlatformDependent.getInt((long)(this.memoryAddress + var3_3 + (long)offset));
        }
        return this.memory.getInt((int)(var1_1 * EPOLL_EVENT_SIZE + var2_2));
    }

    private static int calculateBufferCapacity(int capacity) {
        return capacity * EPOLL_EVENT_SIZE;
    }
}

